/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.core.actions;

import java.util.List;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.epf.diagram.core.DiagramCoreResources;
import org.eclipse.epf.diagram.core.bridge.BridgeHelper;
import org.eclipse.epf.diagram.core.bridge.DiagramAdapter;
import org.eclipse.epf.diagram.core.commands.ChangeBoundsCommand;
import org.eclipse.epf.diagram.core.part.AbstractDiagramEditor;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.actions.DiagramAction;
import org.eclipse.gmf.runtime.diagram.ui.commands.CommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.RelativeBendpoints;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class AccessibilityMoveAction
extends DiagramAction {
    public static final String MOVE_LEFT_ACTION = "move_left_action";
    public static final String MOVE_RIGHT_ACTION = "move_right_action";
    public static final String MOVE_DOWN_ACTION = "move_down_action";
    public static final String MOVE_UP_ACTION = "move_up_action";
    private int direction;

    public AccessibilityMoveAction(IWorkbenchPage iWorkbenchPage) {
        super(iWorkbenchPage);
    }

    public AccessibilityMoveAction(IWorkbenchPart iWorkbenchPart, int n) {
        super(iWorkbenchPart);
        this.direction = n;
    }

    protected Request createTargetRequest() {
        return null;
    }

    protected boolean isSelectionListener() {
        return true;
    }

    public void init() {
        super.init();
        this.setId("move_action_id");
    }

    public void setDirection(int n) {
        this.direction = n;
    }

    protected Command getCommand() {
        List list = this.getSelectedObjects();
        CompositeCommand compositeCommand = new CompositeCommand(DiagramCoreResources.AbstractDiagramEditor_MoveNode_label);
        for (Object e : list) {
            Command command;
            if (!(e instanceof GraphicalEditPart) || (command = this.move(this.direction, (GraphicalEditPart)e)) == null) continue;
            compositeCommand.compose((IUndoableOperation)new CommandProxy(command));
        }
        return compositeCommand.isEmpty() ? null : new ICommandProxy(compositeCommand.reduce());
    }

    public Command move(int n, GraphicalEditPart graphicalEditPart) {
        if (graphicalEditPart.getModel() instanceof Node) {
            View view = (View)graphicalEditPart.getModel();
            Object object = ViewUtil.getStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
            Object object2 = ViewUtil.getStructuralFeatureValue((View)view, (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
            Point point = new Point(((Integer)object).intValue(), ((Integer)object2).intValue());
            int n2 = point.x;
            int n3 = point.y;
            int n4 = 1;
            switch (n) {
                case 16: {
                    n2 = point.x + n4;
                    break;
                }
                case 4: {
                    n3 += n4;
                    break;
                }
                case 1: {
                    n3 -= n4;
                    break;
                }
                case 8: {
                    n2 -= n4;
                    break;
                }
            }
            ChangeBoundsCommand changeBoundsCommand = new ChangeBoundsCommand(this.getEditingDomain(), view, new Point(n2, n3), -1, -1);
            return changeBoundsCommand;
        }
        return null;
    }

    public Command moveBendPoint(int n, ConnectionEditPart connectionEditPart) {
        if (connectionEditPart.getModel() instanceof Edge) {
            Edge edge = (Edge)connectionEditPart.getModel();
            RelativeBendpoints relativeBendpoints = (RelativeBendpoints)edge.getBendpoints();
            List list = relativeBendpoints.getPoints();
            int n2 = 0;
            if (list != null && list.size() > 0) {
                AbsoluteBendpoint absoluteBendpoint = (AbsoluteBendpoint)list.get(n2);
                int n3 = absoluteBendpoint.x;
                int n4 = absoluteBendpoint.y;
                int n5 = 5;
                switch (n) {
                    case 1: {
                        n3 = absoluteBendpoint.x + n5;
                        break;
                    }
                    case 2: {
                        n4 += n5;
                        break;
                    }
                    case 3: {
                        n4 -= n5;
                        break;
                    }
                    case 4: {
                        n3 -= n5;
                        break;
                    }
                }
            }
        }
        return null;
    }

    public TransactionalEditingDomain getEditingDomain() {
        return ((AbstractDiagramEditor)this.getDiagramWorkbenchPart()).getEditingDomain();
    }

    public String getId() {
        switch (this.direction) {
            case 16: {
                return MOVE_RIGHT_ACTION;
            }
            case 4: {
                return MOVE_DOWN_ACTION;
            }
            case 1: {
                return MOVE_UP_ACTION;
            }
            case 8: {
                return MOVE_LEFT_ACTION;
            }
        }
        return "move_action_id";
    }

    public boolean isEnabled() {
        if (TngUtil.isLocked((EObject)this.getOwningProcess())) {
            return false;
        }
        if (BridgeHelper.isReadOnly((View)((AbstractDiagramEditor)this.getDiagramWorkbenchPart()).getDiagram())) {
            return false;
        }
        if (this.getSelectedObjects().isEmpty()) {
            return false;
        }
        return super.isEnabled();
    }

    private Process getOwningProcess() {
        Diagram diagram;
        DiagramAdapter diagramAdapter;
        IDiagramWorkbenchPart iDiagramWorkbenchPart = this.getDiagramWorkbenchPart();
        if (iDiagramWorkbenchPart != null && (diagramAdapter = BridgeHelper.getDiagramAdapter((diagram = ((AbstractDiagramEditor)iDiagramWorkbenchPart).getDiagram()).getElement())) != null) {
            return TngUtil.getOwningProcess((BreakdownElement)diagramAdapter.getActivity());
        }
        return null;
    }
}

