/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.core.providers;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.epf.common.CommonPlugin;
import org.eclipse.epf.common.serviceability.MsgBox;
import org.eclipse.epf.diagram.core.DiagramCorePlugin;
import org.eclipse.epf.diagram.core.part.DiagramEditorInputProxy;
import org.eclipse.epf.diagram.core.part.IDiagramFileEditorInputProxy;
import org.eclipse.epf.diagram.core.part.util.DiagramEditorUtil;
import org.eclipse.epf.diagram.core.providers.AccessibleDiagramModificationListener;
import org.eclipse.epf.diagram.core.resources.IDiagramStorage;
import org.eclipse.epf.diagram.core.services.DiagramManager;
import org.eclipse.epf.diagram.core.services.FileSynchronizer;
import org.eclipse.epf.diagram.model.util.TxUtil;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.services.Services;
import org.eclipse.epf.uma.Activity;
import org.eclipse.gmf.runtime.common.core.util.Log;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.AbstractDocumentProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.DiagramDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.DiagramModificationListener;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDiagramDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocument;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.document.IDocumentListener;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.document.FileDiagramDocumentProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.document.StorageDiagramDocumentProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.document.StorageDocumentProvider;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.document.WorkspaceOperationRunner;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.internal.EditorIDEPlugin;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.internal.l10n.EditorMessages;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.internal.EditorPlugin;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;

public class SharedResourceDiagramDocumentProvider
extends StorageDiagramDocumentProvider {
    private static final FileDiagramDocumentProviderEx fileDiagramDocumentProvider = new FileDiagramDocumentProviderEx();
    private WorkspaceOperationRunner fOperationRunner;
    private DiagramManager fDiagramMgr;
    private boolean locked = false;

    public SharedResourceDiagramDocumentProvider(DiagramManager diagramManager) {
        this.fDiagramMgr = diagramManager;
    }

    protected boolean setDocumentContent(IDocument iDocument, IEditorInput iEditorInput) throws CoreException {
        if (iDocument instanceof IDiagramDocument) {
            ((IDiagramDocument)iDocument).setEditingDomain((TransactionalEditingDomain)this.fDiagramMgr.getEditingDomain());
        }
        return super.setDocumentContent(iDocument, iEditorInput);
    }

    protected void setDocumentContentFromStorage(IDocument iDocument, IStorage iStorage) throws CoreException {
        Resource resource;
        IFile iFile;
        Diagram diagram = (Diagram)iDocument.getContent();
        if (diagram != null && (iFile = WorkspaceSynchronizer.getFile((Resource)(resource = diagram.eResource()))) != null) {
            if (iFile.equals((Object)iStorage)) {
                iDocument.setContent(null);
            } else {
                throw new CoreException((IStatus)new Status(4, EditorIDEPlugin.getPluginId(), 1, EditorMessages.FileDocumentProvider_handleElementContentChanged, null));
            }
        }
        iDocument.setContent((Object)((IDiagramStorage)iStorage).getDiagram());
    }

    protected void disposeElementInfo(Object object, AbstractDocumentProvider.ElementInfo elementInfo) {
        ((DiagramStorageInfo)elementInfo).fListener.stopListening();
    }

    protected void doSaveDocument(IProgressMonitor iProgressMonitor, Object object, IDocument iDocument, boolean bl) throws CoreException {
        IStatus iStatus;
        final Diagram diagram = (Diagram)iDocument.getContent();
        Resource resource = diagram.eResource();
        if (!bl) {
            DiagramManager.checkSynchronizationState(resource);
        }
        if (!(iStatus = Services.getAccessController().checkModify(new Resource[]{resource}, (Object)MsgBox.getDefaultShell())).isOK()) {
            throw new CoreException(iStatus);
        }
        this.fireElementStateChanging(object);
        if (diagram.getElement() instanceof org.eclipse.epf.diagram.model.Diagram) {
            try {
                TxUtil.runInTransaction((EObject)diagram, (Runnable)new Runnable(){

                    public void run() {
                        diagram.persistChildren();
                        for (Object e : diagram.getChildren()) {
                            ((View)e).persistChildren();
                        }
                    }
                });
            }
            catch (ExecutionException executionException) {
                DiagramCorePlugin.getDefault().getLogger().logError((Throwable)executionException);
            }
        }
        ILibraryPersister.FailSafeMethodLibraryPersister failSafeMethodLibraryPersister = Services.getLibraryPersister((String)"xmi").getFailSafePersister();
        try {
            failSafeMethodLibraryPersister.save(resource);
            failSafeMethodLibraryPersister.commit();
        }
        catch (Exception exception) {
            CommonPlugin.getDefault().getLogger().logError((Throwable)exception);
            failSafeMethodLibraryPersister.rollback();
            this.fireElementStateChangeFailed(object);
            throw new CoreException((IStatus)new Status(4, "org.eclipse.epf.diagram.core", 5, exception.getLocalizedMessage(), null));
        }
        try {
            this.fDiagramMgr.removeDiagramBackup(SharedResourceDiagramDocumentProvider.getActivity((IEditorInput)object), diagram.getType());
            if ("ADD".equals(diagram.getType()) || "WPDD".equals(diagram.getType())) {
                org.eclipse.epf.diagram.model.Diagram diagram2 = (org.eclipse.epf.diagram.model.Diagram)diagram.getElement();
                diagram2.setNew(false);
            }
        }
        catch (RuntimeException runtimeException) {
            this.fireElementStateChangeFailed(object);
            throw runtimeException;
        }
        if (iProgressMonitor != null) {
            iProgressMonitor.done();
        }
        SharedResourceDiagramDocumentProvider.logResourceErrorsAndWarnings(resource);
    }

    private static void logResourceErrorsAndWarnings(Resource resource) {
        for (Resource.Diagnostic diagnostic : resource.getErrors()) {
            Log.error((Plugin)EditorPlugin.getInstance(), (int)1, (String)diagnostic.getMessage());
        }
        for (Resource.Diagnostic diagnostic : resource.getWarnings()) {
            Log.warning((Plugin)EditorPlugin.getInstance(), (int)7, (String)diagnostic.getMessage());
        }
    }

    public long getModificationStamp(Object object) {
        if (object instanceof IFileEditorInput) {
            IFileEditorInput iFileEditorInput = (IFileEditorInput)object;
            return FileSynchronizer.computeModificationStamp((IResource)iFileEditorInput.getFile());
        }
        return super.getModificationStamp(object);
    }

    public void setContent(IEditorInput iEditorInput) {
        AbstractDocumentProvider.ElementInfo elementInfo = this.getElementInfo(iEditorInput);
        if (elementInfo == null) {
            return;
        }
        IDocument iDocument = this.createEmptyDocument();
        IStatus iStatus = null;
        try {
            this.setDocumentContent(iDocument, iEditorInput);
        }
        catch (CoreException coreException) {
            iStatus = coreException.getStatus();
        }
        Object object = iDocument.getContent();
        this.fireElementContentAboutToBeReplaced(iEditorInput);
        this.removeUnchangedElementListeners(iEditorInput, elementInfo);
        elementInfo.fDocument.removeDocumentListener((IDocumentListener)elementInfo);
        elementInfo.fDocument.setContent(object);
        elementInfo.fCanBeSaved = false;
        elementInfo.fStatus = iStatus;
        this.addUnchangedElementListeners(iEditorInput, elementInfo);
        this.fireElementContentReplaced(iEditorInput);
    }

    public void handleElementContentChanged(IEditorInput iEditorInput) {
        AbstractDocumentProvider.ElementInfo elementInfo = this.getElementInfo(iEditorInput);
        if (elementInfo == null) {
            return;
        }
        IDocument iDocument = this.createEmptyDocument();
        IStatus iStatus = null;
        try {
            this.setDocumentContent(iDocument, iEditorInput);
        }
        catch (CoreException coreException) {
            iStatus = coreException.getStatus();
        }
        Object object = iDocument.getContent();
        if (!object.equals(elementInfo.fDocument.getContent())) {
            this.fireElementContentAboutToBeReplaced(iEditorInput);
            this.removeUnchangedElementListeners(iEditorInput, elementInfo);
            elementInfo.fDocument.removeDocumentListener((IDocumentListener)elementInfo);
            elementInfo.fDocument.setContent(object);
            elementInfo.fCanBeSaved = false;
            elementInfo.fStatus = iStatus;
            this.addUnchangedElementListeners(iEditorInput, elementInfo);
            this.fireElementContentReplaced(iEditorInput);
        } else {
            this.handleExistingDocumentSaved(iEditorInput, elementInfo, iStatus);
        }
    }

    private void handleExistingDocumentSaved(IEditorInput iEditorInput, AbstractDocumentProvider.ElementInfo elementInfo, IStatus iStatus) {
        this.removeUnchangedElementListeners(iEditorInput, elementInfo);
        elementInfo.fCanBeSaved = false;
        elementInfo.fStatus = iStatus;
        this.addUnchangedElementListeners(iEditorInput, elementInfo);
        this.fireElementDirtyStateChanged(iEditorInput, false);
    }

    public void markDocumentAsSaved(IFileEditorInput iFileEditorInput) {
        AbstractDocumentProvider.ElementInfo elementInfo = this.getElementInfo(iFileEditorInput);
        if (elementInfo == null) {
            return;
        }
        this.handleExistingDocumentSaved((IEditorInput)iFileEditorInput, elementInfo, null);
    }

    protected void doSynchronize(Object object, IProgressMonitor iProgressMonitor) throws CoreException {
        if (object instanceof IEditorInput) {
            this.handleElementContentChanged((IEditorInput)object);
            return;
        }
        super.doSynchronize(object, iProgressMonitor);
    }

    public boolean isSynchronized(Object object) {
        Diagram diagram;
        AbstractDocumentProvider.ElementInfo elementInfo = this.getElementInfo(object);
        if (elementInfo.fDocument instanceof IDiagramDocument && (diagram = ((IDiagramDocument)elementInfo.fDocument).getDiagram()) != null) {
            Resource resource = diagram.eResource();
            return resource != null && DiagramManager.isSynchronized(resource);
        }
        return super.isSynchronized(object);
    }

    public AbstractDocumentProvider.ElementInfo createNewElementInfo(IDocument iDocument) {
        AccessibleDiagramModificationListener accessibleDiagramModificationListener = new AccessibleDiagramModificationListener((AbstractDocumentProvider)this, (DiagramDocument)iDocument);
        DiagramStorageInfo diagramStorageInfo = new DiagramStorageInfo(iDocument, accessibleDiagramModificationListener);
        accessibleDiagramModificationListener.startListening();
        return diagramStorageInfo;
    }

    protected IRunnableContext getOperationRunner(IProgressMonitor iProgressMonitor) {
        return fileDiagramDocumentProvider.getOperationRunner(iProgressMonitor);
    }

    protected ISchedulingRule getSaveRule(Object object) {
        return fileDiagramDocumentProvider.getSaveRule(object);
    }

    public void allowEditing(IEditorInput iEditorInput) {
        Activity activity;
        Diagram diagram;
        AbstractDocumentProvider.ElementInfo elementInfo = this.getElementInfo(iEditorInput);
        if (elementInfo.fDocument instanceof IDiagramDocument && (diagram = ((IDiagramDocument)elementInfo.fDocument).getDiagram()) != null && diagram.eResource() == null && iEditorInput instanceof IDiagramFileEditorInputProxy && (activity = SharedResourceDiagramDocumentProvider.getActivity(iEditorInput)) != null) {
            this.fDiagramMgr.replaceTemporarily(activity, diagram);
        }
    }

    private static Activity getActivity(IEditorInput iEditorInput) {
        return (Activity)((IDiagramFileEditorInputProxy)iEditorInput).getDiagramEditorInput().getMethodElement();
    }

    public void reverseToSaved(IEditorInput iEditorInput) {
        Activity activity;
        Diagram diagram;
        AbstractDocumentProvider.ElementInfo elementInfo = this.getElementInfo(iEditorInput);
        if (elementInfo.fDocument instanceof IDiagramDocument && (diagram = ((IDiagramDocument)elementInfo.fDocument).getDiagram()) != null && diagram.eResource() != null && iEditorInput instanceof DiagramEditorInputProxy && (activity = SharedResourceDiagramDocumentProvider.getActivity(iEditorInput)) != null) {
            this.fDiagramMgr.reverseToSaved(activity, diagram, ((DiagramEditorInputProxy)iEditorInput).getPreferenceHint());
        }
    }

    public void lock(boolean bl) {
        this.locked = bl;
    }

    protected void updateCache(IStorageEditorInput iStorageEditorInput) throws CoreException {
        super.updateCache(iStorageEditorInput);
        StorageDocumentProvider.StorageInfo storageInfo = (StorageDocumentProvider.StorageInfo)this.getElementInfo(iStorageEditorInput);
        if (storageInfo != null && this.locked && storageInfo.fIsModifiable) {
            storageInfo.fIsModifiable = !this.locked;
        }
    }

    public boolean getLockedState() {
        return this.locked;
    }

    public boolean isModifiable(Object object) {
        if (!DiagramEditorUtil.isModifiable(object)) {
            return false;
        }
        return super.isModifiable(object);
    }

    private class DiagramStorageInfo
    extends StorageDocumentProvider.StorageInfo {
        DiagramModificationListener fListener;

        public DiagramStorageInfo(IDocument iDocument, DiagramModificationListener diagramModificationListener) {
            super((StorageDocumentProvider)SharedResourceDiagramDocumentProvider.this, iDocument);
            this.fListener = diagramModificationListener;
        }
    }

    private static class FileDiagramDocumentProviderEx
    extends FileDiagramDocumentProvider {
        private FileDiagramDocumentProviderEx() {
        }

        protected ISchedulingRule getSaveRule(Object object) {
            if (object instanceof IFileEditorInput) {
                IFileEditorInput iFileEditorInput = (IFileEditorInput)object;
                return this.computeSaveSchedulingRule((IResource)iFileEditorInput.getFile());
            }
            return null;
        }

        private ISchedulingRule computeSaveSchedulingRule(IResource iResource) {
            if (iResource.exists() && iResource.isSynchronized(0)) {
                return this.fResourceRuleFactory.refreshRule(iResource);
            }
            IResource iResource2 = iResource;
            while ((iResource2 = (iResource = iResource2).getParent()) != null && !iResource2.exists() && !iResource2.isSynchronized(0)) {
            }
            return this.fResourceRuleFactory.createRule(iResource);
        }

        protected IRunnableContext getOperationRunner(IProgressMonitor iProgressMonitor) {
            return super.getOperationRunner(iProgressMonitor);
        }
    }
}

