/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.configuration;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.configuration.AttributeFeatureValue;
import org.eclipse.epf.library.configuration.DefaultElementRealizer;
import org.eclipse.epf.library.configuration.ElementRealizer;
import org.eclipse.epf.library.configuration.FeatureValue;
import org.eclipse.epf.library.configuration.OrderedListComparator;
import org.eclipse.epf.library.configuration.ToManyFeatureValue;
import org.eclipse.epf.library.configuration.ToManyOppositeFeatureValue;
import org.eclipse.epf.library.configuration.ToOneFeatureValue;
import org.eclipse.epf.library.configuration.ToOneOppositeFeatureValue;
import org.eclipse.epf.library.edit.util.CategorySortHelper;
import org.eclipse.epf.library.edit.util.SectionList;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.Artifact;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.CapabilityPattern;
import org.eclipse.epf.uma.ContentCategory;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.DeliveryProcess;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Practice;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.SupportingMaterial;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.epf.uma.ecore.impl.MultiResourceEObject;
import org.eclipse.epf.uma.ecore.util.OppositeFeature;
import org.eclipse.epf.uma.util.AssociationHelper;

public class ConfigurationHelper {
    public static final String ATTRIBUTE_VALUE_SEPERATOR = "<p/>";
    private static boolean debug = LibraryPlugin.getDefault().isDebugging();

    public static boolean isDescriptionElement(MethodElement methodElement) {
        if (methodElement == null) {
            return false;
        }
        return methodElement instanceof ContentDescription || methodElement.eContainer() instanceof ContentDescription;
    }

    public static boolean isGlobalPackage(MethodPackage methodPackage) {
        if (methodPackage == null) {
            if (debug) {
                System.out.println("ConfigurationHelper.isGlobalPackage: method package is null");
            }
            return false;
        }
        MethodPlugin methodPlugin = LibraryUtil.getMethodPlugin((EObject)methodPackage);
        if (methodPlugin == null) {
            if (debug) {
                System.out.println("ConfigurationHelper.isGlobalPackage: Unable to find method plug-in for " + methodPackage.getName() + ": " + methodPackage.getGuid());
            }
            return false;
        }
        return TngUtil.getAllSystemPackages((MethodPlugin)methodPlugin).contains(methodPackage);
    }

    public static boolean inConfig(MethodElement methodElement, MethodConfiguration methodConfiguration) {
        return ConfigurationHelper.inConfig(methodElement, methodConfiguration, true);
    }

    public static boolean inConfig(MethodElement methodElement, MethodConfiguration methodConfiguration, boolean bl) {
        VariabilityElement variabilityElement;
        if (!ConfigurationHelper.isOwnerSelected(methodElement, methodConfiguration, bl)) {
            return false;
        }
        if (methodElement instanceof VariabilityElement && ConfigurationHelper.isReplacer(variabilityElement = (VariabilityElement)methodElement)) {
            VariabilityElement variabilityElement2 = variabilityElement.getVariabilityBasedOnElement();
            if (ConfigurationHelper.inConfig((MethodElement)variabilityElement2, methodConfiguration)) {
                for (VariabilityElement variabilityElement3 : AssociationHelper.getImmediateVarieties((VariabilityElement)variabilityElement2)) {
                    if (variabilityElement3 == methodElement || variabilityElement3.getVariabilityType() != VariabilityType.REPLACES_LITERAL || !ConfigurationHelper.isOwnerSelected((MethodElement)variabilityElement3, methodConfiguration, bl)) continue;
                    if (debug) {
                        System.out.println("ConfigurationHelper.inConfig: Ignoring replacing element '" + LibraryUtil.getTypeName(methodElement) + "' since its base element has more than one replacer in the configuration");
                    }
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private static boolean isOwnerSelected(MethodElement methodElement, MethodConfiguration methodConfiguration, boolean bl) {
        Object object;
        List list;
        ILibraryManager iLibraryManager;
        MethodLibrary methodLibrary = LibraryServiceUtil.getMethodLibrary((MethodElement)methodConfiguration);
        ILibraryManager iLibraryManager2 = iLibraryManager = methodLibrary == null ? null : LibraryService.getInstance().getLibraryManager(methodLibrary);
        if (iLibraryManager != null) {
            return LibraryService.getInstance().getConfigurationManager(methodConfiguration).getConfigurationData().isOwnerSelected(methodElement, bl);
        }
        if (methodElement == null) {
            return false;
        }
        if (methodConfiguration == null || ConfigurationHelper.isDescriptionElement(methodElement)) {
            return true;
        }
        if (bl && (list = methodConfiguration.getSubtractedCategory()).size() > 0) {
            object = list.iterator();
            while (object.hasNext()) {
                ContentCategory contentCategory = (ContentCategory)object.next();
                if (contentCategory == methodElement) {
                    return false;
                }
                if (contentCategory instanceof CustomCategory) {
                    if (!((CustomCategory)contentCategory).getCategorizedElements().contains(methodElement)) continue;
                    return false;
                }
                System.out.println("TODO, isOwnerSelected: not implemented yet");
            }
        }
        if (methodElement instanceof MethodLibrary || methodElement instanceof MethodConfiguration) {
            return true;
        }
        if (methodElement instanceof MethodPlugin) {
            list = methodConfiguration.getMethodPluginSelection();
            return list != null && list.contains(methodElement);
        }
        if (methodElement instanceof Activity && (list = (Activity)((Activity)methodElement).getVariabilityBasedOnElement()) != null && list != methodElement && (object = TngUtil.getOwningProcess((BreakdownElement)list)) != null && object != methodElement && !ConfigurationHelper.inConfig((MethodElement)object, methodConfiguration, bl)) {
            return false;
        }
        list = LibraryUtil.getSelectable((EObject)methodElement);
        if (list instanceof MethodPackage && ConfigurationHelper.isGlobalPackage((MethodPackage)list)) {
            object = LibraryUtil.getMethodPlugin((EObject)list);
            return ConfigurationHelper.inConfig((MethodElement)object, methodConfiguration, bl);
        }
        object = methodConfiguration.getMethodPackageSelection();
        if (object == null) {
            return false;
        }
        if (list instanceof ProcessPackage) {
            while (list != null && !(list instanceof ProcessComponent) && !object.contains(list)) {
                list = list.eContainer();
            }
        }
        return list != null && object.contains(list);
    }

    public static boolean isContributor(VariabilityElement variabilityElement) {
        if (variabilityElement == null || variabilityElement.getVariabilityBasedOnElement() == null) {
            return false;
        }
        return variabilityElement.getVariabilityType() == VariabilityType.CONTRIBUTES_LITERAL;
    }

    public static boolean isReplacer(VariabilityElement variabilityElement) {
        if (variabilityElement == null || variabilityElement.getVariabilityBasedOnElement() == null) {
            return false;
        }
        return variabilityElement.getVariabilityType() == VariabilityType.REPLACES_LITERAL;
    }

    public static boolean isExtendReplacer(VariabilityElement variabilityElement) {
        if (variabilityElement == null || variabilityElement.getVariabilityBasedOnElement() == null) {
            return false;
        }
        return variabilityElement.getVariabilityType() == VariabilityType.EXTENDS_REPLACES_LITERAL;
    }

    public static boolean isExtender(VariabilityElement variabilityElement) {
        if (variabilityElement == null || variabilityElement.getVariabilityBasedOnElement() == null) {
            return false;
        }
        return variabilityElement.getVariabilityType() == VariabilityType.EXTENDS_LITERAL;
    }

    public static VariabilityElement getReplacer(VariabilityElement variabilityElement, MethodConfiguration methodConfiguration) {
        VariabilityElement variabilityElement2 = null;
        for (VariabilityElement variabilityElement3 : AssociationHelper.getImmediateVarieties((VariabilityElement)variabilityElement)) {
            VariabilityType variabilityType;
            if (variabilityElement3 == null || !ConfigurationHelper.inConfig((MethodElement)variabilityElement3, methodConfiguration) || (variabilityType = variabilityElement3.getVariabilityType()) != VariabilityType.REPLACES_LITERAL && variabilityType != VariabilityType.EXTENDS_REPLACES_LITERAL) continue;
            if (variabilityElement2 != null) {
                if (debug) {
                    System.out.println("ConfigurationHelper.getReplacer: Replacer ignored for element '" + LibraryUtil.getTypeName((MethodElement)variabilityElement) + "' since it has more than one replacerin the configuration");
                }
                return null;
            }
            variabilityElement2 = variabilityElement3;
        }
        return variabilityElement2;
    }

    public static List getContributors(VariabilityElement variabilityElement, MethodConfiguration methodConfiguration) {
        ArrayList<VariabilityElement> arrayList = new ArrayList<VariabilityElement>();
        if (variabilityElement == null) {
            return arrayList;
        }
        for (VariabilityElement variabilityElement2 : AssociationHelper.getImmediateVarieties((VariabilityElement)variabilityElement)) {
            if (variabilityElement2 == null || variabilityElement2.getVariabilityType() != VariabilityType.CONTRIBUTES_LITERAL || !ConfigurationHelper.inConfig((MethodElement)variabilityElement2, methodConfiguration)) continue;
            VariabilityElement variabilityElement3 = ConfigurationHelper.getReplacer(variabilityElement2, methodConfiguration);
            if (variabilityElement3 != null) {
                arrayList.add(variabilityElement3);
                continue;
            }
            arrayList.add(variabilityElement2);
        }
        return arrayList;
    }

    public static List getExtenders(VariabilityElement variabilityElement, MethodConfiguration methodConfiguration) {
        ArrayList<VariabilityElement> arrayList = new ArrayList<VariabilityElement>();
        if (variabilityElement == null) {
            return arrayList;
        }
        for (VariabilityElement variabilityElement2 : AssociationHelper.getImmediateVarieties((VariabilityElement)variabilityElement)) {
            if (variabilityElement2 == null || variabilityElement2.getVariabilityType() != VariabilityType.EXTENDS_LITERAL || !ConfigurationHelper.inConfig((MethodElement)variabilityElement2, methodConfiguration)) continue;
            arrayList.add(variabilityElement2);
        }
        return arrayList;
    }

    public static boolean canShow(MethodElement methodElement, MethodConfiguration methodConfiguration) {
        return ConfigurationHelper.canShow(methodElement, methodConfiguration, true);
    }

    /*
     * Unable to fully structure code
     */
    public static boolean canShow(MethodElement var0, MethodConfiguration var1_1, boolean var2_2) {
        block6: {
            if (var0 == null) {
                return false;
            }
            if (!ConfigurationHelper.inConfig(var0, var1_1, var2_2)) {
                return false;
            }
            var3_3 = var0.getSuppressed();
            if (var3_3 != null && var3_3.booleanValue()) {
                return false;
            }
            if (!(var0 instanceof VariabilityElement)) break block6;
            var4_4 = (VariabilityElement)var0;
            if (ConfigurationHelper.isExtender(var4_4)) {
                return true;
            }
            if (ConfigurationHelper.isContributor(var4_4) || ConfigurationHelper.getReplacer(var4_4, var1_1) != null) {
                return false;
            }
            if (!(var4_4 instanceof Activity) || !ConfigurationHelper.hasContributor((Activity)var4_4)) ** GOTO lbl18
            return false;
lbl-1000:
            // 1 sources

            {
                if (!ConfigurationHelper.isContributor(var4_4 = var4_4.getVariabilityBasedOnElement())) continue;
                return false;
lbl18:
                // 2 sources

                ** while (var4_4 != null && ConfigurationHelper.isReplacer((VariabilityElement)var4_4))
            }
        }
        return true;
    }

    public static String getName(MethodElement methodElement, MethodConfiguration methodConfiguration) {
        if (methodElement instanceof VariabilityElement) {
            VariabilityElement variabilityElement = (VariabilityElement)methodElement;
            if (ConfigurationHelper.isContributor(variabilityElement)) {
                return ConfigurationHelper.getName((MethodElement)variabilityElement.getVariabilityBasedOnElement(), methodConfiguration);
            }
            VariabilityElement variabilityElement2 = ConfigurationHelper.getReplacer(variabilityElement, methodConfiguration);
            if (variabilityElement2 != null) {
                return ConfigurationHelper.getName((MethodElement)variabilityElement2, methodConfiguration);
            }
        }
        return methodElement.getName();
    }

    public static String getPresentationName(MethodElement methodElement, MethodConfiguration methodConfiguration) {
        String string = null;
        if (methodElement instanceof DescribableElement && StrUtil.isBlank((String)(string = ((DescribableElement)methodElement).getPresentationName())) && methodElement instanceof VariabilityElement) {
            EReference eReference = UmaPackage.eINSTANCE.getVariabilityElement_VariabilityBasedOnElement();
            DefaultElementRealizer defaultElementRealizer = new DefaultElementRealizer(methodConfiguration);
            MethodElement methodElement2 = methodElement;
            do {
                VariabilityElement variabilityElement = (VariabilityElement)methodElement2;
                if ((methodElement2 = (DescribableElement)ConfigurationHelper.calc01FeatureValue(methodElement2, (EStructuralFeature)eReference, (ElementRealizer)defaultElementRealizer)) == null) break;
                if (variabilityElement != methodElement2) continue;
                methodElement2 = variabilityElement.getVariabilityBasedOnElement();
            } while (StrUtil.isBlank((String)(string = ((DescribableElement)methodElement2).getPresentationName())));
        }
        if (StrUtil.isBlank(string)) {
            string = TngUtil.getPresentationName((Object)methodElement);
        }
        return string;
    }

    public static VariabilityElement getVariableOwner(MethodElement methodElement) {
        EObject eObject;
        if (methodElement instanceof VariabilityElement) {
            return (VariabilityElement)methodElement;
        }
        if (methodElement instanceof ContentDescription && (eObject = methodElement.eContainer()) instanceof VariabilityElement) {
            return (VariabilityElement)eObject;
        }
        return null;
    }

    public static boolean isMergableAttribute(EStructuralFeature eStructuralFeature) {
        if (!eStructuralFeature.getEType().getInstanceClassName().equals("java.lang.String")) {
            return false;
        }
        return eStructuralFeature != UmaPackage.eINSTANCE.getMethodElement_Guid() && eStructuralFeature != UmaPackage.eINSTANCE.getNamedElement_Name() && eStructuralFeature != UmaPackage.eINSTANCE.getContentDescription_ExternalId() && eStructuralFeature != UmaPackage.eINSTANCE.getDescribableElement_PresentationName();
    }

    public static boolean isAttributeFeature(EStructuralFeature eStructuralFeature) {
        return eStructuralFeature.getEType() instanceof EAttribute;
    }

    public static boolean is01Feature(EStructuralFeature eStructuralFeature) {
        return eStructuralFeature.getEType() instanceof EClass && !eStructuralFeature.isMany();
    }

    public static boolean is0nFeature(EStructuralFeature eStructuralFeature) {
        return eStructuralFeature.getEType() instanceof EClass && eStructuralFeature.isMany();
    }

    private static void calculateFeature(MethodElement methodElement, MethodElement methodElement2, EStructuralFeature eStructuralFeature, MethodConfiguration methodConfiguration, FeatureValue featureValue, ElementRealizer elementRealizer) {
        List list = LibraryUtil.getStructuralFeatures(methodElement);
        if (!list.contains(eStructuralFeature)) {
            return;
        }
        VariabilityElement variabilityElement = ConfigurationHelper.getVariableOwner(methodElement2 == null ? methodElement : methodElement2);
        Object object = methodElement.eGet(eStructuralFeature);
        featureValue.add(variabilityElement, object);
        if (methodConfiguration == null) {
            return;
        }
        if (variabilityElement == null) {
            return;
        }
        ConfigurationHelper.__mergeBase(methodElement, variabilityElement, eStructuralFeature, methodConfiguration, featureValue, elementRealizer);
        if (!ConfigurationHelper.is01Feature(eStructuralFeature) || featureValue.size() == 0) {
            ConfigurationHelper.__mergeContributors(methodElement, variabilityElement, eStructuralFeature, methodConfiguration, featureValue, elementRealizer);
        }
    }

    private static void __mergeBase(MethodElement methodElement, VariabilityElement variabilityElement, EStructuralFeature eStructuralFeature, MethodConfiguration methodConfiguration, FeatureValue featureValue, ElementRealizer elementRealizer) {
        boolean bl = ConfigurationHelper.isExtendReplacer(variabilityElement) || ElementRealizer.isExtendReplaceEnabled() && ConfigurationHelper.isReplacer(variabilityElement);
        boolean bl2 = ConfigurationHelper.isExtender(variabilityElement);
        if (bl2 || bl) {
            boolean bl3 = false;
            if (ConfigurationHelper.is0nFeature(eStructuralFeature)) {
                bl3 = true;
                if (bl || bl2 && ElementRealizer.ignoreBaseToManyAssociations()) {
                    bl3 = featureValue.size() == 0;
                }
            } else if (ConfigurationHelper.is01Feature(eStructuralFeature)) {
                bl3 = featureValue.size() == 0;
            } else {
                boolean bl4 = bl3 = ConfigurationHelper.isMergableAttribute(eStructuralFeature) && featureValue.size() == 0;
            }
            if (bl3) {
                List list;
                VariabilityElement variabilityElement2 = variabilityElement.getVariabilityBasedOnElement();
                if (!bl) {
                    variabilityElement2 = ConfigurationHelper.getCalculatedElement((MethodElement)variabilityElement2, methodConfiguration);
                }
                VariabilityElement variabilityElement3 = variabilityElement2;
                if (ConfigurationHelper.isContainmentFeature(eStructuralFeature) && (list = ConfigurationHelper.getContainers((MethodElement)variabilityElement, methodConfiguration)).contains(variabilityElement2)) {
                    bl3 = false;
                }
                if (bl3 && variabilityElement != variabilityElement2 && ConfigurationHelper.inConfig((MethodElement)variabilityElement2, methodConfiguration)) {
                    if (methodElement instanceof ContentDescription) {
                        try {
                            variabilityElement2 = ((DescribableElement)variabilityElement2).getPresentation();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    ConfigurationHelper.calculateFeature((MethodElement)variabilityElement2, (MethodElement)variabilityElement3, eStructuralFeature, methodConfiguration, featureValue, elementRealizer);
                    if (variabilityElement instanceof ContentElement && eStructuralFeature == UmaPackage.eINSTANCE.getContentDescription_Sections()) {
                        ConfigurationHelper.orderSections((ContentElement)variabilityElement, (List)featureValue.getValue());
                    }
                }
            }
        }
    }

    private static void __mergeContributors(MethodElement methodElement, VariabilityElement variabilityElement, EStructuralFeature eStructuralFeature, MethodConfiguration methodConfiguration, FeatureValue featureValue, ElementRealizer elementRealizer) {
        List list;
        boolean bl = true;
        if (ConfigurationHelper.isAttributeFeature(eStructuralFeature) && !ConfigurationHelper.isMergableAttribute(eStructuralFeature)) {
            bl = false;
        }
        if (bl && (list = ConfigurationHelper.getContributors(variabilityElement, methodConfiguration)) != null && list.size() > 0) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                MethodElement methodElement2;
                MethodElement methodElement3 = methodElement2 = (MethodElement)iterator.next();
                if (methodElement instanceof ContentDescription) {
                    methodElement2 = ((DescribableElement)methodElement2).getPresentation();
                }
                ConfigurationHelper.calculateFeature(methodElement2, methodElement3, eStructuralFeature, methodConfiguration, featureValue, elementRealizer);
            }
        }
    }

    private static void calculateOppositeFeature(MethodElement methodElement, OppositeFeature oppositeFeature, ElementRealizer elementRealizer, FeatureValue featureValue) {
        ConfigurationHelper.calculateOppositeFeature(methodElement, oppositeFeature, true, false, elementRealizer, featureValue);
    }

    private static void calculateOppositeFeature(MethodElement methodElement, OppositeFeature oppositeFeature, boolean bl, boolean bl2, ElementRealizer elementRealizer, FeatureValue featureValue) {
        if (!(methodElement instanceof MultiResourceEObject)) {
            return;
        }
        MethodConfiguration methodConfiguration = elementRealizer.getConfiguration();
        VariabilityElement variabilityElement = ConfigurationHelper.getVariableOwner(methodElement);
        Object object = ((MultiResourceEObject)methodElement).getOppositeFeatureValue(oppositeFeature);
        featureValue.add(variabilityElement, object);
        if (methodElement instanceof VariabilityElement && methodConfiguration != null) {
            boolean bl3;
            VariabilityElement variabilityElement2 = (VariabilityElement)methodElement;
            List list = ConfigurationHelper.getContributors(variabilityElement2, methodConfiguration);
            if (list != null && list.size() > 0) {
                for (MethodElement methodElement2 : list) {
                    ConfigurationHelper.calculateOppositeFeature(methodElement2, oppositeFeature, bl, bl2, elementRealizer, featureValue);
                }
            }
            boolean bl4 = false;
            boolean bl5 = ConfigurationHelper.isExtender(variabilityElement2);
            boolean bl6 = ConfigurationHelper.isReplacer(variabilityElement2);
            boolean bl7 = bl3 = ConfigurationHelper.isExtendReplacer(variabilityElement2) || ElementRealizer.isExtendReplaceEnabled() && bl6;
            if (bl3) {
                bl6 = true;
            }
            if (bl6) {
                bl4 = bl && (object instanceof List || featureValue.size() == 0);
            } else if (bl5) {
                bl4 = bl2;
            }
            if (bl4) {
                DefaultElementRealizer defaultElementRealizer = new DefaultElementRealizer(methodConfiguration, !bl6, !bl6);
                MethodElement methodElement3 = ConfigurationHelper.getCalculatedElement((MethodElement)variabilityElement2.getVariabilityBasedOnElement(), defaultElementRealizer);
                if (methodElement3 == null) {
                    methodElement3 = variabilityElement2.getVariabilityBasedOnElement();
                }
                if (methodElement3 != variabilityElement2 && ConfigurationHelper.inConfig(methodElement3, methodConfiguration)) {
                    ConfigurationHelper.calculateOppositeFeature(methodElement3, oppositeFeature, bl, bl2, elementRealizer, featureValue);
                }
            }
        }
    }

    public static List getCalculatedElements(List list, MethodConfiguration methodConfiguration) {
        return ConfigurationHelper.getCalculatedElements(list, new DefaultElementRealizer(methodConfiguration));
    }

    public static List getCalculatedElements(List list, ElementRealizer elementRealizer) {
        ArrayList<MethodElement> arrayList = new ArrayList<MethodElement>();
        for (MethodElement methodElement : list) {
            if ((methodElement = ConfigurationHelper.getCalculatedElement(methodElement, elementRealizer)) == null || arrayList.contains(methodElement)) continue;
            arrayList.add(methodElement);
        }
        return arrayList;
    }

    public static MethodElement getCalculatedElement(MethodElement methodElement, MethodConfiguration methodConfiguration) {
        DefaultElementRealizer defaultElementRealizer = new DefaultElementRealizer(methodConfiguration, true, true);
        return ConfigurationHelper.getCalculatedElement(methodElement, defaultElementRealizer);
    }

    public static MethodElement getCalculatedElement(MethodElement methodElement, ElementRealizer elementRealizer) {
        MethodElement methodElement2;
        MethodElement methodElement3 = methodElement;
        while ((methodElement2 = elementRealizer.realize(methodElement3)) != methodElement3) {
            methodElement3 = methodElement2;
        }
        return methodElement3;
    }

    public static MethodElement calc01FeatureValue(MethodElement methodElement, EStructuralFeature eStructuralFeature, ElementRealizer elementRealizer) {
        return ConfigurationHelper.calc01FeatureValue(methodElement, null, eStructuralFeature, elementRealizer);
    }

    public static MethodElement calc01FeatureValue(MethodElement methodElement, MethodElement methodElement2, EStructuralFeature eStructuralFeature, ElementRealizer elementRealizer) {
        Object object = methodElement.eGet(eStructuralFeature);
        if (object instanceof ContentDescription) {
            return (MethodElement)object;
        }
        ToOneFeatureValue toOneFeatureValue = new ToOneFeatureValue(methodElement, methodElement2, eStructuralFeature, elementRealizer);
        ConfigurationHelper.calculateFeature(methodElement, methodElement2, eStructuralFeature, elementRealizer.getConfiguration(), toOneFeatureValue, elementRealizer);
        return (MethodElement)toOneFeatureValue.getValue();
    }

    public static boolean isContainmentFeature(EStructuralFeature eStructuralFeature) {
        return eStructuralFeature == UmaPackage.eINSTANCE.getArtifact_ContainedArtifacts() || eStructuralFeature == UmaPackage.eINSTANCE.getPractice_SubPractices();
    }

    public static boolean isContainmentElement(Object object) {
        return object instanceof Artifact || object instanceof Practice;
    }

    private static List getContainers(MethodElement methodElement, MethodConfiguration methodConfiguration) {
        ArrayList<MethodElement> arrayList = new ArrayList<MethodElement>();
        MethodElement methodElement2 = methodElement;
        while (methodElement2 != null && (methodElement2 = methodElement2.eContainer()) != null && methodElement2.getClass().isInstance(methodElement)) {
            if (methodElement2 instanceof VariabilityElement) {
                methodElement2 = ConfigurationHelper.getCalculatedElement((MethodElement)((VariabilityElement)methodElement2), methodConfiguration);
            }
            if (methodElement2 == null || arrayList.contains(methodElement2)) continue;
            arrayList.add(methodElement2);
        }
        return arrayList;
    }

    public static OppositeFeature get01OppositeFeature(EStructuralFeature eStructuralFeature) {
        return null;
    }

    public static EStructuralFeature get01Feature(OppositeFeature oppositeFeature) {
        if (oppositeFeature == AssociationHelper.Role_Primary_Tasks || oppositeFeature == AssociationHelper.RoleDescriptor_PrimaryTaskDescriptors) {
            return oppositeFeature.getTargetFeature();
        }
        return null;
    }

    public static List calc0nFeatureValue(MethodElement methodElement, EStructuralFeature eStructuralFeature, ElementRealizer elementRealizer) {
        return ConfigurationHelper.calc0nFeatureValue(methodElement, null, eStructuralFeature, elementRealizer);
    }

    public static List calc0nFeatureValue(MethodElement methodElement, MethodElement methodElement2, EStructuralFeature eStructuralFeature, ElementRealizer elementRealizer) {
        DefaultElementRealizer defaultElementRealizer;
        OppositeFeature oppositeFeature;
        Object object;
        List list = null;
        MethodConfiguration methodConfiguration = elementRealizer.getConfiguration();
        if (methodElement instanceof Role && eStructuralFeature == UmaPackage.eINSTANCE.getRole_Modifies()) {
            list = ConfigurationHelper.calcModifiedWorkProducts((Role)methodElement, methodElement2, elementRealizer);
        } else if (methodElement instanceof RoleDescriptor && eStructuralFeature == UmaPackage.eINSTANCE.getRoleDescriptor_Modifies()) {
            list = ConfigurationHelper.calcModifiedWorkProductDescriptors((RoleDescriptor)methodElement, methodElement2, elementRealizer);
        } else {
            object = new ToManyFeatureValue(methodElement, methodElement2, eStructuralFeature, elementRealizer);
            ConfigurationHelper.calculateFeature(methodElement, methodElement2, eStructuralFeature, methodConfiguration, (FeatureValue)object, elementRealizer);
            list = (List)((ToManyFeatureValue)object).getValue();
        }
        object = ConfigurationHelper.getCalculatedElements(list, elementRealizer);
        if (object.contains(methodElement)) {
            object.remove(methodElement);
        }
        if ((oppositeFeature = ConfigurationHelper.get01OppositeFeature(eStructuralFeature)) != null) {
            int n = 0;
            while (n < object.size()) {
                MethodElement methodElement3 = (MethodElement)object.get(n);
                defaultElementRealizer = new DefaultElementRealizer(methodConfiguration);
                defaultElementRealizer.setShowSubtracted(elementRealizer.showSubtracted());
                MethodElement methodElement4 = ConfigurationHelper.calc01FeatureValue(methodElement3, oppositeFeature, (ElementRealizer)defaultElementRealizer);
                if (methodElement4 != methodElement) {
                    object.remove(n);
                    continue;
                }
                ++n;
            }
        }
        if (ConfigurationHelper.isContainmentFeature(eStructuralFeature)) {
            List list2 = ConfigurationHelper.getContainers(methodElement, methodConfiguration);
            int n = 0;
            while (n < object.size()) {
                defaultElementRealizer = object.get(n);
                if (defaultElementRealizer == methodElement || list2.contains(defaultElementRealizer)) {
                    object.remove(n);
                    continue;
                }
                ++n;
            }
        }
        List list3 = elementRealizer.realize(methodElement, eStructuralFeature, (List)object);
        if (CategorySortHelper.needToSort((MethodElement)methodElement, (EStructuralFeature)eStructuralFeature)) {
            list3 = CategorySortHelper.sortCategoryElements((MethodElement)methodElement, (Object[])list3.toArray(), (boolean)true);
        }
        return list3;
    }

    public static boolean isContainerInList(MethodElement methodElement, List list, MethodConfiguration methodConfiguration) {
        MethodElement methodElement2 = methodElement;
        while (methodElement2 != null && (methodElement2 = methodElement2.eContainer()) != null && methodElement2.getClass().isInstance(methodElement)) {
            if (list.contains(methodElement2)) {
                return true;
            }
            if (methodElement2 instanceof VariabilityElement) {
                methodElement2 = ConfigurationHelper.getCalculatedElement((MethodElement)((VariabilityElement)methodElement2), methodConfiguration);
            }
            if (methodElement2 == null || !list.contains(methodElement2)) continue;
            return true;
        }
        return false;
    }

    public static Object calcAttributeFeatureValue(MethodElement methodElement, EStructuralFeature eStructuralFeature, MethodConfiguration methodConfiguration) {
        return ConfigurationHelper.calcAttributeFeatureValue(methodElement, null, eStructuralFeature, methodConfiguration);
    }

    public static Object calcAttributeFeatureValue(MethodElement methodElement, MethodElement methodElement2, EStructuralFeature eStructuralFeature, MethodConfiguration methodConfiguration) {
        if (ConfigurationHelper.isMergableAttribute(eStructuralFeature)) {
            DefaultElementRealizer defaultElementRealizer = new DefaultElementRealizer(methodConfiguration);
            AttributeFeatureValue attributeFeatureValue = new AttributeFeatureValue(methodElement, methodElement2, eStructuralFeature, defaultElementRealizer);
            ConfigurationHelper.calculateFeature(methodElement, methodElement2, eStructuralFeature, methodConfiguration, attributeFeatureValue, defaultElementRealizer);
            return attributeFeatureValue.getValue();
        }
        return methodElement.eGet(eStructuralFeature);
    }

    public static List calc0nFeatureValue(MethodElement methodElement, OppositeFeature oppositeFeature, ElementRealizer elementRealizer) {
        return ConfigurationHelper.calc0nFeatureValue(methodElement, oppositeFeature, true, false, elementRealizer);
    }

    public static List calc0nFeatureValue(MethodElement methodElement, OppositeFeature oppositeFeature, boolean bl, boolean bl2, ElementRealizer elementRealizer) {
        ToManyOppositeFeatureValue toManyOppositeFeatureValue = new ToManyOppositeFeatureValue(methodElement, oppositeFeature, elementRealizer);
        ConfigurationHelper.calculateOppositeFeature(methodElement, oppositeFeature, bl, bl2, elementRealizer, toManyOppositeFeatureValue);
        return (List)toManyOppositeFeatureValue.getValue();
    }

    public static MethodElement calc01FeatureValue(MethodElement methodElement, OppositeFeature oppositeFeature, ElementRealizer elementRealizer) {
        ToOneOppositeFeatureValue toOneOppositeFeatureValue = new ToOneOppositeFeatureValue(methodElement, oppositeFeature, elementRealizer);
        ConfigurationHelper.calculateOppositeFeature(methodElement, oppositeFeature, elementRealizer, toOneOppositeFeatureValue);
        return (MethodElement)toOneOppositeFeatureValue.getValue();
    }

    public static void orderSections(ContentElement contentElement, List list) {
        String string = contentElement.getOrderingGuide();
        if (string == null || string.trim().length() == 0) {
            return;
        }
        SectionList sectionList = new SectionList(contentElement, 2);
        if (ConfigurationHelper.isSameList(list, (List)sectionList)) {
            list.clear();
            list.addAll(sectionList);
            return;
        }
        OrderedListComparator orderedListComparator = new OrderedListComparator(new ArrayList(list), (List)sectionList);
        TreeSet treeSet = new TreeSet(orderedListComparator);
        treeSet.addAll(list);
        list.clear();
        list.addAll(treeSet);
    }

    private static boolean isSameList(List list, List list2) {
        if (list.size() != list2.size()) {
            return false;
        }
        for (Object e : list) {
            if (list2.contains(e)) continue;
            return false;
        }
        return true;
    }

    private static void calculateCopyright(MethodElement methodElement, MethodConfiguration methodConfiguration, List list) {
        Object object;
        MethodElement methodElement2;
        VariabilityElement variabilityElement;
        SupportingMaterial supportingMaterial = (SupportingMaterial)ConfigurationHelper.getCalculatedElement((MethodElement)LibraryUtil.getCopyright(methodElement), methodConfiguration);
        if (supportingMaterial != null && !list.contains(supportingMaterial)) {
            list.add(supportingMaterial);
        }
        if ((variabilityElement = ConfigurationHelper.getVariableOwner(methodElement)) == null) {
            return;
        }
        if (methodConfiguration == null) {
            return;
        }
        List list2 = ConfigurationHelper.getContributors(variabilityElement, methodConfiguration);
        if (list2 != null && list2.size() > 0) {
            methodElement2 = list2.iterator();
            while (methodElement2.hasNext()) {
                object = (MethodElement)methodElement2.next();
                ConfigurationHelper.calculateCopyright((MethodElement)object, methodConfiguration, list);
            }
        }
        if (ConfigurationHelper.isExtender(variabilityElement) && variabilityElement != (methodElement2 = ConfigurationHelper.getCalculatedElement((MethodElement)variabilityElement.getVariabilityBasedOnElement(), methodConfiguration)) && ConfigurationHelper.inConfig(methodElement2, methodConfiguration)) {
            object = new ArrayList();
            ConfigurationHelper.calculateCopyright(methodElement2, methodConfiguration, (List)object);
            if (object.size() > 0) {
                int n = 0;
                while (n < list.size()) {
                    if (object.contains(list.get(n))) {
                        list.remove(n);
                        continue;
                    }
                    ++n;
                }
                list.addAll(0, object);
            }
        }
    }

    public static String getCopyrightText(MethodElement methodElement, MethodConfiguration methodConfiguration) {
        StringBuffer stringBuffer = new StringBuffer();
        ArrayList arrayList = new ArrayList();
        ConfigurationHelper.calculateCopyright(methodElement, methodConfiguration, arrayList);
        if (arrayList.size() > 0) {
            for (SupportingMaterial supportingMaterial : arrayList) {
                String string = (String)ConfigurationHelper.calcAttributeFeatureValue((MethodElement)supportingMaterial.getPresentation(), (MethodElement)supportingMaterial, (EStructuralFeature)UmaPackage.eINSTANCE.getContentDescription_MainDescription(), methodConfiguration);
                if (string == null || string.length() <= 0) continue;
                String string2 = ResourceHelper.getElementPath((MethodElement)supportingMaterial);
                String string3 = ResourceHelper.getBackPath(methodElement);
                string = ResourceHelper.fixContentUrlPath(string, string2, string3);
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(ATTRIBUTE_VALUE_SEPERATOR);
                }
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    public static String getActivityStringAttribute(MethodElement methodElement, MethodElement methodElement2, EAttribute eAttribute, MethodConfiguration methodConfiguration) {
        boolean bl;
        VariabilityElement variabilityElement;
        if (!String.class.isAssignableFrom(eAttribute.getEAttributeType().getInstanceClass())) {
            throw new IllegalArgumentException("The specified attribute is not of type String: " + eAttribute);
        }
        Object object = null;
        if (methodElement instanceof ContentDescription) {
            variabilityElement = (VariabilityElement)methodElement.eContainer();
            if (variabilityElement == null) {
                variabilityElement = (VariabilityElement)methodElement2;
            }
            bl = true;
        } else if (methodElement instanceof VariabilityElement) {
            variabilityElement = (VariabilityElement)methodElement;
            bl = false;
        } else {
            object = methodElement.eGet((EStructuralFeature)eAttribute);
            return object == null ? "" : object.toString();
        }
        if (eAttribute == UmaPackage.eINSTANCE.getMethodElement_Guid() || eAttribute == UmaPackage.eINSTANCE.getNamedElement_Name()) {
            return (String)methodElement.eGet((EStructuralFeature)eAttribute);
        }
        VariabilityElement variabilityElement2 = variabilityElement.getVariabilityBasedOnElement();
        VariabilityType variabilityType = variabilityElement.getVariabilityType();
        if (variabilityElement2 != null && variabilityType == VariabilityType.LOCAL_CONTRIBUTION_LITERAL) {
            Object object2;
            if (bl) {
                object = ((DescribableElement)variabilityElement).getPresentation().eGet((EStructuralFeature)eAttribute);
                object2 = ConfigurationHelper.calcAttributeFeatureValue((MethodElement)((DescribableElement)variabilityElement2).getPresentation(), (MethodElement)variabilityElement2, (EStructuralFeature)eAttribute, methodConfiguration);
            } else {
                object = variabilityElement.eGet((EStructuralFeature)eAttribute);
                object2 = ConfigurationHelper.calcAttributeFeatureValue((MethodElement)variabilityElement2, null, (EStructuralFeature)eAttribute, methodConfiguration);
            }
            if (object2 != null && object2.toString().length() > 0) {
                object = object != null && object.toString().length() > 0 ? object2 + ATTRIBUTE_VALUE_SEPERATOR + object : object2;
            }
        } else {
            object = ConfigurationHelper.calcAttributeFeatureValue(methodElement, (MethodElement)variabilityElement, (EStructuralFeature)eAttribute, methodConfiguration);
        }
        return object == null ? "" : object.toString();
    }

    public static List getAllProcesses(MethodConfiguration methodConfiguration) {
        ArrayList<Process> arrayList = new ArrayList<Process>();
        List list = methodConfiguration.getMethodPluginSelection();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            List list2 = TngUtil.getAllProcesses((MethodPlugin)((MethodPlugin)iterator.next()));
            for (Process process : list2) {
                if (!ConfigurationHelper.canShow((MethodElement)process, methodConfiguration) || arrayList.contains(process)) continue;
                arrayList.add(process);
            }
        }
        return arrayList;
    }

    public static List getAllProcesses(MethodPlugin methodPlugin, MethodConfiguration methodConfiguration) {
        ArrayList<Process> arrayList = new ArrayList<Process>();
        List list = TngUtil.getAllProcesses((MethodPlugin)methodPlugin);
        for (Process process : list) {
            if (!ConfigurationHelper.canShow((MethodElement)process, methodConfiguration) || arrayList.contains(process)) continue;
            arrayList.add(process);
        }
        return arrayList;
    }

    public static List getAllDeliveryProcesses(MethodPlugin methodPlugin, MethodConfiguration methodConfiguration) {
        ArrayList<Process> arrayList = new ArrayList<Process>();
        List list = TngUtil.getAllProcesses((MethodPlugin)methodPlugin);
        for (Process process : list) {
            if (!(process instanceof DeliveryProcess) || !ConfigurationHelper.canShow((MethodElement)process, methodConfiguration) || arrayList.contains(process)) continue;
            arrayList.add(process);
        }
        return arrayList;
    }

    public static List getAllCapabilityPatterns(MethodPlugin methodPlugin, MethodConfiguration methodConfiguration) {
        ArrayList<Process> arrayList = new ArrayList<Process>();
        List list = TngUtil.getAllProcesses((MethodPlugin)methodPlugin);
        for (Process process : list) {
            if (!(process instanceof CapabilityPattern) || !ConfigurationHelper.canShow((MethodElement)process, methodConfiguration) || arrayList.contains(process)) continue;
            arrayList.add(process);
        }
        return arrayList;
    }

    public static List calcModifiedWorkProducts(Role role, MethodElement methodElement, ElementRealizer elementRealizer) {
        List list = new ArrayList();
        OppositeFeature oppositeFeature = AssociationHelper.Role_Primary_Tasks;
        ToManyOppositeFeatureValue toManyOppositeFeatureValue = new ToManyOppositeFeatureValue((MethodElement)role, oppositeFeature, elementRealizer);
        ConfigurationHelper.calculateOppositeFeature((MethodElement)role, oppositeFeature, elementRealizer, toManyOppositeFeatureValue);
        if (toManyOppositeFeatureValue.size() > 0) {
            List list2 = (List)toManyOppositeFeatureValue.getValue();
            EReference eReference = UmaPackage.eINSTANCE.getTask_Output();
            for (MethodElement methodElement2 : list2) {
                ToManyFeatureValue toManyFeatureValue = new ToManyFeatureValue((MethodElement)role, methodElement, eReference, elementRealizer);
                ((List)toManyFeatureValue.getValue()).addAll(list);
                ConfigurationHelper.calculateFeature(methodElement2, methodElement, (EStructuralFeature)eReference, elementRealizer.getConfiguration(), toManyFeatureValue, elementRealizer);
                list = (List)toManyFeatureValue.getValue();
            }
        }
        return list;
    }

    public static List calcModifiedWorkProductDescriptors(RoleDescriptor roleDescriptor, MethodElement methodElement, ElementRealizer elementRealizer) {
        List list = new ArrayList();
        OppositeFeature oppositeFeature = AssociationHelper.RoleDescriptor_PrimaryTaskDescriptors;
        ToManyOppositeFeatureValue toManyOppositeFeatureValue = new ToManyOppositeFeatureValue((MethodElement)roleDescriptor, oppositeFeature, elementRealizer);
        ConfigurationHelper.calculateOppositeFeature((MethodElement)roleDescriptor, oppositeFeature, elementRealizer, toManyOppositeFeatureValue);
        if (toManyOppositeFeatureValue.size() > 0) {
            List list2 = (List)toManyOppositeFeatureValue.getValue();
            EReference eReference = UmaPackage.eINSTANCE.getTaskDescriptor_Output();
            for (MethodElement methodElement2 : list2) {
                ToManyFeatureValue toManyFeatureValue = new ToManyFeatureValue((MethodElement)roleDescriptor, methodElement, eReference, elementRealizer);
                ((List)toManyFeatureValue.getValue()).addAll(list);
                ConfigurationHelper.calculateFeature(methodElement2, methodElement, (EStructuralFeature)eReference, elementRealizer.getConfiguration(), toManyFeatureValue, elementRealizer);
                list = (List)toManyFeatureValue.getValue();
            }
        }
        return list;
    }

    public static List calcModifyRoles(WorkProduct workProduct, ElementRealizer elementRealizer) {
        List list = ConfigurationHelper.calc0nFeatureValue((MethodElement)workProduct, AssociationHelper.WorkProduct_OutputFrom_Tasks, elementRealizer);
        ArrayList<Role> arrayList = new ArrayList<Role>();
        for (Task task : list) {
            Role role = (Role)ConfigurationHelper.calc01FeatureValue((MethodElement)task, (EStructuralFeature)UmaPackage.eINSTANCE.getTask_PerformedBy(), elementRealizer);
            if (role == null || arrayList.contains(role)) continue;
            arrayList.add(role);
        }
        return arrayList;
    }

    public static List calcModifyRoleDescriptors(WorkProductDescriptor workProductDescriptor, ElementRealizer elementRealizer) {
        List list = ConfigurationHelper.calc0nFeatureValue((MethodElement)workProductDescriptor, AssociationHelper.WorkProductDescriptor_OutputFrom_TaskDescriptors, elementRealizer);
        ArrayList<RoleDescriptor> arrayList = new ArrayList<RoleDescriptor>();
        for (TaskDescriptor taskDescriptor : list) {
            RoleDescriptor roleDescriptor = (RoleDescriptor)ConfigurationHelper.calc01FeatureValue((MethodElement)taskDescriptor, (EStructuralFeature)UmaPackage.eINSTANCE.getTaskDescriptor_PerformedPrimarilyBy(), elementRealizer);
            if (roleDescriptor == null || arrayList.contains(roleDescriptor)) continue;
            arrayList.add(roleDescriptor);
        }
        return arrayList;
    }

    public static boolean hasContributor(Activity activity) {
        if (ConfigurationHelper.isContributor((VariabilityElement)activity)) {
            return true;
        }
        for (Object e : activity.getBreakdownElements()) {
            if (!(e instanceof Activity) || !ConfigurationHelper.hasContributor((Activity)e)) continue;
            return true;
        }
        return false;
    }

    public static List getBaseProcesses(Activity activity, MethodConfiguration methodConfiguration) {
        ArrayList arrayList = new ArrayList();
        ConfigurationHelper.getBaseProcesses(activity, methodConfiguration, arrayList);
        return arrayList;
    }

    public static void getBaseProcesses(Activity activity, MethodConfiguration methodConfiguration, List list) {
        Object object;
        if (ConfigurationHelper.isExtender((VariabilityElement)activity) && (object = (Activity)activity.getVariabilityBasedOnElement()) != null && !list.contains(object) && object instanceof Process) {
            if (ConfigurationHelper.canShow((MethodElement)object, methodConfiguration)) {
                list.add(object);
            }
            ConfigurationHelper.getBaseProcesses((Activity)object, methodConfiguration, list);
        }
        for (Object e : activity.getBreakdownElements()) {
            if (!(e instanceof Activity)) continue;
            ConfigurationHelper.getBaseProcesses((Activity)e, methodConfiguration, list);
        }
    }
}

