/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.layout;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.epf.library.layout.HtmlBuilder;
import org.eclipse.epf.library.layout.LayoutResources;

public class BrowsingLayoutSettings {
    public static BrowsingLayoutSettings INSTANCE = new BrowsingLayoutSettings();
    private boolean showExtraInfoForDescriptors = false;
    private boolean publishUnopenActivitydd = false;
    private boolean publishADForActivityExtension = false;
    private boolean useNewExtendSemantics = false;
    private File xslPath = null;
    private File cssPath = null;
    private List updatedSites = new ArrayList();

    public void setUseNewExtendSemantics(boolean bl) {
        this.useNewExtendSemantics = bl;
    }

    public boolean isUseNewExtendSemantics() {
        return this.useNewExtendSemantics;
    }

    public void setShowExtraInfoForDescriptors(boolean bl) {
        this.showExtraInfoForDescriptors = bl;
    }

    public boolean isShowExtraInfoForDescriptors() {
        return this.showExtraInfoForDescriptors;
    }

    public void setPublishUnopenActivitydd(boolean bl) {
        this.publishUnopenActivitydd = bl;
    }

    public boolean isPublishUnopenActivitydd() {
        return this.publishUnopenActivitydd;
    }

    public void setPublishADForActivityExtension(boolean bl) {
        this.publishADForActivityExtension = bl;
    }

    public boolean isPublishADForActivityExtension() {
        return this.publishADForActivityExtension;
    }

    public void setXslPath(File file) {
        this.xslPath = file;
    }

    public void setCssPath(File file) {
        this.cssPath = file;
    }

    public File getXslPath() {
        return this.xslPath;
    }

    public File getCssPath() {
        return this.cssPath;
    }

    public void setChanged() {
        this.updatedSites.clear();
    }

    public boolean needUpdate(String string) {
        if (string == null) {
            return false;
        }
        return !this.updatedSites.contains(string);
    }

    public void update(HtmlBuilder htmlBuilder) {
        if (htmlBuilder == null || !this.needUpdate(htmlBuilder.getPublishDir())) {
            return;
        }
        if (this.xslPath == null || this.cssPath == null) {
            LayoutResources.copyLayoutFiles(htmlBuilder.getPublishDir());
            htmlBuilder.loadDefaultLayoutXsl();
        } else {
            htmlBuilder.setLayoutXslRootPath(this.xslPath.getAbsolutePath());
            String string = "*.*,**/*.*";
            String string2 = null;
            boolean bl = true;
            File file = new File(htmlBuilder.getPublishDir(), "css");
            LayoutResources.copyDir(this.cssPath, file, string, string2, bl);
        }
        this.updatedSites.add(htmlBuilder.getPublishDir());
    }
}

