/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.layout.diagram;

import java.awt.Rectangle;
import java.io.File;
import org.eclipse.epf.library.layout.diagram.HTMLArea;
import org.eclipse.epf.library.layout.diagram.HTMLMap;
import org.eclipse.epf.library.layout.diagram.MethodElementDiagram;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.MethodElement;

public class DiagramInfo
extends MethodElementDiagram {
    private int suppressedCount = 0;

    public DiagramInfo(String string, MethodElement methodElement) {
        super(methodElement);
        super.setHTMLMap(new HTMLMap(String.valueOf(string) + "_" + methodElement.getName()));
    }

    public void addArea(MethodElement methodElement, int n, int n2, int n3, int n4, String string, boolean bl) {
        Rectangle rectangle;
        if (bl) {
            ++this.suppressedCount;
            return;
        }
        if (string == null) {
            if (methodElement instanceof DescribableElement) {
                string = ((DescribableElement)methodElement).getPresentationName();
                if ((string.length() < 1 || string == "") && methodElement instanceof Activity) {
                    rectangle = ((Activity)methodElement).getVariabilityBasedOnElement();
                    string = ((Activity)rectangle).getPresentationName();
                }
            } else {
                string = methodElement != null ? methodElement.getName() : "";
            }
        }
        rectangle = new Rectangle(n, n2, n3, n4);
        String string2 = ResourceHelper.getUrl(methodElement, super.getMethodElement(), ".html");
        HTMLMap hTMLMap = super.getHTMLMap();
        hTMLMap.addArea(new HTMLArea(methodElement.getGuid(), string2, "rect", rectangle, string));
    }

    public void setImageFilePath(String string) {
        super.setImageFileName(String.valueOf(ResourceHelper.getBackPath(super.getMethodElement())) + string.replace(File.separatorChar, '/'));
    }

    public int getAreaCount() {
        return super.getHTMLMap().size();
    }

    public int getSuppressedCount() {
        return this.suppressedCount;
    }

    public boolean isEmpty() {
        return this.getAreaCount() + this.getSuppressedCount() == 0;
    }
}

