/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.layout.elements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.common.utils.Timer;
import org.eclipse.epf.common.utils.XMLUtil;
import org.eclipse.epf.diagram.model.util.DiagramInfo;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryResources;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.util.Comparators;
import org.eclipse.epf.library.edit.util.ConfigurableComposedAdapterFactory;
import org.eclipse.epf.library.edit.util.PredecessorList;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.layout.ElementLayoutManager;
import org.eclipse.epf.library.layout.IElementLayout;
import org.eclipse.epf.library.layout.LayoutInfo;
import org.eclipse.epf.library.layout.diagram.IActivityDiagramService;
import org.eclipse.epf.library.layout.diagram.MethodElementDiagram;
import org.eclipse.epf.library.layout.elements.AbstractElementLayout;
import org.eclipse.epf.library.layout.elements.AbstractProcessElementLayout;
import org.eclipse.epf.library.layout.elements.ActivityLayoutData;
import org.eclipse.epf.library.layout.elements.GeneralLayout;
import org.eclipse.epf.library.layout.elements.ProcessElementItem;
import org.eclipse.epf.library.layout.elements.ProcessLayoutData;
import org.eclipse.epf.library.layout.util.XmlElement;
import org.eclipse.epf.library.prefs.BSColumn;
import org.eclipse.epf.library.prefs.PreferenceUtil;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.CompositeRole;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.SupportingMaterial;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.TeamProfile;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.WorkBreakdownElement;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.epf.uma.ecore.util.OppositeFeature;
import org.eclipse.epf.uma.util.AssociationHelper;
import org.eclipse.osgi.util.NLS;

public class ActivityLayout
extends AbstractProcessElementLayout {
    public static final String TAB_NAME_ACTIVITY_DESC = "Description";
    public static final String TAB_NAME_ACTIVITY_WBS = "WBS";
    public static final String TAB_NAME_ACTIVITY_TBS = "TBS";
    public static final String TAB_NAME_ACTIVITY_WPBS = "WPBS";
    DiagramInfo userDiagramInfo = null;
    boolean debug = LibraryPlugin.getDefault().isDebugging();
    private TBSItemDetail itemDetail = new TBSItemDetail();
    private static final String TABURL_SUFFIX_DESC = "_desc.html";
    private static final String TABURL_SUFFIX_WPBS = "_wpbs.html";
    private static final String TABURL_SUFFIX_TBS = "_tbs.html";
    private static final String TABURL_SUFFIX_WBS = "_wbs.html";
    private static final int ACTIVITY_SHOW_LEVEL = 1;
    private static int supCount = 0;

    public void init(ElementLayoutManager elementLayoutManager, MethodElement methodElement) {
        MethodPlugin methodPlugin = LibraryUtil.getMethodPlugin((EObject)methodElement);
        if (methodPlugin == null || methodPlugin.eContainer() == null) {
            if (this.debug && this.getLayoutMgr().isPublishingMode()) {
                System.out.println("Error: Element without a valid container: " + LibraryUtil.getTypeName(methodElement));
            }
            LibraryUtil.loadAllProcesses(LibraryService.getInstance().getCurrentMethodLibrary());
        }
        super.__init(elementLayoutManager, methodElement);
        this.userDiagramInfo = new DiagramInfo((Activity)methodElement);
        String string = this.getFileName(".html");
        if (string != null) {
            string = string.replace('\'', ' ').replace('\"', ' ');
            this.setLayoutInfo(new LayoutInfo(TAB_NAME_ACTIVITY_DESC, "activity_desc.xsl", String.valueOf(string) + TABURL_SUFFIX_DESC, true));
            this.setLayoutInfo(new LayoutInfo(TAB_NAME_ACTIVITY_WPBS, "activity_wpbs.xsl", String.valueOf(string) + TABURL_SUFFIX_WPBS, false));
            this.setLayoutInfo(new LayoutInfo(TAB_NAME_ACTIVITY_TBS, "activity_tbs.xsl", String.valueOf(string) + TABURL_SUFFIX_TBS, false));
            this.setLayoutInfo(new LayoutInfo(TAB_NAME_ACTIVITY_WBS, "activity_wbs.xsl", String.valueOf(string) + TABURL_SUFFIX_WBS, false));
        } else {
            System.out.println("Error in ActivityLayout.init: no file for element " + this.element.getName());
        }
    }

    public String getXslUrl() {
        LayoutInfo layoutInfo;
        String string = this.getLayoutMgr().getValidator().getDefaultActivityTab();
        if (string == null) {
            string = TAB_NAME_ACTIVITY_WBS;
        }
        if ((layoutInfo = this.getLayoutInfo(string)) == null) {
            layoutInfo = this.getLayoutInfo(TAB_NAME_ACTIVITY_WBS);
        }
        return layoutInfo.layout_xsl;
    }

    public static boolean isActivityTabUrl(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        return string.endsWith(TABURL_SUFFIX_DESC) || string.endsWith(TABURL_SUFFIX_WPBS) || string.endsWith(TABURL_SUFFIX_TBS) || string.endsWith(TABURL_SUFFIX_WBS);
    }

    protected boolean acceptFeatureValue(EStructuralFeature eStructuralFeature, Object object) {
        if (object instanceof SupportingMaterial) {
            return !this.userDiagramInfo.isDiagram((SupportingMaterial)object);
        }
        if (object instanceof List) {
            List list = (List)object;
            int n = 0;
            while (n < list.size()) {
                Object e = list.get(n);
                if (e instanceof SupportingMaterial && this.userDiagramInfo.isDiagram((SupportingMaterial)e)) {
                    list.remove(n);
                    continue;
                }
                ++n;
            }
        }
        return true;
    }

    public XmlElement getXmlElement(boolean bl) {
        OppositeFeature oppositeFeature;
        EStructuralFeature eStructuralFeature;
        Object object2;
        String string;
        Timer timer = null;
        if (this.debug) {
            timer = new Timer();
            string = "Generating layout xml for " + LibraryUtil.getTypeName(this.element) + ", includeReferences = " + bl;
            System.out.println(string);
        }
        XmlElement xmlElement = super.getXmlElement();
        this.loadAttributes(xmlElement);
        Process process = this.getOwningProcess();
        Suppression suppression = this.getSuppression(process);
        if (!bl) {
            return xmlElement;
        }
        xmlElement.setAttribute("ShowFullMethodContent", this.layoutManager.getValidator().showExtraInfoForDescriptors() ? "true" : "false");
        XmlElement xmlElement2 = xmlElement.newChild("tabs");
        for (Object object2 : this.layouts) {
            xmlElement2.newChild("tab").setAttribute("name", ((LayoutInfo)object2).name).setAttribute("url", String.valueOf(this.elementPath) + ((LayoutInfo)object2).fileName);
        }
        if (!this.getLayoutMgr().isPublishingMode() || this.element instanceof Process) {
            this.getLayoutMgr().prepareAdaptorFactoriesForProcess(process);
        }
        this.loadCopyright(xmlElement);
        List list = LibraryUtil.getStructuralFeatures(this.element);
        if (list != null) {
            int n = 0;
            while (n < list.size()) {
                eStructuralFeature = (EStructuralFeature)list.get(n);
                if (eStructuralFeature != UmaPackage.eINSTANCE.getActivity_BreakdownElements() && (oppositeFeature = eStructuralFeature.getEType()) instanceof EClass) {
                    this.loadFeature(eStructuralFeature, xmlElement, false);
                }
                ++n;
            }
        }
        object2 = new ArrayList(this.element.getOppositeFeatures());
        eStructuralFeature = object2.iterator();
        while (eStructuralFeature.hasNext()) {
            oppositeFeature = (OppositeFeature)eStructuralFeature.next();
            this.loadFeature(oppositeFeature, xmlElement, bl);
        }
        if (this.debug) {
            timer.stop();
            string = String.valueOf(timer.getTime()) + " mini seconds building Activity Descriotion xml for " + LibraryUtil.getTypeName(this.element);
            System.out.println(string);
            timer.start();
        }
        this.buildWBS(xmlElement, suppression);
        if (this.debug) {
            timer.stop();
            string = String.valueOf(timer.getTime()) + " mini seconds building WBS for " + LibraryUtil.getTypeName(this.element);
            System.out.println(string);
            timer.start();
        }
        this.buildTBS(xmlElement, suppression);
        if (this.debug) {
            timer.stop();
            string = String.valueOf(timer.getTime()) + " mini seconds building TBS for " + LibraryUtil.getTypeName(this.element);
            System.out.println(string);
            timer.start();
        }
        this.buildWPBS(xmlElement, suppression);
        if (this.debug) {
            timer.stop();
            string = String.valueOf(timer.getTime()) + " mini seconds building WPBS for " + LibraryUtil.getTypeName(this.element);
            System.out.println(string);
            string = String.valueOf(timer.getTotalTime()) + " mini seconds building layout xml for " + LibraryUtil.getTypeName(this.element);
            System.out.println(string);
        }
        return xmlElement;
    }

    private String getUserDiagramText(SupportingMaterial supportingMaterial) {
        GeneralLayout generalLayout = new GeneralLayout();
        ((AbstractElementLayout)generalLayout).init(this.getLayoutMgr(), (MethodElement)supportingMaterial.getPresentation());
        generalLayout.setContentTarget(this.element);
        EAttribute eAttribute = UmaPackage.eINSTANCE.getContentDescription_MainDescription();
        return (String)generalLayout.getAttributeFeatureValue((EStructuralFeature)eAttribute);
    }

    private void setColumns(XmlElement xmlElement, List list) {
        XmlElement xmlElement2 = xmlElement.newChild("columns");
        for (BSColumn bSColumn : list) {
            xmlElement2.newChild("column").setAttribute("id", bSColumn.id).setAttribute("label", bSColumn.label);
        }
    }

    private void buildWBS(XmlElement xmlElement, Suppression suppression) {
        String string;
        Object object;
        XmlElement xmlElement2 = xmlElement.newChild("breakdown").setAttribute("name", "Work Breakdown Structure").setAttribute("DisplayName", this.getDisplayName());
        this.setColumns(xmlElement2, PreferenceUtil.getWBSColumns());
        ConfigurableComposedAdapterFactory configurableComposedAdapterFactory = this.layoutManager.getCBSAdapterFactory();
        CompositeRoles compositeRoles = null;
        ProcessUtil.updateIDs((AdapterFactory)configurableComposedAdapterFactory, (Process)suppression.getProcess());
        ActivityLayoutSetting activityLayoutSetting = new ActivityLayoutSetting((ComposedAdapterFactory)configurableComposedAdapterFactory, compositeRoles, suppression);
        activityLayoutSetting.escapeString = true;
        activityLayoutSetting.showTaskOnly = true;
        Object object2 = suppression.getObjectByPath(this.paths, (AdapterFactory)configurableComposedAdapterFactory);
        if (object2 == null) {
            object2 = this.element;
        }
        if (suppression.isSuppressed(object2)) {
            return;
        }
        ProcessElementItem processElementItem = new ProcessElementItem(object2, this.element, this.elementProcessPath);
        this.iterate(processElementItem, xmlElement2, activityLayoutSetting);
        XmlElement xmlElement3 = xmlElement.newChild("diagrams");
        String string2 = "Activity";
        SupportingMaterial supportingMaterial = this.userDiagramInfo.getActivityDiagram();
        if (this.userDiagramInfo.canPublishADImage() && supportingMaterial != null) {
            xmlElement3.newChild("userdiagram").setAttribute("name", string2).setValue(this.getUserDiagramText(supportingMaterial));
        } else {
            org.eclipse.epf.library.layout.diagram.DiagramInfo diagramInfo;
            object = this.getRealizedUDD(suppression, string2);
            boolean bl = true;
            if (object != null) {
                supportingMaterial = object.getActivityDiagram();
                if (object.canPublishADImage() && supportingMaterial != null) {
                    xmlElement3.newChild("userdiagram").setAttribute("name", string2).setValue(this.getUserDiagramText(supportingMaterial));
                    bl = false;
                }
            }
            if (bl && (diagramInfo = this.generateDiagram(suppression, string2, string = ResourceHelper.getDiagramFilePathName(this.element, string2))) != null && diagramInfo.getImageFileName() != null) {
                xmlElement3.newChild("diagram").setAttribute("name", "Activity").setAttribute("alt", this.getDiagramDisplayName("Activity")).addChild(diagramInfo.getXmlElement());
            }
        }
        string2 = "ActivityDetail";
        supportingMaterial = this.userDiagramInfo.getActivityDetailDiagram();
        if (this.userDiagramInfo.canPublishADDImage() && supportingMaterial != null) {
            xmlElement3.newChild("userdiagram").setAttribute("name", string2).setValue(this.getUserDiagramText(supportingMaterial));
        } else {
            string = ResourceHelper.getDiagramFilePathName(this.element, string2);
            object = this.generateDiagram(suppression, string2, string);
            if (object != null && ((MethodElementDiagram)object).getImageFileName() != null) {
                xmlElement3.newChild("diagram").setAttribute("name", "ActivityDetail").setAttribute("alt", this.getDiagramDisplayName("ActivityDetail")).addChild(((MethodElementDiagram)object).getXmlElement());
            }
        }
        string2 = "WPDependency";
        supportingMaterial = this.userDiagramInfo.getWPDDiagram();
        if (this.userDiagramInfo.canPublishWPDImage() && supportingMaterial != null) {
            xmlElement3.newChild("userdiagram").setAttribute("name", string2).setValue(this.getUserDiagramText(supportingMaterial));
        } else {
            string = ResourceHelper.getDiagramFilePathName(this.element, string2);
            object = this.generateDiagram(suppression, string2, string);
            if (object != null && ((MethodElementDiagram)object).getImageFileName() != null) {
                xmlElement3.newChild("diagram").setAttribute("name", "WPDependency").setAttribute("alt", this.getDiagramDisplayName("WPDependency")).addChild(((MethodElementDiagram)object).getXmlElement());
            }
        }
    }

    private String getDiagramDisplayName(String string) {
        String string2 = this.getDisplayName();
        if ("Activity".equals(string)) {
            return NLS.bind((String)LibraryResources.activityDiagramName, (Object)string2);
        }
        if ("ActivityDetail".equals(string)) {
            return NLS.bind((String)LibraryResources.activityDetailDiagramName, (Object)string2);
        }
        if ("WPDependency".equals(string)) {
            return NLS.bind((String)LibraryResources.wpDependencyDiagramName, (Object)string2);
        }
        return "";
    }

    private org.eclipse.epf.library.layout.diagram.DiagramInfo generateDiagram(Suppression suppression, String string, String string2) {
        Object object;
        Timer timer = null;
        if (this.debug) {
            System.out.println("START: generating diagram " + string2);
            timer = new Timer();
        }
        IActivityDiagramService iActivityDiagramService = this.layoutManager.getActivityDiagramService();
        org.eclipse.epf.library.layout.diagram.DiagramInfo diagramInfo = null;
        if (iActivityDiagramService != null) {
            object = this.layoutManager.getDiagramAdapterFactory().getFilter();
            Object object2 = suppression.getObjectByPath(this.paths, (AdapterFactory)this.layoutManager.getDiagramAdapterFactory());
            boolean bl = LibraryUtil.PUBLISH_MODE;
            LibraryUtil.PUBLISH_MODE = true;
            diagramInfo = iActivityDiagramService.saveDiagram(object2, string2, string, (IFilter)object, suppression);
            LibraryUtil.PUBLISH_MODE = bl;
        }
        if (timer != null) {
            timer.stop();
            object = String.valueOf(timer.getTime()) + " mini seconds generating " + string + " diagram";
            System.out.println((String)object);
            System.out.println("END: generating diagram " + string2);
        }
        return diagramInfo;
    }

    private DiagramInfo getRealizedUDD(Suppression suppression, String string) {
        IActivityDiagramService iActivityDiagramService = this.layoutManager.getActivityDiagramService();
        if (iActivityDiagramService != null) {
            DiagramInfo diagramInfo;
            IFilter iFilter = this.layoutManager.getDiagramAdapterFactory().getFilter();
            Object object = suppression.getObjectByPath(this.paths, (AdapterFactory)this.layoutManager.getDiagramAdapterFactory());
            Activity activity = iActivityDiagramService.getRealizedForUnmodified(object, iFilter, suppression);
            if (activity instanceof Activity && (diagramInfo = new DiagramInfo(activity)).canPublishADImage()) {
                return diagramInfo;
            }
        }
        return null;
    }

    private void buildTBS(XmlElement xmlElement, Suppression suppression) {
        XmlElement xmlElement2 = xmlElement.newChild("breakdown").setAttribute("name", "Team Breakdown Structure").setAttribute("DisplayName", this.getDisplayName());
        this.setColumns(xmlElement2, PreferenceUtil.getTBSColumns());
        ConfigurableComposedAdapterFactory configurableComposedAdapterFactory = this.layoutManager.getTBSAdapterFactory();
        CompositeRoles compositeRoles = null;
        IBSItemProvider iBSItemProvider = (IBSItemProvider)configurableComposedAdapterFactory.adapt((Notifier)this.element, ITreeItemContentProvider.class);
        Object object = suppression.getObjectByPath(this.paths, (AdapterFactory)configurableComposedAdapterFactory);
        if (object == null) {
            object = this.element;
        }
        ProcessElementItem processElementItem = new ProcessElementItem(object, this.element, this.elementProcessPath);
        iBSItemProvider.setRolledUp(false);
        this.itemDetail.iterate((ComposedAdapterFactory)configurableComposedAdapterFactory, object);
        iBSItemProvider.setRolledUp(true);
        ActivityLayoutSetting activityLayoutSetting = new ActivityLayoutSetting((ComposedAdapterFactory)configurableComposedAdapterFactory, compositeRoles, suppression);
        activityLayoutSetting.rollupRoles = true;
        activityLayoutSetting.escapeString = true;
        this.iterate(processElementItem, xmlElement2, activityLayoutSetting);
    }

    private void buildWPBS(XmlElement xmlElement, Suppression suppression) {
        XmlElement xmlElement2 = xmlElement.newChild("breakdown").setAttribute("name", "Work Product Breakdown Structure").setAttribute("DisplayName", this.getDisplayName());
        this.setColumns(xmlElement2, PreferenceUtil.getWPBSColumns());
        ConfigurableComposedAdapterFactory configurableComposedAdapterFactory = this.layoutManager.getWPBSAdapterFactory();
        CompositeRoles compositeRoles = null;
        IBSItemProvider iBSItemProvider = (IBSItemProvider)configurableComposedAdapterFactory.adapt((Notifier)this.element, ITreeItemContentProvider.class);
        iBSItemProvider.setRolledUp(true);
        ActivityLayoutSetting activityLayoutSetting = new ActivityLayoutSetting((ComposedAdapterFactory)configurableComposedAdapterFactory, compositeRoles, suppression);
        activityLayoutSetting.escapeString = true;
        Object object = suppression.getObjectByPath(this.paths, (AdapterFactory)configurableComposedAdapterFactory);
        if (object == null) {
            object = this.element;
        }
        ProcessElementItem processElementItem = new ProcessElementItem(object, this.element, this.elementProcessPath);
        this.iterate(processElementItem, xmlElement2, activityLayoutSetting);
    }

    private void iterate(ProcessElementItem processElementItem, XmlElement xmlElement, ActivityLayoutSetting activityLayoutSetting) {
        this.iterate(processElementItem, xmlElement, activityLayoutSetting, 0);
    }

    private void iterate(ProcessElementItem processElementItem, XmlElement xmlElement, ActivityLayoutSetting activityLayoutSetting, int n) {
        Object object;
        ITreeItemContentProvider iTreeItemContentProvider = null;
        Object object2 = processElementItem.rawItem;
        Timer timer = null;
        if (this.debug) {
            timer = new Timer();
        }
        if ((iTreeItemContentProvider = object2 instanceof ITreeItemContentProvider ? (ITreeItemContentProvider)object2 : (ITreeItemContentProvider)activityLayoutSetting.adapterFactory.adapt(object2, ITreeItemContentProvider.class)) != null) {
            object = iTreeItemContentProvider.getChildren(object2);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                XmlElement xmlElement2;
                Object e = iterator.next();
                Object object3 = (MethodElement)LibraryUtil.unwrap(e);
                if (activityLayoutSetting.showTaskOnly && n > 1 && !(object3 instanceof Activity) && !(object3 instanceof TaskDescriptor) || object3 == null) continue;
                this.getLayoutMgr().getValidator().addReferencedElement(this.element, (MethodElement)object3);
                ProcessElementItem processElementItem2 = new ProcessElementItem(e, (MethodElement)object3, processElementItem);
                if (object2 instanceof Activity && activityLayoutSetting.crs != null && object3 instanceof RoleDescriptor && (xmlElement2 = activityLayoutSetting.crs.getCompositeRole((Activity)object2, (RoleDescriptor)object3)) != null) {
                    object3 = xmlElement2;
                }
                xmlElement2 = this.generateChildXml(processElementItem2, xmlElement, activityLayoutSetting);
                xmlElement.addChild(xmlElement2);
                if (activityLayoutSetting.showTaskOnly && n > 1 && !(object3 instanceof Activity)) continue;
                this.iterate(processElementItem2, xmlElement2, activityLayoutSetting, object3 instanceof Activity ? n + 1 : n);
            }
        }
        if (timer != null) {
            timer.stop();
            if (timer.getTime() > 100) {
                object = String.valueOf(timer.getTime()) + " mini seconds iterating breakdown item " + LibraryUtil.getTypeName(processElementItem.element);
                System.out.println((String)object);
            }
        }
    }

    private XmlElement generateChildXml(ProcessElementItem processElementItem, XmlElement xmlElement, ActivityLayoutSetting activityLayoutSetting) {
        String string;
        Object object;
        String string2;
        Object object2;
        String string3;
        Object object3;
        Timer timer = null;
        if (this.debug) {
            timer = new Timer();
        }
        MethodElement methodElement = processElementItem.element;
        IElementLayout iElementLayout = this.getLayout(processElementItem);
        boolean bl = activityLayoutSetting.sup.isSuppressed(processElementItem.rawItem);
        if (bl) {
            this.itemDetail.addSuppressed(processElementItem.element);
        }
        XmlElement xmlElement2 = iElementLayout.getXmlElement(false);
        if (!this.getLayoutMgr().isPublishingMode()) {
            xmlElement2.setAttribute("isSupressed", bl ? "true" : "false");
        }
        IBSItemProvider iBSItemProvider = null;
        iBSItemProvider = processElementItem.rawItem instanceof IBSItemProvider ? (IBSItemProvider)processElementItem.rawItem : (IBSItemProvider)activityLayoutSetting.adapterFactory.adapt((Notifier)processElementItem.element, ITreeItemContentProvider.class);
        if (processElementItem.element instanceof BreakdownElement) {
            object3 = this.getIndex(iBSItemProvider);
            string3 = ProcessUtil.getAttribute((Object)methodElement, (String)"model_info", (Object)iBSItemProvider);
            object2 = ProcessUtil.getAttribute((Object)methodElement, (String)"teams", (Object)iBSItemProvider);
            string2 = ProcessUtil.getAttribute((Object)methodElement, (String)"prefix", (Object)iBSItemProvider);
            object = ProcessUtil.getAttribute((Object)methodElement, (String)"is_event_driven", (Object)iBSItemProvider);
            String string4 = ProcessUtil.getAttribute((Object)methodElement, (String)"is_ongoing", (Object)iBSItemProvider);
            string = ProcessUtil.getAttribute((Object)methodElement, (String)"is_optional", (Object)iBSItemProvider);
            String string5 = ProcessUtil.getAttribute((Object)methodElement, (String)"is_planned", (Object)iBSItemProvider);
            String string6 = ProcessUtil.getAttribute((Object)methodElement, (String)"is_repeatable", (Object)iBSItemProvider);
            String string7 = ProcessUtil.getAttribute((Object)methodElement, (String)"has_multiple_occurrences", (Object)iBSItemProvider);
            String string8 = ProcessUtil.getAttribute((Object)methodElement, (String)"presentation_name", (Object)iBSItemProvider);
            String string9 = ProcessUtil.getAttribute((Object)methodElement, (String)"name", (Object)iBSItemProvider);
            if (activityLayoutSetting.escapeString) {
                string3 = StrUtil.escape((String)string3);
                string8 = XMLUtil.escape((String)string8);
                string9 = XMLUtil.escape((String)string9);
                String string10 = StrUtil.escape((String)iElementLayout.getUrl());
                xmlElement2.setAttribute("Url", string10);
            }
            xmlElement2.setAttribute("Index", (String)object3).setAttribute("ModelInfo", string3).setAttribute("Team", (String)object2);
            xmlElement2.newChild("attribute").setAttribute("name", "prefix").setValue(string2);
            xmlElement2.newChild("attribute").setAttribute("name", "isEventDriven").setValue((String)object);
            xmlElement2.newChild("attribute").setAttribute("name", "isOngoing").setValue(string4);
            xmlElement2.newChild("attribute").setAttribute("name", "isOptional").setValue(string);
            xmlElement2.newChild("attribute").setAttribute("name", "isPlanned").setValue(string5);
            xmlElement2.newChild("attribute").setAttribute("name", "isRepeatable").setValue(string6);
            xmlElement2.newChild("attribute").setAttribute("name", "hasMultipleOccurrences").setValue(string7);
            xmlElement2.setAttribute("DisplayName", string8);
            xmlElement2.setAttribute("Name", string9);
        }
        if (methodElement instanceof WorkProductDescriptor) {
            object3 = iBSItemProvider.getAttribute((Object)methodElement, "entry_state");
            string3 = iBSItemProvider.getAttribute((Object)methodElement, "exit_state");
            object2 = iBSItemProvider.getAttribute((Object)methodElement, "deliverable");
            xmlElement2.setAttribute("EntryState", (String)object3).setAttribute("ExitState", string3).setAttribute("Deliverable", (String)object2);
        }
        if (methodElement instanceof WorkBreakdownElement) {
            object3 = this.getPredecessors(iBSItemProvider, activityLayoutSetting.sup);
            xmlElement2.setAttribute("Predecessors", (String)object3);
        }
        if (methodElement instanceof TaskDescriptor) {
            object3 = xmlElement2.newChild("Steps");
            string3 = (TaskDescriptor)methodElement;
            object2 = string3.getSelectedSteps();
            string2 = (Task)ConfigurationHelper.getCalculatedElement((MethodElement)string3.getTask(), this.getLayoutMgr().getConfiguration());
            if (string2 != null) {
                object = ConfigurationHelper.calc0nFeatureValue((MethodElement)string2, (EStructuralFeature)UmaPackage.eINSTANCE.getTask_Steps(), this.getLayoutMgr().getElementRealizer());
                int n = 0;
                while (n < object.size()) {
                    string = object.get(n);
                    boolean bl2 = object2.contains(string);
                    ((XmlElement)object3).newChild("Step").setAttribute("index", Integer.toString(n)).setAttribute("selected", bl2 ? "true" : "false");
                    ++n;
                }
            }
        }
        if (methodElement instanceof TeamProfile) {
            object3 = ((TeamProfile)methodElement).getSuperTeam();
            xmlElement2.setAttribute("hasSuperTeam", object3 != null ? "true" : "false");
        }
        if (activityLayoutSetting.rollupRoles && methodElement instanceof RoleDescriptor) {
            this.buildRoleRollup((RoleDescriptor)methodElement, xmlElement2, activityLayoutSetting);
        }
        if (timer != null) {
            timer.stop();
            if (timer.getTime() > 100) {
                object3 = String.valueOf(timer.getTime()) + " mini seconds generating xml for breakdown item " + LibraryUtil.getTypeName(processElementItem.element);
                System.out.println((String)object3);
            }
        }
        return xmlElement2;
    }

    private void buildRoleRollup(RoleDescriptor roleDescriptor2, XmlElement xmlElement, ActivityLayoutSetting activityLayoutSetting) {
        Role role = roleDescriptor2.getRole();
        ArrayList<RoleDescriptor> arrayList = this.itemDetail.getDescriptors(role);
        if (arrayList == null) {
            arrayList = new ArrayList<RoleDescriptor>();
        }
        if (!arrayList.contains(roleDescriptor2)) {
            arrayList.add(roleDescriptor2);
        }
        ArrayList arrayList2 = new ArrayList();
        ArrayList arrayList3 = new ArrayList();
        ArrayList arrayList4 = new ArrayList();
        ArrayList arrayList5 = new ArrayList();
        for (RoleDescriptor roleDescriptor2 : arrayList) {
            List list = ConfigurationHelper.calc0nFeatureValue((MethodElement)roleDescriptor2, (EStructuralFeature)UmaPackage.eINSTANCE.getRoleDescriptor_ResponsibleFor(), this.getLayoutMgr().getElementRealizer());
            arrayList2.addAll(list);
            list = ConfigurationHelper.calc0nFeatureValue((MethodElement)roleDescriptor2, (EStructuralFeature)UmaPackage.eINSTANCE.getRoleDescriptor_Modifies(), this.getLayoutMgr().getElementRealizer());
            arrayList3.addAll(list);
            list = ConfigurationHelper.calc0nFeatureValue((MethodElement)roleDescriptor2, AssociationHelper.RoleDescriptor_PrimaryTaskDescriptors, this.getLayoutMgr().getElementRealizer());
            arrayList4.addAll(list);
            list = ConfigurationHelper.calc0nFeatureValue((MethodElement)roleDescriptor2, AssociationHelper.RoleDescriptor_AdditionalTaskDescriptors, this.getLayoutMgr().getElementRealizer());
            arrayList5.addAll(list);
        }
        Collections.sort(arrayList2, Comparators.PRESENTATION_NAME_COMPARATOR);
        this.createRoleRollupNodes(xmlElement, arrayList2, TngUtil.getFeatureText((EStructuralFeature)UmaPackage.eINSTANCE.getRoleDescriptor_ResponsibleFor()));
        Collections.sort(arrayList3, Comparators.PRESENTATION_NAME_COMPARATOR);
        this.createRoleRollupNodes(xmlElement, arrayList3, TngUtil.getFeatureText((EStructuralFeature)UmaPackage.eINSTANCE.getRoleDescriptor_Modifies()));
        Collections.sort(arrayList4, Comparators.PRESENTATION_NAME_COMPARATOR);
        this.createRoleRollupNodes(xmlElement, arrayList4, LibraryResources.ActivityLayout_primaryTasks_text);
        Collections.sort(arrayList5, Comparators.PRESENTATION_NAME_COMPARATOR);
        this.createRoleRollupNodes(xmlElement, arrayList5, LibraryResources.ActivityLayout_additionalTasks_text);
    }

    private void createRoleRollupNodes(XmlElement xmlElement, List list, String string) {
        ArrayList<Task> arrayList = new ArrayList<Task>();
        Task task = null;
        for (MethodElement methodElement : list) {
            task = null;
            if (methodElement instanceof TaskDescriptor) {
                task = ((TaskDescriptor)methodElement).getTask();
            } else if (methodElement instanceof WorkProductDescriptor) {
                task = ((WorkProductDescriptor)methodElement).getWorkProduct();
            }
            if (task == null) {
                task = methodElement;
            }
            if (arrayList.contains(task)) continue;
            arrayList.add(task);
            IElementLayout iElementLayout = this.layoutManager.getLayout(methodElement, true);
            XmlElement xmlElement2 = iElementLayout.getXmlElement(false);
            xmlElement2.setAttribute("ModelInfo", string);
            xmlElement.addChild(xmlElement2);
        }
    }

    private String getIndex(IBSItemProvider iBSItemProvider) {
        if (iBSItemProvider != null) {
            int n = iBSItemProvider.getId();
            if (n == 0) {
                return "";
            }
            return Integer.toString(n);
        }
        return "";
    }

    private String getPredecessors(IBSItemProvider iBSItemProvider, Suppression suppression) {
        PredecessorList predecessorList;
        if (iBSItemProvider != null && (predecessorList = iBSItemProvider.getPredecessors()) != null) {
            return predecessorList.toUnSuppressedString(suppression, true);
        }
        return "";
    }

    public void loadLayoutData(ProcessLayoutData processLayoutData, boolean bl, boolean bl2, boolean bl3) {
        Timer timer = new Timer();
        ActivityLayoutData activityLayoutData = processLayoutData.createActivityLauoutData(this.elementProcessPath);
        Process process = this.getOwningProcess();
        if (process == this.element) {
            supCount = 0;
        }
        Suppression suppression = this.getSuppression(process);
        if (bl) {
            this.loadWBSLayoutData(activityLayoutData, suppression);
        }
        if (bl2) {
            this.loadTBSLayoutData(activityLayoutData, suppression);
        }
        if (bl3) {
            this.loadWPBSLayoutData(activityLayoutData, suppression);
        }
        if (this.debug) {
            timer.stop();
            String string = String.valueOf(timer.getTime()) + " mini-second(s) loading layout data for process " + LibraryUtil.getTypeName((MethodElement)process) + ", activity: " + LibraryUtil.getTypeName(this.element);
            System.out.println(string);
        }
    }

    private void loadWBSLayoutData(ActivityLayoutData activityLayoutData, Suppression suppression) {
        org.eclipse.epf.library.layout.diagram.DiagramInfo diagramInfo;
        org.eclipse.epf.library.layout.diagram.DiagramInfo diagramInfo2;
        ConfigurableComposedAdapterFactory configurableComposedAdapterFactory = this.layoutManager.getCBSAdapterFactory();
        CompositeRoles compositeRoles = null;
        ActivityLayoutSetting activityLayoutSetting = new ActivityLayoutSetting((ComposedAdapterFactory)configurableComposedAdapterFactory, compositeRoles, suppression);
        Object object = suppression.getObjectByPath(this.paths, (AdapterFactory)configurableComposedAdapterFactory);
        if (object == null) {
            object = this.element;
        }
        ProcessElementItem processElementItem = new ProcessElementItem(object, this.element, this.elementProcessPath);
        this.iterateProcessItem(processElementItem, activityLayoutData, activityLayoutSetting, true, false, false);
        String string = Integer.toHexString(this.elementProcessPath.hashCode());
        String string2 = "Activity";
        String string3 = ResourceHelper.getDiagramFilePathName(this.element, String.valueOf(string) + "_" + string2);
        org.eclipse.epf.library.layout.diagram.DiagramInfo diagramInfo3 = this.generateDiagram(suppression, string2, string3);
        if (diagramInfo3 != null && diagramInfo3.getImageFileName() != null) {
            activityLayoutData.setActivityDiagramPath(diagramInfo3.getImageFileName());
        }
        if ((diagramInfo2 = this.generateDiagram(suppression, string2 = "ActivityDetail", string3 = ResourceHelper.getDiagramFilePathName(this.element, String.valueOf(string) + "_" + string2))) != null && diagramInfo2.getImageFileName() != null) {
            activityLayoutData.setActivityDetailDiagramPath(diagramInfo2.getImageFileName());
        }
        if ((diagramInfo = this.generateDiagram(suppression, string2 = "WPDependency", string3 = ResourceHelper.getDiagramFilePathName(this.element, String.valueOf(string) + "_" + string2))) != null && diagramInfo.getImageFileName() != null) {
            activityLayoutData.setWPDependencyDiagramPath(diagramInfo.getImageFileName());
        }
    }

    private void loadTBSLayoutData(ActivityLayoutData activityLayoutData, Suppression suppression) {
        ConfigurableComposedAdapterFactory configurableComposedAdapterFactory = this.layoutManager.getTBSAdapterFactory();
        CompositeRoles compositeRoles = null;
        IBSItemProvider iBSItemProvider = (IBSItemProvider)configurableComposedAdapterFactory.adapt((Notifier)this.element, ITreeItemContentProvider.class);
        iBSItemProvider.setRolledUp(true);
        ActivityLayoutSetting activityLayoutSetting = new ActivityLayoutSetting((ComposedAdapterFactory)configurableComposedAdapterFactory, compositeRoles, suppression);
        activityLayoutSetting.rollupRoles = true;
        Object object = suppression.getObjectByPath(this.paths, (AdapterFactory)configurableComposedAdapterFactory);
        if (object == null) {
            object = this.element;
        }
        ProcessElementItem processElementItem = new ProcessElementItem(object, this.element, this.elementProcessPath);
        this.iterateProcessItem(processElementItem, activityLayoutData, activityLayoutSetting, false, true, false);
    }

    private void loadWPBSLayoutData(ActivityLayoutData activityLayoutData, Suppression suppression) {
        ConfigurableComposedAdapterFactory configurableComposedAdapterFactory = this.layoutManager.getWPBSAdapterFactory();
        CompositeRoles compositeRoles = null;
        IBSItemProvider iBSItemProvider = (IBSItemProvider)configurableComposedAdapterFactory.adapt((Notifier)this.element, ITreeItemContentProvider.class);
        iBSItemProvider.setRolledUp(true);
        ActivityLayoutSetting activityLayoutSetting = new ActivityLayoutSetting((ComposedAdapterFactory)configurableComposedAdapterFactory, compositeRoles, suppression);
        Object object = suppression.getObjectByPath(this.paths, (AdapterFactory)configurableComposedAdapterFactory);
        if (object == null) {
            object = this.element;
        }
        ProcessElementItem processElementItem = new ProcessElementItem(object, this.element, this.elementProcessPath);
        this.iterateProcessItem(processElementItem, activityLayoutData, activityLayoutSetting, false, false, true);
    }

    private void iterateProcessItem(ProcessElementItem processElementItem, ActivityLayoutData activityLayoutData, ActivityLayoutSetting activityLayoutSetting, boolean bl, boolean bl2, boolean bl3) {
        ITreeItemContentProvider iTreeItemContentProvider = null;
        Object object = processElementItem.rawItem;
        iTreeItemContentProvider = object instanceof ITreeItemContentProvider ? (ITreeItemContentProvider)object : (ITreeItemContentProvider)activityLayoutSetting.adapterFactory.adapt(object, ITreeItemContentProvider.class);
        if (iTreeItemContentProvider != null) {
            Collection collection = iTreeItemContentProvider.getChildren(object);
            for (Object e : collection) {
                IElementLayout iElementLayout;
                boolean bl4 = activityLayoutSetting.sup.isSuppressed(e);
                MethodElement methodElement = (MethodElement)LibraryUtil.unwrap(e);
                ProcessElementItem processElementItem2 = new ProcessElementItem(e, methodElement, processElementItem);
                if (this.debug && bl4) {
                    System.out.println("suppressed: " + ++supCount + " : " + LibraryUtil.getTypeName(methodElement) + ": " + processElementItem2.path);
                }
                if (!((iElementLayout = this.getLayout(processElementItem2)) instanceof AbstractProcessElementLayout)) continue;
                if (bl4) {
                    String string = ((AbstractProcessElementLayout)iElementLayout).getRelativeProcessPath();
                    activityLayoutData.setSuppressed(string);
                    continue;
                }
                if (iElementLayout instanceof ActivityLayout) {
                    ((ActivityLayout)iElementLayout).loadLayoutData(activityLayoutData.getProcessLayoutData(), bl, bl2, bl3);
                    continue;
                }
                this.iterateProcessItem(processElementItem2, activityLayoutData, activityLayoutSetting, bl, bl2, bl3);
            }
        }
    }

    public void findAllLinkedElements() {
        ConfigurableComposedAdapterFactory configurableComposedAdapterFactory;
        Process process = this.getOwningProcess();
        Suppression suppression = this.getSuppression(process);
        Object object = suppression.getObjectByPath(this.paths, (AdapterFactory)(configurableComposedAdapterFactory = this.layoutManager.getCBSAdapterFactory()));
        if (object == null) {
            object = this.element;
        }
        this.getLayoutMgr().getValidator().addReferencedElement(null, this.element);
        this.iterateItemForLinkedElements(object, (ComposedAdapterFactory)configurableComposedAdapterFactory, suppression);
    }

    private void iterateItemForLinkedElements(Object object, ComposedAdapterFactory composedAdapterFactory, Suppression suppression) {
        ITreeItemContentProvider iTreeItemContentProvider = null;
        iTreeItemContentProvider = object instanceof ITreeItemContentProvider ? (ITreeItemContentProvider)object : (ITreeItemContentProvider)composedAdapterFactory.adapt(object, ITreeItemContentProvider.class);
        if (iTreeItemContentProvider == null) {
            return;
        }
        Collection collection = iTreeItemContentProvider.getChildren(object);
        for (Object e : collection) {
            if (suppression.isSuppressed(e)) continue;
            MethodElement methodElement = (MethodElement)LibraryUtil.unwrap(e);
            Task task = null;
            if (methodElement instanceof TaskDescriptor) {
                task = ((TaskDescriptor)methodElement).getTask();
            } else if (methodElement instanceof RoleDescriptor) {
                task = ((RoleDescriptor)methodElement).getRole();
            } else if (methodElement instanceof WorkProductDescriptor) {
                task = ((WorkProductDescriptor)methodElement).getWorkProduct();
            }
            if (task != null) {
                this.getLayoutMgr().getValidator().addReferencedElement(methodElement, (MethodElement)task);
            }
            MethodElement methodElement2 = (MethodElement)LibraryUtil.unwrap(e);
            this.getLayoutMgr().getValidator().addReferencedElement(methodElement2, methodElement);
            this.iterateItemForLinkedElements(e, composedAdapterFactory, suppression);
        }
    }

    public class ActivityLayoutSetting {
        public ComposedAdapterFactory adapterFactory;
        public CompositeRoles crs;
        public Suppression sup;
        boolean rollupRoles = false;
        public boolean escapeString = false;
        public boolean showTaskOnly = false;

        public ActivityLayoutSetting(ComposedAdapterFactory composedAdapterFactory, CompositeRoles compositeRoles, Suppression suppression) {
            this.adapterFactory = composedAdapterFactory;
            this.crs = compositeRoles;
            this.sup = suppression;
        }
    }

    public class CompositeRoleInfo {
        Activity parent;
        Activity owner;
        List items = new ArrayList();

        public CompositeRoleInfo(Activity activity, Activity activity2) {
            this.parent = activity;
            this.owner = activity2;
        }

        private void addCompositeRole(CompositeRole compositeRole) {
            if (!this.items.contains(compositeRole)) {
                this.items.add(compositeRole);
            }
        }

        private Activity getParentActivity() {
            return this.parent;
        }

        private CompositeRole getCompositeRole(RoleDescriptor roleDescriptor) {
            if (this.items.size() == 0) {
                return null;
            }
            Role role = roleDescriptor.getRole();
            for (CompositeRole compositeRole : this.items) {
                if (!compositeRole.getAggregatedRoles().contains(role)) continue;
                return compositeRole;
            }
            return null;
        }
    }

    public class CompositeRoles {
        Map itemMap = new HashMap();

        public CompositeRoles(ComposedAdapterFactory composedAdapterFactory, Activity activity) {
            this.scan(composedAdapterFactory, null, activity);
        }

        private CompositeRoleInfo getCompositeRoleInfo(Activity activity, Activity activity2) {
            CompositeRoleInfo compositeRoleInfo = (CompositeRoleInfo)this.itemMap.get(activity2);
            if (compositeRoleInfo == null) {
                compositeRoleInfo = new CompositeRoleInfo(activity, activity2);
                this.itemMap.put(activity2, compositeRoleInfo);
            }
            return compositeRoleInfo;
        }

        private void scan(ComposedAdapterFactory composedAdapterFactory, Activity activity, Activity activity2) {
            ITreeItemContentProvider iTreeItemContentProvider = (ITreeItemContentProvider)composedAdapterFactory.adapt((Notifier)activity2, ITreeItemContentProvider.class);
            if (iTreeItemContentProvider != null) {
                Collection collection = iTreeItemContentProvider.getChildren((Object)activity2);
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    MethodElement methodElement = (MethodElement)LibraryUtil.unwrap(iterator.next());
                    if (methodElement instanceof CompositeRole) {
                        this.getCompositeRoleInfo(activity, activity2).addCompositeRole((CompositeRole)methodElement);
                        continue;
                    }
                    if (!(methodElement instanceof Activity)) continue;
                    this.scan(composedAdapterFactory, activity2, (Activity)methodElement);
                }
            }
        }

        private CompositeRole getCompositeRole(Activity activity, RoleDescriptor roleDescriptor) {
            if (activity == null) {
                return null;
            }
            CompositeRole compositeRole = null;
            CompositeRoleInfo compositeRoleInfo = (CompositeRoleInfo)this.itemMap.get(activity);
            if (compositeRoleInfo != null) {
                compositeRole = compositeRoleInfo.getCompositeRole(roleDescriptor);
                if (compositeRole != null) {
                    return compositeRole;
                }
                return this.getCompositeRole(compositeRoleInfo.getParentActivity(), roleDescriptor);
            }
            return null;
        }
    }

    public class TBSItemDetail {
        List suppressedItems = new ArrayList();
        Map roleDescriptorMap = new HashMap();

        public void addSuppressed(Object object) {
            if (!this.suppressedItems.contains(object)) {
                this.suppressedItems.add(object);
            }
        }

        public void iterate(ComposedAdapterFactory composedAdapterFactory, Object object) {
            ITreeItemContentProvider iTreeItemContentProvider = null;
            iTreeItemContentProvider = object instanceof ITreeItemContentProvider ? (ITreeItemContentProvider)object : (ITreeItemContentProvider)composedAdapterFactory.adapt(object, ITreeItemContentProvider.class);
            if (iTreeItemContentProvider == null) {
                return;
            }
            Collection collection = iTreeItemContentProvider.getChildren(object);
            for (Object e : collection) {
                MethodElement methodElement = (MethodElement)LibraryUtil.unwrap(e);
                if (methodElement instanceof RoleDescriptor) {
                    this.addRoleDescriptor((RoleDescriptor)methodElement);
                    continue;
                }
                this.iterate(composedAdapterFactory, e);
            }
        }

        private void addRoleDescriptor(RoleDescriptor roleDescriptor) {
            Role role = roleDescriptor.getRole();
            if (role != null) {
                ArrayList<RoleDescriptor> arrayList = (ArrayList<RoleDescriptor>)this.roleDescriptorMap.get(role);
                if (arrayList == null) {
                    arrayList = new ArrayList<RoleDescriptor>();
                    this.roleDescriptorMap.put(role, arrayList);
                    if (ActivityLayout.this.debug) {
                        System.out.println("Added RoleDescriptor " + roleDescriptor.getPresentationName());
                    }
                }
                if (!arrayList.contains(roleDescriptor)) {
                    arrayList.add(roleDescriptor);
                }
            }
        }

        public List getDescriptors(Role role) {
            return (List)this.roleDescriptorMap.get(role);
        }
    }
}

