/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.xml.services;

import com.ibm.icu.text.SimpleDateFormat;
import java.io.File;
import java.net.URI;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.sdo.EDataObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.dataexchange.util.ContentProcessor;
import org.eclipse.epf.dataexchange.util.ILogger;
import org.eclipse.epf.export.xml.services.FeatureManager;
import org.eclipse.epf.importing.xml.ImportXMLPlugin;
import org.eclipse.epf.importing.xml.ImportXMLResources;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.util.ModelStructure;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.persistence.MultiFileSaveUtil;
import org.eclipse.epf.resourcemanager.ResourceDescriptor;
import org.eclipse.epf.resourcemanager.ResourceManager;
import org.eclipse.epf.services.IFileManager;
import org.eclipse.epf.services.Services;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.CapabilityPattern;
import org.eclipse.epf.uma.ContentDescription;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.DeliveryProcess;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.Discipline;
import org.eclipse.epf.uma.DisciplineGrouping;
import org.eclipse.epf.uma.Domain;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodElementProperty;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.RoleSet;
import org.eclipse.epf.uma.RoleSetGrouping;
import org.eclipse.epf.uma.Section;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.Tool;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.WorkBreakdownElement;
import org.eclipse.epf.uma.WorkOrder;
import org.eclipse.epf.uma.WorkOrderType;
import org.eclipse.epf.uma.WorkProductType;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UmaLibrary {
    private boolean debug = ImportXMLPlugin.getDefault().isDebugging();
    private boolean overwrite = false;
    private ILogger logger;
    private ContentProcessor contentProc = null;
    private Map newElementsMap = new HashMap();
    private Map renameElementMap;
    Map elementsMap = new HashMap();
    HashSet sourceElementIDs = new HashSet();
    private MethodPackage cpRoot = null;
    private MethodPackage dpRoot = null;

    public UmaLibrary(Map map, ContentProcessor contentProcessor, ILogger iLogger, boolean bl) {
        this.renameElementMap = map;
        this.logger = iLogger;
        this.contentProc = contentProcessor;
        this.overwrite = bl;
        this.buildElementsMap();
    }

    public MethodLibrary getRoot() {
        return LibraryService.getInstance().getCurrentMethodLibrary();
    }

    private void buildElementsMap() {
        this.elementsMap.clear();
        this.elementsMap.put(this.getRoot().getGuid(), this.getRoot());
        TreeIterator treeIterator = this.getRoot().eAllContents();
        while (treeIterator.hasNext()) {
            Object object = treeIterator.next();
            if (!(object instanceof MethodElement)) continue;
            this.elementsMap.put(((MethodElement)object).getGuid(), object);
        }
    }

    public EDataObject createContentCategory(String string, String string2, String string3, String string4) {
        this.setSourceId(string4);
        EDataObject eDataObject = this.getElement(string4);
        if (eDataObject != null) {
            return eDataObject;
        }
        MethodPlugin methodPlugin = (MethodPlugin)this.getElement(string);
        EClass eClass = FeatureManager.INSTANCE.getRmcEClass(string2);
        if (eClass == null) {
            this.logger.logWarning(NLS.bind((String)ImportXMLResources.library_error_no_eclass, (Object)string2));
            return null;
        }
        eDataObject = (EDataObject)EcoreUtil.create((EClass)eClass);
        this.setElement(string4, eDataObject);
        ContentPackage contentPackage = (ContentPackage)this.getRootPackage(methodPlugin, eDataObject);
        contentPackage.getContentElements().add(eDataObject);
        return eDataObject;
    }

    public MethodPackage getRootPackage(MethodPlugin methodPlugin, Object object) {
        String[] stringArray = null;
        if (object instanceof CustomCategory) {
            stringArray = ModelStructure.DEFAULT.customCategoryPath;
        } else if (object instanceof Discipline || object instanceof DisciplineGrouping) {
            stringArray = ModelStructure.DEFAULT.disciplineDefinitionPath;
        } else if (object instanceof Domain) {
            stringArray = ModelStructure.DEFAULT.domainPath;
        } else if (object instanceof RoleSet || object instanceof RoleSetGrouping) {
            stringArray = ModelStructure.DEFAULT.roleSetPath;
        } else if (object instanceof Tool) {
            stringArray = ModelStructure.DEFAULT.toolPath;
        } else if (object instanceof WorkProductType) {
            stringArray = ModelStructure.DEFAULT.workProductTypePath;
        }
        if (stringArray != null) {
            return UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])stringArray);
        }
        this.logger.logWarning(NLS.bind((String)ImportXMLResources.library_no_package, (Object)object));
        return null;
    }

    public EDataObject createMethodPlugin(String string, String string2) throws Exception {
        Object object;
        boolean bl;
        EDataObject eDataObject = this.getElement(string);
        boolean bl2 = bl = eDataObject != null;
        if (eDataObject == null) {
            object = new HashMap<String, Map>();
            object.put("renameElementMap", this.renameElementMap);
            eDataObject = org.eclipse.epf.dataexchange.importing.LibraryService.INSTANCE.createPlugin(string2, string, (Map)object);
            this.setElement(string, eDataObject);
        }
        this.setSourceId(string);
        object = TngUtil.getAllSystemPackages((MethodPlugin)((MethodPlugin)eDataObject));
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            MethodPackage methodPackage = (MethodPackage)iterator.next();
            this.setSourceId(methodPackage.getGuid());
            if (bl) continue;
            this.newElementsMap.put(methodPackage.getGuid(), methodPackage);
        }
        return eDataObject;
    }

    public EDataObject getContentRootPackage(EDataObject eDataObject) {
        if (!(eDataObject instanceof MethodPlugin)) {
            return null;
        }
        return UmaUtil.findMethodPackage((MethodPlugin)((MethodPlugin)eDataObject), (String[])ModelStructure.DEFAULT.coreContentPath);
    }

    public EDataObject getCapabilityPatternRootPackage(EDataObject eDataObject) {
        if (!(eDataObject instanceof MethodPlugin)) {
            return null;
        }
        return UmaUtil.findMethodPackage((MethodPlugin)((MethodPlugin)eDataObject), (String[])ModelStructure.DEFAULT.capabilityPatternPath);
    }

    public EDataObject getDeliveryProcessRootPackage(EDataObject eDataObject) {
        if (!(eDataObject instanceof MethodPlugin)) {
            return null;
        }
        return UmaUtil.findMethodPackage((MethodPlugin)((MethodPlugin)eDataObject), (String[])ModelStructure.DEFAULT.deliveryProcessPath);
    }

    public EDataObject createElement(EDataObject eDataObject, String string, String string2, String string3, String string4) {
        EDataObject eDataObject2;
        block18: {
            EStructuralFeature eStructuralFeature;
            block19: {
                this.setSourceId(string4);
                eDataObject2 = this.getElement(string4);
                if (eDataObject2 != null) {
                    EObject eObject;
                    if (eDataObject2 instanceof Activity && (eObject = eDataObject2.eContainer()) instanceof ProcessPackage) {
                        ProcessPackage processPackage = (ProcessPackage)eObject;
                        this.setSourceId(processPackage.getGuid());
                    }
                    return eDataObject2;
                }
                EClass eClass = FeatureManager.INSTANCE.getRmcEClass(string2);
                if (eClass == null) {
                    this.logger.logWarning(NLS.bind((String)ImportXMLResources.library_error_no_eclass, (Object)string2));
                    return null;
                }
                eDataObject2 = (EDataObject)EcoreUtil.create((EClass)eClass);
                if (eDataObject2 instanceof WorkOrder) {
                    ((ProcessPackage)eDataObject.eContainer()).getProcessElements().add(eDataObject2);
                }
                this.setElement(string4, eDataObject2);
                if (eDataObject instanceof MethodPlugin) {
                    MethodPlugin methodPlugin = (MethodPlugin)eDataObject;
                    if (eDataObject2 instanceof ContentPackage) {
                        MethodPackage methodPackage = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])ModelStructure.DEFAULT.coreContentPath);
                        methodPackage.getChildPackages().add(eDataObject2);
                    } else if (eDataObject2 instanceof ProcessComponent) {
                        MethodPackage methodPackage = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])ModelStructure.DEFAULT.capabilityPatternPath);
                        methodPackage.getChildPackages().add(eDataObject2);
                    } else if (eDataObject2 instanceof ProcessPackage) {
                        MethodPackage methodPackage = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])ModelStructure.DEFAULT.deliveryProcessPath);
                        methodPackage.getChildPackages().add(eDataObject2);
                    }
                    break block18;
                }
                eStructuralFeature = FeatureManager.INSTANCE.getRmcFeature(eDataObject.eClass(), string);
                if (eStructuralFeature != null) break block19;
                return null;
            }
            try {
                List list;
                if (eDataObject instanceof Activity && eStructuralFeature == UmaPackage.eINSTANCE.getActivity_BreakdownElements() && eDataObject2 instanceof BreakdownElement) {
                    list = eDataObject;
                    while (list != null && !(list instanceof ProcessPackage)) {
                        list = list.eContainer();
                    }
                    if (eDataObject2 instanceof Activity) {
                        List list2 = ((ProcessPackage)list).getChildPackages();
                        ProcessPackage processPackage = null;
                        processPackage = UmaFactory.eINSTANCE.createProcessPackage();
                        processPackage.setName(((MethodElement)eDataObject).getName());
                        this.setElement(EcoreUtil.generateUUID(), (EDataObject)processPackage);
                        this.setSourceId(processPackage.getGuid());
                        list2.add(processPackage);
                        list = processPackage;
                    }
                    ((ProcessPackage)list).getProcessElements().add(eDataObject2);
                }
                if (eStructuralFeature.isMany()) {
                    list = (List)eDataObject.eGet(eStructuralFeature);
                    list.add(eDataObject2);
                } else {
                    eDataObject.eSet(eStructuralFeature, (Object)eDataObject2);
                }
            }
            catch (RuntimeException runtimeException) {
                this.logger.logWarning(NLS.bind((String)ImportXMLResources.library_error_create_element, (Object)runtimeException.getMessage()));
            }
        }
        return eDataObject2;
    }

    private void setElement(String string, EDataObject eDataObject) {
        if (!this.elementsMap.containsKey(string)) {
            if (eDataObject instanceof MethodElement) {
                ((MethodElement)eDataObject).setGuid(string);
            }
            this.elementsMap.put(string, eDataObject);
            this.setDirty((EObject)eDataObject);
            this.newElementsMap.put(string, eDataObject);
        }
    }

    private void setSourceId(String string) {
        if (!this.sourceElementIDs.contains(string)) {
            this.sourceElementIDs.add(string);
        }
    }

    private void setDirty(EObject eObject) {
        Resource resource = eObject.eResource();
        if (resource != null && !resource.isModified()) {
            resource.setModified(true);
        }
    }

    public EDataObject getElement(String string) {
        return (EDataObject)this.elementsMap.get(string);
    }

    private Date createDate(String string) {
        string = string.replace('T', ' ');
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        return simpleDateFormat.parse(string, new ParsePosition(0));
    }

    private String getString(Object object) {
        String string = "";
        if (object instanceof MethodElement) {
            string = LibraryUtil.getTypeName((MethodElement)((MethodElement)object));
        } else if (object != null) {
            string = object.toString();
        }
        return string;
    }

    public void setAtributeFeatureValue(EDataObject eDataObject, String string, Object object) throws Exception {
        boolean bl = eDataObject.eDeliver();
        eDataObject.eSetDeliver(false);
        this.setAtributeFeatureValue_(eDataObject, string, object);
        eDataObject.eSetDeliver(bl);
    }

    private void setAtributeFeatureValue_(EDataObject eDataObject, String string, Object object) throws Exception {
        if (eDataObject == null || string == null || object == null) {
            return;
        }
        if (object instanceof List || object instanceof EDataObject) {
            if (string.equals("methodElementProperty")) {
                this.setMepFeatureValue(eDataObject, string, object);
                return;
            }
            throw new Exception(NLS.bind((String)ImportXMLResources.library_error_set_attribute_2, (Object)object));
        }
        EStructuralFeature eStructuralFeature = FeatureManager.INSTANCE.getRmcFeature(eDataObject.eClass(), string);
        if (eStructuralFeature == null) {
            Object[] objectArray = new Object[]{this.getString(eDataObject), string, object};
            this.logger.logWarning(String.valueOf(NLS.bind((String)ImportXMLResources.library_error_set_attribute, (Object[])objectArray)) + eDataObject);
            return;
        }
        this.setDirty((EObject)eDataObject);
        if (eStructuralFeature == UmaPackage.eINSTANCE.getGuidanceDescription_Attachments()) {
            if (object != null) {
                object = this.contentProc.resolveAttachmentResources((Object)eDataObject, object.toString().trim());
            }
            eDataObject.eSet(eStructuralFeature, object);
        } else if (eStructuralFeature instanceof EReference && object instanceof String) {
            EDataObject eDataObject2 = this.getElement((String)object);
            if (eDataObject2 != null) {
                if (eStructuralFeature.isMany()) {
                    ((List)eDataObject.eGet(eStructuralFeature)).add(eDataObject2);
                } else {
                    eDataObject.eSet(eStructuralFeature, (Object)eDataObject2);
                }
            } else {
                Object[] objectArray = new Object[]{this.getString(eDataObject), eStructuralFeature.getName(), object};
                String string2 = NLS.bind((String)ImportXMLResources.library_error_set_attribute, (Object[])objectArray);
                this.logger.logWarning(string2);
            }
        } else if (eStructuralFeature instanceof EAttribute) {
            try {
                if (eStructuralFeature.getName().equals("variabilityType")) {
                    object = VariabilityType.get((String)object.toString());
                } else if (eStructuralFeature.getName().equals("linkType")) {
                    object = WorkOrderType.get((String)object.toString());
                } else if (eStructuralFeature == UmaPackage.eINSTANCE.getMethodUnit_ChangeDate()) {
                    object = this.createDate(object.toString());
                } else if (eStructuralFeature.getName().equals("nodeicon") || eStructuralFeature.getName().equals("shapeicon")) {
                    MethodPlugin methodPlugin = UmaUtil.getMethodPlugin((EObject)((MethodElement)eDataObject));
                    int n = methodPlugin.getName().length() + 1;
                    object = new URI(object.toString().substring(n));
                    this.contentProc.copyResource(((URI)object).getPath(), (EObject)eDataObject, methodPlugin);
                } else if (this.contentProc != null && eDataObject instanceof MethodElement && object instanceof String) {
                    object = this.contentProc.resolveResourceFiles((Object)((MethodElement)eDataObject), (String)object);
                }
                eDataObject.eSet(eStructuralFeature, object);
            }
            catch (RuntimeException runtimeException) {
                Object[] objectArray = new Object[]{this.getString(eDataObject), string, object};
                this.logger.logError(NLS.bind((String)ImportXMLResources.library_error_set_attribute, (Object[])objectArray), (Throwable)runtimeException);
            }
        } else {
            Object[] objectArray = new Object[]{this.getString(eDataObject), string, object};
            this.logger.logWarning(NLS.bind((String)ImportXMLResources.library_error_set_attribute_3, (Object[])objectArray));
        }
    }

    private void setMepFeatureValue(EDataObject eDataObject, String string, Object object) {
        MethodElementProperty methodElementProperty;
        Object object2;
        int n;
        int n2;
        List list = (List)object;
        int n3 = list == null ? 0 : list.size();
        EStructuralFeature eStructuralFeature = FeatureManager.INSTANCE.getRmcFeature(eDataObject.eClass(), string);
        List list2 = (List)eDataObject.eGet(eStructuralFeature);
        int n4 = n2 = list2 == null ? 0 : list2.size();
        if (n3 == 0) {
            if (n2 == 0) {
                return;
            }
            list2.removeAll(list2);
            this.setDirty((EObject)eDataObject);
            return;
        }
        boolean bl = false;
        if (n3 == n2) {
            bl = true;
            n = 0;
            while (n < n3) {
                object2 = (org.eclipse.epf.xml.uma.MethodElementProperty)list.get(n);
                methodElementProperty = (MethodElementProperty)list2.get(n);
                if (!object2.getName().equals(methodElementProperty.getName())) {
                    bl = false;
                    break;
                }
                if (!object2.getValue().equals(methodElementProperty.getValue())) {
                    bl = false;
                    break;
                }
                ++n;
            }
        }
        if (bl) {
            return;
        }
        list2.removeAll(list2);
        n = 0;
        while (n < n3) {
            object2 = list.get(n);
            if (object2 instanceof org.eclipse.epf.xml.uma.MethodElementProperty) {
                methodElementProperty = object2;
                EClass eClass = FeatureManager.INSTANCE.getRmcEClass("MethodElementProperty");
                MethodElementProperty methodElementProperty2 = (MethodElementProperty)EcoreUtil.create((EClass)eClass);
                methodElementProperty2.setValue(methodElementProperty.getValue());
                methodElementProperty2.setName(methodElementProperty.getName());
                list2.add(methodElementProperty2);
            }
            ++n;
        }
        this.setDirty((EObject)eDataObject);
    }

    public void setReferenceValue(EDataObject eDataObject, String string, String string2) throws Exception {
        if (eDataObject == null || string == null || string2 == null) {
            return;
        }
        EDataObject eDataObject2 = this.getElement(string2);
        if (eDataObject2 == null) {
            this.logger.logWarning(NLS.bind((String)ImportXMLResources.library_error_set_reference, (Object)string, (Object)string2));
            return;
        }
        EStructuralFeature eStructuralFeature = FeatureManager.INSTANCE.getRmcFeature(eDataObject.eClass(), string);
        if (eStructuralFeature == null) {
            Object[] objectArray = new Object[]{this.getString(eDataObject), string, string2};
            this.logger.logWarning(NLS.bind((String)ImportXMLResources.library_error_set_reference_2, (Object[])objectArray));
            return;
        }
        if (eDataObject2.eContainer() == eDataObject) {
            return;
        }
        if (eStructuralFeature.isMany()) {
            try {
                List list = (List)eDataObject.eGet(eStructuralFeature);
                if (!list.contains(eDataObject2)) {
                    list.add(eDataObject2);
                }
            }
            catch (RuntimeException runtimeException) {
                Object[] objectArray = new Object[]{this.getString(eDataObject), string, string2};
                this.logger.logError(NLS.bind((String)ImportXMLResources.library_error_set_reference_2, (Object[])objectArray), (Throwable)runtimeException);
            }
        } else {
            eDataObject.eSet(eStructuralFeature, (Object)eDataObject2);
        }
        this.setDirty((EObject)eDataObject);
    }

    public void setWorkOrder(Object object, String string) {
        if (object instanceof WorkOrder) {
            WorkBreakdownElement workBreakdownElement = (WorkBreakdownElement)this.getElement(string);
            ((WorkOrder)object).setPred(workBreakdownElement);
            this.setDirty((EObject)object);
        }
    }

    public void fixLibrary() {
        MethodLibrary methodLibrary = this.getRoot();
        Iterator iterator = methodLibrary.getMethodPlugins().iterator();
        while (iterator.hasNext()) {
            this.fixPlugin((MethodPlugin)iterator.next());
        }
    }

    public void fixTaskDescriptors(Map<String, org.eclipse.epf.xml.uma.TaskDescriptor> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        for (Map.Entry<String, org.eclipse.epf.xml.uma.TaskDescriptor> entry : map.entrySet()) {
            String string = entry.getKey();
            org.eclipse.epf.xml.uma.TaskDescriptor taskDescriptor = entry.getValue();
            TaskDescriptor taskDescriptor2 = (TaskDescriptor)this.elementsMap.get(string);
            assert (taskDescriptor2 != null);
            if (taskDescriptor2 == null) continue;
            EList eList = taskDescriptor.getStep();
            int n = 0;
            while (n < eList.size()) {
                org.eclipse.epf.xml.uma.MethodElement methodElement = (org.eclipse.epf.xml.uma.MethodElement)eList.get(n);
                Section section = (Section)this.elementsMap.get(methodElement.getId());
                assert (section != null);
                if (section != null) {
                    taskDescriptor2.getSelectedSteps().add(section);
                }
                ++n;
            }
        }
    }

    private void fixPlugin(MethodPlugin methodPlugin) {
        this.fixCustomCategories(methodPlugin);
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        this.cpRoot = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])ModelStructure.DEFAULT.capabilityPatternPath);
        this.dpRoot = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])ModelStructure.DEFAULT.deliveryProcessPath);
        this.getAllPackages(this.cpRoot, arrayList);
        this.getAllPackages(this.dpRoot, arrayList2);
        ArrayList<EObject> arrayList3 = new ArrayList<EObject>();
        TreeIterator treeIterator = methodPlugin.eAllContents();
        while (treeIterator.hasNext()) {
            EObject eObject = (EObject)treeIterator.next();
            boolean bl = eObject.eDeliver();
            try {
                String string;
                String string2;
                eObject.eSetDeliver(false);
                if (eObject instanceof ProcessComponent) {
                    arrayList3.add(eObject);
                } else if (eObject instanceof DescribableElement && ((string2 = ((DescribableElement)eObject).getPresentationName()) == null || string2.length() == 0)) {
                    ((DescribableElement)eObject).setPresentationName(((DescribableElement)eObject).getName());
                }
                if (!(eObject instanceof MethodElement) || eObject instanceof Section || (string = StrUtil.makeValidFileName((String)(string2 = ((MethodElement)eObject).getName()))).equals(string2)) continue;
                ((MethodElement)eObject).setName(string);
            }
            finally {
                eObject.eSetDeliver(bl);
            }
        }
        if (arrayList3.size() > 0) {
            for (EObject eObject : arrayList3) {
                Process process = eObject.getProcess();
                if (process instanceof DeliveryProcess) {
                    if (arrayList2.contains(eObject)) continue;
                    this.moveProcessComponent((ProcessPackage)eObject, this.dpRoot);
                    continue;
                }
                if (!(process instanceof CapabilityPattern) || arrayList.contains(eObject)) continue;
                this.moveProcessComponent((ProcessPackage)eObject, this.cpRoot);
            }
        }
    }

    private void getAllPackages(MethodPackage methodPackage, List list) {
        list.add(methodPackage);
        Iterator iterator = methodPackage.getChildPackages().iterator();
        while (iterator.hasNext()) {
            this.getAllPackages((MethodPackage)iterator.next(), list);
        }
    }

    private void moveProcessComponent(ProcessPackage processPackage, MethodPackage methodPackage) {
        EObject eObject = processPackage.eContainer();
        if (eObject instanceof ProcessPackage && ((ProcessPackage)eObject).getChildPackages().size() == 1 && eObject != this.cpRoot && eObject != this.dpRoot) {
            this.moveProcessComponent((ProcessPackage)eObject, methodPackage);
        } else {
            methodPackage.getChildPackages().add(processPackage);
        }
    }

    private void fixCustomCategories(MethodPlugin methodPlugin) {
        ContentPackage contentPackage = UmaUtil.findContentPackage((MethodPlugin)methodPlugin, (String[])ModelStructure.DEFAULT.customCategoryPath);
        ArrayList arrayList = new ArrayList(contentPackage.getContentElements());
        ArrayList<CustomCategory> arrayList2 = new ArrayList<CustomCategory>();
        while (arrayList.size() > 0) {
            CustomCategory customCategory = (CustomCategory)arrayList.remove(0);
            arrayList2.add(customCategory);
            this.fixCustomCategories(customCategory, arrayList, arrayList2);
        }
        TngUtil.getRootCustomCategory((MethodPlugin)methodPlugin).getCategorizedElements().addAll(arrayList2);
    }

    private void fixCustomCategories(CustomCategory customCategory, List list, List list2) {
        for (Object e : customCategory.getSubCategories()) {
            list.remove(e);
            list2.remove(e);
            this.fixCustomCategories((CustomCategory)e, list, list2);
        }
        for (Object e : customCategory.getCategorizedElements()) {
            if (!(e instanceof CustomCategory)) continue;
            list.remove(e);
            list2.remove(e);
            this.fixCustomCategories((CustomCategory)e, list, list2);
        }
    }

    public void deleteElements() {
        Services.getFileManager();
        ArrayList<MethodElement> arrayList = new ArrayList<MethodElement>();
        block0: for (Map.Entry entry : this.elementsMap.entrySet()) {
            MethodPackage methodPackage;
            Object object;
            String string = (String)entry.getKey();
            MethodElement methodElement = (MethodElement)entry.getValue();
            if (this.sourceElementIDs.contains(string)) continue;
            if (this.overwrite) {
                boolean bl;
                boolean bl2 = bl = !(methodElement instanceof MethodLibrary) && !(methodElement instanceof MethodPlugin) && !(methodElement instanceof MethodConfiguration);
                if (bl) {
                    object = UmaUtil.getMethodPlugin((EObject)methodElement);
                    boolean bl3 = bl = object != null && !this.isNewElement(object.getGuid()) && this.sourceElementIDs.contains(object.getGuid());
                }
                if (bl) {
                    arrayList.add(methodElement);
                    this.handleActivityRemoval(methodElement);
                    continue;
                }
            }
            if (methodElement instanceof CustomCategory && TngUtil.isRootCustomCategory((CustomCategory)((CustomCategory)methodElement)) || (methodPackage = TngUtil.getMethodPackage((EObject)methodElement)) == null) continue;
            object = methodPackage.getGuid();
            if (this.sourceElementIDs.contains(object)) {
                arrayList.add(methodElement);
                this.handleActivityRemoval(methodElement);
                continue;
            }
            if (!(methodElement instanceof Activity)) continue;
            boolean bl = true;
            MethodPackage methodPackage2 = methodPackage;
            while (methodPackage2 != null && !(methodPackage2 instanceof ProcessComponent)) {
                methodPackage2 = TngUtil.getParentMethodPackage((EObject)methodPackage2);
            }
            if (methodPackage2 instanceof ProcessComponent) {
                bl = this.sourceElementIDs.contains(methodPackage2.getGuid());
            }
            if (!bl) continue;
            methodPackage = TngUtil.getMethodPackage((EObject)methodPackage);
            while (methodPackage != null) {
                object = methodPackage.getGuid();
                if (this.sourceElementIDs.contains(object)) {
                    arrayList.add(methodElement);
                    this.handleActivityRemoval(methodElement);
                    continue block0;
                }
                methodPackage = TngUtil.getParentMethodPackage((EObject)methodPackage);
            }
        }
        this.deleteResoruces(arrayList);
    }

    private void handleActivityRemoval(MethodElement methodElement) {
        if (!(methodElement instanceof BreakdownElement)) {
            return;
        }
        BreakdownElement breakdownElement = (BreakdownElement)methodElement;
        Activity activity = breakdownElement.getSuperActivities();
        if (activity != null) {
            activity.getBreakdownElements().remove(breakdownElement);
        }
    }

    private void deleteResoruces(List list) {
        if (list.size() == 0) {
            return;
        }
        IFileManager iFileManager = Services.getFileManager();
        for (MethodElement methodElement : list) {
            ContentDescription contentDescription = null;
            if (methodElement instanceof DescribableElement) {
                contentDescription = ((DescribableElement)methodElement).getPresentation();
            } else if (methodElement instanceof ContentDescription || this.overwrite && methodElement instanceof ProcessComponent) {
                contentDescription = methodElement;
            }
            if (contentDescription != null) {
                MethodPlugin methodPlugin = UmaUtil.getMethodPlugin((EObject)methodElement);
                Resource resource = methodPlugin == null ? null : methodPlugin.eResource();
                Resource resource2 = contentDescription.eResource();
                if (resource2 != null && resource2 != resource) {
                    File file;
                    File[] fileArray;
                    ResourceDescriptor resourceDescriptor;
                    ResourceManager resourceManager;
                    String string = resource2.getURI().toFileString();
                    if (this.debug) {
                        System.out.println("deleting resource: " + string);
                    }
                    if (!iFileManager.delete(string) && this.debug) {
                        System.out.println("unable to delete file: " + string);
                    }
                    if ((resourceManager = MultiFileSaveUtil.getResourceManager((Resource)resource2)) != null) {
                        EcoreUtil.remove((EObject)resourceManager);
                    }
                    if ((resourceDescriptor = MultiFileSaveUtil.getResourceDescriptor((Resource)resource2)) != null) {
                        EcoreUtil.remove((EObject)resourceDescriptor);
                    }
                    if (this.overwrite && ((fileArray = (file = new File(string).getParentFile()).listFiles()) == null || fileArray.length == 0)) {
                        if (this.debug) {
                            System.out.println("deleting folder resource: " + file);
                        }
                        if (!iFileManager.delete(file.getAbsolutePath()) && this.debug) {
                            System.out.println("unable to delete folder file: " + file);
                        }
                    }
                }
            }
            EcoreUtil.remove((EObject)methodElement);
        }
    }

    public boolean isNewElement(String string) {
        return this.newElementsMap.containsKey(string);
    }
}

