/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.xml.wizards;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.epf.authoring.ui.wizards.SaveAllEditorsPage;
import org.eclipse.epf.common.serviceability.MsgBox;
import org.eclipse.epf.export.xml.ExportXMLPlugin;
import org.eclipse.epf.importing.xml.ImportXMLPlugin;
import org.eclipse.epf.importing.xml.ImportXMLResources;
import org.eclipse.epf.importing.xml.preferences.ImportXMLPreferences;
import org.eclipse.epf.importing.xml.services.ImportXMLService;
import org.eclipse.epf.importing.xml.wizards.SelectXMLFilePage;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.ILibraryService;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.ui.actions.LibraryLockingOperationRunner;
import org.eclipse.epf.library.ui.wizards.LibraryBackupUtil;
import org.eclipse.epf.library.util.ResourceUtil;
import org.eclipse.epf.persistence.refresh.RefreshJob;
import org.eclipse.epf.services.IFileManager;
import org.eclipse.epf.services.Services;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class ImportXMLWizard
extends Wizard
implements IImportWizard {
    ImportXMLService service = new ImportXMLService();
    private boolean succeed = true;
    private SelectXMLFilePage filePage = null;

    public ImportXMLWizard() {
        this.setWindowTitle(ImportXMLResources.importXMLWizard_title);
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
    }

    public void addPages() {
        ILibraryManager iLibraryManager;
        IFileManager iFileManager = Services.getFileManager();
        if (LibraryService.getInstance().getCurrentMethodLibrary() != null) {
            iFileManager.checkModify(LibraryService.getInstance().getCurrentMethodLibrary().eResource().getURI().toFileString(), (Object)MsgBox.getDefaultShell());
        }
        if ((iLibraryManager = LibraryService.getInstance().getCurrentLibraryManager()) != null && iLibraryManager.isMethodLibraryReadOnly()) {
            File file = new File(LibraryService.getInstance().getCurrentMethodLibraryLocation(), "library.xmi");
            ImportXMLPlugin.getDefault().getMsgDialog().displayError(ImportXMLResources.importXMLWizard_title, ImportXMLResources.importXMLError_msg, NLS.bind((String)ImportXMLResources.importXMLError_reason, (Object)file.getAbsolutePath()));
            return;
        }
        SaveAllEditorsPage.addPageIfNeeded((Wizard)this, (boolean)true, null, null, (ImageDescriptor)ImportXMLPlugin.getDefault().getImageDescriptor("full/wizban/ImportXML.gif"));
        this.filePage = new SelectXMLFilePage();
        this.addPage((IWizardPage)this.filePage);
    }

    public void createPageControls(Composite composite) {
        super.createPageControls(composite);
        composite.getShell().setImage(ExportXMLPlugin.getDefault().getSharedImage("full/obj16/XMLFile.gif"));
    }

    public boolean performFinish() {
        boolean bl = RefreshJob.getInstance().isEnabled();
        if (bl) {
            RefreshJob.getInstance().setEnabled(false);
        }
        final boolean[] blArray = new boolean[1];
        LibraryLockingOperationRunner libraryLockingOperationRunner = new LibraryLockingOperationRunner();
        libraryLockingOperationRunner.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                blArray[0] = ImportXMLWizard.this.performFinish_();
            }
        });
        if (bl) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {}
            RefreshJob.getInstance().setEnabled(true);
        }
        libraryLockingOperationRunner = new LibraryLockingOperationRunner();
        libraryLockingOperationRunner.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                String string = NLS.bind((String)ImportXMLResources.review_log_files, (Object)ImportXMLWizard.this.service.getLogPath());
                MsgBox.prompt((String)string, (int)32);
            }
        });
        ResourceUtil.refreshResources((MethodLibrary)LibraryService.getInstance().getCurrentMethodLibrary(), (IProgressMonitor)new NullProgressMonitor());
        return blArray[0];
    }

    private boolean performFinish_() {
        LibraryBackupUtil.promptBackupCurrentLibrary(null, (ILibraryService)LibraryService.getInstance());
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException {
                try {
                    iProgressMonitor.beginTask(ImportXMLResources.importingXML_text, -1);
                    String string = ImportXMLWizard.this.filePage.getPath();
                    boolean bl = ImportXMLWizard.this.filePage.getMergeOption();
                    boolean bl2 = ImportXMLWizard.this.filePage.getCheckBasePlugins();
                    ImportXMLWizard.this.service.setOverwrite(!bl);
                    ImportXMLWizard.this.service.setCheckBasePlugins(bl2);
                    ImportXMLWizard.this.succeed = ImportXMLWizard.this.service.loadXml(string);
                    if (!ImportXMLWizard.this.succeed) {
                        return;
                    }
                    try {
                        ImportXMLWizard.this.service.doImport(iProgressMonitor);
                        ImportXMLPreferences.setXMLFile(string);
                        ImportXMLPreferences.setMergeOption(bl);
                        ImportXMLPreferences.setCheckBasePluginsOption(bl2);
                    }
                    catch (Exception exception) {
                        throw new InvocationTargetException(exception);
                    }
                }
                finally {
                    iProgressMonitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, iRunnableWithProgress);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            ImportXMLPlugin.getDefault().getMsgDialog().displayError(ImportXMLResources.importXMLWizard_title, throwable.getMessage(), throwable);
            return false;
        }
        return this.succeed;
    }

    public void dispose() {
        this.service.dispose();
    }
}

