/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui.xmi;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.epf.library.ui.wizards.NewLibraryWizardPage;
import org.eclipse.epf.library.ui.xmi.XMILibraryUIResources;
import org.eclipse.epf.library.xmi.preferences.XMILibraryPreferences;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class NewXMILibraryWizardPage
extends NewLibraryWizardPage {
    private Text nameText;
    private Combo locationCombo;
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent modifyEvent) {
            NewXMILibraryWizardPage.this.setPageComplete(NewXMILibraryWizardPage.this.isPageComplete());
            NewXMILibraryWizardPage.this.getWizard().getContainer().updateButtons();
        }
    };

    public NewXMILibraryWizardPage(String string) {
        super(string);
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(composite2, 0);
        label.setText(XMILibraryUIResources.nameLabel_text);
        this.nameText = new Text(composite2, 2048);
        this.nameText.setLayoutData((Object)new GridData(768));
        this.nameText.setEditable(false);
        new Label(composite2, 0);
        Label label2 = new Label(composite2, 0);
        label2.setText(XMILibraryUIResources.locationLabel_text);
        this.locationCombo = new Combo(composite2, 2048);
        this.locationCombo.setLayoutData((Object)new GridData(768));
        this.locationCombo.addModifyListener(this.modifyListener);
        this.locationCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                NewXMILibraryWizardPage.this.setPageComplete(NewXMILibraryWizardPage.this.isPageComplete());
                NewXMILibraryWizardPage.this.getWizard().getContainer().updateButtons();
            }
        });
        final Shell shell = composite.getShell();
        final Button button = new Button(composite2, 0);
        button.setText(XMILibraryUIResources.browseButton_text);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                try {
                    DirectoryDialog directoryDialog = new DirectoryDialog(shell, 0);
                    String string = directoryDialog.open();
                    if (string != null) {
                        NewXMILibraryWizardPage.this.locationCombo.add(string, 0);
                        NewXMILibraryWizardPage.this.locationCombo.setText(string);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        });
        new Label(composite2, 0);
        final Button button2 = new Button(composite2, 32);
        button2.setText(XMILibraryUIResources.defaultPathCheckboxLabel_text);
        button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (button2.getSelection()) {
                    NewXMILibraryWizardPage.this.locationCombo.removeModifyListener(NewXMILibraryWizardPage.this.modifyListener);
                    NewXMILibraryWizardPage.this.locationCombo.setText(XMILibraryPreferences.getDefaultLibraryPath());
                    NewXMILibraryWizardPage.this.locationCombo.addModifyListener(NewXMILibraryWizardPage.this.modifyListener);
                    NewXMILibraryWizardPage.this.locationCombo.setEnabled(false);
                    button.setEnabled(false);
                } else {
                    NewXMILibraryWizardPage.this.locationCombo.setEnabled(true);
                    button.setEnabled(true);
                }
            }
        });
        this.setPageComplete(true);
        this.setControl((Control)composite2);
    }

    public void onEnterPage(Object object) {
        if (object != null && object instanceof String) {
            String string = (String)object;
            this.nameText.setText(string);
        }
        if (this.getLibraryPath().length() == 0) {
            this.locationCombo.removeModifyListener(this.modifyListener);
            this.locationCombo.setText(XMILibraryPreferences.getDefaultLibraryPath());
            this.locationCombo.addModifyListener(this.modifyListener);
        }
    }

    public boolean isPageComplete() {
        return this.getLibraryPath().length() > 0 && this.getLibraryName().length() > 0;
    }

    public IWizardPage getNextPage() {
        return null;
    }

    public String getLibraryName() {
        return this.nameText.getText().trim();
    }

    public String getLibraryPath() {
        return this.locationCombo.getText().trim();
    }

    public Map getSelections() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        File file = new File(this.getLibraryPath(), this.getLibraryName());
        hashMap.put("library.path", file.getAbsolutePath());
        return hashMap;
    }
}

