/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.xml.wizards;

import org.eclipse.epf.export.ExportResources;
import org.eclipse.epf.export.xml.ExportXMLPlugin;
import org.eclipse.epf.export.xml.ExportXMLResources;
import org.eclipse.epf.export.xml.preferences.ExportXMLPreferences;
import org.eclipse.epf.export.xml.wizards.ExportXMLWizard;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.epf.ui.wizards.BaseWizardPage;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class SelectExportTypePage
extends BaseWizardPage
implements Listener {
    public static final String PAGE_NAME = SelectExportTypePage.class.getName();
    private Button exportLibraryRadioButton;
    private Button exportPluginsRadioButton;

    public SelectExportTypePage() {
        super(PAGE_NAME);
        this.setTitle(ExportResources.selectExportTypePage_title);
        this.setDescription(ExportXMLResources.selectExportTypePage_desc);
        this.setImageDescriptor(ExportXMLPlugin.getDefault().getImageDescriptor("full/wizban/ExportXML.gif"));
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        this.exportLibraryRadioButton = SelectExportTypePage.createRadioButton((Composite)composite2, (String)ExportXMLResources.exportLibraryRadioButton_text, (int)1, (boolean)false);
        this.exportPluginsRadioButton = SelectExportTypePage.createRadioButton((Composite)composite2, (String)ExportXMLResources.exportPluginsRadioButton_text, (int)1, (boolean)false);
        switch (ExportXMLPreferences.getExportType()) {
            case 1: {
                this.exportLibraryRadioButton.setSelection(true);
                break;
            }
            case 2: {
                this.exportPluginsRadioButton.setSelection(true);
            }
        }
        this.addListeners();
        this.setControl((Control)composite2);
        this.setPageComplete(true);
    }

    private void addListeners() {
        this.exportLibraryRadioButton.addListener(13, (Listener)this);
        this.exportPluginsRadioButton.addListener(13, (Listener)this);
    }

    public void handleEvent(Event event) {
        this.setPageComplete(this.isPageComplete());
        this.getWizard().getContainer().updateButtons();
    }

    public boolean isPageComplete() {
        if (LibraryService.getInstance().getCurrentMethodLibrary() == null) {
            this.setErrorMessage(LibraryUIResources.noOpenLibraryWarning_msg);
            return false;
        }
        return this.getErrorMessage() == null;
    }

    public IWizardPage getNextPage() {
        ExportXMLWizard exportXMLWizard = (ExportXMLWizard)this.getWizard();
        if (this.exportLibraryRadioButton.getSelection()) {
            exportXMLWizard.xmlData.setExportType(1);
            return exportXMLWizard.selectXMLFilePage;
        }
        if (this.exportPluginsRadioButton.getSelection()) {
            exportXMLWizard.xmlData.setExportType(2);
            return exportXMLWizard.selectPluginPage;
        }
        return null;
    }
}

