/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.gef.edit;

import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.IFigure;
import org.eclipse.epf.authoring.gef.edit.NodeEditPart;
import org.eclipse.epf.authoring.gef.util.DiagramUIResources;
import org.eclipse.epf.authoring.gef.util.TemplateConstants;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.common.serviceability.MsgDialog;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.epf.diagram.model.TypedNode;
import org.eclipse.epf.diagram.model.WorkBreakdownElementNode;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Property;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;

public class FreeTextDirectEditManager
extends DirectEditManager {
    protected VerifyListener verifyListener;
    private Font scaledFont;
    protected IFigure figure;

    public FreeTextDirectEditManager(GraphicalEditPart graphicalEditPart, Class clazz, CellEditorLocator cellEditorLocator, IFigure iFigure) {
        super(graphicalEditPart, clazz, cellEditorLocator);
        this.figure = iFigure;
    }

    protected void bringDown() {
        this.bringDown(true);
    }

    protected void bringDown(boolean bl) {
        Font font = this.scaledFont;
        this.scaledFont = null;
        super.bringDown();
        if (font != null) {
            font.dispose();
        }
        if (bl) {
            Object object;
            Node node = (Node)this.getEditPart().getModel();
            String string = "";
            if (node instanceof WorkBreakdownElementNode && (object = node.getObject()) instanceof Activity && ProcessUtil.isExtendingOrLocallyContributing((BreakdownElement)((BreakdownElement)object))) {
                string = ProcessUtil.getPresentationName((BreakdownElement)((BreakdownElement)object));
            }
            if (node instanceof TypedNode && ((TypedNode)node).getType() == 6) {
                object = ((Node)this.getEditPart().getModel()).getGraphNode();
                string = ((Property)object.getProperty().get(0)).getValue();
            }
            if (string == null || string.trim().length() == 0) {
                Display.getCurrent().asyncExec((Runnable)new PromptEdit((NodeEditPart)this.getEditPart(), DiagramUIResources.err_name_empty));
            }
        }
    }

    protected void initCellEditor() {
        TextCellEditor textCellEditor = (TextCellEditor)this.getCellEditor();
        textCellEditor.setStyle(2);
        Text text = (Text)textCellEditor.getControl();
        this.verifyListener = new VerifyListener(){

            public void verifyText(VerifyEvent verifyEvent) {
                Text text = (Text)FreeTextDirectEditManager.this.getCellEditor().getControl();
                String string = text.getText();
                String string2 = string.substring(0, verifyEvent.start);
                String string3 = string.substring(verifyEvent.end, string.length());
                GC gC = new GC((Drawable)text);
                Point point = gC.textExtent(String.valueOf(string2) + verifyEvent.text + string3);
                gC.dispose();
                if (point.x != 0) {
                    point = text.computeSize(point.x, -1);
                }
                FreeTextDirectEditManager.this.getCellEditor().getControl().setSize(point.x, point.y);
            }
        };
        text.addVerifyListener(this.verifyListener);
        String string = ((NodeEditPart)this.getEditPart()).getDirectEditText();
        textCellEditor.setValue((Object)string);
        Font font = this.figure.getFont();
        FontMetrics fontMetrics = FigureUtilities.getFontMetrics((Font)font);
        int n = fontMetrics.getHeight();
        int n2 = fontMetrics.getAverageCharWidth();
        text.setSize(string.length() * n2 + 100, n + 50);
        if (font != null) {
            text.setFont(font);
        } else {
            text.setFont(TemplateConstants.DEFAULT_FONT);
        }
        text.selectAll();
    }

    protected void unhookListeners() {
        super.unhookListeners();
        if (this.getCellEditor() != null) {
            Text text = (Text)this.getCellEditor().getControl();
            if (this.verifyListener != null) {
                text.removeVerifyListener(this.verifyListener);
            }
            this.verifyListener = null;
        }
    }

    protected String validate(String string) {
        return null;
    }

    protected void commit() {
        String string = this.validate((String)this.getCellEditor().getValue());
        if (string != null) {
            this.bringDown(false);
            Display.getCurrent().asyncExec((Runnable)new PromptEdit((NodeEditPart)this.getEditPart(), string));
            return;
        }
        super.commit();
    }

    static class PromptEdit
    implements Runnable {
        private NodeEditPart part;
        private String msg;

        PromptEdit(NodeEditPart nodeEditPart, String string) {
            this.part = nodeEditPart;
            this.msg = string;
        }

        public void run() {
            String string = DiagramUIResources.diagram_errorDialog_title_text0;
            MsgDialog msgDialog = AuthoringUIPlugin.getDefault().getMsgDialog();
            msgDialog.displayError(string, this.msg);
            this.part.performDirectEdit();
        }
    }
}

