/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.gef.edit;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.IFigure;
import org.eclipse.epf.authoring.gef.edit.ActivityDetailDiagramEditPart;
import org.eclipse.epf.authoring.gef.edit.NamedNodeEditPart;
import org.eclipse.epf.authoring.gef.edit.TextFigureCellEditorLocator;
import org.eclipse.epf.authoring.gef.edit.TextFigureDirectEditManager;
import org.eclipse.epf.authoring.gef.figures.ActivityFigure;
import org.eclipse.epf.authoring.gef.figures.Colors;
import org.eclipse.epf.authoring.gef.figures.Images;
import org.eclipse.epf.authoring.gef.figures.TextFigure;
import org.eclipse.epf.diagram.model.NamedNode;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.epf.diagram.model.WorkBreakdownElementNode;
import org.eclipse.epf.diagram.model.WorkProductDescriptorNode;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Iteration;
import org.eclipse.epf.uma.Milestone;
import org.eclipse.epf.uma.Phase;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class WorkBreakdownElementNodeEditPart
extends NamedNodeEditPart {
    public WorkBreakdownElementNodeEditPart(NamedNode namedNode) {
        super(namedNode);
    }

    protected Image getImage() {
        Image image = null;
        Node node = (Node)this.getModel();
        Object object = node.getObject();
        if (object instanceof Phase) {
            image = Images.PHASE;
        } else if (object instanceof Iteration) {
            image = Images.ITERATION;
        } else if (object instanceof Activity) {
            image = Images.ACTIVITY;
        } else if (object instanceof TaskDescriptor) {
            image = Images.TASK_DESCRIPTOR;
        } else if (object instanceof Milestone) {
            image = Images.MILESTONE;
        }
        return image;
    }

    protected IFigure createFigure() {
        ActivityFigure activityFigure = new ActivityFigure();
        Image image = this.getImage();
        if (image != null) {
            activityFigure.add(image);
        }
        return activityFigure;
    }

    String getDirectEditText() {
        TextFigure textFigure = (TextFigure)this.getFigure();
        return textFigure.getText();
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        IFigure iFigure = this.getDirectEditFigure();
        if (iFigure instanceof ActivityFigure) {
            WorkBreakdownElementNode workBreakdownElementNode;
            Object object;
            ActivityFigure activityFigure = (ActivityFigure)iFigure;
            iFigure.setForegroundColor(this.getForegroundColor());
            String string = this.getModel() instanceof WorkBreakdownElementNode ? ((object = (workBreakdownElementNode = (WorkBreakdownElementNode)this.getModel()).getObject()) instanceof Activity && ProcessUtil.isExtendingOrLocallyContributing((BreakdownElement)((BreakdownElement)object)) ? ProcessUtil.getPresentationName((BreakdownElement)((BreakdownElement)object)) : ((NamedNode)this.getModel()).getName()) : ((NamedNode)this.getModel()).getName();
            try {
                if (this.getParent() instanceof ActivityDetailDiagramEditPart || this.getParent().getParent() instanceof ActivityDetailDiagramEditPart) {
                    int n = 12;
                    if (this.getModel() instanceof WorkProductDescriptorNode) {
                        n = 3;
                    }
                    string = this.wrap(string, n);
                }
            }
            catch (NullPointerException nullPointerException) {}
            activityFigure.setText(string);
        }
    }

    private Color getForegroundColor() {
        NamedNode namedNode = (NamedNode)this.getModel();
        if (namedNode.isSuppressed()) {
            return Colors.SUPRESSED_ELEMENT_LABEL;
        }
        if (namedNode.isReadOnly()) {
            return Colors.INHERITED_ELEMENT_LABEL;
        }
        return ColorConstants.black;
    }

    protected DirectEditManager createDirectEditManager() {
        return new TextFigureDirectEditManager((GraphicalEditPart)this, TextCellEditor.class, new TextFigureCellEditorLocator((TextFigure)this.getFigure()), (TextFigure)this.getFigure()){

            protected String validate(String string) {
                Object object = this.getEditPart().getModel();
                if (object instanceof WorkBreakdownElementNode) {
                    WorkBreakdownElementNode workBreakdownElementNode = (WorkBreakdownElementNode)object;
                    Object object2 = workBreakdownElementNode.getObject();
                    if (object2 instanceof Activity) {
                        return TngUtil.checkWBSActivityPresentationName((Object)object2, (String)string, (Suppression)workBreakdownElementNode.getDiagram().getSuppression());
                    }
                    return TngUtil.checkWorkBreakdownElementPresentationName((Object)object2, (String)string, (Suppression)workBreakdownElementNode.getDiagram().getSuppression());
                }
                return super.validate(string);
            }
        };
    }
}

