/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.gef.viewer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epf.authoring.gef.viewer.AbstractDiagramGraphicalViewer;
import org.eclipse.epf.authoring.gef.viewer.ActivityDetailDiagramViewer;
import org.eclipse.epf.authoring.gef.viewer.ActivityDiagramViewer;
import org.eclipse.epf.authoring.gef.viewer.WPDependencyDiagramViewer;
import org.eclipse.epf.diagram.model.util.GraphicalDataManager;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.VariabilityInfo;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.layout.ProcessAdapterFactoryFilter;
import org.eclipse.epf.library.layout.diagram.DiagramInfo;
import org.eclipse.epf.library.layout.diagram.IActivityDiagramService;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.Diagram;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ActivityDiagramService
implements IActivityDiagramService {
    private Composite parent = null;
    private Composite holder = null;
    private File pubDir;
    private static Map typeMap = new HashMap();
    private DiagramInfo diagramInfo = null;
    private boolean publishUncreatedADD = true;
    private boolean publishADForActivityExtension = true;
    Shell shell = null;

    static {
        typeMap.put("Activity", new Integer(0));
        typeMap.put("ActivityDetail", new Integer(2));
        typeMap.put("WPDependency", new Integer(1));
    }

    public static int getIntType(String string) {
        Integer n = (Integer)typeMap.get(string);
        if (n != null) {
            return n;
        }
        return -1;
    }

    public ActivityDiagramService() {
        this(null, new File(LibraryService.getInstance().getCurrentMethodLibraryLocation()));
    }

    public ActivityDiagramService(File file) {
        this(null, file);
    }

    public ActivityDiagramService(Composite composite, File file) {
        this.parent = composite;
        this.pubDir = file;
    }

    private AbstractDiagramGraphicalViewer getDiagramViewer(int n) {
        if (this.shell != null && this.shell.isDisposed()) {
            this.parent = null;
            this.shell = null;
        }
        this.getViewerHolder(this.parent);
        switch (n) {
            case 0: {
                return new ActivityDiagramViewer(this.holder);
            }
            case 2: {
                return new ActivityDetailDiagramViewer(this.holder);
            }
            case 1: {
                return new WPDependencyDiagramViewer(this.holder);
            }
        }
        return null;
    }

    private void getViewerHolder(Composite composite) {
        if (composite == null) {
            if (this.shell == null || this.shell.isDisposed()) {
                this.shell = this.createShell();
            }
            this.shell.open();
            composite = this.shell;
        }
        if (this.holder != null) {
            this.holder.dispose();
        }
        this.holder = new Composite(composite, 0);
        this.holder.setLayoutData((Object)new GridData(1, 1));
        this.holder.setLayout((Layout)new GridLayout());
        this.holder.setVisible(false);
    }

    private Shell createShell() {
        Shell shell = null;
        Display display = Display.getDefault();
        shell = new Shell(display);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        shell.setLayout((Layout)gridLayout);
        shell.setBounds(0, 0, 0, 0);
        shell.setVisible(false);
        return shell;
    }

    public void dispose() {
        if (this.shell != null && !this.shell.isDisposed()) {
            this.shell.close();
            this.shell.dispose();
        }
    }

    public DiagramInfo saveDiagram(final Object object, final String string, final String string2, final IFilter iFilter, final Suppression suppression) {
        this.diagramInfo = null;
        SafeUpdateController.syncExec((Runnable)new Runnable(){

            public void run() {
                ActivityDiagramService.this.__internal_saveDiagram(object, string, string2, iFilter, suppression);
            }
        });
        return this.diagramInfo;
    }

    private boolean hasUserDefinedDiagram(Activity activity, String string, String string2) throws Exception {
        org.eclipse.epf.diagram.model.util.DiagramInfo diagramInfo = new org.eclipse.epf.diagram.model.util.DiagramInfo(activity);
        switch (ActivityDiagramService.getIntType(string2)) {
            case 0: {
                if (!diagramInfo.canPublishADImage()) break;
                return diagramInfo.getActivityDiagram() != null && diagramInfo.canPublishADImage();
            }
            case 2: {
                if (!diagramInfo.canPublishADDImage()) break;
                return diagramInfo.getActivityDetailDiagram() != null && diagramInfo.canPublishADDImage();
            }
            case 1: {
                if (!diagramInfo.canPublishWPDImage()) break;
                return diagramInfo.getWPDDiagram() != null && diagramInfo.canPublishWPDImage();
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void __internal_saveDiagram(Object object, String string, String string2, IFilter iFilter, Suppression suppression) {
        if (suppression.isSuppressed(object)) {
            return;
        }
        Object object2 = TngUtil.unwrap((Object)object);
        if (!(object2 instanceof Activity)) {
            return;
        }
        Activity activity = (Activity)object2;
        Image image = null;
        int n = ActivityDiagramService.getIntType(string2);
        if (n < 0) {
            return;
        }
        AbstractDiagramGraphicalViewer abstractDiagramGraphicalViewer = null;
        boolean bl = activity.eResource().isModified();
        try {
            boolean bl2;
            Diagram diagram;
            block41: {
                ImageLoader imageLoader;
                Object object3;
                Object object4;
                Object object5;
                if (this.hasUserDefinedDiagram(activity, string, string2)) {
                    return;
                }
                diagram = GraphicalDataManager.getInstance().getUMADiagram(activity, n, false);
                boolean bl3 = bl2 = diagram != null;
                if (bl2) {
                    if (diagram.getSuppressed().booleanValue()) {
                        return;
                    }
                    if (n == 0 && this.checkVariability((VariabilityElement)activity, iFilter, n) != null) {
                        return;
                    }
                } else {
                    if (n == 1) {
                        return;
                    }
                    if (n == 0) {
                        if (!this.publishADForActivityExtension) {
                            return;
                        }
                        if (!activity.getBreakdownElements().isEmpty()) {
                            return;
                        }
                        object5 = this.checkVariability((VariabilityElement)activity, iFilter, n);
                        if (object5 == null) {
                            return;
                        }
                        object = object5;
                        activity = (Activity)object5;
                        bl2 = true;
                    }
                    if (!this.publishUncreatedADD && n == 2) {
                        boolean bl4 = false;
                        object4 = null;
                        if (iFilter instanceof ProcessAdapterFactoryFilter) {
                            object4 = ((ProcessAdapterFactoryFilter)iFilter).getMethodConfiguration();
                        }
                        if (object4 == null) {
                            return;
                        }
                        object3 = ConfigurationHelper.getContributors((VariabilityElement)activity, (MethodConfiguration)object4);
                        if (activity instanceof Activity && (imageLoader = object3.iterator()) != null) {
                            while (imageLoader.hasNext()) {
                                Diagram diagram2;
                                Object e = imageLoader.next();
                                if (e == null || (diagram2 = GraphicalDataManager.getInstance().getUMADiagram((Activity)e, n, false)) == null) continue;
                                bl4 = true;
                                break;
                            }
                        }
                        if (!bl4) {
                            return;
                        }
                    }
                }
                try {
                    abstractDiagramGraphicalViewer = this.getDiagramViewer(n);
                    abstractDiagramGraphicalViewer.loadDiagram(object, !bl2, iFilter, suppression);
                    this.diagramInfo = abstractDiagramGraphicalViewer.getDiagramInfo();
                    if (this.diagramInfo == null || this.diagramInfo.isEmpty()) break block41;
                    image = abstractDiagramGraphicalViewer.createDiagramImage();
                    if (image != null) {
                        object5 = new File(this.pubDir, string);
                        object4 = ((File)object5).getParentFile();
                        if (!((File)object4).exists()) {
                            ((File)object4).mkdirs();
                        }
                        if (!((File)object5).exists()) {
                            ((File)object5).createNewFile();
                        }
                        object3 = new FileOutputStream((File)object5);
                        imageLoader = new ImageLoader();
                        imageLoader.data = new ImageData[]{image.getImageData()};
                        imageLoader.save((OutputStream)object3, 4);
                        this.diagramInfo.setImageFilePath(string);
                    } else {
                        System.out.println("Unable to create diagram image");
                    }
                }
                catch (RuntimeException runtimeException) {
                    runtimeException.printStackTrace();
                }
            }
            if (bl2) return;
            diagram = GraphicalDataManager.getInstance().getUMADiagram(activity, n, false);
            if (diagram == null) return;
            EcoreUtil.remove((EObject)diagram);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        finally {
            try {
                activity.eResource().setModified(bl);
                if (abstractDiagramGraphicalViewer != null) {
                    abstractDiagramGraphicalViewer.dispose();
                }
                if (image != null) {
                    image.dispose();
                }
            }
            catch (RuntimeException runtimeException) {
                runtimeException.printStackTrace();
            }
        }
    }

    private VariabilityElement checkVariability(VariabilityElement variabilityElement, IFilter iFilter, int n) {
        Object object2;
        MethodConfiguration methodConfiguration = null;
        if (iFilter instanceof ProcessAdapterFactoryFilter) {
            methodConfiguration = ((ProcessAdapterFactoryFilter)iFilter).getMethodConfiguration();
        }
        if (methodConfiguration == null) {
            return null;
        }
        List list = ConfigurationHelper.getContributors((VariabilityElement)variabilityElement, (MethodConfiguration)methodConfiguration);
        for (Object object2 : list) {
            if (!(object2 instanceof Activity) || ((Activity)object2).getBreakdownElements().isEmpty()) continue;
            return null;
        }
        VariabilityInfo variabilityInfo = ((ProcessAdapterFactoryFilter)iFilter).getVariabilityInfo(variabilityElement);
        object2 = variabilityInfo.getContributors();
        VariabilityElement variabilityElement2 = variabilityElement.getVariabilityBasedOnElement();
        if (variabilityElement2 == null) {
            return null;
        }
        Activity activity = (Activity)ConfigurationHelper.getReplacer((VariabilityElement)variabilityElement2, (MethodConfiguration)methodConfiguration);
        if (activity != null) {
            variabilityElement2 = activity;
            Diagram diagram = GraphicalDataManager.getInstance().getUMADiagram(activity, n, false);
            if (diagram != null) {
                return activity;
            }
            return null;
        }
        Diagram diagram = GraphicalDataManager.getInstance().getUMADiagram((Activity)variabilityElement2, n, false);
        if (diagram != null) {
            if (diagram.getSuppressed().booleanValue()) {
                return null;
            }
            VariabilityInfo variabilityInfo2 = ((ProcessAdapterFactoryFilter)iFilter).getVariabilityInfo(variabilityElement2);
            List list2 = variabilityInfo2.getContributors();
            if (object2.size() != list2.size()) {
                for (Object e : object2) {
                    if (list2.contains(e) || ((Activity)e).getBreakdownElements().isEmpty()) continue;
                    return null;
                }
            }
            return variabilityElement2;
        }
        return this.checkVariability(variabilityElement2, iFilter, n);
    }

    public void setPublishedUnCreatedADD(boolean bl) {
        this.publishUncreatedADD = bl;
    }

    public void setPublishADForActivityExtension(boolean bl) {
        this.publishADForActivityExtension = bl;
    }

    public Activity getRealizedForUnmodified(Object object, IFilter iFilter, Suppression suppression) {
        return null;
    }
}

