/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.epf.authoring.ui.AuthoringPerspective;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.BrowsingPerspective;
import org.eclipse.epf.authoring.ui.dialogs.ContributionSelection;
import org.eclipse.epf.authoring.ui.editors.EditorChooser;
import org.eclipse.epf.authoring.ui.views.ConfigurationView;
import org.eclipse.epf.authoring.ui.views.LibraryView;
import org.eclipse.epf.common.utils.PerspectiveUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class UIActionDispatcher
implements ISelectionProvider {
    private static UIActionDispatcher instance = null;
    protected List<ISelectionChangedListener> selectionChangedListeners = new ArrayList<ISelectionChangedListener>();
    protected List<IDoubleClickListener> doubleClickListeners = new ArrayList<IDoubleClickListener>();
    private CurrentSelection currentSelection = new CurrentSelection();
    private IDoubleClickListener doubleClickListener = new IDoubleClickListener(){

        public void doubleClick(DoubleClickEvent doubleClickEvent) {
            ISelection iSelection = doubleClickEvent.getSelection();
            if (iSelection != null) {
                IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IWorkbenchPartSite iWorkbenchPartSite = iWorkbenchWindow.getActivePage().getActivePart().getSite();
                IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
                Object[] objectArray = iStructuredSelection.toArray();
                Object object = null;
                if (objectArray != null && objectArray.length > 0) {
                    UIActionDispatcher.openAuthoringPerspective();
                    Object object2 = TngUtil.unwrap((Object)objectArray[0]);
                    ConfigurationView configurationView = ConfigurationView.getView();
                    if (configurationView != null && iWorkbenchPartSite.equals(configurationView.getSite())) {
                        if (object2 instanceof VariabilityElement) {
                            VariabilityElement variabilityElement = (VariabilityElement)object2;
                            ContributionSelection contributionSelection = new ContributionSelection();
                            object = contributionSelection.getSelectedContributor(variabilityElement);
                        }
                    } else {
                        object = object2;
                    }
                    if (object != null) {
                        EditorChooser.getInstance().openEditor(object);
                    }
                }
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UIActionDispatcher getInstance() {
        if (instance != null) return instance;
        Class<UIActionDispatcher> clazz = UIActionDispatcher.class;
        synchronized (UIActionDispatcher.class) {
            if (instance != null) return instance;
            instance = new UIActionDispatcher();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private UIActionDispatcher() {
        this(null);
    }

    public UIActionDispatcher(Object object) {
        IWorkbenchWindow iWorkbenchWindow = AuthoringUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (iWorkbenchWindow != null) {
            iWorkbenchWindow.addPerspectiveListener(new IPerspectiveListener(){

                public void perspectiveActivated(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor) {
                    if (iPerspectiveDescriptor.getId().equals(AuthoringPerspective.PERSPECTIVE_ID)) {
                        UIActionDispatcher.this.addDoubleClickListener(UIActionDispatcher.this.doubleClickListener);
                    } else {
                        UIActionDispatcher.this.removeDoubleClickListener(UIActionDispatcher.this.doubleClickListener);
                    }
                }

                public void perspectiveChanged(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor, String string) {
                }
            });
        }
        if (PerspectiveUtil.isActivePerspective((String)AuthoringPerspective.PERSPECTIVE_ID)) {
            this.addDoubleClickListener(this.doubleClickListener);
        }
    }

    public static void editConfiguration(String string) {
    }

    public static void openLibraryPerspective() {
        PerspectiveUtil.openPerspective((String)BrowsingPerspective.PERSPECTIVE_ID);
        IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewPart iViewPart = iWorkbenchPage.findView(LibraryView.VIEW_ID);
        if (iViewPart != null) {
            iWorkbenchPage.hideView(iViewPart);
        }
        iViewPart = iWorkbenchPage.findView(ConfigurationView.VIEW_ID);
        iWorkbenchPage.activate((IWorkbenchPart)iViewPart);
    }

    public static void openAuthoringPerspective() {
        PerspectiveUtil.openPerspective((String)AuthoringPerspective.PERSPECTIVE_ID);
        IWorkbenchPage iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewPart iViewPart = iWorkbenchPage.findView(LibraryView.VIEW_ID);
        iWorkbenchPage.activate((IWorkbenchPart)iViewPart);
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        if (!this.selectionChangedListeners.contains(iSelectionChangedListener)) {
            this.selectionChangedListeners.add(iSelectionChangedListener);
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.selectionChangedListeners.remove(iSelectionChangedListener);
    }

    public ISelection getSelection() {
        return this.currentSelection.selection;
    }

    public ISelectionProvider getSelectionSource() {
        return this.currentSelection.source;
    }

    public void setSelection(ISelection iSelection) {
        this.setSelection(this, iSelection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelection(ISelectionProvider iSelectionProvider, ISelection iSelection) {
        UIActionDispatcher uIActionDispatcher = this;
        synchronized (uIActionDispatcher) {
            this.currentSelection.selection = iSelection;
            this.currentSelection.source = iSelectionProvider;
            SelectionChangedEvent selectionChangedEvent = new SelectionChangedEvent(iSelectionProvider, iSelection);
            ArrayList<ISelectionChangedListener> arrayList = new ArrayList<ISelectionChangedListener>();
            while (this.selectionChangedListeners.size() > 0) {
                ISelectionChangedListener iSelectionChangedListener = this.selectionChangedListeners.remove(0);
                if (iSelectionChangedListener == null) continue;
                try {
                    iSelectionChangedListener.selectionChanged(selectionChangedEvent);
                }
                catch (Exception exception) {
                    AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)exception);
                }
                arrayList.add(iSelectionChangedListener);
            }
            this.selectionChangedListeners.addAll(arrayList);
        }
    }

    public void addDoubleClickListener(IDoubleClickListener iDoubleClickListener) {
        if (!this.doubleClickListeners.contains(iDoubleClickListener)) {
            this.doubleClickListeners.add(iDoubleClickListener);
        }
    }

    public void removeDoubleClickListener(IDoubleClickListener iDoubleClickListener) {
        this.doubleClickListeners.remove(iDoubleClickListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleDoubleClickEvent(DoubleClickEvent doubleClickEvent) {
        UIActionDispatcher uIActionDispatcher = this;
        synchronized (uIActionDispatcher) {
            ArrayList<IDoubleClickListener> arrayList = new ArrayList<IDoubleClickListener>();
            while (this.doubleClickListeners.size() > 0) {
                IDoubleClickListener iDoubleClickListener = this.doubleClickListeners.remove(0);
                try {
                    iDoubleClickListener.doubleClick(doubleClickEvent);
                }
                catch (Exception exception) {
                    AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)exception);
                }
                arrayList.add(iDoubleClickListener);
            }
            this.doubleClickListeners.addAll(arrayList);
        }
    }

    public class CurrentSelection {
        public ISelectionProvider source = null;
        public ISelection selection = StructuredSelection.EMPTY;
    }
}

