/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.actions;

import org.eclipse.epf.authoring.ui.AuthoringUIImages;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.actions.LayoutAction;
import org.eclipse.epf.authoring.ui.actions.MultiActionGroup;
import org.eclipse.epf.authoring.ui.views.LibraryView;
import org.eclipse.epf.library.edit.PluginUIPackageContext;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IActionBars;

public class LayoutActionGroup
extends MultiActionGroup {
    public LayoutActionGroup(LibraryView libraryView) {
        super(LayoutActionGroup.createActions(libraryView), LayoutActionGroup.getSelectedState(libraryView));
    }

    public void fillActionBars(IActionBars iActionBars) {
        super.fillActionBars(iActionBars);
        this.contributeToViewMenu(iActionBars.getMenuManager());
    }

    private void contributeToViewMenu(IMenuManager iMenuManager) {
        iMenuManager.add((IContributionItem)new Separator());
        MenuManager menuManager = new MenuManager(AuthoringUIResources.LayoutActionGroup_label);
        Separator separator = new Separator("layout");
        iMenuManager.add((IContributionItem)new Separator("additions"));
        iMenuManager.add((IContributionItem)separator);
        iMenuManager.appendToGroup("layout", (IContributionItem)menuManager);
        iMenuManager.add((IContributionItem)new Separator("additions-end"));
        this.addActions((IMenuManager)menuManager);
    }

    static int getSelectedState(LibraryView libraryView) {
        if (PluginUIPackageContext.INSTANCE.isFlatLayout()) {
            return 0;
        }
        return 1;
    }

    static IAction[] createActions(LibraryView libraryView) {
        LayoutAction layoutAction = new LayoutAction(libraryView, true);
        layoutAction.setText(AuthoringUIResources.LayoutActionGroup_flatLayoutAction_label);
        layoutAction.setImageDescriptor(AuthoringUIImages.IMG_DESC_LAYOUT_FLAT);
        LayoutAction layoutAction2 = new LayoutAction(libraryView, false);
        layoutAction2.setText(AuthoringUIResources.LayoutActionGroup_hierarchicalLayoutAction_label);
        layoutAction2.setImageDescriptor(AuthoringUIImages.IMG_DESC_LAYOUT_HIERARCHICAL);
        return new IAction[]{layoutAction, layoutAction2};
    }
}

