/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.action.CopyAction;
import org.eclipse.emf.edit.ui.action.CreateChildAction;
import org.eclipse.emf.edit.ui.action.CreateSiblingAction;
import org.eclipse.emf.edit.ui.action.CutAction;
import org.eclipse.emf.edit.ui.action.DeleteAction;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.action.LoadResourceAction;
import org.eclipse.emf.edit.ui.action.PasteAction;
import org.eclipse.emf.edit.ui.action.RedoAction;
import org.eclipse.emf.edit.ui.action.UndoAction;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.actions.LibraryValidateAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class MethodLibraryActionBarContributor
extends EditingDomainActionBarContributor
implements ISelectionChangedListener {
    protected IEditorPart activeEditorPart;
    protected ISelectionProvider selectionProvider;
    protected IAction showPropertiesViewAction = new Action(this.getString("_UI_ShowPropertiesView_menu_item")){

        public void run() {
            try {
                MethodLibraryActionBarContributor.this.getPage().showView("org.eclipse.ui.views.PropertySheet");
            }
            catch (PartInitException partInitException) {
                AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)partInitException);
            }
        }
    };
    protected IAction refreshViewerAction = new Action(this.getString("_UI_RefreshViewer_menu_item")){

        public boolean isEnabled() {
            return MethodLibraryActionBarContributor.this.activeEditorPart instanceof IViewerProvider;
        }

        public void run() {
            MethodLibraryActionBarContributor.this.doRefresh();
        }
    };
    protected Collection createChildActions;
    protected IMenuManager createChildMenuManager;
    protected Collection createSiblingActions;
    protected IMenuManager createSiblingMenuManager;
    protected String name;
    protected boolean enabled;

    public MethodLibraryActionBarContributor(String string) {
        this.loadResourceAction = new LoadResourceAction();
        this.validateAction = new LibraryValidateAction();
        this.name = string;
    }

    protected DeleteAction createDeleteAction() {
        return new DeleteAction();
    }

    public void init(IActionBars iActionBars) {
        ISharedImages iSharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.deleteAction = this.createDeleteAction();
        this.deleteAction.setImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        iActionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteAction);
        this.cutAction = this.createCutAction();
        this.cutAction.setImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_CUT"));
        iActionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)this.cutAction);
        this.copyAction = this.createCopyAction();
        this.copyAction.setImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        iActionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
        this.pasteAction = this.createPasteAction();
        this.pasteAction.setImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
        iActionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.pasteAction);
        this.undoAction = new UndoAction();
        this.undoAction.setImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_UNDO"));
        iActionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undoAction);
        this.redoAction = new RedoAction();
        this.redoAction.setImageDescriptor(iSharedImages.getImageDescriptor("IMG_TOOL_REDO"));
        iActionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redoAction);
    }

    protected CopyAction createCopyAction() {
        return new CopyAction();
    }

    protected PasteAction createPasteAction() {
        return new PasteAction();
    }

    protected CutAction createCutAction() {
        return new CutAction();
    }

    public void contributeToToolBar(IToolBarManager iToolBarManager) {
        iToolBarManager.add((IContributionItem)new Separator(String.valueOf(this.name) + "-settings"));
        iToolBarManager.add((IContributionItem)new Separator(String.valueOf(this.name) + "-additions"));
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public void contributeToMenu(IMenuManager iMenuManager) {
        super.contributeToMenu(iMenuManager);
        MenuManager menuManager = new MenuManager(this.getString("_UI_" + this.name + "_menu"), "org.eclipse.epf.authoring." + this.name + "MenuID");
        iMenuManager.insertAfter("additions", (IContributionItem)menuManager);
        menuManager.add((IContributionItem)new Separator("settings"));
        menuManager.add((IContributionItem)new Separator("actions"));
        menuManager.add((IContributionItem)new Separator("additions"));
        menuManager.add((IContributionItem)new Separator("additions-end"));
        this.createChildMenuManager = new MenuManager(this.getString("_UI_CreateChild_menu_item"));
        menuManager.insertBefore("additions", (IContributionItem)this.createChildMenuManager);
        this.createSiblingMenuManager = new MenuManager(this.getString("_UI_CreateSibling_menu_item"));
        menuManager.insertBefore("additions", (IContributionItem)this.createSiblingMenuManager);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager iMenuManager) {
                iMenuManager.updateAll(true);
            }
        });
        this.addGlobalActions((IMenuManager)menuManager);
    }

    public void setActiveEditor(IEditorPart iEditorPart) {
        super.setActiveEditor(iEditorPart);
        this.activeEditorPart = iEditorPart;
        if (this.selectionProvider != null) {
            this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        if (iEditorPart == null) {
            this.selectionProvider = null;
        } else {
            this.selectionProvider = iEditorPart.getSite().getSelectionProvider();
            this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            if (this.selectionProvider.getSelection() != null) {
                this.selectionChanged(new SelectionChangedEvent(this.selectionProvider, this.selectionProvider.getSelection()));
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        if (this.createChildMenuManager != null) {
            this.depopulateManager((IContributionManager)this.createChildMenuManager, this.createChildActions);
        }
        if (this.createSiblingMenuManager != null) {
            this.depopulateManager((IContributionManager)this.createSiblingMenuManager, this.createSiblingActions);
        }
        Collection collection = null;
        Collection collection2 = null;
        ISelection iSelection = selectionChangedEvent.getSelection();
        if (iSelection instanceof IStructuredSelection && ((IStructuredSelection)iSelection).size() == 1) {
            Object object = ((IStructuredSelection)iSelection).getFirstElement();
            EditingDomain editingDomain = ((IEditingDomainProvider)this.activeEditorPart).getEditingDomain();
            collection = editingDomain.getNewChildDescriptors(object, null);
            collection2 = editingDomain.getNewChildDescriptors(null, object);
        }
        this.createChildActions = this.generateCreateChildActions(collection, iSelection);
        this.createSiblingActions = this.generateCreateSiblingActions(collection2, iSelection);
        if (this.createChildMenuManager != null) {
            this.populateManager((IContributionManager)this.createChildMenuManager, this.createChildActions, null);
            this.createChildMenuManager.update(true);
        }
        if (this.createSiblingMenuManager != null) {
            this.populateManager((IContributionManager)this.createSiblingMenuManager, this.createSiblingActions, null);
            this.createSiblingMenuManager.update(true);
        }
    }

    protected Collection generateCreateChildActions(Collection collection, ISelection iSelection) {
        ArrayList<CreateChildAction> arrayList = new ArrayList<CreateChildAction>();
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                arrayList.add(new CreateChildAction(this.activeEditorPart, iSelection, iterator.next()));
            }
        }
        return arrayList;
    }

    protected Collection generateCreateSiblingActions(Collection collection, ISelection iSelection) {
        ArrayList<CreateSiblingAction> arrayList = new ArrayList<CreateSiblingAction>();
        if (collection != null) {
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                arrayList.add(new CreateSiblingAction(this.activeEditorPart, iSelection, iterator.next()));
            }
        }
        return arrayList;
    }

    protected void populateManager(IContributionManager iContributionManager, Collection collection, String string) {
        if (collection != null) {
            for (IAction iAction : collection) {
                if (string != null) {
                    iContributionManager.insertBefore(string, iAction);
                    continue;
                }
                iContributionManager.add(iAction);
            }
        }
    }

    protected void depopulateManager(IContributionManager iContributionManager, Collection collection) {
        if (collection != null) {
            IContributionItem[] iContributionItemArray = iContributionManager.getItems();
            int n = 0;
            while (n < iContributionItemArray.length) {
                IAction iAction;
                IContributionItem iContributionItem = iContributionItemArray[n];
                while (iContributionItem instanceof SubContributionItem) {
                    iContributionItem = ((SubContributionItem)iContributionItem).getInnerItem();
                }
                if (iContributionItem instanceof ActionContributionItem && collection.contains(iAction = ((ActionContributionItem)iContributionItem).getAction())) {
                    iContributionManager.remove(iContributionItem);
                }
                ++n;
            }
        }
    }

    public void menuAboutToShow(IMenuManager iMenuManager) {
        iMenuManager.add((IContributionItem)new Separator("additions"));
        iMenuManager.add((IContributionItem)new Separator("edit"));
        iMenuManager.add((IContributionItem)new ActionContributionItem((IAction)this.undoAction));
        iMenuManager.add((IContributionItem)new ActionContributionItem((IAction)this.redoAction));
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IContributionItem)new ActionContributionItem((IAction)this.copyAction));
        iMenuManager.add((IContributionItem)new ActionContributionItem((IAction)this.pasteAction));
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IContributionItem)new ActionContributionItem((IAction)this.deleteAction));
        iMenuManager.add((IContributionItem)new Separator());
        iMenuManager.add((IContributionItem)new Separator("additions-end"));
        this.addGlobalActions(iMenuManager);
        if (this.enabled) {
            MenuManager menuManager = null;
            menuManager = new MenuManager(this.getString("_UI_CreateChild_menu_item"));
            this.populateManager((IContributionManager)menuManager, this.createChildActions, null);
            iMenuManager.insertBefore("additions", (IContributionItem)menuManager);
            menuManager = new MenuManager(this.getString("_UI_CreateSibling_menu_item"));
            this.populateManager((IContributionManager)menuManager, this.createSiblingActions, null);
            iMenuManager.insertBefore("additions", (IContributionItem)menuManager);
        }
    }

    protected void addGlobalActions(IMenuManager iMenuManager) {
        String string;
        iMenuManager.insertAfter("additions-end", (IContributionItem)new Separator("ui-actions"));
        iMenuManager.insertAfter("ui-actions", this.showPropertiesViewAction);
        this.refreshViewerAction.setEnabled(this.refreshViewerAction.isEnabled());
        iMenuManager.insertAfter("ui-actions", this.refreshViewerAction);
        String string2 = string = (this.style & 1) == 0 ? "additions-end" : "additions";
        if (this.validateAction != null) {
            iMenuManager.insertBefore(string, (IContributionItem)new ActionContributionItem((IAction)this.validateAction));
        }
    }

    protected String getString(String string) {
        return AuthoringUIPlugin.getDefault().getString(string);
    }

    protected void doRefresh() {
        Viewer viewer;
        if (this.activeEditorPart instanceof IViewerProvider && (viewer = ((IViewerProvider)this.activeEditorPart).getViewer()) != null) {
            viewer.refresh();
        }
    }
}

