/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.dialogs.FilterSorter;
import org.eclipse.epf.authoring.ui.dialogs.FilterSorterForAll;
import org.eclipse.epf.authoring.ui.filters.DescriptorConfigurationFilter;
import org.eclipse.epf.authoring.ui.filters.ExProcessAuthoringConfigurator;
import org.eclipse.epf.authoring.ui.util.AuthoringAccessibleListener;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.edit.itemsfilter.FilterHelper;
import org.eclipse.epf.library.edit.itemsfilter.ICategoryFilter;
import org.eclipse.epf.library.edit.itemsfilter.IFilter;
import org.eclipse.epf.library.edit.itemsfilter.IProcessFilter;
import org.eclipse.epf.library.edit.process.BreakdownElementItemProvider;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.util.MethodElementUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;

public class ADDInfoDialog
extends Dialog
implements ISelectionChangedListener,
IDoubleClickListener {
    protected Button okButton;
    protected Button cancelButton;
    protected Text ctrl_brief_desc;
    private String dialogTitle;
    private String tabStr;
    private Object contentElement;
    private ArrayList selectedList = new ArrayList();
    private boolean viewerSelectionSingle = false;
    private String viewerLabel = null;
    private TreeViewer treeViewer;
    protected IStructuredContentProvider contentProvider;
    protected ILabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

        public String getText(Object object) {
            if (object instanceof VariabilityElement) {
                return TngUtil.getLabel((VariabilityElement)((VariabilityElement)object), (String)"", (boolean)true);
            }
            return super.getText(object);
        }
    };
    private AdapterFactory adapterFactory;
    private ComposedAdapterFactory composedAdapterFactory;
    private List alreadySelectedList = new ArrayList();
    private org.eclipse.epf.library.edit.IFilter filter;
    Pattern regexPattern;
    protected FilterHelper helper;
    private Button expandButton;
    private Button collapseButton;
    private Object input;

    public ADDInfoDialog(Shell shell, Object object, String string, List list) {
        super(shell);
        this.contentElement = object;
        this.tabStr = string;
        this.filter = null;
        this.alreadySelectedList = list;
        this.helper = new FilterHelper(object, string, null, null, this.alreadySelectedList);
        this.initProviderForTabs();
    }

    public ADDInfoDialog(Shell shell, org.eclipse.epf.library.edit.IFilter iFilter, String string, List list, Object object) {
        this(shell, iFilter, null, string, list);
        this.input = object;
    }

    public ADDInfoDialog(Shell shell, org.eclipse.epf.library.edit.IFilter iFilter, Object object, String string) {
        super(shell);
        this.filter = iFilter;
        this.tabStr = string;
        this.helper = new FilterHelper(object, string, null, null, null);
        this.initProviderForTabs();
    }

    public ADDInfoDialog(Shell shell, org.eclipse.epf.library.edit.IFilter iFilter, Object object, String string, List list) {
        super(shell);
        this.filter = iFilter;
        this.tabStr = string;
        this.alreadySelectedList = list;
        this.helper = new FilterHelper(object, string, null, null, list);
        this.contentElement = object;
        this.initProviderForTabs();
    }

    public ADDInfoDialog(Shell shell) {
        super(shell);
        this.helper = new FilterHelper(null, null, null, null, null);
    }

    protected void buttonPressed(int n) {
        if (n == 0) {
            this.saveValues();
        }
        super.buttonPressed(n);
        if (this.composedAdapterFactory != null) {
            this.composedAdapterFactory.dispose();
        }
        this.close();
    }

    public void saveValues() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.treeViewer.getSelection();
        if (iStructuredSelection.size() > 0) {
            Object[] objectArray = iStructuredSelection.toArray();
            int n = 0;
            while (n < objectArray.length) {
                Object object = LibraryUtil.unwrap((Object)objectArray[n]);
                if (object instanceof Activity) {
                    this.selectedList.add(object);
                }
                ++n;
            }
        }
    }

    protected void cancelPressed() {
        if (this.composedAdapterFactory != null) {
            this.composedAdapterFactory.dispose();
        }
        super.cancelPressed();
    }

    public void setTitle(String string) {
        this.dialogTitle = string;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.dialogTitle == null) {
            this.dialogTitle = this.tabStr;
        }
        shell.setText("Activity Detail Diagram Info: " + this.dialogTitle);
    }

    protected void createButtonsForButtonBar(Composite composite) {
        super.createButtonsForButtonBar(composite);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        composite2.setFont(composite.getFont());
        GridLayout gridLayout = (GridLayout)composite2.getLayout();
        gridLayout.marginWidth = 10;
        gridLayout.marginHeight = 10;
        gridLayout.numColumns = 3;
        Label label = new Label(composite2, 0);
        label.setText("Select the activity to modify ADD");
        GridData gridData = new GridData(1);
        label.setLayoutData((Object)gridData);
        gridData = new Composite(composite2, 0);
        GridData gridData2 = new GridData(896);
        gridData2.horizontalSpan = 2;
        gridData.setLayoutData((Object)gridData2);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 2;
        gridLayout2.marginRight = 0;
        gridData.setLayout((Layout)gridLayout2);
        this.expandButton = new Button((Composite)gridData, 524288);
        this.expandButton.setImage(AuthoringUIPlugin.getDefault().getSharedImage("expandall.gif"));
        this.expandButton.setToolTipText(AuthoringUIResources.FilterDialog_ExpandAll);
        this.expandButton.getAccessible().addAccessibleListener((AccessibleListener)new AuthoringAccessibleListener(AuthoringUIResources.FilterDialog_ExpandAll));
        gridData2 = new GridData(544);
        this.expandButton.setLayoutData((Object)gridData2);
        this.collapseButton = new Button((Composite)gridData, 8);
        this.collapseButton.setImage(AuthoringUIPlugin.getDefault().getSharedImage("collapseall.gif"));
        this.collapseButton.setToolTipText(AuthoringUIResources.FilterDialog_CollapseAll);
        this.collapseButton.getAccessible().addAccessibleListener((AccessibleListener)new AuthoringAccessibleListener(AuthoringUIResources.FilterDialog_CollapseAll));
        gridData2 = new GridData(128);
        this.collapseButton.setLayoutData((Object)gridData2);
        this.createLine(composite2, 3);
        this.createViewerLabel(composite2);
        this.createViewer(composite2);
        new Label(composite2, 0).setText(AuthoringUIResources.FilterDialog_BriefDescription);
        this.ctrl_brief_desc = new Text(composite2, 2634);
        GridData gridData3 = new GridData(768);
        gridData3.horizontalSpan = 3;
        gridData3.heightHint = 60;
        this.ctrl_brief_desc.setLayoutData((Object)gridData3);
        this.createLine(composite2, 3);
        this.addListener();
        return composite2;
    }

    private void createViewer(Composite composite) {
        this.treeViewer = this.viewerSelectionSingle ? new TreeViewer(composite, 2820) : new TreeViewer(composite, 2818);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.treeViewer.setUseHashlookup(true);
        if (this.input != null) {
            this.treeViewer.setInput(this.input);
        } else if (this.contentElement != null) {
            if (this.contentElement instanceof Activity) {
                if (this.contentElement instanceof Process) {
                    if (((Process)this.contentElement).eContainer() instanceof ProcessComponent) {
                        if (this.tabStr.equals(FilterConstants.GUIDANCE) || this.tabStr.equals(FilterConstants.ROADMAP) || this.tabStr.equals(FilterConstants.SUPPORTING_MATERIALS)) {
                            this.treeViewer.setInput((Object)UmaUtil.getMethodLibrary((EObject)((EObject)this.contentElement)));
                        } else {
                            this.treeViewer.setInput((Object)((Process)this.contentElement).eContainer());
                        }
                    } else {
                        this.treeViewer.setInput(this.contentElement);
                    }
                } else {
                    this.treeViewer.setInput((Object)UmaUtil.getMethodLibrary((EObject)((EObject)this.contentElement)));
                }
            } else {
                this.treeViewer.setInput((Object)UmaUtil.getMethodLibrary((EObject)((EObject)this.contentElement)));
            }
        } else {
            this.treeViewer.setInput((Object)LibraryService.getInstance().getCurrentMethodLibrary());
        }
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.treeViewer.addDoubleClickListener((IDoubleClickListener)this);
        this.treeViewer.getTree().setFont(composite.getFont());
        if (this.tabStr.equalsIgnoreCase(FilterConstants.ALL_ELEMENTS)) {
            this.treeViewer.setSorter((ViewerSorter)new FilterSorterForAll());
        } else {
            this.treeViewer.setSorter((ViewerSorter)new FilterSorter());
        }
        GridData gridData = new GridData(1808);
        gridData.widthHint = 300;
        gridData.heightHint = 300;
        gridData.horizontalSpan = 3;
        this.treeViewer.getControl().setLayoutData((Object)gridData);
    }

    private void createLine(Composite composite, int n) {
        Label label = new Label(composite, 259);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = n;
        label.setLayoutData((Object)gridData);
    }

    private void createViewerLabel(Composite composite) {
        if (this.viewerLabel != null) {
            Label label = new Label(composite, 0);
            label.setText(this.viewerLabel);
        }
    }

    public void setViewerSelectionSingle(boolean bl) {
        this.viewerSelectionSingle = bl;
    }

    public void doubleClick(DoubleClickEvent doubleClickEvent) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)doubleClickEvent.getSelection();
        Object object = iStructuredSelection.getFirstElement();
        if ((object = LibraryUtil.unwrap((Object)object)) instanceof ContentElement || object instanceof Process) {
            this.selectedList.add(object);
        } else if (object instanceof ProcessComponent) {
            this.selectedList.add(object);
        } else if (object instanceof BreakdownElement) {
            this.selectedList.add(object);
        } else if (object instanceof ProcessPackage) {
            this.selectedList.add(object);
        }
        this.close();
        if (this.composedAdapterFactory != null) {
            this.composedAdapterFactory.dispose();
        }
    }

    public void traverseTree(TreeItem[] treeItemArray, List list) {
        int n = 0;
        while (n < treeItemArray.length) {
            TreeItem[] treeItemArray2 = treeItemArray[n].getItems();
            if (treeItemArray2.length > 1) {
                list.add(treeItemArray[n].getData());
                this.traverseTree(treeItemArray2, list);
            } else {
                list.add(treeItemArray[n].getData());
            }
            ++n;
        }
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        this.updateSelection(selectionChangedEvent);
        this.updateButtons();
    }

    protected void updateButtons() {
    }

    public Object getParentObject(Object object) {
        return MethodElementUtil.getMethodModel((Object)object);
    }

    protected void updateSelection(SelectionChangedEvent selectionChangedEvent) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
        Object object = iStructuredSelection.getFirstElement();
        if (object instanceof BreakdownElementWrapperItemProvider || object instanceof BreakdownElementItemProvider) {
            Object object2 = TngUtil.unwrap((Object)object);
            this.setBriefDescription(object2);
        } else {
            this.setBriefDescription(object);
        }
    }

    private void setBriefDescription(Object object) {
        String string;
        if (object instanceof MethodElement && (string = ((MethodElement)object).getBriefDescription()) != null) {
            this.ctrl_brief_desc.setText(string);
        }
    }

    public void addListener() {
        this.expandButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ADDInfoDialog.this.treeViewer.expandAll();
            }
        });
        this.collapseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ADDInfoDialog.this.treeViewer.collapseAll();
            }
        });
    }

    public ArrayList getSelectedItems() {
        return this.selectedList;
    }

    private void initProviderForTabs() {
        if (this.filter != null) {
            if (this.filter instanceof IFilter) {
                if (this.filter instanceof ICategoryFilter) {
                    this.helper.setContentCategoryTabStr(this.tabStr);
                }
                ((IFilter)this.filter).setHelper(this.helper);
            } else if (this.filter instanceof DescriptorConfigurationFilter) {
                ((DescriptorConfigurationFilter)this.filter).setHelper(this.helper);
            } else if (this.filter instanceof ExProcessAuthoringConfigurator) {
                ((ExProcessAuthoringConfigurator)this.filter).setHelper(this.helper);
            }
        }
        if (this.filter instanceof IProcessFilter) {
            if (this.tabStr.equalsIgnoreCase(FilterConstants.WORK_PRODUCT_DESCRIPTORS)) {
                this.adapterFactory = TngAdapterFactory.INSTANCE.getPBSFilter_AdapterFactory(this.filter);
                this.contentProvider = new AdapterFactoryContentProvider(this.adapterFactory);
                this.composedAdapterFactory = TngAdapterFactory.INSTANCE.getPBSFilter_ComposedAdapterFactory();
                this.labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getPBS_ComposedAdapterFactory());
            } else if (this.tabStr.equalsIgnoreCase(FilterConstants.ROLE_DESCRIPTORS)) {
                this.adapterFactory = TngAdapterFactory.INSTANCE.getOBSFilter_AdapterFactory(this.filter);
                this.contentProvider = new AdapterFactoryContentProvider(this.adapterFactory);
                this.composedAdapterFactory = TngAdapterFactory.INSTANCE.getOBSFilter_ComposedAdapterFactory();
                this.labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory());
            }
        } else {
            this.adapterFactory = TngAdapterFactory.INSTANCE.getItemsFilter_AdapterFactory(this.filter);
            this.contentProvider = new AdapterFactoryContentProvider(this.adapterFactory);
            this.composedAdapterFactory = TngAdapterFactory.INSTANCE.getItemsFilter_ComposedAdapterFactory();
        }
    }

    public void setExistingElements(List list) {
        this.alreadySelectedList = list;
        if (this.helper != null) {
            this.helper.setAlreadySelectedList(list);
        }
    }

    public FilterHelper getHelper() {
        return this.helper;
    }

    public String[] getFilterTypeArray() {
        return null;
    }

    public void setContentProvider(IStructuredContentProvider iStructuredContentProvider, ComposedAdapterFactory composedAdapterFactory) {
        this.contentProvider = iStructuredContentProvider;
        this.composedAdapterFactory = composedAdapterFactory;
    }

    public void setFilter(org.eclipse.epf.library.edit.IFilter iFilter) {
        this.filter = iFilter;
        if (this.helper != null) {
            if (this.filter instanceof IFilter) {
                ((IFilter)this.filter).setHelper(this.helper);
            } else if (this.filter instanceof DescriptorConfigurationFilter) {
                ((DescriptorConfigurationFilter)this.filter).setHelper(this.helper);
            }
        }
    }

    public void setInput(Object object) {
        if (object != null) {
            this.input = object;
        }
    }

    public void setViewerLabel(String string) {
        this.viewerLabel = string;
    }
}

