/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.dialogs.FilterSorter;
import org.eclipse.epf.authoring.ui.dialogs.FilterSorterForAll;
import org.eclipse.epf.authoring.ui.filters.DescriptorConfigurationFilter;
import org.eclipse.epf.authoring.ui.filters.ExProcessAuthoringConfigurator;
import org.eclipse.epf.authoring.ui.util.AuthoringAccessibleListener;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.configuration.ConfigurationFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.edit.itemsfilter.FilterHelper;
import org.eclipse.epf.library.edit.itemsfilter.ICategoryFilter;
import org.eclipse.epf.library.edit.itemsfilter.IFilter;
import org.eclipse.epf.library.edit.itemsfilter.IProcessFilter;
import org.eclipse.epf.library.edit.navigator.MethodPluginItemProvider;
import org.eclipse.epf.library.edit.process.BreakdownElementItemProvider;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.util.MethodElementUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.NamedElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.search.internal.core.text.PatternConstructor;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;

public class ItemsFilterDialog
extends Dialog
implements ISelectionChangedListener,
IDoubleClickListener {
    protected Button okButton;
    protected Button cancelButton;
    protected Text ctrl_pattern;
    protected Text ctrl_brief_desc;
    private String pattern;
    private String filterTypeStr;
    protected Combo filterType;
    private String dialogTitle;
    private String tabStr;
    private Object contentElement;
    private ArrayList selectedList = new ArrayList();
    private boolean viewerSelectionSingle = false;
    private String viewerLabel = null;
    private TreeViewer treeViewer;
    protected IStructuredContentProvider contentProvider;
    protected ILabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

        public String getText(Object object) {
            MethodPluginItemProvider methodPluginItemProvider;
            if (object instanceof VariabilityElement) {
                return TngUtil.getLabel((VariabilityElement)((VariabilityElement)object), (String)"", (boolean)true);
            }
            if (object instanceof MethodPlugin && (methodPluginItemProvider = (MethodPluginItemProvider)TngUtil.getAdapter((EObject)((MethodPlugin)object), MethodPluginItemProvider.class)) != null) {
                return methodPluginItemProvider.getFullName(object);
            }
            return super.getText(object);
        }

        public String getColumnText(Object object, int n) {
            return this.getText(object);
        }

        public Image getColumnImage(Object object, int n) {
            return super.getImage(object);
        }
    };
    private AdapterFactory adapterFactory;
    private ComposedAdapterFactory composedAdapterFactory;
    private List alreadySelectedList = new ArrayList();
    private org.eclipse.epf.library.edit.IFilter filter;
    Pattern regexPattern;
    protected FilterHelper helper;
    private String STORE_EXPANDED_LEVEL_ID = ".LEVEL_ID";
    private String PATTERN_ID = ".Pattern";
    private String TYPE_ID = ".Type";
    private String DIALOG_NAME;
    private Button expandButton;
    private Button collapseButton;
    private Object input;
    private String[] types;
    public long delay = 800L;
    private UpdateTreeJob treeJob = new UpdateTreeJob(AuthoringUIResources.ItemsFilterDialog_UpdateTreeJob_name);

    public ItemsFilterDialog(Shell shell, Object object, String string, List list) {
        super(shell);
        this.contentElement = object;
        this.tabStr = string;
        this.filter = null;
        this.alreadySelectedList = list;
        this.helper = new FilterHelper(object, string, null, null, this.alreadySelectedList);
        this.initProviderForTabs();
    }

    public ItemsFilterDialog(Shell shell, org.eclipse.epf.library.edit.IFilter iFilter, String string, List list, Object object) {
        this(shell, iFilter, null, string, list);
        this.input = object;
    }

    public ItemsFilterDialog(Shell shell, org.eclipse.epf.library.edit.IFilter iFilter, Object object, String string) {
        super(shell);
        this.filter = iFilter;
        this.tabStr = string;
        this.helper = new FilterHelper(object, string, null, null, null);
        this.initProviderForTabs();
    }

    public ItemsFilterDialog(Shell shell, org.eclipse.epf.library.edit.IFilter iFilter, Object object, String string, List list) {
        super(shell);
        this.filter = iFilter;
        this.tabStr = string;
        this.alreadySelectedList = list;
        this.helper = new FilterHelper(object, string, null, null, list);
        this.contentElement = object;
        this.initProviderForTabs();
    }

    public ItemsFilterDialog(Shell shell) {
        super(shell);
        this.helper = new FilterHelper(null, null, null, null, null);
    }

    protected void buttonPressed(int n) {
        if (n == 0) {
            this.saveValues();
        }
        super.buttonPressed(n);
        if (this.composedAdapterFactory != null) {
            this.composedAdapterFactory.dispose();
        }
    }

    protected void cancelPressed() {
        if (this.treeJob != null) {
            this.treeJob.cancel();
        }
        super.cancelPressed();
        if (this.composedAdapterFactory != null) {
            this.composedAdapterFactory.dispose();
        }
    }

    protected void okPressed() {
        if (this.treeJob != null) {
            this.treeJob.cancel();
        }
        super.okPressed();
    }

    public void setTitle(String string) {
        this.dialogTitle = string;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.dialogTitle == null) {
            this.dialogTitle = this.tabStr;
        }
        shell.setText(String.valueOf(AuthoringUIResources.FilterDialog_title) + this.dialogTitle);
    }

    protected void createButtonsForButtonBar(Composite composite) {
        super.createButtonsForButtonBar(composite);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        composite2.setFont(composite.getFont());
        GridLayout gridLayout = (GridLayout)composite2.getLayout();
        gridLayout.marginWidth = 10;
        gridLayout.marginHeight = 10;
        gridLayout.numColumns = 3;
        Label label = new Label(composite2, 0);
        label.setText(AuthoringUIResources.FilterDialog_Type_text);
        GridData gridData = new GridData(1);
        label.setLayoutData((Object)gridData);
        this.filterType = new Combo(composite2, 12);
        gridData = new GridData(1);
        gridData.horizontalSpan = 2;
        gridData.widthHint = 390;
        this.filterType.setLayoutData((Object)gridData);
        if (this.types == null) {
            this.fillFilterTypeCombo();
        } else {
            this.filterType.setItems(this.types);
            if (this.helper != null) {
                this.filterTypeStr = this.filterType.getItem(0);
                this.helper.setFilterTypeStr(this.filterType.getItem(0));
                if (this.tabStr == null) {
                    this.tabStr = this.filterTypeStr;
                    this.helper.setTabStr(this.tabStr);
                }
            }
        }
        this.filterType.select(0);
        gridData = new Label(composite2, 0);
        gridData.setText(AuthoringUIResources.FilterDialog_Pattern_text);
        GridData gridData2 = new GridData();
        gridData2.horizontalSpan = 3;
        gridData.setLayoutData((Object)gridData2);
        this.ctrl_pattern = new Text(composite2, 2048);
        gridData2 = new GridData(256);
        gridData2.horizontalSpan = 3;
        this.ctrl_pattern.setLayoutData((Object)gridData2);
        this.ctrl_pattern.getAccessible().addAccessibleListener((AccessibleListener)new AuthoringAccessibleListener(String.valueOf(AuthoringUIResources.FilterDialog_Pattern_text) + AuthoringUIResources.FilterDialog_Pattern_description));
        gridData2 = new Label(composite2, 64);
        gridData2.setText(AuthoringUIResources.FilterDialog_Pattern_description);
        GridData gridData3 = new GridData(-1, -1, false, false, 3, 1);
        gridData3.widthHint = 550;
        gridData2.setLayoutData((Object)gridData3);
        gridData3 = new Composite(composite2, 0);
        GridData gridData4 = new GridData(896);
        gridData4.horizontalSpan = 2;
        gridData3.setLayoutData((Object)gridData4);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 2;
        gridLayout2.marginRight = 0;
        gridData3.setLayout((Layout)gridLayout2);
        this.expandButton = new Button((Composite)gridData3, 524288);
        this.expandButton.setImage(AuthoringUIPlugin.getDefault().getSharedImage("expandall.gif"));
        this.expandButton.setToolTipText(AuthoringUIResources.FilterDialog_ExpandAll);
        this.expandButton.getAccessible().addAccessibleListener((AccessibleListener)new AuthoringAccessibleListener(AuthoringUIResources.FilterDialog_ExpandAll));
        gridData4 = new GridData(544);
        this.expandButton.setLayoutData((Object)gridData4);
        this.collapseButton = new Button((Composite)gridData3, 8);
        this.collapseButton.setImage(AuthoringUIPlugin.getDefault().getSharedImage("collapseall.gif"));
        this.collapseButton.setToolTipText(AuthoringUIResources.FilterDialog_CollapseAll);
        this.collapseButton.getAccessible().addAccessibleListener((AccessibleListener)new AuthoringAccessibleListener(AuthoringUIResources.FilterDialog_CollapseAll));
        gridData4 = new GridData(128);
        this.collapseButton.setLayoutData((Object)gridData4);
        this.createLine(composite2, 3);
        this.createViewerLabel(composite2);
        this.createViewer(composite2);
        this.restoreLastSettings();
        new Label(composite2, 0).setText(AuthoringUIResources.FilterDialog_BriefDescription);
        this.ctrl_brief_desc = new Text(composite2, 2634);
        GridData gridData5 = new GridData(768);
        gridData5.horizontalSpan = 3;
        gridData5.heightHint = 60;
        this.ctrl_brief_desc.setLayoutData((Object)gridData5);
        this.createLine(composite2, 3);
        this.addListener();
        return composite2;
    }

    private void createViewer(Composite composite) {
        this.treeViewer = this.viewerSelectionSingle ? new TreeViewer(composite, 2820) : new TreeViewer(composite, 2818);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.setInput(this.getInput());
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.treeViewer.addDoubleClickListener((IDoubleClickListener)this);
        this.treeViewer.getTree().setFont(composite.getFont());
        if (this.tabStr.equalsIgnoreCase(FilterConstants.ALL_ELEMENTS)) {
            this.treeViewer.setSorter((ViewerSorter)new FilterSorterForAll());
        } else {
            this.treeViewer.setSorter((ViewerSorter)new FilterSorter());
        }
        GridData gridData = new GridData(1808);
        gridData.widthHint = 300;
        gridData.heightHint = 300;
        gridData.horizontalSpan = 3;
        this.treeViewer.getControl().setLayoutData((Object)gridData);
    }

    private Object getInput() {
        if (this.input != null) {
            return this.input;
        }
        if (this.contentElement != null) {
            Process process;
            if (this.contentElement instanceof Process && (process = (Process)this.contentElement).eContainer() instanceof ProcessComponent) {
                if (!(this.tabStr.equals(FilterConstants.GUIDANCE) || this.tabStr.equals(FilterConstants.ROADMAP) || this.tabStr.equals(FilterConstants.SUPPORTING_MATERIALS))) {
                    return process.eContainer();
                }
                return process;
            }
            return UmaUtil.getMethodLibrary((EObject)((EObject)this.contentElement));
        }
        return LibraryService.getInstance().getCurrentMethodLibrary();
    }

    private void createLine(Composite composite, int n) {
        Label label = new Label(composite, 259);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = n;
        label.setLayoutData((Object)gridData);
    }

    private void createViewerLabel(Composite composite) {
        if (this.viewerLabel != null) {
            Label label = new Label(composite, 0);
            label.setText(this.viewerLabel);
        }
    }

    public void setViewerSelectionSingle(boolean bl) {
        this.viewerSelectionSingle = bl;
    }

    public void doubleClick(DoubleClickEvent doubleClickEvent) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)doubleClickEvent.getSelection();
        Object object = iStructuredSelection.getFirstElement();
        if ((object = LibraryUtil.unwrap((Object)object)) instanceof ContentElement || object instanceof Process || object instanceof ProcessComponent || object instanceof BreakdownElement || object instanceof ProcessPackage) {
            this.selectedList.add(object);
        }
        this.saveLastSettings();
        this.close();
        if (this.composedAdapterFactory != null) {
            this.composedAdapterFactory.dispose();
        }
    }

    protected IDialogSettings getDialogSettings() {
        DialogSettings dialogSettings = (DialogSettings)AuthoringUIPlugin.getDefault().getDialogSettings();
        DialogSettings dialogSettings2 = (DialogSettings)dialogSettings.getSection(String.valueOf(this.DIALOG_NAME) + this.STORE_EXPANDED_LEVEL_ID);
        if (dialogSettings2 == null) {
            dialogSettings2 = (DialogSettings)dialogSettings.addNewSection(String.valueOf(this.DIALOG_NAME) + this.STORE_EXPANDED_LEVEL_ID);
        }
        return dialogSettings2;
    }

    protected void restoreLastSettings() {
        List list;
        this.DIALOG_NAME = this.tabStr;
        DialogSettings dialogSettings = (DialogSettings)this.getDialogSettings();
        String string = dialogSettings.get(String.valueOf(this.DIALOG_NAME) + this.PATTERN_ID);
        if (string != null && string.length() > 0) {
            this.pattern = dialogSettings.get(String.valueOf(this.DIALOG_NAME) + this.PATTERN_ID);
            this.filterTypeStr = dialogSettings.get(String.valueOf(this.DIALOG_NAME) + this.TYPE_ID);
            this.filterType.setText(this.filterTypeStr);
            this.regexPattern = this.getRegEx(this.pattern);
            this.ctrl_pattern.setText(this.pattern);
            if (this.helper != null) {
                this.helper.setPattern(this.pattern);
                this.helper.setRegexPattern(this.regexPattern);
                this.helper.setFilterTypeStr(this.filterTypeStr);
            }
            this.initProviderForTabs();
        }
        if ((list = (List)FilterConstants.hashMap.get(String.valueOf(this.DIALOG_NAME) + this.STORE_EXPANDED_LEVEL_ID)) == null || list.isEmpty()) {
            this.treeViewer.expandAll();
            return;
        }
        if (list != null && !list.isEmpty()) {
            try {
                this.treeViewer.setExpandedElements(list.toArray());
                this.treeViewer.refresh();
            }
            catch (Exception exception) {
                this.treeViewer.expandAll();
            }
        }
    }

    public void traverseTree(TreeItem[] treeItemArray, List list) {
        int n = 0;
        while (n < treeItemArray.length) {
            TreeItem[] treeItemArray2 = treeItemArray[n].getItems();
            if (treeItemArray2.length > 1) {
                list.add(treeItemArray[n].getData());
                this.traverseTree(treeItemArray2, list);
            } else {
                list.add(treeItemArray[n].getData());
            }
            ++n;
        }
    }

    protected void saveValues() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.treeViewer.getSelection();
        if (iStructuredSelection.size() > 0) {
            Object[] objectArray = iStructuredSelection.toArray();
            int n = 0;
            while (n < objectArray.length) {
                Object object = LibraryUtil.unwrap((Object)objectArray[n]);
                if (object instanceof ContentElement || object instanceof Process || object instanceof ProcessComponent || object instanceof BreakdownElement || object instanceof ProcessPackage) {
                    this.selectedList.add(object);
                }
                ++n;
            }
        }
        this.saveLastSettings();
    }

    public void saveLastSettings() {
        IDialogSettings iDialogSettings = this.getDialogSettings();
        this.DIALOG_NAME = this.tabStr;
        Object[] objectArray = this.treeViewer.getExpandedElements();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            if (object instanceof NamedElement) {
                arrayList.add(objectArray[n]);
            }
            ++n;
        }
        iDialogSettings.put(String.valueOf(this.DIALOG_NAME) + this.PATTERN_ID, this.pattern);
        iDialogSettings.put(String.valueOf(this.DIALOG_NAME) + this.TYPE_ID, this.filterTypeStr);
        FilterConstants.hashMap.put(String.valueOf(this.DIALOG_NAME) + this.STORE_EXPANDED_LEVEL_ID, arrayList);
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        this.updateSelection(selectionChangedEvent);
        this.updateButtons();
    }

    protected void updateButtons() {
    }

    public Object getParentObject(Object object) {
        return MethodElementUtil.getMethodModel((Object)object);
    }

    protected void updateSelection(SelectionChangedEvent selectionChangedEvent) {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)selectionChangedEvent.getSelection();
        Object object = iStructuredSelection.getFirstElement();
        if (object instanceof BreakdownElementWrapperItemProvider || object instanceof BreakdownElementItemProvider) {
            Object object2 = TngUtil.unwrap((Object)object);
            this.setBriefDescription(object2);
        } else {
            this.setBriefDescription(object);
        }
    }

    private void setBriefDescription(Object object) {
        String string;
        if (object instanceof MethodElement && (string = ((MethodElement)object).getBriefDescription()) != null) {
            this.ctrl_brief_desc.setText(string);
        }
    }

    public void fillFilterTypeCombo() {
        if (this.filter instanceof ConfigurationFilter) {
            String[] stringArray = new String[]{this.tabStr};
            this.filterType.setItems(stringArray);
            this.filterTypeStr = stringArray[0];
        } else if (FilterConstants.categoryStrs.contains(this.tabStr)) {
            String[] stringArray = new String[]{this.tabStr, FilterConstants.METHO_PLUGINS};
            this.filterType.setItems(stringArray);
            this.filterTypeStr = stringArray[0];
        } else if (FilterConstants.CUSTOM_CATEGORIES.equalsIgnoreCase(this.tabStr)) {
            String[] stringArray = new String[]{this.tabStr, FilterConstants.METHO_PLUGINS};
            this.filterType.setItems(stringArray);
            this.filterTypeStr = stringArray[0];
        } else if (FilterConstants.breakdownElements.contains(this.tabStr)) {
            String[] stringArray = new String[]{this.tabStr};
            this.filterType.setItems(stringArray);
            this.filterTypeStr = stringArray[0];
        } else if (FilterConstants.contentElementStrs.contains(this.tabStr)) {
            String[] stringArray = new String[]{this.tabStr, FilterConstants.CONTENT_PACKAGES, FilterConstants.METHO_PLUGINS};
            this.filterType.setItems(stringArray);
            this.filterTypeStr = stringArray[0];
        } else if (FilterConstants.ALL_ELEMENTS.equals(this.tabStr)) {
            String string = "-";
            String[] stringArray = new String[26];
            int n = 0;
            stringArray[n++] = FilterConstants.ALL_ELEMENTS;
            stringArray[n++] = FilterConstants.CONTENT_PACKAGES;
            stringArray[n++] = String.valueOf(string) + FilterConstants.ROLES;
            stringArray[n++] = String.valueOf(string) + FilterConstants.TASKS;
            stringArray[n++] = String.valueOf(string) + FilterConstants.WORKPRODUCTS;
            stringArray[n++] = String.valueOf(string) + FilterConstants.GUIDANCE;
            stringArray[n++] = "--" + FilterConstants.CHECKLISTS;
            stringArray[n++] = "--" + FilterConstants.CONCEPTS;
            stringArray[n++] = "--" + FilterConstants.EXAMPLES;
            stringArray[n++] = "--" + FilterConstants.GUIDELINES;
            stringArray[n++] = "--" + FilterConstants.REUSABLE_ASSETS;
            stringArray[n++] = "--" + FilterConstants.SUPPORTING_MATERIALS;
            stringArray[n++] = "--" + FilterConstants.TOOL_MENTORS;
            stringArray[n++] = "--" + FilterConstants.ESTIMATE_CONSIDERATIONS;
            stringArray[n++] = "--" + FilterConstants.REPORTS;
            stringArray[n++] = "--" + FilterConstants.TEMPLATES;
            stringArray[n++] = "--" + FilterConstants.TOOL_MENTORS;
            stringArray[n++] = "--" + FilterConstants.ESTIMATE_CONSIDERATIONS;
            stringArray[n++] = FilterConstants.DISCIPLINES;
            stringArray[n++] = FilterConstants.ROLESETS;
            stringArray[n++] = FilterConstants.WORKPRODUCTTYPES;
            stringArray[n++] = FilterConstants.DOMAINS;
            stringArray[n++] = FilterConstants.TOOLS;
            stringArray[n++] = FilterConstants.CUSTOM_CATEGORIES;
            stringArray[n++] = FilterConstants.PROCESSES;
            stringArray[n++] = FilterConstants.METHO_PLUGINS;
            this.filterType.setItems(stringArray);
            this.filterTypeStr = stringArray[0];
        } else if (FilterConstants.CONFIG_CONTENT_ELEMENT.equals(this.tabStr)) {
            String[] stringArray = new String[]{this.tabStr};
            this.filterType.setItems(stringArray);
            this.filterTypeStr = stringArray[0];
        } else {
            String[] stringArray = new String[]{this.tabStr};
            this.filterType.setItems(stringArray);
            this.filterTypeStr = stringArray[0];
        }
    }

    public void addListener() {
        this.ctrl_pattern.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                if (ItemsFilterDialog.this.treeJob.getState() == 0) {
                    ItemsFilterDialog.this.treeJob.schedule(ItemsFilterDialog.this.delay);
                } else if (ItemsFilterDialog.this.treeJob.getState() == 2 || ItemsFilterDialog.this.treeJob.getState() == 1) {
                    ItemsFilterDialog.this.treeJob.cancel();
                    ItemsFilterDialog.this.treeJob.schedule(ItemsFilterDialog.this.delay);
                }
            }
        });
        this.filterType.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (ItemsFilterDialog.this.filterType.getSelectionIndex() > -1) {
                    ItemsFilterDialog.this.filterTypeStr = ItemsFilterDialog.this.filterType.getItem(ItemsFilterDialog.this.filterType.getSelectionIndex());
                }
                ItemsFilterDialog.this.filterTypeStr.trim();
                if (ItemsFilterDialog.this.helper != null) {
                    ItemsFilterDialog.this.helper.setPattern(ItemsFilterDialog.this.pattern);
                    ItemsFilterDialog.this.helper.setRegexPattern(ItemsFilterDialog.this.regexPattern);
                    ItemsFilterDialog.this.helper.setFilterTypeStr(ItemsFilterDialog.this.filterTypeStr);
                    ItemsFilterDialog.this.helper.setTabStr(ItemsFilterDialog.this.filterTypeStr);
                }
                ItemsFilterDialog.this.refreshTreeViewer();
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.expandButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ItemsFilterDialog.this.expandOrCollapse(true);
            }
        });
        this.collapseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ItemsFilterDialog.this.expandOrCollapse(false);
            }
        });
    }

    public ArrayList getSelectedItems() {
        return this.selectedList;
    }

    private void initProviderForTabs() {
        if (this.filter != null) {
            if (this.filter instanceof IFilter) {
                if (this.filter instanceof ICategoryFilter) {
                    this.helper.setContentCategoryTabStr(this.tabStr);
                }
                ((IFilter)this.filter).setHelper(this.helper);
            } else if (this.filter instanceof DescriptorConfigurationFilter) {
                ((DescriptorConfigurationFilter)this.filter).setHelper(this.helper);
            } else if (this.filter instanceof ExProcessAuthoringConfigurator) {
                ((ExProcessAuthoringConfigurator)this.filter).setHelper(this.helper);
            }
        }
        if (this.filter instanceof IProcessFilter) {
            if (this.tabStr.equalsIgnoreCase(FilterConstants.WORK_PRODUCT_DESCRIPTORS)) {
                this.adapterFactory = TngAdapterFactory.INSTANCE.getPBSFilter_AdapterFactory(this.filter);
                this.contentProvider = new AdapterFactoryContentProvider(this.adapterFactory);
                this.composedAdapterFactory = TngAdapterFactory.INSTANCE.getPBSFilter_ComposedAdapterFactory();
                this.labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getPBS_ComposedAdapterFactory()){

                    public String getColumnText(Object object, int n) {
                        return super.getText(object);
                    }

                    public Image getColumnImage(Object object, int n) {
                        return super.getImage(object);
                    }
                };
            } else if (this.tabStr.equalsIgnoreCase(FilterConstants.ROLE_DESCRIPTORS)) {
                this.adapterFactory = TngAdapterFactory.INSTANCE.getOBSFilter_AdapterFactory(this.filter);
                this.contentProvider = new AdapterFactoryContentProvider(this.adapterFactory);
                this.composedAdapterFactory = TngAdapterFactory.INSTANCE.getOBSFilter_ComposedAdapterFactory();
                this.labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory()){

                    public String getColumnText(Object object, int n) {
                        return super.getText(object);
                    }

                    public Image getColumnImage(Object object, int n) {
                        return super.getImage(object);
                    }
                };
            }
        } else {
            this.adapterFactory = TngAdapterFactory.INSTANCE.getItemsFilter_AdapterFactory(this.filter);
            this.contentProvider = new AdapterFactoryContentProvider(this.adapterFactory);
            this.composedAdapterFactory = TngAdapterFactory.INSTANCE.getItemsFilter_ComposedAdapterFactory();
        }
    }

    public void setExistingElements(List list) {
        this.alreadySelectedList = list;
        if (this.helper != null) {
            this.helper.setAlreadySelectedList(list);
        }
    }

    public FilterHelper getHelper() {
        return this.helper;
    }

    public String[] getFilterTypeArray() {
        return null;
    }

    public void setContentProvider(IStructuredContentProvider iStructuredContentProvider, ComposedAdapterFactory composedAdapterFactory) {
        this.contentProvider = iStructuredContentProvider;
        this.composedAdapterFactory = composedAdapterFactory;
    }

    public void setTypes(String[] stringArray) {
        this.types = stringArray;
    }

    public void setFilter(org.eclipse.epf.library.edit.IFilter iFilter) {
        this.filter = iFilter;
        if (this.helper != null) {
            if (this.filter instanceof IFilter) {
                ((IFilter)this.filter).setHelper(this.helper);
            } else if (this.filter instanceof DescriptorConfigurationFilter) {
                ((DescriptorConfigurationFilter)this.filter).setHelper(this.helper);
            }
        }
    }

    public void setInput(Object object) {
        if (object != null) {
            this.input = object;
        }
    }

    public void setViewerLabel(String string) {
        this.viewerLabel = string;
    }

    public void refreshTreeViewer() {
        try {
            this.treeViewer.getTree().clearAll(true);
            this.treeViewer.getTree().setVisible(false);
            this.treeViewer.refresh();
            this.treeViewer.expandAll();
            this.treeViewer.getTree().setVisible(true);
        }
        catch (Exception exception) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)exception);
        }
    }

    public void expandOrCollapse(boolean bl) {
        this.treeViewer.getTree().setVisible(false);
        if (bl) {
            this.treeViewer.expandAll();
        } else {
            this.treeViewer.collapseAll();
        }
        this.treeViewer.getTree().setVisible(true);
    }

    private Pattern getRegEx(String string) {
        try {
            return PatternConstructor.createPattern((String)string, (boolean)false, (boolean)false);
        }
        catch (Exception exception) {
            return PatternConstructor.createPattern((String)"*", (boolean)false, (boolean)false);
        }
    }

    private class UpdateTreeJob
    extends Job {
        public UpdateTreeJob(String string) {
            super(string);
        }

        protected IStatus run(IProgressMonitor iProgressMonitor) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (ItemsFilterDialog.this.treeViewer == null || ItemsFilterDialog.this.treeViewer.getControl() == null || ItemsFilterDialog.this.treeViewer.getControl().isDisposed()) {
                        return;
                    }
                    ItemsFilterDialog.this.treeViewer.getTree().clearAll(true);
                    if (((UpdateTreeJob)UpdateTreeJob.this).ItemsFilterDialog.this.ctrl_pattern.getText() != null && ((UpdateTreeJob)UpdateTreeJob.this).ItemsFilterDialog.this.ctrl_pattern.getText().trim().length() > 0) {
                        ItemsFilterDialog.this.pattern = ((UpdateTreeJob)UpdateTreeJob.this).ItemsFilterDialog.this.ctrl_pattern.getText().trim();
                    } else {
                        ItemsFilterDialog.this.pattern = "*";
                    }
                    ((UpdateTreeJob)UpdateTreeJob.this).ItemsFilterDialog.this.regexPattern = ItemsFilterDialog.this.getRegEx(ItemsFilterDialog.this.pattern);
                    if (((UpdateTreeJob)UpdateTreeJob.this).ItemsFilterDialog.this.helper != null) {
                        ((UpdateTreeJob)UpdateTreeJob.this).ItemsFilterDialog.this.helper.setPattern(ItemsFilterDialog.this.pattern);
                        ((UpdateTreeJob)UpdateTreeJob.this).ItemsFilterDialog.this.helper.setRegexPattern(((UpdateTreeJob)UpdateTreeJob.this).ItemsFilterDialog.this.regexPattern);
                        ((UpdateTreeJob)UpdateTreeJob.this).ItemsFilterDialog.this.helper.setFilterTypeStr(ItemsFilterDialog.this.filterTypeStr);
                        ((UpdateTreeJob)UpdateTreeJob.this).ItemsFilterDialog.this.helper.setTabStr(ItemsFilterDialog.this.filterTypeStr);
                    }
                    ItemsFilterDialog.this.refreshTreeViewer();
                }
            });
            return Status.OK_STATUS;
        }
    }
}

