/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.editors;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.authoring.ui.editors.EditorOpener;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodElementProperty;
import org.eclipse.epf.uma.MethodPlugin;
import org.osgi.framework.Bundle;

public class EditorOpenerFactory {
    public static final String EXTENSION_POINT_NAMESPACE = "org.eclipse.epf.authoring.ui";
    public static final String EXTENSION_POINT_NAME = "EditorOpener";
    public static final String CLASS_ATTRIB_NAME = "class";
    public static final String ID_ATTRIB_NAME = "id";
    private static EditorOpenerFactory instance = null;
    private Map<String, EditorOpenerElement> openerElements = new HashMap<String, EditorOpenerElement>();

    public static synchronized EditorOpenerFactory getInstance() {
        if (instance == null) {
            instance = new EditorOpenerFactory();
        }
        return instance;
    }

    private EditorOpenerFactory() {
        this.init();
    }

    protected void init() {
        IExtensionRegistry iExtensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint iExtensionPoint = iExtensionRegistry.getExtensionPoint(EXTENSION_POINT_NAMESPACE, EXTENSION_POINT_NAME);
        if (iExtensionPoint != null) {
            IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
            int n = 0;
            while (n < iExtensionArray.length) {
                IExtension iExtension = iExtensionArray[n];
                String string = iExtension.getNamespaceIdentifier();
                Bundle bundle = Platform.getBundle((String)string);
                IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
                int n2 = 0;
                while (n2 < iConfigurationElementArray.length) {
                    IConfigurationElement iConfigurationElement = iConfigurationElementArray[n2];
                    try {
                        EditorOpenerElement editorOpenerElement;
                        String string2 = iConfigurationElement.getAttribute(CLASS_ATTRIB_NAME);
                        String string3 = iConfigurationElement.getAttribute(ID_ATTRIB_NAME);
                        if (string2 != null && string2.trim().length() > 0 && string3 != null && string3.trim().length() > 0 && (editorOpenerElement = this.openerElements.get(string3)) == null) {
                            editorOpenerElement = new EditorOpenerElement(bundle, string2, string3);
                            this.openerElements.put(string3, editorOpenerElement);
                        }
                    }
                    catch (Exception exception) {
                        LibraryPlugin.getDefault().getLogger().logError((Throwable)exception);
                    }
                    ++n2;
                }
                ++n;
            }
        }
    }

    public EditorOpener getOpener(Object object) {
        if (object instanceof MethodElement) {
            MethodElement methodElement = (MethodElement)object;
            while (methodElement != null) {
                List list = methodElement.getMethodElementProperty();
                if (list != null && list.size() > 0) {
                    for (MethodElementProperty methodElementProperty : list) {
                        String string = methodElementProperty.getName();
                        EditorOpener editorOpener = this.createExtension(string);
                        if (editorOpener == null) continue;
                        return editorOpener;
                    }
                }
                if (methodElement instanceof MethodPlugin) break;
                methodElement = LibraryUtil.getMethodPlugin((EObject)methodElement);
            }
        }
        return null;
    }

    public boolean hasExtension(String string) {
        return this.openerElements.containsKey(string);
    }

    private EditorOpener createExtension(String string) {
        if (!this.hasExtension(string)) {
            return null;
        }
        EditorOpenerElement editorOpenerElement = this.openerElements.get(string);
        try {
            Class clazz = editorOpenerElement.bundle.loadClass(editorOpenerElement.className);
            return (EditorOpener)clazz.newInstance();
        }
        catch (Exception exception) {
            LibraryPlugin.getDefault().getLogger().logError((Throwable)exception);
            return null;
        }
    }

    private class EditorOpenerElement {
        Bundle bundle;
        String className;
        String id;

        private EditorOpenerElement(Bundle bundle, String string, String string2) {
            this.bundle = bundle;
            this.className = string;
            this.id = string2;
        }
    }
}

