/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.editors;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditor;
import org.eclipse.epf.authoring.ui.forms.MethodLibraryDescriptionFormPage;
import org.eclipse.epf.authoring.ui.views.LibraryView;
import org.eclipse.epf.common.serviceability.MsgDialog;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.persistence.MultiFileIOException;
import org.eclipse.epf.persistence.MultiFileSaveUtil;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.editor.IFormPage;

public class MethodLibraryEditor
extends MethodElementEditor {
    public void setPartName() {
        String string = AuthoringUIResources.MethodLibraryEditor_title;
        if (this.elementObj.getName() != null) {
            string = String.valueOf(string) + this.elementObj.getName();
        }
        this.setPartName(string);
    }

    protected void addPages() {
        try {
            this.addPage((IFormPage)new MethodLibraryDescriptionFormPage(this));
            this.createPreviewPage();
        }
        catch (PartInitException partInitException) {
            partInitException.printStackTrace();
        }
    }

    public void dispose() {
        this.getSite().getPage().closeAllEditors(false);
        LibraryView.getView().setInputForViewer(null);
        try {
            LibraryService.getInstance().closeCurrentMethodLibrary();
        }
        catch (Exception exception) {}
        super.dispose();
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        if (iProgressMonitor != null) {
            iProgressMonitor.beginTask(AuthoringUIResources.MethodLibraryEditor_savemodellibrary, -1);
            try {
                try {
                    LibraryService.getInstance().saveCurrentMethodLibrary();
                    this.firePropertyChange(257);
                }
                catch (Exception exception) {
                    Object object;
                    exception.printStackTrace();
                    String string = AuthoringUIResources.MethodLibraryEditor_err_save;
                    String string2 = "";
                    if (exception.getMessage() != null) {
                        string2 = exception.getMessage();
                    }
                    if (exception instanceof MultiFileIOException && (object = ((MultiFileIOException)exception).getTroubleObject()) instanceof MethodElement) {
                        string2 = String.valueOf(AuthoringUIResources.MethodLibraryEditor_troubleobject) + MultiFileSaveUtil.getPath((MethodElement)((MethodElement)object));
                    }
                    object = AuthoringUIResources.MethodLibraryEditor_error_dialog_title;
                    String string3 = AuthoringUIResources.MethodLibraryEditor_save_library_problem_msg;
                    MsgDialog msgDialog = AuthoringUIPlugin.getDefault().getMsgDialog();
                    msgDialog.displayError((String)object, string3, string, string2);
                    iProgressMonitor.done();
                }
            }
            finally {
                iProgressMonitor.done();
            }
        }
    }

    public boolean isDirty() {
        ILibraryManager iLibraryManager = LibraryService.getInstance().getCurrentLibraryManager();
        return iLibraryManager != null ? iLibraryManager.isMethodLibraryModified() : false;
    }
}

