/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.forms;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.authoring.ui.AuthoringUIHelpContexts;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditor;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditorInput;
import org.eclipse.epf.authoring.ui.forms.IRefreshable;
import org.eclipse.epf.authoring.ui.util.UIHelper;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.util.MethodElementUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.ui.LibraryUIText;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.NamedElement;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class ContentPackageDescriptionPage
extends FormPage
implements IRefreshable {
    private static final String FORM_PREFIX = String.valueOf(LibraryUIText.TEXT_CONTENT_PACKAGE) + ": ";
    private Text ctrl_name;
    private Text ctrl_brief_desc;
    private CheckboxTableViewer ctrl_dependency;
    private ScrolledForm form;
    private ContentPackage contentPackage;
    private Hashtable aPackageMap = new Hashtable();
    private MethodElementEditor.ModifyListener modelModifyListener;

    public ContentPackageDescriptionPage(FormEditor formEditor) {
        super(formEditor, AuthoringUIText.DESCRIPTION_PAGE_TITLE, AuthoringUIText.DESCRIPTION_PAGE_TITLE);
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) {
        super.init(iEditorSite, iEditorInput);
        MethodElementEditorInput methodElementEditorInput = (MethodElementEditorInput)iEditorInput;
        MethodElement methodElement = methodElementEditorInput.getMethodElement();
        this.contentPackage = (ContentPackage)methodElement;
    }

    protected void createFormContent(IManagedForm iManagedForm) {
        this.form = iManagedForm.getForm();
        FormToolkit formToolkit = iManagedForm.getToolkit();
        this.form.setText(String.valueOf(FORM_PREFIX) + this.contentPackage.getName());
        TableWrapLayout tableWrapLayout = new TableWrapLayout();
        this.form.getBody().setLayout((Layout)tableWrapLayout);
        Section section = formToolkit.createSection(this.form.getBody(), 450);
        TableWrapData tableWrapData = new TableWrapData(256);
        section.setLayoutData((Object)tableWrapData);
        section.setText(AuthoringUIText.GENERAL_INFO_SECTION_NAME);
        section.setDescription(MessageFormat.format(AuthoringUIText.GENERAL_INFO_SECTION_DESC, LibraryUIText.getUITextLower((MethodElement)this.contentPackage)));
        section.setLayout((Layout)new GridLayout());
        Composite composite = formToolkit.createComposite((Composite)section);
        composite.setLayoutData((Object)new GridData(768));
        composite.setLayout((Layout)new GridLayout(2, false));
        section.setClient((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite.getParent().getParent(), AuthoringUIHelpContexts.CONTENT_PACKAGE_EDITOR_ALL_CONTEXT);
        Label label = formToolkit.createLabel(composite, AuthoringUIText.NAME_TEXT);
        GridData gridData = new GridData(1);
        label.setLayoutData((Object)gridData);
        this.ctrl_name = formToolkit.createText(composite, "");
        gridData = new GridData(768);
        this.ctrl_name.setLayoutData((Object)gridData);
        gridData = formToolkit.createLabel(composite, AuthoringUIText.BRIEF_DESCRIPTION_TEXT);
        GridData gridData2 = new GridData(1);
        gridData.setLayoutData((Object)gridData2);
        this.ctrl_brief_desc = formToolkit.createText(composite, "", 578);
        gridData2 = new GridData(768);
        gridData2.heightHint = 40;
        gridData2.widthHint = 300;
        this.ctrl_brief_desc.setLayoutData((Object)gridData2);
        gridData2 = formToolkit.createSection(this.form.getBody(), 450);
        TableWrapData tableWrapData2 = new TableWrapData(256);
        gridData2.setLayoutData((Object)tableWrapData2);
        gridData2.setText(AuthoringUIText.DEPENDENCIES_SECTION_NAME);
        gridData2.setDescription(AuthoringUIText.DEPENDENCIES_SECTION_DESC);
        gridData2.setLayout((Layout)new GridLayout());
        Composite composite2 = formToolkit.createComposite((Composite)gridData2);
        composite2.setLayoutData((Object)new GridData(768));
        composite2.setLayout((Layout)new GridLayout(2, false));
        gridData2.setClient((Control)composite2);
        Table table = formToolkit.createTable(composite2, 553);
        Object object = new GridData(1809);
        object.heightHint = 100;
        table.setLayoutData(object);
        this.ctrl_dependency = new CheckboxTableViewer(table);
        object = new LabelProvider(){

            public String getText(Object object) {
                return object.toString();
            }
        };
        this.ctrl_dependency.setLabelProvider((IBaseLabelProvider)object);
        Hashtable hashtable = this.getDependenciesPackages(this.contentPackage);
        if (hashtable != null) {
            for (String string : hashtable.keySet()) {
                this.ctrl_dependency.add((Object)string);
            }
        }
        this.ctrl_dependency.setAllChecked(true);
        this.ctrl_dependency.setAllGrayed(true);
        formToolkit.paintBordersFor(composite);
        formToolkit.paintBordersFor(composite2);
        this.loadData();
        this.addListeners();
        Display display = this.form.getBody().getDisplay();
        if (display != null && !display.isDisposed()) {
            display.asyncExec(new Runnable(){

                public void run() {
                    ContentPackageDescriptionPage.this.ctrl_name.setFocus();
                    ContentPackageDescriptionPage.this.ctrl_name.setSelection(0, ContentPackageDescriptionPage.this.ctrl_name.getText().length());
                }
            });
        }
    }

    private void addListeners() {
        final MethodElementEditor methodElementEditor = (MethodElementEditor)this.getEditor();
        this.modelModifyListener = methodElementEditor.createModifyListener((EObject)this.contentPackage);
        this.form.addListener(26, new Listener(){

            public void handleEvent(Event event) {
                ContentPackageDescriptionPage.this.ctrl_dependency.refresh();
                Hashtable hashtable = ContentPackageDescriptionPage.this.getDependenciesPackages(ContentPackageDescriptionPage.this.contentPackage);
                if (hashtable != null) {
                    for (String string : hashtable.keySet()) {
                        ContentPackageDescriptionPage.this.ctrl_dependency.add((Object)string);
                    }
                }
                ContentPackageDescriptionPage.this.ctrl_dependency.setAllChecked(true);
                ContentPackageDescriptionPage.this.ctrl_dependency.setAllGrayed(true);
                if (TngUtil.isLocked((EObject)ContentPackageDescriptionPage.this.contentPackage)) {
                    ContentPackageDescriptionPage.this.enableControls(false);
                } else {
                    ContentPackageDescriptionPage.this.enableControls(true);
                }
            }
        });
        this.ctrl_name.addModifyListener((ModifyListener)this.modelModifyListener);
        this.ctrl_name.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                ((MethodElementEditor)ContentPackageDescriptionPage.this.getEditor()).setCurrentFeatureEditor(focusEvent.widget, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name());
            }

            public void focusLost(FocusEvent focusEvent) {
                Collection collection = Collections.singleton(UmaPackage.eINSTANCE.getMethodPackage());
                String string = ContentPackageDescriptionPage.this.contentPackage.getName();
                if (((MethodElementEditor)ContentPackageDescriptionPage.this.getEditor()).mustRestoreValue(focusEvent.widget, string)) {
                    return;
                }
                String string2 = null;
                String string3 = ContentPackageDescriptionPage.this.ctrl_name.getText();
                if (string3 != null) {
                    string3 = string3.trim();
                    string2 = string.indexOf("&") < 0 && string3.indexOf("&") > -1 ? NLS.bind((String)LibraryEditResources.invalidElementNameError4_msg, (Object)string3) : TngUtil.checkName((NamedElement)ContentPackageDescriptionPage.this.contentPackage, (String)string3, (Collection)collection);
                }
                if (string2 == null) {
                    if (!string3.equals(ContentPackageDescriptionPage.this.contentPackage.getName())) {
                        ContentPackageDescriptionPage.this.ctrl_name.setText(string3);
                        methodElementEditor.getActionManager().doAction(1, (EObject)ContentPackageDescriptionPage.this.contentPackage, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name(), (Object)string3, -1);
                    }
                } else {
                    AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.renameDialog_title, string2);
                    ContentPackageDescriptionPage.this.ctrl_name.setText(ContentPackageDescriptionPage.this.contentPackage.getName());
                    ContentPackageDescriptionPage.this.ctrl_name.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            ContentPackageDescriptionPage.this.ctrl_name.setFocus();
                            ContentPackageDescriptionPage.this.ctrl_name.selectAll();
                        }
                    });
                }
            }
        });
        this.ctrl_brief_desc.addModifyListener((ModifyListener)this.modelModifyListener);
        this.ctrl_brief_desc.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                ((MethodElementEditor)ContentPackageDescriptionPage.this.getEditor()).setCurrentFeatureEditor(focusEvent.widget, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodElement_BriefDescription());
            }

            public void focusLost(FocusEvent focusEvent) {
                boolean bl;
                String string = ContentPackageDescriptionPage.this.contentPackage.getBriefDescription();
                if (((MethodElementEditor)ContentPackageDescriptionPage.this.getEditor()).mustRestoreValue(focusEvent.widget, string)) {
                    return;
                }
                String string2 = ContentPackageDescriptionPage.this.ctrl_brief_desc.getText();
                if (!string2.equals(ContentPackageDescriptionPage.this.contentPackage.getBriefDescription()) && (bl = methodElementEditor.getActionManager().doAction(1, (EObject)ContentPackageDescriptionPage.this.contentPackage, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodElement_BriefDescription(), (Object)string2, -1))) {
                    ContentPackageDescriptionPage.this.ctrl_brief_desc.setText(string2);
                }
            }
        });
        this.ctrl_dependency.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                Object object = checkStateChangedEvent.getSource();
                ((CheckboxTableViewer)object).setAllChecked(true);
            }
        });
    }

    protected void enableControls(boolean bl) {
        this.ctrl_name.setEditable(bl);
        this.ctrl_brief_desc.setEditable(bl);
    }

    private void loadData() {
        String string = this.contentPackage.getName();
        String string2 = this.contentPackage.getBriefDescription();
        List list = this.contentPackage.getReusedPackages();
        this.ctrl_name.setText(string == null ? "" : string);
        this.ctrl_name.selectAll();
        this.ctrl_brief_desc.setText(string2 == null ? "" : string2);
        int n = 0;
        while (n < list.size()) {
            for (Map.Entry entry : this.aPackageMap.entrySet()) {
                if (list.get(n) != entry.getValue()) continue;
                this.ctrl_dependency.setChecked(entry.getKey(), true);
            }
            ++n;
        }
    }

    public Hashtable getDependenciesPackages(ContentPackage contentPackage) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (ContentElement contentElement : contentPackage.getContentElements()) {
            if (contentElement.getVariabilityBasedOnElement() != null) {
                arrayList.add((ContentElement)contentElement.getVariabilityBasedOnElement());
            }
            arrayList.addAll(MethodElementUtil.getSelectedGuidances((EObject)contentElement));
            boolean cfr_ignored_0 = contentElement instanceof Role;
            if (contentElement instanceof Task) {
                if (((Task)contentElement).getPerformedBy() != null) {
                    arrayList.add(((Task)contentElement).getPerformedBy());
                }
                if (((Task)contentElement).getAdditionallyPerformedBy() != null) {
                    arrayList.addAll(((Task)contentElement).getAdditionallyPerformedBy());
                }
                if (((Task)contentElement).getMandatoryInput() != null) {
                    arrayList.addAll(((Task)contentElement).getMandatoryInput());
                }
                if (((Task)contentElement).getOptionalInput() != null) {
                    arrayList.addAll(((Task)contentElement).getOptionalInput());
                }
                if (((Task)contentElement).getOutput() != null) {
                    arrayList.addAll(((Task)contentElement).getOutput());
                }
            }
            boolean cfr_ignored_1 = contentElement instanceof WorkProduct;
        }
        int n = 0;
        while (n < arrayList.size()) {
            ContentElement contentElement;
            contentElement = ((ContentElement)arrayList.get(n)).eContainer();
            if (contentElement instanceof ContentPackage && !contentPackage.equals(contentElement)) {
                this.aPackageMap.put(TngUtil.getLabelWithPath((Object)((ContentPackage)contentElement)), (ContentPackage)contentElement);
            }
            ++n;
        }
        return this.aPackageMap;
    }

    public void refreshName(String string) {
        if (string != null && this.ctrl_name != null && !this.ctrl_name.isDisposed()) {
            this.ctrl_name.removeModifyListener((ModifyListener)this.modelModifyListener);
            this.ctrl_name.setText(string);
            this.ctrl_name.addModifyListener((ModifyListener)this.modelModifyListener);
            UIHelper.setFormText(this.form, (MethodElement)this.contentPackage);
        }
    }
}

