/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.forms;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.filters.ContentFilter;
import org.eclipse.epf.authoring.ui.forms.AssociationFormPage;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.edit.util.CategorySortHelper;
import org.eclipse.epf.library.edit.util.ContentElementOrderList;
import org.eclipse.epf.library.edit.util.ModelStructure;
import org.eclipse.epf.library.util.LibraryManager;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.Discipline;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.editor.FormEditor;

public class DisciplineTasksPage
extends AssociationFormPage {
    private static final String FORM_PAGE_ID = "disciplineTasksPage";
    private Discipline discipline;
    private ContentElementOrderList allSteps;

    public DisciplineTasksPage(FormEditor formEditor) {
        super(formEditor, FORM_PAGE_ID, AuthoringUIText.TASKS_PAGE_TITLE);
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) {
        super.init(iEditorSite, iEditorInput);
        this.discipline = (Discipline)this.contentElement;
        this.setUseCategory2(false);
        this.setUseCategory3(false);
        this.setAllowChange1(true);
        this.setIsUpAndDownButtonsRequired1(true);
    }

    protected void initContentProviderSelected() {
        this.contentProviderSelected = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                if (DisciplineTasksPage.this.allSteps == null) {
                    DisciplineTasksPage.this.allSteps = new ContentElementOrderList(DisciplineTasksPage.this.contentElement, 1, DisciplineTasksPage.this.getContentCategoryOrderFeature());
                }
                List list = CategorySortHelper.sortCategoryElements((MethodElement)DisciplineTasksPage.this.contentElement, (Object[])DisciplineTasksPage.this.allSteps.toArray());
                return list.toArray();
            }
        };
        this.viewer_selected.setContentProvider((IContentProvider)this.contentProviderSelected);
    }

    protected void addItemsToModel1(ArrayList arrayList) {
        if (!arrayList.isEmpty()) {
            for (Task task : arrayList) {
                LibraryManager.getInstance().addToDiscipline(this.getActionManager(), this.discipline, task, (List)this.usedCategories);
            }
        }
    }

    protected void removeItemsFromModel1(ArrayList arrayList) {
        if (!arrayList.isEmpty()) {
            for (Task task : arrayList) {
                LibraryManager.getInstance().removeFromDiscipline(this.getActionManager(), this.discipline, task, (List)this.usedCategories);
            }
        }
    }

    protected Object getContentElement() {
        return this.discipline;
    }

    protected String getTabString() {
        return FilterConstants.TASKS;
    }

    protected IFilter getFilter() {
        this.filter = new ContentFilter(){

            protected boolean childAccept(Object object) {
                if (object instanceof ContentElement && this.getHelper().isContributor((ContentElement)object)) {
                    return false;
                }
                return object instanceof Task;
            }
        };
        return this.filter;
    }

    protected String getMultipleSelectDescription(int n) {
        return super.getMultipleSelectDescription(n, AuthoringUIResources.disciplineTasksPage_multipleSelectDescription);
    }

    protected String getSectionDescription() {
        return AuthoringUIResources.disciplineTasksPage_sectionDescription;
    }

    protected String getSectionName() {
        return AuthoringUIResources.disciplineTasksPage_sectionName;
    }

    protected String getSelectedLabel() {
        return AuthoringUIResources.disciplineTasksPage_selectedLabel;
    }

    protected String getSelectedLabel2() {
        return AuthoringUIResources.disciplineTasksPage_selectedLabel;
    }

    protected String getSelectedLabel3() {
        return AuthoringUIResources.disciplineTasksPage_selectedLabel;
    }

    protected EStructuralFeature getContentCategoryOrderFeature() {
        return UmaPackage.eINSTANCE.getDiscipline_Tasks();
    }

    protected String[] getModelStructurePath() {
        return ModelStructure.DEFAULT.disciplineDefinitionPath;
    }

    protected ContentElementOrderList getContentElementOrderList() {
        return this.allSteps;
    }
}

