/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.forms;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.authoring.gef.figures.Colors;
import org.eclipse.epf.authoring.ui.AuthoringUIHelpContexts;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.celleditors.AbstractCheckBoxCellEditor;
import org.eclipse.epf.authoring.ui.celleditors.ProcessCheckBoxCellEditor;
import org.eclipse.epf.authoring.ui.editors.ColumnDescriptor;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditor;
import org.eclipse.epf.authoring.ui.editors.ProcessEditor;
import org.eclipse.epf.authoring.ui.forms.ProcessFormPage;
import org.eclipse.epf.authoring.ui.providers.ExposedAdapterFactoryContentProvider;
import org.eclipse.epf.authoring.ui.providers.VariabilityElementLabelProvider;
import org.eclipse.epf.authoring.ui.views.ProcessViewer;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.process.IColumnAware;
import org.eclipse.epf.library.edit.util.PredecessorList;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.WorkBreakdownElement;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class ProcessBreakdownStructureFormPage
extends ProcessFormPage
implements IViewerProvider {
    protected static final String TXT_TRUE = "true";
    protected static final String TXT_FALSE = "false";
    protected static final Collection<EClass> ECLASSES = new ArrayList<EClass>();
    private int tabIndex = 0;
    protected ColumnDescriptor[] columnDescriptors;
    protected AdapterFactory adapterFactory;
    protected ProcessViewer viewer;
    protected TextCellEditor textCellEditor;
    protected ValidatingTextCellEditor nameCellEditor;
    protected ValidatingTextCellEditor predListCellEditor;
    protected ComboBoxCellEditor comboBoxCellEditor;
    protected CheckboxCellEditor checkBoxCellEditor;
    protected ValidatingTextCellEditor presentationNameCellEditor;
    protected boolean isReadOnly;

    static {
        ECLASSES.add(UmaPackage.eINSTANCE.getMethodPackage());
    }

    public ProcessBreakdownStructureFormPage(FormEditor formEditor, String string, String string2) {
        super(formEditor, string, string2);
    }

    public boolean isReadOnly() {
        if (this.isReadOnly) {
            return this.isReadOnly;
        }
        return TngUtil.isLocked((EObject)this.process);
    }

    public boolean basicIsReadOnly() {
        return this.isReadOnly;
    }

    public void setReadOnly(boolean bl) {
        this.isReadOnly = bl;
    }

    public void setAdapterFactory(AdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
    }

    public void setColumnDescriptors(ColumnDescriptor[] columnDescriptorArray) {
        this.columnDescriptors = columnDescriptorArray;
        if (this.adapterFactory instanceof IColumnAware) {
            HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
            int n = 0;
            while (n < columnDescriptorArray.length) {
                hashMap.put(new Integer(n), columnDescriptorArray[n].id);
                ++n;
            }
            ((IColumnAware)this.adapterFactory).setColumnIndexToNameMap(hashMap);
        }
    }

    protected void setText(BreakdownElement breakdownElement, String string, String string2) {
        IActionManager iActionManager = ((MethodElementEditor)this.getEditor()).getActionManager();
        if (string == "predecessors") {
            WorkBreakdownElement workBreakdownElement = (WorkBreakdownElement)breakdownElement;
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            if (PredecessorList.prepareUpdatePredecessors((AdapterFactory)this.adapterFactory, (WorkBreakdownElement)workBreakdownElement, (String)string2, arrayList, arrayList2)) {
                if (!arrayList2.isEmpty()) {
                    iActionManager.doAction(6, (EObject)workBreakdownElement, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkBreakdownElement_LinkToPredecessor(), arrayList2, -1);
                }
                if (!arrayList.isEmpty()) {
                    iActionManager.doAction(5, (EObject)workBreakdownElement, (EStructuralFeature)UmaPackage.eINSTANCE.getWorkBreakdownElement_LinkToPredecessor(), arrayList, -1);
                }
            }
            return;
        }
        ProcessUtil.setAttribute((IActionManager)iActionManager, (BreakdownElement)breakdownElement, (String)string, (String)string2);
    }

    protected String getText(BreakdownElement breakdownElement, String string) {
        if (string == "presentation_name" && ProcessUtil.isExtendingOrLocallyContributing((BreakdownElement)breakdownElement)) {
            return breakdownElement.getPresentationName();
        }
        IBSItemProvider iBSItemProvider = (IBSItemProvider)this.adapterFactory.adapt((Notifier)breakdownElement, ITreeItemContentProvider.class);
        return iBSItemProvider.getAttribute((Object)breakdownElement, string);
    }

    public void setTabIndex(int n) {
        this.tabIndex = n;
    }

    public int getTabIndex() {
        return this.tabIndex;
    }

    public void setTabFolder(CTabFolder cTabFolder) {
    }

    protected void createFormContent(IManagedForm iManagedForm) {
        ScrolledForm scrolledForm = iManagedForm.getForm();
        FormToolkit formToolkit = iManagedForm.getToolkit();
        scrolledForm.setText(this.getEditor().getPartName());
        TableWrapLayout tableWrapLayout = new TableWrapLayout();
        scrolledForm.getBody().setLayout((Layout)tableWrapLayout);
        Section section = formToolkit.createSection(scrolledForm.getBody(), 320);
        TableWrapData tableWrapData = new TableWrapData(256, 256);
        section.setLayoutData((Object)tableWrapData);
        section.setText(String.valueOf(this.getTitle()) + " " + AuthoringUIResources.processBreakdownStructureFormPage_BSEditor);
        section.setLayout((Layout)new GridLayout());
        Composite composite = formToolkit.createComposite((Composite)section);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout());
        section.setClient((Control)composite);
        Control control = this.createControl(composite);
        formToolkit.adapt(control, true, true);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.verticalIndent = 10;
        gridData.heightHint = 600;
        control.setLayoutData((Object)gridData);
        ProcessEditor processEditor = (ProcessEditor)this.getEditor();
        processEditor.createContextMenuFor((StructuredViewer)this.viewer);
        this.setInput(this.process);
    }

    public Control createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(1809);
        composite2.setLayoutData((Object)gridData);
        this.viewer = new ProcessViewer(composite2, 68354);
        this.viewer.getControl().setLayoutData((Object)gridData);
        this.viewer.setupColumns(this.columnDescriptors);
        this.viewer.setContentProvider((IContentProvider)new ExposedAdapterFactoryContentProvider(this.adapterFactory));
        this.viewer.setLabelProvider((IBaseLabelProvider)new ProcessAdapterFactoryLabelProvider(this.adapterFactory));
        this.viewer.setActionManager(((MethodElementEditor)this.getEditor()).getActionManager());
        this.textCellEditor = new TextCellEditor(this.viewer.getCellEditorParent());
        this.comboBoxCellEditor = new ComboBoxCellEditor(this.viewer.getCellEditorParent(), new String[]{TXT_TRUE, TXT_FALSE});
        this.checkBoxCellEditor = new CheckboxCellEditor(this.viewer.getCellEditorParent());
        this.setAllEditorsAndModifiers();
        this.viewer.setAutoExpandLevel(3);
        this.viewer.setInput(this.process);
        this.setContextHelp(this.viewer.getControl());
        return composite2;
    }

    private void setAllEditorsAndModifiers() {
        this.setCellEditors();
        this.setCheckBoxCellEditors();
        this.viewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object object, String string) {
                if (ProcessBreakdownStructureFormPage.this.isReadOnly() || object instanceof BreakdownElementWrapperItemProvider && ((BreakdownElementWrapperItemProvider)object).isReadOnly()) {
                    return false;
                }
                if (string == "id" || string == "type" || string == "model_info" || string == "deliverable") {
                    return false;
                }
                if (!((object = TngUtil.unwrap((Object)object)) instanceof WorkProductDescriptor || string != "entry_state" && string != "exit_state")) {
                    return false;
                }
                return object instanceof WorkBreakdownElement || string != "predecessors";
            }

            public Object getValue(Object object, String string) {
                BreakdownElement breakdownElement = (BreakdownElement)TngUtil.unwrap((Object)object);
                String string2 = ProcessBreakdownStructureFormPage.this.getText(breakdownElement, string);
                switch (ProcessBreakdownStructureFormPage.this.getCellEditorType(string)) {
                    case 2: {
                        if (ProcessBreakdownStructureFormPage.TXT_TRUE.equalsIgnoreCase(string2)) {
                            return new Integer(0);
                        }
                        return new Integer(1);
                    }
                    case 1: {
                        return string2;
                    }
                    case 3: {
                        return Boolean.valueOf(string2);
                    }
                }
                return string2;
            }

            public void modify(Object object, String string, Object object2) {
                String string2;
                Widget widget = (Widget)object;
                BreakdownElement breakdownElement = (BreakdownElement)TngUtil.unwrap((Object)widget.getData());
                int n = ProcessBreakdownStructureFormPage.this.getColumnIndex(string);
                CellEditor cellEditor = ProcessBreakdownStructureFormPage.this.viewer.getCellEditors()[n];
                String string3 = cellEditor.getErrorMessage();
                if (string3 != null) {
                    return;
                }
                switch (ProcessBreakdownStructureFormPage.this.getCellEditorType(string)) {
                    case 1: {
                        string2 = (String)object2;
                        break;
                    }
                    case 2: {
                        int n2 = ((Number)object2).intValue();
                        if (n2 == 0) {
                            string2 = ProcessBreakdownStructureFormPage.TXT_TRUE;
                            break;
                        }
                        string2 = ProcessBreakdownStructureFormPage.TXT_FALSE;
                        break;
                    }
                    case 3: {
                        string2 = object2.toString();
                        break;
                    }
                    default: {
                        string2 = TngUtil.checkNull((String)object2.toString());
                    }
                }
                ProcessBreakdownStructureFormPage.this.setText(breakdownElement, string, string2);
                if (string == "presentation_name" && StrUtil.isBlank((String)breakdownElement.getName())) {
                    breakdownElement.setName(string2);
                }
                ProcessBreakdownStructureFormPage.this.viewer.refresh();
            }
        });
    }

    public CellEditor getCellEditor(String string, int n) {
        if (string == "presentation_name") {
            if (this.presentationNameCellEditor == null) {
                this.presentationNameCellEditor = new ValidatingTextCellEditor(this.viewer.getCellEditorParent()){

                    protected String isValid(Object object, String string) {
                        object = TngUtil.unwrap((Object)object);
                        Suppression suppression = ((ProcessEditor)ProcessBreakdownStructureFormPage.this.getEditor()).getSuppression();
                        boolean bl = true;
                        return ProcessUtil.checkBreakdownElementPresentationName((AdapterFactory)ProcessBreakdownStructureFormPage.this.adapterFactory, (BreakdownElement)((BreakdownElement)object), (String)string, (Suppression)suppression, (boolean)bl);
                    }
                };
                this.presentationNameCellEditor.setValidator(new CellEditorValidator(this.presentationNameCellEditor));
                this.presentationNameCellEditor.getControl().addListener(27, (Listener)new ValidatingDeactivateListener(this.presentationNameCellEditor));
            }
            this.presentationNameCellEditor.setColumnIndex(n);
            return this.presentationNameCellEditor;
        }
        if (string == "name") {
            if (this.nameCellEditor == null) {
                this.nameCellEditor = new ValidatingTextCellEditor(this.viewer.getCellEditorParent()){

                    protected String isValid(Object object, String string) {
                        object = TngUtil.unwrap((Object)object);
                        Suppression suppression = ((ProcessEditor)ProcessBreakdownStructureFormPage.this.getEditor()).getSuppression();
                        return TngUtil.checkActivityName((AdapterFactory)ProcessBreakdownStructureFormPage.this.adapterFactory, (Object)object, (String)string, (Suppression)suppression);
                    }
                };
                this.nameCellEditor.setValidator(new CellEditorValidator(this.nameCellEditor));
                this.nameCellEditor.getControl().addListener(27, (Listener)new ValidatingDeactivateListener(this.nameCellEditor));
            }
            this.nameCellEditor.setColumnIndex(n);
            return this.nameCellEditor;
        }
        if (string == "predecessors") {
            if (this.predListCellEditor == null) {
                this.predListCellEditor = new ValidatingTextCellEditor(this.viewer.getCellEditorParent()){

                    protected String isValid(Object object, String string) {
                        object = TngUtil.unwrap((Object)object);
                        return ProcessUtil.checkPredecessorList((WorkBreakdownElement)((WorkBreakdownElement)object), (String)string, (AdapterFactory)ProcessBreakdownStructureFormPage.this.adapterFactory, (Object)ProcessBreakdownStructureFormPage.this.process, null);
                    }
                };
                this.predListCellEditor.setValidator(new CellEditorValidator(this.predListCellEditor));
                this.predListCellEditor.getControl().addListener(27, (Listener)new ValidatingDeactivateListener(this.predListCellEditor));
            }
            this.predListCellEditor.setColumnIndex(n);
            return this.predListCellEditor;
        }
        return null;
    }

    public void setCellEditors() {
        CellEditor[] cellEditorArray = new CellEditor[this.columnDescriptors.length];
        int n = 0;
        while (n < this.columnDescriptors.length) {
            CellEditor cellEditor = this.getCellEditor(this.columnDescriptors[n].id, n);
            if (cellEditor != null) {
                cellEditorArray[n] = cellEditor;
            } else {
                switch (this.columnDescriptors[n].cellEditorType) {
                    case 2: {
                        cellEditorArray[n] = this.comboBoxCellEditor;
                        break;
                    }
                    case 1: {
                        cellEditorArray[n] = this.textCellEditor;
                        break;
                    }
                    case 3: {
                        cellEditorArray[n] = this.checkBoxCellEditor;
                        break;
                    }
                    default: {
                        cellEditorArray[n] = null;
                    }
                }
            }
            ++n;
        }
        this.viewer.setCellEditors(cellEditorArray);
    }

    public void setInput(Object object) {
        if (object instanceof Process) {
            this.process = (Process)object;
            if (this.process.eContainer() instanceof ProcessComponent) {
                this.viewer.setInput(this.process.eContainer());
                return;
            }
        }
        this.viewer.setInput(null);
    }

    protected int getColumnIndex(String string) {
        Object[] objectArray = this.viewer.getColumnProperties();
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] == string) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    protected int getCellEditorType(String string) {
        int n = 0;
        while (n < this.columnDescriptors.length) {
            ColumnDescriptor columnDescriptor = this.columnDescriptors[n];
            if (columnDescriptor.id == string) {
                return columnDescriptor.cellEditorType;
            }
            ++n;
        }
        return 0;
    }

    public Viewer getViewer() {
        return this.viewer;
    }

    public void setProcess(Process process) {
        if (this.process != process) {
            this.setInput(process);
        }
    }

    public AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    public void updateColumns(ColumnDescriptor[] columnDescriptorArray) {
        this.setColumnDescriptors(columnDescriptorArray);
        this.viewer.setupColumns(columnDescriptorArray);
        this.setAllEditorsAndModifiers();
        this.viewer.refresh();
    }

    public void dispose() {
        if (this.viewer.getContentProvider() != null) {
            this.viewer.getContentProvider().dispose();
        }
        if (this.viewer.getLabelProvider() != null) {
            this.viewer.getLabelProvider().dispose();
        }
        super.dispose();
    }

    protected void setContextHelp(Control control) {
        AdapterFactory adapterFactory = this.getAdapterFactory();
        ComposedAdapterFactory composedAdapterFactory = TngAdapterFactory.INSTANCE.getProcessComposedAdapterFactory();
        ComposedAdapterFactory composedAdapterFactory2 = TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory();
        ComposedAdapterFactory composedAdapterFactory3 = TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory();
        ComposedAdapterFactory composedAdapterFactory4 = TngAdapterFactory.INSTANCE.getPBS_ComposedAdapterFactory();
        if (adapterFactory == composedAdapterFactory2) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp(control, AuthoringUIHelpContexts.FORM_EDITOR_PROCESS_WBS_CONTEXT);
        } else if (adapterFactory == composedAdapterFactory3) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp(control, AuthoringUIHelpContexts.FORM_EDITOR_PROCESS_OBS_CONTEXT);
        } else if (adapterFactory == composedAdapterFactory4) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp(control, AuthoringUIHelpContexts.FORM_EDITOR_PROCESS_PBS_CONTEXT);
        } else if (adapterFactory == composedAdapterFactory) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp(control, AuthoringUIHelpContexts.FORM_EDITOR_PROCESS_ALLBS_CONTEXT);
        }
    }

    public IAction[] getAdditionalActions() {
        return null;
    }

    public void setCheckBoxCellEditors() {
        AbstractCheckBoxCellEditor[] abstractCheckBoxCellEditorArray = new AbstractCheckBoxCellEditor[this.columnDescriptors.length];
        int n = 0;
        while (n < this.columnDescriptors.length) {
            switch (this.columnDescriptors[n].cellEditorType) {
                case 3: {
                    abstractCheckBoxCellEditorArray[n] = new ProcessCheckBoxCellEditor(this.viewer.getCellEditorParent());
                    break;
                }
                default: {
                    abstractCheckBoxCellEditorArray[n] = null;
                }
            }
            ++n;
        }
        this.viewer.setCheckBoxCellEditors(abstractCheckBoxCellEditorArray);
    }

    protected static class CellEditorValidator
    implements ICellEditorValidator {
        private ValidatingTextCellEditor cellEditor;

        public CellEditorValidator(ValidatingTextCellEditor validatingTextCellEditor) {
            this.cellEditor = validatingTextCellEditor;
        }

        public String isValid(Object object) {
            return this.cellEditor.isValid((String)object);
        }
    }

    private class ProcessAdapterFactoryLabelProvider
    extends VariabilityElementLabelProvider
    implements IColorProvider {
        private DecoratingLabelProvider decoratingLabelProvider;

        public ProcessAdapterFactoryLabelProvider(AdapterFactory adapterFactory) {
            super(adapterFactory);
            this.decoratingLabelProvider = new DecoratingLabelProvider((ILabelProvider)new AdapterFactoryLabelProvider(adapterFactory), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator());
        }

        public void addListener(ILabelProviderListener iLabelProviderListener) {
            super.addListener(iLabelProviderListener);
            this.decoratingLabelProvider.addListener(iLabelProviderListener);
        }

        public void removeListener(ILabelProviderListener iLabelProviderListener) {
            super.removeListener(iLabelProviderListener);
            this.decoratingLabelProvider.removeListener(iLabelProviderListener);
        }

        public Image getColumnImage(Object object, int n) {
            if (n == 0) {
                return this.getImage(object);
            }
            return super.getColumnImage(object, n);
        }

        public Image getImage(Object object) {
            return this.decoratingLabelProvider.getImage(object);
        }

        public Color getForeground(Object object) {
            if (this.isSuppressed(object)) {
                return Colors.SUPRESSED_ELEMENT_LABEL;
            }
            if (this.isExternal(object)) {
                return Colors.INHERITED_ELEMENT_LABEL;
            }
            return null;
        }

        private boolean isSuppressed(Object object) {
            if (object instanceof BreakdownElement) {
                return this.getSuppression().isSuppressed((Object)((BreakdownElement)object));
            }
            if (object instanceof BreakdownElementWrapperItemProvider) {
                return this.getSuppression().isSuppressed((Object)((BreakdownElementWrapperItemProvider)object));
            }
            return false;
        }

        private Suppression getSuppression() {
            return ((ProcessEditor)ProcessBreakdownStructureFormPage.this.getEditor()).getSuppression();
        }

        public Color getBackground(Object object) {
            return null;
        }

        public boolean isExternal(Object object) {
            return ProcessUtil.isInherited((Object)object);
        }

        public Font getFont(Object object) {
            if (this.isExternal(object)) {
                return italicFont;
            }
            return regularFont;
        }

        public void dispose() {
            this.decoratingLabelProvider.dispose();
            this.decoratingLabelProvider = null;
            super.dispose();
        }
    }

    protected class ValidatingDeactivateListener
    implements Listener {
        private ValidatingTextCellEditor cellEditor;

        public ValidatingDeactivateListener(ValidatingTextCellEditor validatingTextCellEditor) {
            this.cellEditor = validatingTextCellEditor;
        }

        public void handleEvent(Event event) {
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    if (ValidatingDeactivateListener.this.cellEditor.getLastInvalidElement() != null) {
                        AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.editProcessElementErrorDialog_title, ValidatingDeactivateListener.this.cellEditor.getErrorMessage());
                        ((ValidatingDeactivateListener)ValidatingDeactivateListener.this).ProcessBreakdownStructureFormPage.this.viewer.editElement(ValidatingDeactivateListener.this.cellEditor.getLastInvalidElement(), ValidatingDeactivateListener.this.cellEditor.getColumnIndex());
                    }
                }
            });
        }
    }

    protected class ValidatingTextCellEditor
    extends TextCellEditor {
        protected Object lastInvalidElement;
        private int columnIndex;

        public ValidatingTextCellEditor(Composite composite) {
            super(composite);
        }

        public void setColumnIndex(int n) {
            this.columnIndex = n;
        }

        public int getColumnIndex() {
            return this.columnIndex;
        }

        public Object getLastInvalidElement() {
            return this.lastInvalidElement;
        }

        String isValid(String string) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)ProcessBreakdownStructureFormPage.this.viewer.getSelection();
            if (iStructuredSelection.size() == 1) {
                Object object = iStructuredSelection.getFirstElement();
                String string2 = this.isValid(object, string);
                this.lastInvalidElement = string2 != null ? object : null;
                return string2;
            }
            return null;
        }

        protected String isValid(Object object, String string) {
            return null;
        }
    }
}

