/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.properties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.process.command.DeleteUnusedDescriptorsCommand;
import org.eclipse.epf.library.edit.ui.ReferenceSelection;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.ui.actions.ProcessDeleteAction;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.TaskDescriptor;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.epf.uma.util.UmaUtil;

public class RemoveDescriptorCommand
extends AbstractCommand
implements IResourceAwareCommand {
    private List elements;
    private Descriptor desc;
    private Collection modifiedResources;
    private Command deleteUnusedDescriptorsCommand = null;
    private int featureID;
    private List references;

    public RemoveDescriptorCommand(Descriptor descriptor, List list, int n) {
        this.elements = list;
        this.desc = descriptor;
        this.featureID = n;
        this.modifiedResources = new HashSet();
    }

    public void execute() {
        ArrayList<Descriptor> arrayList = new ArrayList<Descriptor>();
        int n = 0;
        while (n < this.elements.size()) {
            Activity activity;
            Descriptor descriptor = (Descriptor)this.elements.get(n);
            boolean bl = descriptor instanceof WorkProductDescriptor ? ProcessUtil.checkWorkProductDescriptorReferences((Collection)Collections.singleton(this.desc), (WorkProductDescriptor)((WorkProductDescriptor)descriptor), (boolean)true, (int)this.featureID) : ProcessUtil.checkDescriptorReferences((Descriptor)this.desc, (Descriptor)descriptor);
            if (!bl && (activity = UmaUtil.getParentActivity((BreakdownElement)this.desc)).getBreakdownElements().contains(descriptor)) {
                arrayList.add(descriptor);
            }
            ++n;
        }
        if (!arrayList.isEmpty()) {
            Object[] objectArray = ReferenceSelection.getReferences(arrayList);
            this.references = Arrays.asList(objectArray);
        }
        this.redo();
    }

    public void redo() {
        if (this.desc instanceof TaskDescriptor) {
            switch (this.featureID) {
                case 31: {
                    ((TaskDescriptor)this.desc).setPerformedPrimarilyBy(null);
                    break;
                }
                case 25: {
                    ((TaskDescriptor)this.desc).getAdditionallyPerformedBy().removeAll(this.elements);
                    break;
                }
                case 26: {
                    ((TaskDescriptor)this.desc).getAssistedBy().removeAll(this.elements);
                    break;
                }
                case 28: {
                    ((TaskDescriptor)this.desc).getMandatoryInput().removeAll(this.elements);
                    break;
                }
                case 27: {
                    ((TaskDescriptor)this.desc).getExternalInput().removeAll(this.elements);
                    break;
                }
                case 29: {
                    ((TaskDescriptor)this.desc).getOptionalInput().removeAll(this.elements);
                    break;
                }
                case 30: {
                    ((TaskDescriptor)this.desc).getOutput().removeAll(this.elements);
                }
            }
        } else if (this.desc instanceof RoleDescriptor) {
            switch (this.featureID) {
                case 22: {
                    ((RoleDescriptor)this.desc).getResponsibleFor().removeAll(this.elements);
                }
            }
        }
        if (this.references != null && !this.references.isEmpty()) {
            if (this.deleteUnusedDescriptorsCommand == null) {
                this.deleteUnusedDescriptorsCommand = new DeleteUnusedDescriptorsCommand(this.references, false, Collections.EMPTY_LIST){

                    protected Command delete(List list) {
                        return ProcessDeleteAction.delete((Collection)list);
                    }
                };
            }
            this.deleteUnusedDescriptorsCommand.execute();
        }
        if (!this.elements.isEmpty() && this.desc.eResource() != null) {
            this.modifiedResources.add(this.desc.eResource());
        }
    }

    public void undo() {
        block19: {
            block18: {
                if (!(this.desc instanceof TaskDescriptor)) break block18;
                switch (this.featureID) {
                    case 31: {
                        Object e = this.elements.get(0);
                        if (e instanceof RoleDescriptor) {
                            ((TaskDescriptor)this.desc).setPerformedPrimarilyBy((RoleDescriptor)e);
                            break;
                        }
                        break block19;
                    }
                    case 25: {
                        ((TaskDescriptor)this.desc).getAdditionallyPerformedBy().addAll(this.elements);
                        break;
                    }
                    case 26: {
                        ((TaskDescriptor)this.desc).getAssistedBy().addAll(this.elements);
                        break;
                    }
                    case 28: {
                        ((TaskDescriptor)this.desc).getMandatoryInput().addAll(this.elements);
                        break;
                    }
                    case 27: {
                        ((TaskDescriptor)this.desc).getExternalInput().addAll(this.elements);
                        break;
                    }
                    case 29: {
                        ((TaskDescriptor)this.desc).getOptionalInput().addAll(this.elements);
                        break;
                    }
                    case 30: {
                        ((TaskDescriptor)this.desc).getOutput().addAll(this.elements);
                    }
                }
                break block19;
            }
            if (this.desc instanceof RoleDescriptor) {
                switch (this.featureID) {
                    case 22: {
                        ((RoleDescriptor)this.desc).getResponsibleFor().addAll(this.elements);
                    }
                }
            }
        }
        if (this.references != null && !this.references.isEmpty()) {
            try {
                if (this.deleteUnusedDescriptorsCommand != null) {
                    this.deleteUnusedDescriptorsCommand.undo();
                }
            }
            catch (RuntimeException runtimeException) {}
        }
    }

    public void dispose() {
        if (this.deleteUnusedDescriptorsCommand != null) {
            this.deleteUnusedDescriptorsCommand.dispose();
        }
        if (this.references != null) {
            this.references.clear();
        }
        if (this.modifiedResources != null) {
            this.modifiedResources.clear();
        }
        super.dispose();
    }

    protected boolean prepare() {
        return true;
    }

    public Collection getModifiedResources() {
        return this.modifiedResources;
    }
}

