/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.util;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditor;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditorInput;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.persistence.refresh.IRefreshHandler;
import org.eclipse.epf.persistence.refresh.RefreshJob;
import org.eclipse.epf.persistence.util.LibrarySchedulingRule;
import org.eclipse.epf.persistence.util.PersistenceUtil;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.part.ViewPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefreshHandler
implements IRefreshHandler {
    private ViewPart view;

    public RefreshHandler(ViewPart viewPart) {
        this.view = viewPart;
    }

    private Control getControl() {
        Viewer viewer;
        if (this.view instanceof IViewerProvider && (viewer = ((IViewerProvider)this.view).getViewer()) != null) {
            return viewer.getControl();
        }
        return null;
    }

    public void refresh(IProgressMonitor iProgressMonitor) {
        Control control = this.getControl();
        if (control == null || control.isDisposed()) {
            return;
        }
        if (control.getDisplay().getThread() == Thread.currentThread()) {
            this.doRefresh(this.view.getSite().getShell());
        } else {
            control.getDisplay().syncExec(new Runnable(){

                public void run() {
                    RefreshHandler.this.doRefresh(null);
                }
            });
        }
    }

    private void doRefresh(Shell shell) {
        boolean bl = !RefreshJob.getInstance().getReloadedBeforeRefreshResources().isEmpty() || !RefreshJob.getInstance().getAddedResources().isEmpty();
        ArrayList<Resource> arrayList = new ArrayList<Resource>(RefreshJob.getInstance().getRemovedResources());
        ArrayList<Resource> arrayList2 = new ArrayList<Resource>(RefreshJob.getInstance().getChangedResources());
        ArrayList<IResource> arrayList3 = new ArrayList<IResource>(RefreshJob.getInstance().getAddedWorkspaceResources());
        if (!arrayList.isEmpty() || !arrayList2.isEmpty() || !arrayList3.isEmpty() || bl) {
            this.blockingRefresh(arrayList, arrayList2, arrayList3, shell);
        }
        if (!arrayList.isEmpty()) {
            RefreshJob.getInstance().getRemovedResources().removeAll(arrayList);
        }
        if (!arrayList2.isEmpty()) {
            RefreshJob.getInstance().getChangedResources().removeAll(arrayList2);
        }
        if (!arrayList3.isEmpty()) {
            RefreshJob.getInstance().getAddedWorkspaceResources().removeAll(arrayList3);
        }
        if (bl) {
            RefreshJob.getInstance().getReloadedBeforeRefreshResources().clear();
            RefreshJob.getInstance().getAddedResources().clear();
        }
    }

    private void blockingRefresh(final ArrayList<Resource> arrayList, final ArrayList<Resource> arrayList2, final Collection<IResource> collection, Shell shell) {
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                iProgressMonitor.beginTask("", -1);
                iProgressMonitor.subTask(AuthoringUIResources._UI_RefreshViewer_menu_item);
                iProgressMonitor.worked(1);
                try {
                    RefreshHandler.this.doRefresh(arrayList, arrayList2, collection);
                }
                finally {
                    iProgressMonitor.done();
                }
            }
        };
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(shell);
        try {
            this.view.getSite().getWorkbenchWindow().getWorkbench().getProgressService().runInUI((IRunnableContext)progressMonitorDialog, iRunnableWithProgress, (ISchedulingRule)new LibrarySchedulingRule(LibraryService.getInstance().getCurrentMethodLibrary()));
        }
        catch (Exception exception) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)exception);
            String string = AuthoringUIResources.ProcessEditor_refreshErrorTitle;
            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(string, exception.toString(), (Throwable)exception);
        }
    }

    private synchronized void doRefresh(Collection<Resource> collection, Collection<Resource> collection2, Collection<IResource> collection3) {
        ResourceSet resourceSet;
        ILibraryManager iLibraryManager;
        HashSet<IEditorPart> hashSet = new HashSet<IEditorPart>();
        if (!collection.isEmpty()) {
            this.handleRemovedResources(collection, hashSet);
        }
        if (!collection2.isEmpty()) {
            this.handleChangedResources(collection2, hashSet);
        }
        if (collection3 != null && !collection3.isEmpty() && (iLibraryManager = LibraryService.getInstance().getCurrentLibraryManager()) != null && (resourceSet = iLibraryManager.getEditingDomain().getResourceSet()) instanceof MultiFileResourceSetImpl) {
            ((MultiFileResourceSetImpl)resourceSet).loadNewResources(collection3);
            ((MultiFileResourceSetImpl)resourceSet).getUnresolvedProxyMarkerManager().validateAllMarkers();
        }
    }

    private Collection<Resource> handleChangedResources(Collection<Resource> collection, Collection<IEditorPart> collection2) {
        return this.handleChangedResources(collection, null, collection2);
    }

    private Collection<Resource> handleRemovedResources(Collection<Resource> collection, Collection<IEditorPart> collection2) {
        Resource resource;
        Object object;
        IEditorPart iEditorPart;
        IEditorReference iEditorReference;
        IWorkbenchPage iWorkbenchPage = this.view.getSite().getPage();
        IEditorReference[] iEditorReferenceArray = iWorkbenchPage.getEditorReferences();
        ArrayList<IEditorPart> arrayList = new ArrayList<IEditorPart>();
        ArrayList<Resource> arrayList2 = new ArrayList<Resource>(collection);
        if (collection2 == null) {
            collection2 = new ArrayList<IEditorPart>();
        }
        int n = 0;
        while (n < iEditorReferenceArray.length) {
            iEditorReference = iEditorReferenceArray[n];
            iEditorPart = iEditorReference.getEditor(true);
            if (iEditorPart instanceof MethodElementEditor && iEditorPart.isDirty()) {
                Resource resource2;
                object = (MethodElementEditorInput)iEditorPart.getEditorInput();
                Resource resource3 = resource2 = ((MethodElementEditorInput)object).getMethodElement() != null ? ((MethodElementEditorInput)object).getMethodElement().eResource() : null;
                if (!collection.contains(resource2)) {
                    resource = ((MethodElementEditor)iEditorPart).getUsedResources();
                    int n2 = 0;
                    while (n2 < arrayList2.size()) {
                        resource2 = arrayList2.get(n2);
                        if (resource.contains(resource2)) {
                            arrayList.add(iEditorPart);
                            break;
                        }
                        ++n2;
                    }
                } else {
                    collection2.add(iEditorPart);
                }
            }
            ++n;
        }
        if (!arrayList.isEmpty()) {
            Object[] objectArray = this.selectDirtyEditors(arrayList);
            int n3 = 0;
            while (n3 < objectArray.length) {
                collection2.add((IEditorPart)objectArray[n3]);
                ++n3;
            }
        }
        PersistenceUtil.unload(collection);
        int n4 = 0;
        while (n4 < iEditorReferenceArray.length) {
            iEditorReference = iEditorReferenceArray[n4];
            iEditorPart = iEditorReference.getEditor(true);
            if (iEditorPart instanceof MethodElementEditor && !iEditorPart.isDirty()) {
                object = ((MethodElementEditor)iEditorPart).getUsedResources();
                int n5 = 0;
                while (n5 < arrayList2.size()) {
                    resource = arrayList2.get(n5);
                    if (object.contains(resource)) {
                        collection2.add(iEditorPart);
                        break;
                    }
                    ++n5;
                }
            }
            ++n4;
        }
        return collection;
    }

    public Collection<Resource> handleChangedResources(Collection<Resource> collection, Collection<IEditorPart> collection2, Collection<IEditorPart> collection3) {
        ILibraryManager iLibraryManager;
        Collection<Resource> collection4;
        Object object;
        Control control = this.getControl();
        if (control == null || control.isDisposed()) {
            return Collections.emptyList();
        }
        IWorkbenchPage iWorkbenchPage = this.view.getSite().getPage();
        IEditorReference[] iEditorReferenceArray = iWorkbenchPage.getEditorReferences();
        ArrayList<IEditorPart> arrayList = new ArrayList<IEditorPart>();
        ArrayList<Resource> arrayList2 = new ArrayList<Resource>(collection);
        int n = 0;
        while (n < iEditorReferenceArray.length) {
            IEditorReference iEditorReference = iEditorReferenceArray[n];
            object = iEditorReference.getEditor(true);
            if (object instanceof MethodElementEditor && object.isDirty()) {
                collection4 = ((MethodElementEditor)((Object)object)).getUsedResources();
                int n2 = 0;
                while (n2 < arrayList2.size()) {
                    Resource resource = arrayList2.get(n2);
                    if (collection4.contains(resource)) {
                        arrayList.add((IEditorPart)object);
                        break;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        if (!arrayList.isEmpty()) {
            Object[] objectArray = this.selectDirtyEditors(arrayList);
            if (objectArray != null) {
                int n3 = 0;
                while (n3 < objectArray.length) {
                    object = objectArray[n3];
                    if (!(collection2 != null && collection2.contains(object) || collection3 != null && collection3.contains(object))) {
                        arrayList.remove(object);
                    }
                    ++n3;
                }
            }
            int n4 = 0;
            while (n4 < arrayList.size()) {
                object = (MethodElementEditor)arrayList.get(n4);
                collection4 = ((MethodElementEditor)((Object)object)).getUsedResources();
                collection4.retainAll(arrayList2);
                ((MethodElementEditor)((Object)object)).updateResourceInfos(collection4);
                ((MethodElementEditor)((Object)object)).ovewriteResources(collection4);
                arrayList2.removeAll(collection4);
                ++n4;
            }
        }
        if (!arrayList2.isEmpty() && (iLibraryManager = LibraryService.getInstance().getCurrentLibraryManager()) != null) {
            iLibraryManager.reloadResources(arrayList2);
        }
        return arrayList2;
    }

    private Object[] selectDirtyEditors(ArrayList<IEditorPart> arrayList) {
        return RefreshHandler.selectDirtyEditors(arrayList, this.view.getSite().getShell());
    }

    public static Object[] selectDirtyEditors(List<?> list, Shell shell) {
        String string = AuthoringUIResources._UI_FileConflict_label;
        String string2 = AuthoringUIResources.selectEditorsToDiscardConflictChanges;
        return RefreshHandler.selectEditors(list, string, string2, shell);
    }

    private static Object[] selectEditors(List<?> list, String string, String string2, Shell shell) {
        IStructuredContentProvider iStructuredContentProvider = new IStructuredContentProvider(){
            List<?> fContents;

            public Object[] getElements(Object object) {
                if (this.fContents != null && this.fContents == object) {
                    return this.fContents.toArray();
                }
                return new Object[0];
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object object, Object object2) {
                this.fContents = object2 instanceof List ? (List)object2 : null;
            }
        };
        LabelProvider labelProvider = new LabelProvider(){

            public String getText(Object object) {
                if (object instanceof IEditorPart) {
                    return ((IEditorPart)object).getTitle();
                }
                return super.getText(object);
            }

            public Image getImage(Object object) {
                if (object instanceof IEditorPart) {
                    return ((IEditorPart)object).getTitleImage();
                }
                return super.getImage(object);
            }
        };
        ListSelectionDialog listSelectionDialog = new ListSelectionDialog(shell, list, iStructuredContentProvider, (ILabelProvider)labelProvider, string2);
        listSelectionDialog.setTitle(string);
        listSelectionDialog.setBlockOnOpen(true);
        listSelectionDialog.open();
        return listSelectionDialog.getResult();
    }
}

