/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.editors.BreakdownElementEditorInput;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditorInput;
import org.eclipse.epf.common.serviceability.MsgBox;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.diagram.core.part.AbstractDiagramEditor;
import org.eclipse.epf.diagram.core.part.DiagramEditorInputProxy;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.util.MethodElementUtil;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.DependencyChecker;
import org.eclipse.epf.library.edit.validation.IValidator;
import org.eclipse.epf.library.edit.validation.internal.ContentElementNameValidator;
import org.eclipse.epf.library.edit.validation.internal.ValidatorFactory;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.library.ui.LibraryUIText;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.Deliverable;
import org.eclipse.epf.uma.Guidance;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Practice;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class UIHelper {
    public static void setItems(Table table, ArrayList arrayList) {
        table.removeAll();
        int n = 0;
        while (n < arrayList.size()) {
            TableItem tableItem = new TableItem(table, 0);
            tableItem.setText((String)arrayList.get(n));
            ++n;
        }
    }

    public static org.eclipse.swt.widgets.List createList(FormToolkit formToolkit, Composite composite, int n) {
        org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List(composite, n);
        formToolkit.adapt((Control)list, true, true);
        return list;
    }

    public static Object[] getSelectedGuidances(ContentElement contentElement) {
        List list = MethodElementUtil.getSelectedGuidances((EObject)contentElement);
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof Practice)) continue;
            iterator.remove();
        }
        return list.toArray();
    }

    private static String getFormPageTitlePrefixFor(MethodElement methodElement) {
        String string = LibraryUIText.getUIText((MethodElement)methodElement);
        if (methodElement instanceof WorkProduct) {
            return String.valueOf(LibraryUIText.TEXT_WORK_PRODUCT) + " (" + string + ")";
        }
        if (methodElement instanceof Guidance) {
            return String.valueOf(LibraryUIText.TEXT_GUIDANCE) + " (" + string + ")";
        }
        return string;
    }

    public static void setFormText(ScrolledForm scrolledForm, MethodElement methodElement) {
        if (scrolledForm != null && !scrolledForm.isDisposed()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(UIHelper.getFormPageTitlePrefixFor(methodElement));
            stringBuffer.append(AuthoringUIResources.editor_title_colon_with_spaces);
            if (methodElement instanceof VariabilityElement) {
                stringBuffer.append(TngUtil.getLabel((VariabilityElement)((VariabilityElement)methodElement), (String)"", (boolean)true));
            } else if (methodElement.getName() != null) {
                stringBuffer.append(methodElement.getName());
            }
            scrolledForm.setText(stringBuffer.toString());
        }
    }

    public static boolean checkCircularDeliverables(Deliverable deliverable, Deliverable deliverable2) {
        return DependencyChecker.checkCircularDeliverables((Deliverable)deliverable, (Deliverable)deliverable2);
    }

    public static void deliverablePartsChain(Deliverable deliverable, List list) {
        List list2 = deliverable.getDeliveredWorkProducts();
        if (list2 != null && list2.size() > 0) {
            for (Object e : list2) {
                if (!(e instanceof Deliverable)) continue;
                list.add(e);
                UIHelper.deliverablePartsChain((Deliverable)e, list);
            }
        }
    }

    public static String resolveContentElementNameConflict(EObject eObject, MethodElement methodElement, EReference eReference) {
        ContentElementNameValidator contentElementNameValidator = new ContentElementNameValidator(eObject, (EStructuralFeature)eReference, (ContentElement)methodElement, (IFilter)new ValidatorFactory.TypeFilter((EObject)methodElement));
        String string = contentElementNameValidator.isValid(methodElement.getName());
        if (string != null) {
            String string2 = TngUtil.getFeatureText((EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name());
            String string3 = LibraryEditResources.resolveNameConflictDialog_title;
            String string4 = NLS.bind((String)LibraryEditResources.resolveNameConflictDialog_text, (Object)StrUtil.toLower((String)string2), (Object)methodElement.getName());
            String string5 = (String)methodElement.eGet((EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name());
            IInputValidator iInputValidator = new IInputValidator((IValidator)contentElementNameValidator){
                private final /* synthetic */ IValidator val$validator;
                {
                    this.val$validator = iValidator;
                }

                public String isValid(String string) {
                    return this.val$validator.isValid(string);
                }
            };
            InputDialog inputDialog = new InputDialog(MsgBox.getDefaultShell(), string3, string4, string5, iInputValidator);
            if (inputDialog.open() == 1) {
                throw new OperationCanceledException();
            }
            return inputDialog.getValue();
        }
        return null;
    }

    public static void refreshOpenDiagramEditorsOfParent(Object object, List arrayList) {
        IEditorInput iEditorInput;
        IEditorPart iEditorPart;
        arrayList = new ArrayList<IEditorReference>();
        IWorkbenchPage iWorkbenchPage = AuthoringUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorReference[] iEditorReferenceArray = iWorkbenchPage.getEditorReferences();
        int n = 0;
        while (n < iEditorReferenceArray.length) {
            IEditorReference iEditorReference = iEditorReferenceArray[n];
            iEditorPart = iEditorReference.getEditor(true);
            if (iEditorPart != null) {
                Object object2;
                iEditorInput = iEditorPart.getEditorInput();
                BreakdownElementWrapperItemProvider breakdownElementWrapperItemProvider = null;
                if (iEditorInput instanceof BreakdownElementEditorInput) {
                    object2 = (BreakdownElementEditorInput)iEditorInput;
                    if (((BreakdownElementEditorInput)object2).getWrapper() != null) {
                        Object object3;
                        breakdownElementWrapperItemProvider = ((BreakdownElementEditorInput)object2).getWrapper();
                        if (breakdownElementWrapperItemProvider instanceof BreakdownElementWrapperItemProvider && (object3 = breakdownElementWrapperItemProvider.getParent(null)) instanceof BreakdownElementWrapperItemProvider && breakdownElementWrapperItemProvider.equals(object)) {
                            UIHelper.refreshOpenDiagramEditorsOfParent(object3, arrayList);
                        }
                    } else {
                        breakdownElementWrapperItemProvider = ((MethodElementEditorInput)object2).getMethodElement();
                    }
                } else if (iEditorInput instanceof DiagramEditorInputProxy && (object2 = ((DiagramEditorInputProxy)iEditorInput).getDiagramEditorInput()) != null) {
                    breakdownElementWrapperItemProvider = object2.getMethodElement();
                }
                if (breakdownElementWrapperItemProvider != null) {
                    if (breakdownElementWrapperItemProvider instanceof Activity) {
                        if (((Activity)breakdownElementWrapperItemProvider).getBreakdownElements().contains(object)) {
                            arrayList.add(iEditorReference);
                        } else if (object instanceof BreakdownElementWrapperItemProvider) {
                            object2 = object;
                            while (object2 instanceof BreakdownElementWrapperItemProvider && ((BreakdownElementWrapperItemProvider)object2).getOwner() != null) {
                                if (((BreakdownElementWrapperItemProvider)object2).getOwner().equals(breakdownElementWrapperItemProvider)) {
                                    arrayList.add(iEditorReference);
                                }
                                object2 = ((BreakdownElementWrapperItemProvider)object2).getOwner();
                            }
                        }
                    } else if (breakdownElementWrapperItemProvider instanceof BreakdownElementWrapperItemProvider && (object2 = breakdownElementWrapperItemProvider.getChildren((Object)breakdownElementWrapperItemProvider)) != null && object2.contains(object)) {
                        arrayList.add(iEditorReference);
                    }
                }
            }
            ++n;
        }
        n = arrayList.size();
        int n2 = 0;
        while (n2 < n) {
            iEditorPart = (IEditorReference)arrayList.get(n2);
            iEditorInput = iEditorPart.getEditor(true);
            if (iEditorInput instanceof AbstractDiagramEditor) {
                ((AbstractDiagramEditor)iEditorInput).refreshDiagram();
            }
            ++n2;
        }
    }

    public static void closeDiagramEditorsIncludingParent(Object object, List arrayList) {
        IEditorReference[] iEditorReferenceArray;
        arrayList = new ArrayList<IEditorReference[]>();
        IWorkbenchPage iWorkbenchPage = AuthoringUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorReference[] iEditorReferenceArray2 = iWorkbenchPage.getEditorReferences();
        int n = 0;
        while (n < iEditorReferenceArray2.length) {
            iEditorReferenceArray = iEditorReferenceArray2[n];
            IEditorPart iEditorPart = iEditorReferenceArray.getEditor(true);
            if (iEditorPart != null) {
                Object object2;
                IEditorInput iEditorInput = iEditorPart.getEditorInput();
                BreakdownElementWrapperItemProvider breakdownElementWrapperItemProvider = null;
                if (iEditorInput instanceof BreakdownElementEditorInput) {
                    object2 = (BreakdownElementEditorInput)iEditorInput;
                    if (((BreakdownElementEditorInput)object2).getWrapper() != null) {
                        Object object3;
                        breakdownElementWrapperItemProvider = ((BreakdownElementEditorInput)object2).getWrapper();
                        if (breakdownElementWrapperItemProvider instanceof BreakdownElementWrapperItemProvider && (object3 = breakdownElementWrapperItemProvider.getParent(null)) instanceof BreakdownElementWrapperItemProvider && breakdownElementWrapperItemProvider.equals(object)) {
                            UIHelper.closeDiagramEditorsIncludingParent(object3, arrayList);
                        }
                    } else {
                        breakdownElementWrapperItemProvider = ((MethodElementEditorInput)object2).getMethodElement();
                    }
                } else if (iEditorInput instanceof DiagramEditorInputProxy && (object2 = ((DiagramEditorInputProxy)iEditorInput).getDiagramEditorInput()) != null) {
                    breakdownElementWrapperItemProvider = object2.getMethodElement();
                }
                if (breakdownElementWrapperItemProvider != null) {
                    if (breakdownElementWrapperItemProvider instanceof Activity) {
                        if (breakdownElementWrapperItemProvider.equals(object)) {
                            arrayList.add(iEditorReferenceArray);
                        }
                        if (((Activity)breakdownElementWrapperItemProvider).getBreakdownElements().contains(object)) {
                            arrayList.add(iEditorReferenceArray);
                        } else if (object instanceof BreakdownElementWrapperItemProvider && ((BreakdownElementWrapperItemProvider)object).getOwner() != null && ((BreakdownElementWrapperItemProvider)object).getOwner().equals(breakdownElementWrapperItemProvider)) {
                            arrayList.add(iEditorReferenceArray);
                            if (((BreakdownElementWrapperItemProvider)object).getOwner() instanceof BreakdownElementWrapperItemProvider && ((BreakdownElementWrapperItemProvider)((BreakdownElementWrapperItemProvider)object).getOwner()).getOwner().equals(breakdownElementWrapperItemProvider)) {
                                arrayList.add(iEditorReferenceArray);
                            }
                        }
                    } else if (breakdownElementWrapperItemProvider instanceof BreakdownElementWrapperItemProvider && (object2 = breakdownElementWrapperItemProvider.getChildren((Object)breakdownElementWrapperItemProvider)) != null && object2.contains(object)) {
                        arrayList.add(iEditorReferenceArray);
                    }
                }
            }
            ++n;
        }
        n = arrayList.size();
        iEditorReferenceArray = new IEditorReference[n];
        int n2 = 0;
        while (n2 < n) {
            iEditorReferenceArray[n2] = (IEditorReference)arrayList.get(n2);
            ++n2;
        }
        iWorkbenchPage.closeEditors(iEditorReferenceArray, false);
    }

    public static VariabilityElement getBaseActivity(Activity activity) {
        while (!activity.getVariabilityType().equals(VariabilityType.NA_LITERAL)) {
            VariabilityElement variabilityElement = activity.getVariabilityBasedOnElement();
            if (variabilityElement == null || !(variabilityElement instanceof Activity)) break;
            activity = (Activity)variabilityElement;
        }
        return activity;
    }

    public static void closeDiagramEditors(Object object, List arrayList) {
        IEditorReference[] iEditorReferenceArray;
        arrayList = new ArrayList<IEditorReference[]>();
        IWorkbenchPage iWorkbenchPage = AuthoringUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorReference[] iEditorReferenceArray2 = iWorkbenchPage.getEditorReferences();
        int n = 0;
        while (n < iEditorReferenceArray2.length) {
            iEditorReferenceArray = iEditorReferenceArray2[n];
            IEditorPart iEditorPart = iEditorReferenceArray.getEditor(true);
            if (iEditorPart != null) {
                Object object2;
                IEditorInput iEditorInput = iEditorPart.getEditorInput();
                Object object3 = null;
                if (iEditorInput instanceof BreakdownElementEditorInput) {
                    object2 = (BreakdownElementEditorInput)iEditorInput;
                    if (((BreakdownElementEditorInput)object2).getWrapper() != null) {
                        Object object4;
                        object3 = ((BreakdownElementEditorInput)object2).getWrapper();
                        if (object3 instanceof BreakdownElementWrapperItemProvider && (object4 = ((BreakdownElementWrapperItemProvider)object3).getParent(object3)) instanceof BreakdownElementWrapperItemProvider && object3.equals(object)) {
                            UIHelper.closeDiagramEditors(object4, arrayList);
                        }
                    } else {
                        object3 = ((MethodElementEditorInput)object2).getMethodElement();
                    }
                } else if (iEditorInput instanceof DiagramEditorInputProxy && (object2 = ((DiagramEditorInputProxy)iEditorInput).getDiagramEditorInput()) != null) {
                    object3 = object2.getMethodElement();
                }
                if (object3 != null) {
                    if (object3.equals(object)) {
                        arrayList.add(iEditorReferenceArray);
                    } else if (object instanceof Activity) {
                        object2 = new ArrayList();
                        ProcessUtil.getChildElements((Activity)((Activity)object), Activity.class, (Collection)object2);
                        if (object2.contains(object3)) {
                            arrayList.add(iEditorReferenceArray);
                        }
                    }
                }
            }
            ++n;
        }
        n = arrayList.size();
        iEditorReferenceArray = new IEditorReference[n];
        int n2 = 0;
        while (n2 < n) {
            iEditorReferenceArray[n2] = (IEditorReference)arrayList.get(n2);
            ++n2;
        }
        iWorkbenchPage.closeEditors(iEditorReferenceArray, false);
        iEditorReferenceArray = null;
    }

    public static void syncDiagramEditors(Object object) {
        Object object2;
        IEditorInput iEditorInput;
        IEditorReference[] iEditorReferenceArray;
        ArrayList<IEditorReference[]> arrayList = new ArrayList<IEditorReference[]>();
        ArrayList<IEditorReference[]> arrayList2 = new ArrayList<IEditorReference[]>();
        IWorkbenchPage iWorkbenchPage = AuthoringUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IEditorReference[] iEditorReferenceArray2 = iWorkbenchPage.getEditorReferences();
        int n = 0;
        while (n < iEditorReferenceArray2.length) {
            iEditorReferenceArray = iEditorReferenceArray2[n];
            IEditorPart iEditorPart = iEditorReferenceArray.getEditor(true);
            if (iEditorPart != null) {
                Object object3;
                iEditorInput = iEditorPart.getEditorInput();
                object2 = null;
                if (iEditorInput instanceof BreakdownElementEditorInput) {
                    object3 = (BreakdownElementEditorInput)iEditorInput;
                    object2 = ((BreakdownElementEditorInput)object3).getWrapper() != null ? ((BreakdownElementEditorInput)object3).getWrapper() : ((MethodElementEditorInput)object3).getMethodElement();
                } else if (iEditorInput instanceof DiagramEditorInputProxy && (object3 = ((DiagramEditorInputProxy)iEditorInput).getDiagramEditorInput()) != null) {
                    object2 = object3.getMethodElement();
                }
                if (object2 != null) {
                    if (object2.equals(object)) {
                        arrayList.add(iEditorReferenceArray);
                    } else if (object2 instanceof Activity) {
                        if (((Activity)object2).getBreakdownElements().contains(object)) {
                            arrayList2.add(iEditorReferenceArray);
                        } else if (object instanceof BreakdownElementWrapperItemProvider) {
                            object3 = object;
                            while (object3 instanceof BreakdownElementWrapperItemProvider && ((BreakdownElementWrapperItemProvider)object3).getOwner() != null) {
                                if (((BreakdownElementWrapperItemProvider)object3).getOwner().equals(object2)) {
                                    arrayList2.add(iEditorReferenceArray);
                                }
                                object3 = ((BreakdownElementWrapperItemProvider)object3).getOwner();
                            }
                        }
                    } else if (object2 instanceof BreakdownElementWrapperItemProvider && (object3 = ((BreakdownElementWrapperItemProvider)object2).getChildren(object2)) != null && object3.contains(object)) {
                        arrayList2.add(iEditorReferenceArray);
                    }
                }
            }
            ++n;
        }
        n = arrayList.size();
        iEditorReferenceArray = new IEditorReference[n];
        int n2 = 0;
        while (n2 < n) {
            iEditorReferenceArray[n2] = (IEditorReference)arrayList.get(n2);
            ++n2;
        }
        iWorkbenchPage.closeEditors(iEditorReferenceArray, false);
        iEditorReferenceArray = null;
        n = arrayList2.size();
        n2 = 0;
        while (n2 < n) {
            iEditorInput = (IEditorReference)arrayList2.get(n2);
            object2 = iEditorInput.getEditor(true);
            if (object2 instanceof AbstractDiagramEditor) {
                ((AbstractDiagramEditor)object2).refreshDiagram();
            }
            ++n2;
        }
    }

    public static void showProblemsView() {
        SafeUpdateController.asyncExec((Runnable)new Runnable(){

            public void run() {
                try {
                    IWorkbenchPage iWorkbenchPage;
                    IViewPart iViewPart;
                    if (PlatformUI.getWorkbench().getActiveWorkbenchWindow() != null && PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage() != null && (iViewPart = (iWorkbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()).findView("org.eclipse.ui.views.ProblemView")) == null) {
                        iWorkbenchPage.showView("org.eclipse.ui.views.ProblemView", null, 2);
                    }
                }
                catch (Exception exception) {
                    AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)exception);
                }
            }
        });
    }
}

