/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.views;

import java.io.File;
import java.util.Collection;
import org.eclipse.epf.authoring.gef.viewer.ActivityDiagramService;
import org.eclipse.epf.authoring.ui.AuthoringUIImages;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.BrowsingPerspective;
import org.eclipse.epf.authoring.ui.UIActionDispatcher;
import org.eclipse.epf.authoring.ui.views.ConfigurationView;
import org.eclipse.epf.authoring.ui.views.ElementHTMLViewer;
import org.eclipse.epf.authoring.ui.views.ViewHelper;
import org.eclipse.epf.common.utils.PerspectiveUtil;
import org.eclipse.epf.diagram.ui.service.DiagramImageService;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.ILibraryServiceListener;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.events.ILibraryChangeListener;
import org.eclipse.epf.library.layout.ElementLayoutManager;
import org.eclipse.epf.library.layout.HtmlBuilder;
import org.eclipse.epf.library.layout.diagram.IActivityDiagramService;
import org.eclipse.epf.library.ui.preferences.LibraryUIPreferences;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class ContentView
extends ViewPart {
    public static final String VIEW_ID = ContentView.class.getName();
    private ElementHTMLViewer contentViewer;
    private Object displayedElement;
    private IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart iWorkbenchPart) {
            if (iWorkbenchPart instanceof ContentView && iWorkbenchPart == ContentView.this) {
                ContentView.this.handleSelection(UIActionDispatcher.getInstance().getSelectionSource(), UIActionDispatcher.getInstance().getSelection());
            }
        }

        public void partBroughtToTop(IWorkbenchPart iWorkbenchPart) {
        }

        public void partClosed(IWorkbenchPart iWorkbenchPart) {
        }

        public void partDeactivated(IWorkbenchPart iWorkbenchPart) {
        }

        public void partOpened(IWorkbenchPart iWorkbenchPart) {
        }
    };
    private ISelectionChangedListener selectionChangeListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
            ContentView.this.handleSelection(selectionChangedEvent.getSource(), selectionChangedEvent.getSelection());
        }
    };
    private ILibraryChangeListener libraryChangeListener = new ILibraryChangeListener(){

        public void libraryChanged(int n, Collection collection) {
            if (collection != null && ContentView.this.displayedElement != null && collection.contains(ContentView.this.displayedElement)) {
                ContentView.this.displayedElement = null;
            }
        }
    };
    private ILibraryServiceListener libSvcListener = new ILibraryServiceListener(){

        public void configurationSet(MethodConfiguration methodConfiguration) {
            ContentView.this.contentViewer.getBrowser().setUrl("about:blank");
            ContentView.this.displayedElement = null;
        }

        public void libraryClosed(MethodLibrary methodLibrary) {
        }

        public void libraryCreated(MethodLibrary methodLibrary) {
            this.cleanup();
        }

        public void libraryOpened(MethodLibrary methodLibrary) {
            this.cleanup();
        }

        public void libraryReopened(MethodLibrary methodLibrary) {
            this.cleanup();
        }

        public void librarySet(MethodLibrary methodLibrary) {
        }

        private void cleanup() {
            if (ContentView.this.contentViewer != null) {
                ContentView.this.contentViewer.setHtmlBuilder(new HtmlBuilder());
                ContentView.this.contentViewer.getBrowser().redraw();
            }
        }
    };
    private Action backAction;
    private Action forwardAction;
    private Action stopAction;
    private Action refreshAction;
    private Action printAction;
    private Composite diagramViewerHolder;

    public void createPartControl(Composite composite) {
        try {
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            gridLayout.horizontalSpacing = 0;
            gridLayout.verticalSpacing = 0;
            composite.setLayout((Layout)gridLayout);
            composite.setLayoutData((Object)new GridData(1808));
            this.contentViewer = new ElementHTMLViewer(composite);
            this.diagramViewerHolder = new Composite(composite, 0);
            this.diagramViewerHolder.setLayoutData((Object)new GridData(1, 1));
            this.diagramViewerHolder.setLayout((Layout)new GridLayout());
            this.diagramViewerHolder.setVisible(false);
            this.createActions();
            this.getSite().getWorkbenchWindow().getPartService().addPartListener(this.partListener);
            this.getSite().getWorkbenchWindow().addPerspectiveListener(new IPerspectiveListener(){

                public void perspectiveActivated(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor) {
                }

                public void perspectiveChanged(IWorkbenchPage iWorkbenchPage, IPerspectiveDescriptor iPerspectiveDescriptor, String string) {
                    if (iPerspectiveDescriptor.getId().equals(BrowsingPerspective.PERSPECTIVE_ID) && string.equals("editorAreaShow")) {
                        iWorkbenchPage.setEditorAreaVisible(false);
                        AuthoringUIPlugin.getDefault().getMsgDialog().displayWarning(AuthoringUIResources.warningDialog_title, AuthoringUIResources.addEditorToPerspectiveWarning_msg);
                    }
                }
            });
            UIActionDispatcher.getInstance().addSelectionChangedListener(this.selectionChangeListener);
            LibraryService.getInstance().addListener(this.libSvcListener);
            ILibraryManager iLibraryManager = LibraryService.getInstance().getCurrentLibraryManager();
            if (iLibraryManager != null) {
                iLibraryManager.addListener(this.libraryChangeListener);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setFocus() {
        this.contentViewer.setFocus();
    }

    public void dispose() {
        LibraryService.getInstance().removeListener(this.libSvcListener);
        ILibraryManager iLibraryManager = LibraryService.getInstance().getCurrentLibraryManager();
        if (iLibraryManager != null) {
            iLibraryManager.removeListener(this.libraryChangeListener);
        }
        UIActionDispatcher.getInstance().removeSelectionChangedListener(this.selectionChangeListener);
        this.getSite().getWorkbenchWindow().getPartService().removePartListener(this.partListener);
    }

    protected void createActions() {
        this.backAction = new Action(){

            public void run() {
                Browser browser = ContentView.this.contentViewer.getBrowser();
                if (browser != null) {
                    browser.back();
                }
            }
        };
        this.backAction.setText(AuthoringUIResources.back_text);
        this.backAction.setToolTipText(AuthoringUIResources.back_text);
        this.backAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_BACK"));
        this.forwardAction = new Action(){

            public void run() {
                Browser browser = ContentView.this.contentViewer.getBrowser();
                if (browser != null) {
                    browser.forward();
                }
            }
        };
        this.forwardAction.setText(AuthoringUIResources.forward_text);
        this.forwardAction.setToolTipText(AuthoringUIResources.forward_text);
        this.forwardAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_FORWARD"));
        this.stopAction = new Action(){

            public void run() {
                Browser browser = ContentView.this.contentViewer.getBrowser();
                if (browser != null) {
                    browser.stop();
                }
            }
        };
        this.stopAction.setText(AuthoringUIResources.stop_text);
        this.stopAction.setToolTipText(AuthoringUIResources.stop_text);
        this.stopAction.setImageDescriptor(AuthoringUIImages.IMG_DESC_STOP);
        this.refreshAction = new Action(){

            public void run() {
                ContentView.this.contentViewer.refresh();
            }
        };
        this.refreshAction.setText(AuthoringUIResources.refresh_text);
        this.refreshAction.setToolTipText(AuthoringUIResources.refresh_text);
        this.refreshAction.setImageDescriptor(AuthoringUIImages.IMG_DESC_REFRESH);
        this.printAction = new Action(){

            public void run() {
                ContentView.this.contentViewer.print();
            }
        };
        this.printAction.setText(AuthoringUIResources.print_text);
        this.printAction.setToolTipText(AuthoringUIResources.print_text);
        this.printAction.setImageDescriptor(AuthoringUIImages.IMG_DESC_PRINT);
        IActionBars iActionBars = this.getViewSite().getActionBars();
        IToolBarManager iToolBarManager = iActionBars.getToolBarManager();
        iToolBarManager.add((IAction)this.backAction);
        iToolBarManager.add((IAction)this.forwardAction);
        iToolBarManager.add((IAction)this.stopAction);
        iToolBarManager.add((IAction)this.refreshAction);
        iToolBarManager.add((IAction)this.printAction);
    }

    protected boolean isViewVisible() {
        IWorkbenchPage iWorkbenchPage = this.getSite().getWorkbenchWindow().getActivePage();
        if (iWorkbenchPage == null) {
            return false;
        }
        IViewPart iViewPart = iWorkbenchPage.findView(this.getViewId());
        return iViewPart != null;
    }

    protected void handleSelection(Object object, ISelection iSelection) {
        if (iSelection == null || !this.isViewVisible()) {
            return;
        }
        if (iSelection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            Object[] objectArray = iStructuredSelection.toArray();
            if (objectArray != null && objectArray.length > 0) {
                Object object2 = objectArray[0];
                if (this.displayedElement != null && this.displayedElement == object2) {
                    this.displayedElement = null;
                    return;
                }
                if (this.displayContentPage(object, object2)) {
                    this.displayedElement = object2;
                }
            } else {
                this.contentViewer.getBrowser().setUrl("about:blank");
                this.displayedElement = null;
            }
        }
    }

    protected boolean isConfigSource(Object object) {
        return object != null && object instanceof ConfigurationView;
    }

    protected ElementLayoutManager getLayoutMgr() {
        return LibraryService.getInstance().getCurrentConfigurationManager().getElementLayoutManager();
    }

    protected String getViewId() {
        return VIEW_ID;
    }

    protected boolean displayContentPage(Object object, Object object2) {
        Object object3 = LibraryUtil.unwrap((Object)object2);
        if ((object3 = ViewHelper.handleDangling(object3)) == null) {
            return false;
        }
        ElementLayoutManager elementLayoutManager = null;
        boolean bl = PerspectiveUtil.isActivePerspective((String)BrowsingPerspective.PERSPECTIVE_ID);
        boolean bl2 = this.isConfigSource(object);
        if (bl && !bl2) {
            return false;
        }
        if (bl2) {
            elementLayoutManager = this.getLayoutMgr();
            if (elementLayoutManager == null) {
                return false;
            }
            String string = AuthoringUIPlugin.getDefault().getPreferenceStore().getString("PUBLISH_NEW_DIAGRAM");
            Boolean bl3 = new Boolean(true);
            if (string != null && string.length() > 0) {
                bl3 = new Boolean(string);
            }
            if (bl3.booleanValue()) {
                DiagramImageService diagramImageService = (DiagramImageService)elementLayoutManager.getActivityDiagramService();
                if (diagramImageService == null) {
                    diagramImageService = new DiagramImageService(this.diagramViewerHolder, new File(elementLayoutManager.getPublishDir()));
                    diagramImageService.setConfig(elementLayoutManager.getConfiguration());
                    elementLayoutManager.setActivityDiagramService((IActivityDiagramService)diagramImageService);
                }
                boolean bl4 = LibraryUIPreferences.getPublishUnopenActivitydd();
                diagramImageService.setPublishedUnCreatedADD(bl4);
                bl4 = LibraryUIPreferences.getPublishADForActivityExtension();
                diagramImageService.setPublishADForActivityExtension(bl4);
            } else {
                ActivityDiagramService activityDiagramService = (ActivityDiagramService)elementLayoutManager.getActivityDiagramService();
                if (activityDiagramService == null) {
                    activityDiagramService = new ActivityDiagramService(this.diagramViewerHolder, new File(elementLayoutManager.getPublishDir()));
                    elementLayoutManager.setActivityDiagramService((IActivityDiagramService)activityDiagramService);
                }
                boolean bl5 = LibraryUIPreferences.getPublishUnopenActivitydd();
                activityDiagramService.setPublishedUnCreatedADD(bl5);
                bl5 = LibraryUIPreferences.getPublishADForActivityExtension();
                activityDiagramService.setPublishADForActivityExtension(bl5);
            }
        }
        this.contentViewer.setLayoutManager(elementLayoutManager);
        this.contentViewer.showElementContent(object2);
        return true;
    }

    public boolean displayHTMLContentPage(Object object) {
        object = LibraryUtil.unwrap((Object)object);
        if ((object = ViewHelper.handleDangling(object)) != null) {
            this.contentViewer.setLayoutManager(null);
            this.contentViewer.showElementContent(object);
            return true;
        }
        return false;
    }
}

