/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.views;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.library.edit.process.ActivityWrapperItemProvider;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.layout.BrowsingLayoutSettings;
import org.eclipse.epf.library.layout.ElementLayoutManager;
import org.eclipse.epf.library.layout.HtmlBuilder;
import org.eclipse.epf.library.layout.IElementLayout;
import org.eclipse.epf.library.layout.elements.AbstractProcessElementLayout;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationAdapter;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ElementHTMLViewer {
    protected Browser browser = null;
    protected Composite parent;
    private String currentLocation = null;
    private String currentText = null;
    private HtmlBuilder htmlBuilder;
    private Cursor waitCursor = null;

    public ElementHTMLViewer(Composite composite) {
        this.parent = composite;
        this.htmlBuilder = new HtmlBuilder();
        this.createControl();
    }

    private void createControl() {
        try {
            this.browser = new Browser(this.parent, 0);
            this.browser.setLayoutData((Object)new GridData(1808));
            this.browser.addLocationListener((LocationListener)new LocationAdapter(){

                public void changed(LocationEvent locationEvent) {
                }

                public void changing(LocationEvent locationEvent) {
                    String string = ElementHTMLViewer.this.getElementUrl(locationEvent.location);
                    if (string == null || string.startsWith("javascript:")) {
                        return;
                    }
                    if (ElementHTMLViewer.this.isLocationChanged(string)) {
                        ElementHTMLViewer.this.currentLocation = string;
                        ElementHTMLViewer.this.generateHtml(ElementHTMLViewer.this.currentLocation);
                    }
                }
            });
            this.browser.addStatusTextListener(new StatusTextListener(){

                public void changed(StatusTextEvent statusTextEvent) {
                    String string = statusTextEvent.text;
                    if (string != null && string.length() > 0) {
                        ElementHTMLViewer.this.currentText = string;
                    }
                }
            });
            this.browser.addOpenWindowListener(new OpenWindowListener(){

                public void open(WindowEvent windowEvent) {
                    if (SWT.getPlatform().equals("win32")) {
                        return;
                    }
                    Display.getCurrent().asyncExec(new Runnable(){

                        public void run() {
                            try {
                                Shell shell = new Shell();
                                GridLayout gridLayout = new GridLayout();
                                gridLayout.marginHeight = 0;
                                gridLayout.marginWidth = 0;
                                shell.setLayout((Layout)gridLayout);
                                Browser browser = new Browser((Composite)shell, 0);
                                browser.setLayoutData((Object)new GridData(1808));
                                browser.setUrl(ElementHTMLViewer.this.currentText);
                                shell.open();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    });
                }
            });
            this.waitCursor = this.parent.getShell().getDisplay().getSystemCursor(1);
        }
        catch (Exception exception) {
            this.browser = null;
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)exception);
        }
    }

    private boolean isLocationChanged(String string) {
        if (string == null || this.currentLocation == null) {
            return false;
        }
        if (File.separatorChar != '/') {
            string = string.replace(File.separatorChar, '/');
            String string2 = this.getUrl(this.currentLocation);
            return string2.indexOf(string) != 0;
        }
        return !string.endsWith(this.currentLocation) && !this.currentLocation.endsWith(string);
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public void setFocus() {
        if (this.browser != null) {
            this.browser.setFocus();
        }
    }

    public HtmlBuilder getHtmlBuilder() {
        if (this.htmlBuilder != null) {
            BrowsingLayoutSettings.INSTANCE.update(this.htmlBuilder);
        }
        return this.htmlBuilder;
    }

    public void setHtmlBuilder(HtmlBuilder htmlBuilder) {
        this.htmlBuilder = htmlBuilder;
    }

    public void setLayoutManager(ElementLayoutManager elementLayoutManager) {
        this.htmlBuilder.setLayoutManager(elementLayoutManager);
    }

    public void showElementContent(Object object) {
        this.startWait();
        try {
            IElementLayout iElementLayout = null;
            String string = "about:blank";
            Object object2 = LibraryUtil.unwrap((Object)object);
            if (object instanceof ActivityWrapperItemProvider) {
                ActivityWrapperItemProvider activityWrapperItemProvider = (ActivityWrapperItemProvider)object;
                Object object3 = activityWrapperItemProvider.getTopItem();
                if (object2 instanceof MethodElement && object3 instanceof Process) {
                    String string2 = AbstractProcessElementLayout.getPath((BreakdownElementWrapperItemProvider)activityWrapperItemProvider);
                    iElementLayout = this.getHtmlBuilder().getLayoutManager().createLayout((MethodElement)object2, (Process)object3, string2);
                    string = this.getHtmlBuilder().generateHtml(iElementLayout);
                }
            } else if (object2 instanceof MethodElement) {
                string = this.getHtmlBuilder().generateHtml((MethodElement)object2);
            }
            if (string == null) {
                string = "about:blank";
            } else {
                if (!(SWT.getPlatform().equals("win32") || string.startsWith("file://") || string.equals("about:blank"))) {
                    string = "file://" + string;
                }
                if (iElementLayout instanceof AbstractProcessElementLayout) {
                    string = String.valueOf(string) + ((AbstractProcessElementLayout)iElementLayout).getQueryString();
                }
            }
            this.currentLocation = string;
            this.browser.setUrl(string);
        }
        catch (RuntimeException runtimeException) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)runtimeException);
        }
        this.endWait();
    }

    private void generateHtml(String string) {
        this.startWait();
        try {
            this.getHtmlBuilder().generateHtml(string);
        }
        catch (RuntimeException runtimeException) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)runtimeException);
        }
        this.endWait();
    }

    private String getElementUrl(String string) {
        if (string == null || string.length() == 0 || string.equals("about:blank") || string.toLowerCase().startsWith("javascript:")) {
            return null;
        }
        if ((string = this.getUrl(string)).indexOf("pages_not_installed/") >= 0) {
            return null;
        }
        if (ResourceHelper.getGuidFromFileName((String)string) == null) {
            return null;
        }
        return string;
    }

    private String getUrl(String string) {
        String string2 = this.getHtmlBuilder().getPublishDir();
        String string3 = this.fixPath(string);
        int n = string3.toLowerCase().indexOf(this.fixPath(string2).toLowerCase());
        if (n >= 0) {
            string3 = string3.substring(n + string2.length());
        }
        if ((n = string3.indexOf("#")) > 0) {
            string3 = string3.substring(0, n);
        }
        return string3;
    }

    private String fixPath(String string) {
        try {
            string = URLDecoder.decode(string, "utf-8");
            if (File.separatorChar != '/') {
                return string.replace(File.separatorChar, '/');
            }
            return string;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "";
        }
    }

    public void print() {
        this.browser.execute("window.print();");
    }

    private void startWait() {
        this.parent.getShell().setCursor(this.waitCursor);
    }

    private void endWait() {
        this.parent.getShell().setCursor(null);
    }

    public void refresh() {
        this.generateHtml(this.currentLocation);
        this.browser.refresh();
    }
}

