/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.views;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GrayingCheckboxTreeViewerWrapper
implements ICheckStateListener,
ISelectionChangedListener,
ITreeViewerListener {
    protected AdapterFactoryContentProvider fTreeContentProvider;
    protected AdapterFactoryLabelProvider fTreeLabelProvider;
    protected List<Object> fExpandedTreeNodes = new ArrayList<Object>();
    protected List<Object> fCheckedStateStore = new ArrayList<Object>();
    protected List<Object> fWhiteCheckedTreeItems = new ArrayList<Object>();
    protected List<ICheckStateListener> fListeners = new ArrayList<ICheckStateListener>();
    protected CheckboxTreeViewer fTreeViewer;
    protected Object fRoot;

    public GrayingCheckboxTreeViewerWrapper(Composite composite, int n, Object object, AdapterFactoryContentProvider adapterFactoryContentProvider, AdapterFactoryLabelProvider adapterFactoryLabelProvider) {
        this.fRoot = object;
        this.fTreeContentProvider = adapterFactoryContentProvider;
        this.fTreeLabelProvider = adapterFactoryLabelProvider;
        this.createContents(composite, n);
    }

    protected void createContents(Composite composite, int n) {
        this.createTreeViewer(composite, n);
        this.initialize();
    }

    protected void createTreeViewer(Composite composite, int n) {
        Tree tree = new Tree(composite, 2080);
        GridData gridData = new GridData(1808);
        gridData.heightHint = n;
        tree.setLayoutData((Object)gridData);
        this.fTreeViewer = new CheckboxTreeViewer(tree);
        this.fTreeViewer.setUseHashlookup(true);
        this.fTreeViewer.setContentProvider((IContentProvider)this.fTreeContentProvider);
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)this.fTreeLabelProvider);
        this.fTreeViewer.addTreeListener((ITreeViewerListener)this);
        this.fTreeViewer.addCheckStateListener((ICheckStateListener)this);
        this.fTreeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
    }

    public void aboutToOpen() {
        Object object;
        this.determineWhiteCheckedDescendents(this.fRoot);
        this.checkNewTreeElements(this.getTreeChildren(this.fRoot));
        Object[] objectArray = this.getTreeChildren(this.fRoot);
        Object object2 = object = objectArray.length > 0 ? objectArray[0] : null;
        if (object != null) {
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection(object));
        }
        this.fTreeViewer.getControl().setFocus();
    }

    public void addCheckStateListener(ICheckStateListener iCheckStateListener) {
        this.fListeners.add(iCheckStateListener);
    }

    protected void addToHierarchyToCheckedStore(Object object) {
        Object object2;
        if (!this.fCheckedStateStore.contains(object)) {
            this.fCheckedStateStore.add(object);
        }
        if ((object2 = this.fTreeContentProvider.getParent(object)) != null) {
            this.addToHierarchyToCheckedStore(object2);
        }
        this.fTreeViewer.setExpandedState(object, true);
    }

    protected boolean areAllChildrenWhiteChecked(Object object) {
        Object[] objectArray = this.getTreeChildren(object);
        int n = 0;
        while (n < objectArray.length) {
            if (!this.fWhiteCheckedTreeItems.contains(objectArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected void checkNewTreeElements(Object[] objectArray) {
        int n = 0;
        while (n < objectArray.length) {
            Object object = objectArray[n];
            boolean bl = this.fCheckedStateStore.contains(object);
            this.fTreeViewer.setChecked(object, bl);
            this.fTreeViewer.setGrayed(object, bl && !this.fWhiteCheckedTreeItems.contains(object));
            ++n;
        }
    }

    public void checkStateChanged(final CheckStateChangedEvent checkStateChangedEvent) {
        BusyIndicator.showWhile((Display)this.fTreeViewer.getControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                if (checkStateChangedEvent.getCheckable().equals(GrayingCheckboxTreeViewerWrapper.this.fTreeViewer)) {
                    GrayingCheckboxTreeViewerWrapper.this.treeItemChecked(checkStateChangedEvent.getElement(), checkStateChangedEvent.getChecked());
                }
                GrayingCheckboxTreeViewerWrapper.this.notifyCheckStateChangeListeners(checkStateChangedEvent);
            }
        });
    }

    public void selectTreeCheck(Object object, boolean bl) {
        this.treeItemChecked(object, bl);
    }

    protected boolean determineShouldBeAtLeastGrayChecked(Object object) {
        Object[] objectArray = this.getTreeChildren(object);
        int n = 0;
        while (n < objectArray.length) {
            if (this.fCheckedStateStore.contains(objectArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected boolean determineShouldBeWhiteChecked(Object object) {
        return this.areAllChildrenWhiteChecked(object) && this.fCheckedStateStore.contains(object);
    }

    protected void determineWhiteCheckedDescendents(Object object) {
        Object[] objectArray = this.getTreeChildren(object);
        int n = 0;
        while (n < objectArray.length) {
            this.determineWhiteCheckedDescendents(objectArray[n]);
            ++n;
        }
        if (this.determineShouldBeWhiteChecked(object)) {
            this.setWhiteChecked(object, true);
        }
    }

    public void expandAll() {
        this.fTreeViewer.expandAll();
    }

    public void collapseAll() {
        this.fTreeViewer.collapseAll();
    }

    public Set<Object> getAllCheckedTreeItems() {
        return new HashSet<Object>(this.fCheckedStateStore);
    }

    public int getCheckedElementCount() {
        return this.fCheckedStateStore.size();
    }

    public Tree getTree() {
        return this.fTreeViewer.getTree();
    }

    public void addTreeFilter(ViewerFilter viewerFilter) {
        this.fTreeViewer.addFilter(viewerFilter);
    }

    protected void grayCheckHierarchy(Object object) {
        Object object2;
        if (this.fCheckedStateStore.contains(object)) {
            return;
        }
        this.fCheckedStateStore.add(object);
        if (this.determineShouldBeWhiteChecked(object)) {
            this.setWhiteChecked(object, true);
        }
        if ((object2 = this.fTreeContentProvider.getParent(object)) != null) {
            this.grayCheckHierarchy(object2);
        }
    }

    public void initialCheckTreeItem(Object object) {
        this.treeItemChecked(object, true);
    }

    protected void initialize() {
        this.fTreeViewer.setInput(this.fRoot);
    }

    protected void notifyCheckStateChangeListeners(CheckStateChangedEvent checkStateChangedEvent) {
        Iterator<ICheckStateListener> iterator = this.fListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next().checkStateChanged(checkStateChangedEvent);
        }
    }

    public void removeCheckStateListener(ICheckStateListener iCheckStateListener) {
        this.fListeners.remove(iCheckStateListener);
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
    }

    public void setAllSelections(final boolean bl) {
        BusyIndicator.showWhile((Display)this.fTreeViewer.getControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                GrayingCheckboxTreeViewerWrapper.this.setTreeChecked(GrayingCheckboxTreeViewerWrapper.this.fRoot, bl);
            }
        });
    }

    public void setRoot(Object object) {
        this.fRoot = object;
        this.initialize();
    }

    protected void setTreeChecked(Object object, boolean bl) {
        if (bl) {
            this.fCheckedStateStore.add(object);
        } else {
            this.fCheckedStateStore.remove(object);
        }
        this.setWhiteChecked(object, bl);
        this.fTreeViewer.setChecked(object, bl);
        this.fTreeViewer.setGrayed(object, false);
        Object[] objectArray = this.getTreeChildren(object);
        int n = 0;
        while (n < objectArray.length) {
            this.setTreeChecked(objectArray[n], bl);
            ++n;
        }
    }

    public void setTreeProviders(ITreeContentProvider iTreeContentProvider, ILabelProvider iLabelProvider) {
        this.fTreeViewer.setContentProvider((IContentProvider)iTreeContentProvider);
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)iLabelProvider);
    }

    public void setTreeSorter(ViewerSorter viewerSorter) {
        this.fTreeViewer.setSorter(viewerSorter);
    }

    protected void setWhiteChecked(Object object, boolean bl) {
        if (bl) {
            if (!this.fWhiteCheckedTreeItems.contains(object)) {
                this.fWhiteCheckedTreeItems.add(object);
            }
        } else {
            this.fWhiteCheckedTreeItems.remove(object);
        }
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        Object object = treeExpansionEvent.getElement();
        if (!this.fExpandedTreeNodes.contains(object)) {
            this.fExpandedTreeNodes.add(object);
            this.checkNewTreeElements(this.getTreeChildren(object));
        }
    }

    protected void treeItemChecked(Object object, boolean bl) {
        this.setTreeChecked(object, bl);
        Object object2 = this.fTreeContentProvider.getParent(object);
        if (object2 == null) {
            return;
        }
        if (bl) {
            this.grayCheckHierarchy(object2);
        } else {
            this.ungrayCheckHierarchy(object2);
        }
        this.updateHierarchy(object);
    }

    protected void ungrayCheckHierarchy(Object object) {
        Object object2;
        if (!this.determineShouldBeAtLeastGrayChecked(object)) {
            this.fCheckedStateStore.remove(object);
        }
        if ((object2 = this.fTreeContentProvider.getParent(object)) != null) {
            this.ungrayCheckHierarchy(object2);
        }
    }

    protected void updateHierarchy(Object object) {
        boolean bl = this.determineShouldBeWhiteChecked(object);
        boolean bl2 = this.determineShouldBeAtLeastGrayChecked(object);
        this.fTreeViewer.setChecked(object, bl || bl2);
        this.setWhiteChecked(object, bl);
        if (bl) {
            this.fTreeViewer.setGrayed(object, false);
        } else {
            this.fTreeViewer.setGrayed(object, bl2);
        }
        Object object2 = this.fTreeContentProvider.getParent(object);
        if (object2 != null) {
            this.updateHierarchy(object2);
            if (bl || bl2) {
                this.fTreeViewer.setExpandedState(object2, true);
            }
        }
    }

    protected Object[] filter(ViewerFilter[] viewerFilterArray, Object[] objectArray) {
        if (viewerFilterArray != null) {
            ArrayList<Object> arrayList = new ArrayList<Object>(objectArray.length);
            int n = 0;
            while (n < objectArray.length) {
                boolean bl = true;
                int n2 = 0;
                while (n2 < viewerFilterArray.length) {
                    bl = viewerFilterArray[n2].select((Viewer)this.fTreeViewer, null, objectArray[n]);
                    if (!bl) break;
                    ++n2;
                }
                if (bl) {
                    arrayList.add(objectArray[n]);
                }
                ++n;
            }
            return arrayList.toArray();
        }
        return objectArray;
    }

    protected Object[] getTreeChildren(Object object) {
        return this.filter(this.fTreeViewer.getFilters(), this.fTreeContentProvider.getChildren(object));
    }

    public Set<Object> getWhiteCheckedTreeItems() {
        return new HashSet<Object>(this.fWhiteCheckedTreeItems);
    }

    public void updateSelections(final List list) {
        BusyIndicator.showWhile((Display)this.fTreeViewer.getControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                GrayingCheckboxTreeViewerWrapper.this.fExpandedTreeNodes.clear();
                GrayingCheckboxTreeViewerWrapper.this.handleUpdateSelection(list);
            }
        });
    }

    protected void handleUpdateSelection(List list) {
        for (Object e : list) {
            Object object;
            if (!this.fCheckedStateStore.contains(e)) {
                this.fCheckedStateStore.add(e);
            }
            if ((object = this.fTreeContentProvider.getParent(e)) == null) continue;
            this.addToHierarchyToCheckedStore(object);
        }
        for (Object e : list) {
            this.updateHierarchy(e);
        }
    }

    public boolean isTreeItemGreyChecked(Object object) {
        return this.fTreeViewer.getGrayed(object);
    }

    public void expandTreeToLevel(Object object, int n) {
        this.fTreeViewer.expandToLevel(object, n);
    }

    public void setTreeSelection(ISelection iSelection) {
        this.fTreeViewer.setSelection(iSelection);
    }

    public void refresh() {
        this.fExpandedTreeNodes.clear();
        this.fTreeViewer.refresh();
    }
}

