/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.editors.EditorChooser;
import org.eclipse.epf.authoring.ui.views.LibraryView;
import org.eclipse.epf.authoring.ui.wizards.NewPluginMainPage;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.ui.actions.LibraryLockingOperationRunner;
import org.eclipse.epf.ui.wizards.BaseWizard;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewPluginWizard
extends BaseWizard
implements INewWizard {
    public static final String WIZARD_ID = NewPluginWizard.class.getName();
    public static final String WIZARD_EXTENSION_POINT_ID = "org.eclipse.epf.authoring.ui.newPluginWizard";
    protected NewPluginMainPage mainPage;
    protected MethodPlugin newPlugin;

    public String getWizardExtenderExtensionPointId() {
        return WIZARD_EXTENSION_POINT_ID;
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        super.init(iWorkbench, iStructuredSelection);
        this.setWindowTitle(AuthoringUIResources.newPluginWizard_title);
    }

    public void addPages() {
        if (this.wizardExtender == null) {
            this.mainPage = this.createMainPage();
            super.addPage((IWizardPage)this.mainPage);
        } else {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            IWizardPage iWizardPage = this.wizardExtender.getReplaceWizardPage(NewPluginMainPage.PAGE_NAME);
            if (iWizardPage != null) {
                arrayList.add(iWizardPage);
            } else {
                this.mainPage = this.createMainPage();
                arrayList.add((Object)this.mainPage);
            }
            super.getNewWizardPages(arrayList);
            for (IWizardPage iWizardPage2 : arrayList) {
                super.addPage(iWizardPage2);
            }
            this.wizardExtender.initWizardPages(arrayList);
        }
    }

    protected NewPluginMainPage createMainPage() {
        return new NewPluginMainPage();
    }

    public void createPageControls(Composite composite) {
        super.createPageControls(composite);
        composite.getShell().setImage(AuthoringUIPlugin.getDefault().getSharedImage("full/obj16/MethodPlugin.gif"));
    }

    public boolean doFinish() {
        try {
            this.newPlugin = LibraryServiceUtil.createMethodPlugin((String)this.mainPage.getPluginName(), (String)this.mainPage.getBriefDescription(), (String)this.mainPage.getAuthors(), (Object[])this.mainPage.getReferencedPlugins());
            this.initMethodPlugin(this.newPlugin);
            return true;
        }
        catch (Exception exception) {
            String string = exception.getMessage() != null ? exception.getMessage() : AuthoringUIResources.newPluginError_reason;
            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.newPluginWizard_title, AuthoringUIResources.newPluginError_msg, string, (Throwable)exception);
            return false;
        }
    }

    public boolean initMethodPlugin(final MethodPlugin methodPlugin) {
        try {
            ILibraryManager iLibraryManager = LibraryService.getInstance().getCurrentLibraryManager();
            if (iLibraryManager != null) {
                iLibraryManager.addMethodPlugin(methodPlugin);
            }
            Display.getCurrent().asyncExec(new Runnable(){

                public void run() {
                    ArrayList<MethodPlugin> arrayList = new ArrayList<MethodPlugin>();
                    arrayList.add(methodPlugin);
                    LibraryView.getView().setSelectionToViewer(arrayList);
                    EditorChooser.getInstance().openEditor(NewPluginWizard.this.newPlugin);
                }
            });
            return true;
        }
        catch (Exception exception) {
            AuthoringUIPlugin.getDefault().getLogger().logError("Failed to initialize method plug-in '" + methodPlugin.getName() + "'", (Throwable)exception);
            return false;
        }
    }

    private boolean superPerformFinish() {
        return super.performFinish();
    }

    public boolean performFinish() {
        final boolean[] blArray = new boolean[1];
        LibraryLockingOperationRunner libraryLockingOperationRunner = new LibraryLockingOperationRunner();
        libraryLockingOperationRunner.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                blArray[0] = NewPluginWizard.this.superPerformFinish();
            }
        });
        return blArray[0];
    }
}

