/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.configuration.MethodConfigurationElementList;
import org.eclipse.epf.library.edit.util.ModelStructure;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.persistence.ILibraryResourceSet;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.library.util.ModelStorage;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.uma.CapabilityPattern;
import org.eclipse.epf.uma.Checklist;
import org.eclipse.epf.uma.DeliveryProcess;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessFamily;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.util.UmaUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LibraryServiceUtil {
    private static final IFilter CHECKLIST_FILTER = new IFilter(){

        public boolean accept(Object object) {
            return object instanceof Checklist;
        }
    };

    public static String getMethodLibraryPath(MethodLibrary methodLibrary) {
        URI uRI;
        if (methodLibrary == null) {
            return null;
        }
        Resource resource = methodLibrary.eResource();
        if (resource != null && (uRI = resource.getURI()) != null && uRI.isFile()) {
            String string = uRI.toFileString();
            return new File(string).getParentFile().getAbsolutePath();
        }
        return null;
    }

    public static String getCurrentMethodLibraryPath() {
        return LibraryServiceUtil.getMethodLibraryPath(LibraryService.getInstance().getCurrentMethodLibrary());
    }

    public static MethodLibrary getMethodLibrary(MethodElement methodElement) {
        MethodElement methodElement2 = methodElement;
        while (methodElement2 != null) {
            if (methodElement2 instanceof MethodLibrary) {
                return (MethodLibrary)methodElement2;
            }
            methodElement2 = methodElement2.eContainer();
        }
        return null;
    }

    public static MethodConfiguration getMethodConfiguration(MethodLibrary methodLibrary, String string) {
        if (methodLibrary != null) {
            List list = methodLibrary.getPredefinedConfigurations();
            for (MethodConfiguration methodConfiguration : list) {
                if (methodConfiguration instanceof ProcessFamily || !methodConfiguration.getName().equals(string)) continue;
                return methodConfiguration;
            }
        }
        return null;
    }

    public static MethodConfiguration[] getMethodConfigurations(MethodLibrary methodLibrary) {
        MethodConfiguration methodConfiguration;
        ArrayList arrayList;
        if (methodLibrary != null) {
            arrayList = new ArrayList(methodLibrary.getPredefinedConfigurations());
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                methodConfiguration = (MethodConfiguration)iterator.next();
                if (methodConfiguration != null && !(methodConfiguration instanceof ProcessFamily)) continue;
                iterator.remove();
            }
        } else {
            arrayList = Collections.EMPTY_LIST;
        }
        methodConfiguration = new MethodConfiguration[arrayList.size()];
        arrayList.toArray((T[])methodConfiguration);
        return methodConfiguration;
    }

    public static String[] getMethodConfigurationNames(MethodLibrary methodLibrary) {
        MethodConfiguration methodConfiguration2;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (methodLibrary != null) {
            List list = methodLibrary.getPredefinedConfigurations();
            for (MethodConfiguration methodConfiguration2 : list) {
                if (methodConfiguration2 instanceof ProcessFamily) continue;
                arrayList.add(methodConfiguration2.getName());
            }
        }
        methodConfiguration2 = new String[arrayList.size()];
        arrayList.toArray((T[])methodConfiguration2);
        return methodConfiguration2;
    }

    public static Map<String, Process> getProcesses() {
        MethodLibrary methodLibrary = LibraryService.getInstance().getCurrentMethodLibrary();
        if (methodLibrary == null) {
            return null;
        }
        TreeMap<String, Process> treeMap = new TreeMap<String, Process>();
        List list = LibraryUtil.getMethodPlugins(methodLibrary);
        for (MethodPlugin methodPlugin : list) {
            String[] stringArray;
            String[] stringArray2;
            MethodPackage methodPackage = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])(stringArray2 = ModelStructure.DEFAULT.capabilityPatternPath));
            if (methodPackage instanceof ProcessPackage && methodPackage instanceof ProcessPackage) {
                LibraryServiceUtil.getCapabilityPatterns((ProcessPackage)methodPackage, treeMap);
            }
            if (!((methodPackage = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])(stringArray = ModelStructure.DEFAULT.deliveryProcessPath))) instanceof ProcessPackage) || !(methodPackage instanceof ProcessPackage)) continue;
            LibraryServiceUtil.getDeliveryProcesses((ProcessPackage)methodPackage, treeMap);
        }
        return treeMap;
    }

    public static Map<String, Process> getCapabilityPatterns() {
        MethodLibrary methodLibrary = LibraryService.getInstance().getCurrentMethodLibrary();
        if (methodLibrary == null) {
            return null;
        }
        TreeMap<String, Process> treeMap = new TreeMap<String, Process>();
        List list = LibraryUtil.getMethodPlugins(methodLibrary);
        for (MethodPlugin methodPlugin : list) {
            String[] stringArray;
            MethodPackage methodPackage = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])(stringArray = ModelStructure.DEFAULT.capabilityPatternPath));
            if (!(methodPackage instanceof ProcessPackage)) continue;
            LibraryServiceUtil.getCapabilityPatterns((ProcessPackage)methodPackage, treeMap);
        }
        return treeMap;
    }

    public static List<CapabilityPattern> getCapabilityPatterns(MethodPlugin methodPlugin) {
        ArrayList<CapabilityPattern> arrayList = new ArrayList<CapabilityPattern>();
        List list = TngUtil.getAllProcesses((MethodPlugin)methodPlugin);
        for (Process process : list) {
            if (!(process instanceof CapabilityPattern)) continue;
            arrayList.add((CapabilityPattern)process);
        }
        return arrayList;
    }

    public static Map<String, Process> getDeliveryProcesses() {
        MethodLibrary methodLibrary = LibraryService.getInstance().getCurrentMethodLibrary();
        if (methodLibrary == null) {
            return null;
        }
        TreeMap<String, Process> treeMap = new TreeMap<String, Process>();
        List list = LibraryUtil.getMethodPlugins(methodLibrary);
        for (MethodPlugin methodPlugin : list) {
            String[] stringArray;
            MethodPackage methodPackage = UmaUtil.findMethodPackage((MethodPlugin)methodPlugin, (String[])(stringArray = ModelStructure.DEFAULT.deliveryProcessPath));
            if (!(methodPackage instanceof ProcessPackage)) continue;
            LibraryServiceUtil.getDeliveryProcesses((ProcessPackage)methodPackage, treeMap);
        }
        return treeMap;
    }

    public static List<DeliveryProcess> getDeliveryProcesses(MethodPlugin methodPlugin) {
        ArrayList<DeliveryProcess> arrayList = new ArrayList<DeliveryProcess>();
        List list = TngUtil.getAllProcesses((MethodPlugin)methodPlugin);
        for (Process process : list) {
            if (!(process instanceof DeliveryProcess)) continue;
            arrayList.add((DeliveryProcess)process);
        }
        return arrayList;
    }

    protected static void getCapabilityPatterns(ProcessPackage processPackage, Map<String, Process> map) {
        List list = processPackage.getChildPackages();
        for (MethodPackage methodPackage : list) {
            if (methodPackage instanceof ProcessComponent) {
                ProcessComponent processComponent = (ProcessComponent)methodPackage;
                Process process = processComponent.getProcess();
                if (!(process instanceof CapabilityPattern)) continue;
                String string = process.getName();
                map.put(string, process);
                continue;
            }
            if (!(methodPackage instanceof ProcessPackage)) continue;
            LibraryServiceUtil.getCapabilityPatterns((ProcessPackage)methodPackage, map);
        }
    }

    protected static void getDeliveryProcesses(ProcessPackage processPackage, Map<String, Process> map) {
        List list = processPackage.getChildPackages();
        for (MethodPackage methodPackage : list) {
            if (methodPackage instanceof ProcessComponent) {
                ProcessComponent processComponent = (ProcessComponent)methodPackage;
                Process process = processComponent.getProcess();
                if (!(process instanceof DeliveryProcess)) continue;
                String string = process.getName();
                map.put(string, process);
                continue;
            }
            if (!(methodPackage instanceof ProcessPackage)) continue;
            LibraryServiceUtil.getDeliveryProcesses((ProcessPackage)methodPackage, map);
        }
    }

    public static String[] getProcessFamilyNames(MethodLibrary methodLibrary) {
        MethodConfiguration methodConfiguration2;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (methodLibrary != null) {
            List list = methodLibrary.getPredefinedConfigurations();
            for (MethodConfiguration methodConfiguration2 : list) {
                if (!(methodConfiguration2 instanceof ProcessFamily)) continue;
                arrayList.add(methodConfiguration2.getName());
            }
        }
        methodConfiguration2 = new String[arrayList.size()];
        arrayList.toArray((T[])methodConfiguration2);
        return methodConfiguration2;
    }

    public static String[] getContexts(Process process) {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (process != null) {
            stringArray = process.getValidContext();
            for (MethodConfiguration methodConfiguration : stringArray) {
                arrayList.add(methodConfiguration.getName());
            }
        }
        stringArray = new String[arrayList.size()];
        arrayList.toArray(stringArray);
        return stringArray;
    }

    public static Map<String, MethodConfiguration> getMethodConfigurations(Process process) {
        if (process == null) {
            return null;
        }
        TreeMap<String, MethodConfiguration> treeMap = new TreeMap<String, MethodConfiguration>();
        MethodConfiguration methodConfiguration = process.getDefaultContext();
        if (methodConfiguration != null) {
            treeMap.put(methodConfiguration.getName(), methodConfiguration);
        }
        List list = process.getValidContext();
        for (MethodConfiguration methodConfiguration2 : list) {
            if (methodConfiguration2 == null) continue;
            treeMap.put(methodConfiguration2.getName(), methodConfiguration2);
        }
        return treeMap;
    }

    public static Map<String, Checklist> getChecklists(MethodConfiguration methodConfiguration) {
        if (methodConfiguration == null) {
            return null;
        }
        HashMap<String, Checklist> hashMap = new HashMap<String, Checklist>();
        ArrayList<IFilter> arrayList = new ArrayList<IFilter>();
        arrayList.add(CHECKLIST_FILTER);
        MethodConfigurationElementList methodConfigurationElementList = new MethodConfigurationElementList(methodConfiguration, arrayList);
        List list = methodConfigurationElementList.getList();
        for (Object e : list) {
            if (!(e instanceof Checklist)) continue;
            Checklist checklist = (Checklist)e;
            hashMap.put(checklist.getName(), checklist);
        }
        return hashMap;
    }

    public void setGUID(MethodElement methodElement) {
        EList eList;
        String string = methodElement.getGuid();
        if (string == null || string.length() == 0) {
            string = EcoreUtil.generateUUID();
            boolean bl = methodElement.eDeliver();
            try {
                methodElement.eSetDeliver(false);
                methodElement.setGuid(string);
            }
            finally {
                methodElement.eSetDeliver(bl);
            }
        }
        if ((eList = methodElement.eContents()) != null && eList.size() > 0) {
            for (Object e : eList) {
                if (!(e instanceof MethodElement)) continue;
                this.setGUID((MethodElement)e);
            }
        }
    }

    public static String getDebugString(MethodElement methodElement) {
        if (methodElement == null) {
            return "null";
        }
        return String.valueOf(methodElement.getClass().getName()) + "[name: " + methodElement.getName() + ", guid=" + methodElement.getGuid() + "]";
    }

    public static ILibraryPersister getCurrentPersister() {
        try {
            ResourceSet resourceSet = LibraryService.getInstance().getCurrentLibraryManager().getEditingDomain().getResourceSet();
            if (resourceSet instanceof ILibraryResourceSet) {
                return ((ILibraryResourceSet)resourceSet).getPersister();
            }
        }
        catch (NullPointerException nullPointerException) {}
        return null;
    }

    public static ILibraryPersister getPersisterFor(Resource resource) {
        ResourceSet resourceSet = resource.getResourceSet();
        if (resourceSet instanceof ILibraryResourceSet) {
            return ((ILibraryResourceSet)resourceSet).getPersister();
        }
        return null;
    }

    public static MethodPlugin createMethodPlugin(String string, String string2, String string3, Object[] objectArray) throws Exception {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException();
        }
        MethodPlugin methodPlugin = UmaFactory.eINSTANCE.createMethodPlugin();
        methodPlugin.setName(StrUtil.makeValidFileName((String)string));
        if (string2 != null) {
            methodPlugin.setBriefDescription(string2);
        }
        if (string3 != null) {
            methodPlugin.setAuthors(string3);
        }
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                MethodPlugin methodPlugin2 = (MethodPlugin)objectArray[n];
                if (methodPlugin != null) {
                    methodPlugin.getBases().add(methodPlugin2);
                }
                ++n;
            }
        }
        ModelStorage.initialize(methodPlugin);
        return methodPlugin;
    }
}

