/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.configuration;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.configuration.DefaultElementRealizer;
import org.eclipse.epf.library.configuration.ElementRealizer;
import org.eclipse.epf.library.configuration.FeatureValue;
import org.eclipse.epf.library.edit.IConfigurator;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.VariabilityInfo;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.library.util.Log;
import org.eclipse.epf.uma.Discipline;
import org.eclipse.epf.uma.DisciplineGrouping;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.RoleSet;
import org.eclipse.epf.uma.RoleSetGrouping;
import org.eclipse.epf.uma.Task;
import org.eclipse.epf.uma.ToolMentor;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.WorkProduct;
import org.eclipse.epf.uma.util.AssociationHelper;
import org.eclipse.jface.viewers.Viewer;

public class ConfigurationFilter
extends AdapterImpl
implements IConfigurator {
    protected MethodConfiguration methodConfig;
    private Viewer viewer;
    private boolean discardContributors = true;

    public ConfigurationFilter(MethodConfiguration methodConfiguration, Viewer viewer) {
        this.methodConfig = methodConfiguration;
        this.viewer = viewer;
    }

    public ConfigurationFilter(MethodConfiguration methodConfiguration, Viewer viewer, boolean bl) {
        this(methodConfiguration, viewer);
        this.discardContributors = bl;
    }

    public boolean accept(Object object) {
        if (this.methodConfig == null) {
            return true;
        }
        object = LibraryUtil.unwrap(object);
        if ((ElementRealizer.isExtendReplaceEnabled() || object instanceof VariabilityElement && ConfigurationHelper.isExtendReplacer((VariabilityElement)object)) && FeatureValue.isBlankIndicator(object)) {
            return false;
        }
        if (object instanceof MethodPackage) {
            return this.methodConfig.getMethodPackageSelection().contains(object);
        }
        if (object instanceof MethodElement) {
            return ConfigurationHelper.canShow((MethodElement)object, this.methodConfig);
        }
        if (object instanceof ItemProviderAdapter) {
            return true;
        }
        if (Log.DEBUG) {
            System.out.println("Object filtered: " + (object == null ? null : object.toString()));
        }
        return false;
    }

    public Collection getChildren(Object object, EStructuralFeature eStructuralFeature) {
        if (this.methodConfig == null) {
            return null;
        }
        DefaultElementRealizer defaultElementRealizer = new DefaultElementRealizer(this.methodConfig);
        defaultElementRealizer.setDiscardContributor(this.discardContributors);
        if (eStructuralFeature != null && eStructuralFeature.isMany() && object instanceof MethodElement) {
            List list = ConfigurationHelper.calc0nFeatureValue((MethodElement)object, eStructuralFeature, (ElementRealizer)defaultElementRealizer);
            return list;
        }
        return null;
    }

    public void notifyChanged(final Notification notification) {
        if (this.viewer == null) {
            return;
        }
        SafeUpdateController.syncExec(new Runnable(){

            public void run() {
                switch (notification.getEventType()) {
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: {
                        ConfigurationFilter.this.viewer.refresh();
                    }
                }
            }
        });
    }

    public MethodConfiguration getMethodConfiguration() {
        return this.methodConfig;
    }

    public void setMethodConfiguration(MethodConfiguration methodConfiguration) {
        this.methodConfig = methodConfiguration;
    }

    protected void resolveElementVariabilityList(VariabilityElement variabilityElement, VariabilityInfo variabilityInfo, boolean bl, ElementRealizer elementRealizer) {
        List list;
        if (this.methodConfig == null) {
            return;
        }
        List list2 = ConfigurationHelper.getContributors(variabilityElement, this.methodConfig);
        if (list2 != null && list2.size() > 0) {
            for (VariabilityElement variabilityElement2 : list2) {
                list = variabilityInfo.getContributors();
                if (!list.contains(variabilityElement2)) {
                    list.add(variabilityElement2);
                }
                this.resolveElementVariabilityList(variabilityElement2, variabilityInfo, false, elementRealizer);
            }
        }
        if (ConfigurationHelper.isExtender(variabilityElement)) {
            VariabilityElement variabilityElement2;
            VariabilityElement variabilityElement3 = variabilityElement.getVariabilityBasedOnElement();
            variabilityElement2 = (VariabilityElement)ConfigurationHelper.getCalculatedElement((MethodElement)variabilityElement3, elementRealizer);
            if (bl && !(list = variabilityInfo.getInheritanceList()).contains(variabilityElement2)) {
                list.add(variabilityElement2);
            }
            this.resolveElementVariabilityList(variabilityElement2, variabilityInfo, bl, elementRealizer);
        }
    }

    public VariabilityInfo getVariabilityInfo(VariabilityElement variabilityElement) {
        DefaultElementRealizer defaultElementRealizer = new DefaultElementRealizer(this.methodConfig, true, true);
        return this.getVariabilityInfo(variabilityElement, defaultElementRealizer);
    }

    protected VariabilityInfo getVariabilityInfo(VariabilityElement variabilityElement, ElementRealizer elementRealizer) {
        VariabilityElement variabilityElement2 = (VariabilityElement)ConfigurationHelper.getCalculatedElement((MethodElement)variabilityElement, elementRealizer);
        if (variabilityElement2 == null) {
            return null;
        }
        VariabilityInfo variabilityInfo = new VariabilityInfo(variabilityElement);
        variabilityInfo.getInheritanceList().add(variabilityElement2);
        this.resolveElementVariabilityList(variabilityElement2, variabilityInfo, true, elementRealizer);
        return variabilityInfo;
    }

    public Object resolve(Object object) {
        if (object instanceof VariabilityElement) {
            DefaultElementRealizer defaultElementRealizer = new DefaultElementRealizer(this.methodConfig, true, true);
            return ConfigurationHelper.getCalculatedElement((MethodElement)object, defaultElementRealizer);
        }
        return object;
    }

    public IFilter getUncategorizedTaskFilter() {
        return new IFilter(){

            public boolean accept(Object object) {
                return object instanceof Task && ConfigurationHelper.calc0nFeatureValue((MethodElement)((Task)object), AssociationHelper.Task_Disciplines, (ElementRealizer)new DefaultElementRealizer(ConfigurationFilter.this.methodConfig)).isEmpty();
            }
        };
    }

    public IFilter getDomainUncategorizedWorkProductFilter() {
        return new IFilter(){

            public boolean accept(Object object) {
                return object instanceof WorkProduct && ConfigurationHelper.calc0nFeatureValue((MethodElement)((WorkProduct)object), AssociationHelper.WorkProduct_Domains, (ElementRealizer)new DefaultElementRealizer(ConfigurationFilter.this.methodConfig)).isEmpty();
            }
        };
    }

    public IFilter getWpTypeUncategorizedWorkProductFilter() {
        return new IFilter(){

            public boolean accept(Object object) {
                return object instanceof WorkProduct && ConfigurationHelper.calc0nFeatureValue((MethodElement)((WorkProduct)object), AssociationHelper.WorkProduct_WorkProductTypes, (ElementRealizer)new DefaultElementRealizer(ConfigurationFilter.this.methodConfig)).isEmpty();
            }
        };
    }

    public IFilter getUncategorizedRoleFilter() {
        return new IFilter(){

            public boolean accept(Object object) {
                return object instanceof Role && ConfigurationHelper.calc0nFeatureValue((MethodElement)((Role)object), AssociationHelper.Role_RoleSets, (ElementRealizer)new DefaultElementRealizer(ConfigurationFilter.this.methodConfig)).isEmpty();
            }
        };
    }

    public IFilter getUncategorizedToolMentorFilter() {
        return new IFilter(){

            public boolean accept(Object object) {
                return object instanceof ToolMentor && ConfigurationHelper.calc0nFeatureValue((MethodElement)((ToolMentor)object), AssociationHelper.ToolMentor_Tool, (ElementRealizer)new DefaultElementRealizer(ConfigurationFilter.this.methodConfig)).isEmpty();
            }
        };
    }

    public IFilter getDisciplinesFilter() {
        return new IFilter(){

            public boolean accept(Object object) {
                if (object instanceof DisciplineGrouping) {
                    return true;
                }
                return object instanceof Discipline && ConfigurationHelper.calc0nFeatureValue((MethodElement)object, AssociationHelper.Discipline_DisciplineGroupings, (ElementRealizer)new DefaultElementRealizer(ConfigurationFilter.this.methodConfig)).isEmpty();
            }
        };
    }

    public IFilter getRoleSetsFilter() {
        return new IFilter(){

            public boolean accept(Object object) {
                if (object instanceof RoleSetGrouping) {
                    return true;
                }
                return object instanceof RoleSet && ConfigurationHelper.calc0nFeatureValue((MethodElement)object, AssociationHelper.RoleSet_RoleSetGrouppings, (ElementRealizer)new DefaultElementRealizer(ConfigurationFilter.this.methodConfig)).isEmpty();
            }
        };
    }
}

