/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.layout.elements;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.edit.util.ConfigurableComposedAdapterFactory;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.layout.ElementLayoutManager;
import org.eclipse.epf.library.layout.IElementLayout;
import org.eclipse.epf.library.layout.elements.DescriptorLayout;
import org.eclipse.epf.library.layout.util.XmlElement;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.WorkProductDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskDescriptorLayout
extends DescriptorLayout {
    public static final Collection<EStructuralFeature> extraFeaturesFromTask = Arrays.asList(UmaPackage.eINSTANCE.getTask_ToolMentors());

    @Override
    public void init(ElementLayoutManager elementLayoutManager, MethodElement methodElement) {
        super.__init(elementLayoutManager, methodElement);
    }

    @Override
    public XmlElement getXmlElement(boolean bl) {
        return super.getXmlElement(bl);
    }

    @Override
    public void loadReferences(XmlElement xmlElement, boolean bl) {
        List list = LibraryUtil.getStructuralFeatures(this.element);
        if (list != null) {
            int n = 0;
            while (n < list.size()) {
                EStructuralFeature eStructuralFeature = (EStructuralFeature)list.get(n);
                if (eStructuralFeature == UmaPackage.eINSTANCE.getTaskDescriptor_SelectedSteps()) {
                    this.processSteps(xmlElement, bl);
                } else if (eStructuralFeature == UmaPackage.eINSTANCE.getWorkBreakdownElement_LinkToPredecessor()) {
                    super.loadWorkOrder(xmlElement);
                } else if (eStructuralFeature.getEType() instanceof EClass) {
                    this.loadFeature(eStructuralFeature, xmlElement, bl);
                }
                ++n;
            }
        }
        xmlElement.setAttribute("ShowFullMethodContent", this.layoutManager.getValidator().showExtraInfoForDescriptors() ? "true" : "false");
        if (this.elementLayout != null && this.layoutManager.getValidator().showExtraInfoForDescriptors()) {
            for (EStructuralFeature eStructuralFeature : this.getExtraFeaturesFromContentElement()) {
                this.elementLayout.loadFeature(eStructuralFeature, xmlElement, false);
            }
        }
    }

    private void processSteps(XmlElement xmlElement, boolean bl) {
        EReference eReference = UmaPackage.eINSTANCE.getTaskDescriptor_SelectedSteps();
        String string = eReference.getName();
        List list = ConfigurationHelper.calc0nFeatureValue(this.element, (EStructuralFeature)eReference, this.getLayoutMgr().getElementRealizer());
        XmlElement xmlElement2 = xmlElement.newChild("referenceList").setAttribute("name", string);
        if (list != null && list.size() > 0) {
            for (Object object : list) {
                IElementLayout iElementLayout;
                MethodElement methodElement;
                if (!(object instanceof MethodElement) || (object = ConfigurationHelper.getCalculatedElement(methodElement = (MethodElement)object, this.layoutManager.getConfiguration())) == null || (iElementLayout = this.layoutManager.getLayout(methodElement, true)) == null) continue;
                iElementLayout.setContentTarget(this.element);
                xmlElement2.addChild(iElementLayout.getXmlElement(ConfigurationHelper.isDescriptionElement(methodElement) ? true : bl));
            }
        }
    }

    @Override
    protected Collection<EStructuralFeature> getExtraFeaturesFromContentElement() {
        ArrayList<EStructuralFeature> arrayList = new ArrayList<EStructuralFeature>(extraFeaturesFromTask);
        arrayList.addAll(super.getExtraFeaturesFromContentElement());
        return arrayList;
    }

    @Override
    protected boolean isSuppressed(Suppression suppression, EStructuralFeature eStructuralFeature, Object object) {
        if (object instanceof RoleDescriptor || object instanceof WorkProductDescriptor) {
            ConfigurableComposedAdapterFactory configurableComposedAdapterFactory;
            String string = DescriptorLayout.makePath(this.elementProcessPath, (MethodElement)object);
            String[] stringArray = DescriptorLayout.getPathArray(string);
            Object object2 = suppression.getObjectByPath(stringArray, (AdapterFactory)(configurableComposedAdapterFactory = this.layoutManager.getCBSAdapterFactory()));
            if (object2 == null) {
                object2 = object;
            }
            return suppression.isSuppressed(object2, eStructuralFeature);
        }
        return super.isSuppressed(suppression, eStructuralFeature, object);
    }
}

