/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.core.actions;

import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.epf.diagram.core.DiagramCoreResources;
import org.eclipse.epf.diagram.core.commands.ChangeBoundsCommand;
import org.eclipse.epf.diagram.core.commands.ReconnectLinkCommand;
import org.eclipse.epf.diagram.core.util.DiagramCoreUtil;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeNodeEditPart;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;

public class DiagramActionsService {
    public static final String ALIGN_HORZ_AVERAGE = "align_horizontal_to_average";
    public static final String ALIGN_HORZ_FIRST_SELECTED = "align_horizontal_to_first_selection";
    public static final String ALIGN_VERT_AVERAGE = "align_vertical_to_average";
    public static final String ALIGN_VERT_FIRST_SELECTED = "align_vertical_to_first_selection";
    private DefaultEditDomain editDomain;
    private GraphicalViewer graphicalViewer;
    private ActionRegistry actionRegistry;
    private InternalTransactionalEditingDomain transactionDomain;

    public DiagramActionsService(InternalTransactionalEditingDomain internalTransactionalEditingDomain, GraphicalViewer graphicalViewer, DefaultEditDomain defaultEditDomain, ActionRegistry actionRegistry) {
        this.transactionDomain = internalTransactionalEditingDomain;
        this.graphicalViewer = graphicalViewer;
        this.editDomain = defaultEditDomain;
        this.actionRegistry = actionRegistry;
    }

    public void setGraphicalViewer(GraphicalViewer graphicalViewer) {
        this.graphicalViewer = graphicalViewer;
    }

    private GraphicalViewer getGraphicalViewer() {
        return this.graphicalViewer;
    }

    protected CommandStack getCommandStack() {
        return this.getEditDomain().getCommandStack();
    }

    protected DefaultEditDomain getEditDomain() {
        return this.editDomain;
    }

    protected ActionRegistry getActionRegistry() {
        return this.actionRegistry;
    }

    public IAction registerHorizontalAlignAverageAction() {
        Action action = new Action(DiagramCoreResources.AbstractDiagramEditor_hAlignAverageAction_text){

            public void run() {
                DiagramActionsService.this.horizAlignToAverageSelected();
            }

            public String getId() {
                return DiagramActionsService.ALIGN_HORZ_AVERAGE;
            }
        };
        this.getActionRegistry().registerAction((IAction)action);
        return action;
    }

    public IAction registerHorizontalAlignFirstSelectedAction() {
        Action action = new Action(DiagramCoreResources.AbstractDiagramEditor_hAlignFirstSelectedAction_text){

            public void run() {
                DiagramActionsService.this.horzAlignToFirstSelected();
            }

            public String getId() {
                return DiagramActionsService.ALIGN_HORZ_FIRST_SELECTED;
            }
        };
        this.getActionRegistry().registerAction((IAction)action);
        return action;
    }

    public IAction registerVerticalAlignAverageAction() {
        Action action = new Action(DiagramCoreResources.AbstractDiagramEditor_vAlignAverageAction_text){

            public void run() {
                DiagramActionsService.this.verticalAlignToAverageSelected();
            }

            public String getId() {
                return DiagramActionsService.ALIGN_VERT_AVERAGE;
            }
        };
        this.getActionRegistry().registerAction((IAction)action);
        return action;
    }

    public IAction registerVerticalAlignFirstSelectedAction() {
        Action action = new Action(DiagramCoreResources.AbstractDiagramEditor_vAlignFirstSelectedAction_text){

            public void run() {
                DiagramActionsService.this.verticalAlignToFirstSelected();
            }

            public String getId() {
                return DiagramActionsService.ALIGN_VERT_FIRST_SELECTED;
            }
        };
        this.getActionRegistry().registerAction((IAction)action);
        return action;
    }

    public void horzAlignToFirstSelected() {
        List list = this.getGraphicalViewer().getSelectedEditParts();
        AbstractGraphicalEditPart abstractGraphicalEditPart = null;
        int n = 0;
        while (n < list.size()) {
            if (list.get(n) instanceof ShapeNodeEditPart) {
                AbstractGraphicalEditPart abstractGraphicalEditPart2 = (AbstractGraphicalEditPart)list.get(n);
                if (abstractGraphicalEditPart == null) {
                    abstractGraphicalEditPart = abstractGraphicalEditPart2;
                } else {
                    Object object;
                    Rectangle rectangle = abstractGraphicalEditPart2.getFigure().getBounds();
                    int n2 = (int)((double)(rectangle.height - abstractGraphicalEditPart.getFigure().getBounds().height) / 2.0);
                    if (!(abstractGraphicalEditPart2.getParent() instanceof DiagramEditPart)) {
                        abstractGraphicalEditPart2 = (AbstractGraphicalEditPart)abstractGraphicalEditPart2.getParent();
                        object = abstractGraphicalEditPart2.getFigure().getBounds();
                        n2 += rectangle.y - object.y;
                        rectangle = object;
                    }
                    object = new ChangeBoundsCommand((TransactionalEditingDomain)this.transactionDomain, (View)((Node)abstractGraphicalEditPart2.getModel()), new Point(rectangle.x, abstractGraphicalEditPart.getFigure().getBounds().y - n2), rectangle.width, -1);
                    this.getCommandStack().execute((Command)object);
                }
            }
            ++n;
        }
    }

    public void horizAlignToAverageSelected() {
        List list = this.getGraphicalViewer().getSelectedEditParts();
        AbstractGraphicalEditPart abstractGraphicalEditPart = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < list.size()) {
            if (list.get(n3) instanceof ShapeNodeEditPart) {
                AbstractGraphicalEditPart abstractGraphicalEditPart2 = (AbstractGraphicalEditPart)list.get(n3);
                if (abstractGraphicalEditPart == null) {
                    abstractGraphicalEditPart = abstractGraphicalEditPart2;
                }
                n2 += abstractGraphicalEditPart2.getFigure().getBounds().y;
                ++n;
            }
            ++n3;
        }
        n3 = (int)((double)n2 / (double)n);
        int n4 = 0;
        while (n4 < list.size()) {
            if (list.get(n4) instanceof ShapeNodeEditPart) {
                Object object;
                AbstractGraphicalEditPart abstractGraphicalEditPart3 = (AbstractGraphicalEditPart)list.get(n4);
                Rectangle rectangle = abstractGraphicalEditPart3.getFigure().getBounds();
                int n5 = (int)((double)(rectangle.height - abstractGraphicalEditPart.getFigure().getBounds().height) / 2.0);
                if (!(abstractGraphicalEditPart3.getParent() instanceof DiagramEditPart)) {
                    abstractGraphicalEditPart3 = (AbstractGraphicalEditPart)abstractGraphicalEditPart3.getParent();
                    object = abstractGraphicalEditPart3.getFigure().getBounds();
                    n5 += rectangle.y - object.y;
                    rectangle = object;
                }
                object = new ChangeBoundsCommand((TransactionalEditingDomain)this.transactionDomain, (View)((Node)abstractGraphicalEditPart3.getModel()), new Point(rectangle.x, n3 - n5), rectangle.width, -1);
                this.getCommandStack().execute((Command)object);
            }
            ++n4;
        }
    }

    public void verticalAlignToAverageSelected() {
        List list = this.getGraphicalViewer().getSelectedEditParts();
        AbstractGraphicalEditPart abstractGraphicalEditPart = null;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < list.size()) {
            if (list.get(n3) instanceof ShapeNodeEditPart) {
                AbstractGraphicalEditPart abstractGraphicalEditPart2 = (AbstractGraphicalEditPart)list.get(n3);
                if (abstractGraphicalEditPart == null) {
                    abstractGraphicalEditPart = abstractGraphicalEditPart2;
                }
                n2 += abstractGraphicalEditPart2.getFigure().getBounds().x;
                ++n;
            }
            ++n3;
        }
        n3 = (int)((double)n2 / (double)n);
        int n4 = 0;
        while (n4 < list.size()) {
            if (list.get(n4) instanceof ShapeNodeEditPart) {
                Object object;
                AbstractGraphicalEditPart abstractGraphicalEditPart3 = (AbstractGraphicalEditPart)list.get(n4);
                Rectangle rectangle = abstractGraphicalEditPart3.getFigure().getBounds();
                int n5 = (int)((double)(rectangle.width - abstractGraphicalEditPart.getFigure().getBounds().width) / 2.0);
                if (!(abstractGraphicalEditPart3.getParent() instanceof DiagramEditPart)) {
                    abstractGraphicalEditPart3 = (AbstractGraphicalEditPart)abstractGraphicalEditPart3.getParent();
                    object = abstractGraphicalEditPart3.getFigure().getBounds();
                    n5 += rectangle.x - object.x;
                    rectangle = object;
                }
                object = new ChangeBoundsCommand((TransactionalEditingDomain)this.transactionDomain, (View)((Node)abstractGraphicalEditPart3.getModel()), new Point(n3 - n5, rectangle.y), rectangle.width, -1);
                this.getCommandStack().execute((Command)object);
            }
            ++n4;
        }
    }

    public void verticalAlignToFirstSelected() {
        AbstractGraphicalEditPart abstractGraphicalEditPart;
        List list = this.getGraphicalViewer().getSelectedEditParts();
        AbstractGraphicalEditPart abstractGraphicalEditPart2 = null;
        int n = 0;
        while (n < list.size()) {
            if (list.get(n) instanceof ShapeNodeEditPart) {
                abstractGraphicalEditPart = (AbstractGraphicalEditPart)list.get(n);
                if (abstractGraphicalEditPart2 == null) {
                    abstractGraphicalEditPart2 = abstractGraphicalEditPart;
                    break;
                }
            }
            ++n;
        }
        n = 0;
        while (n < list.size()) {
            if (list.get(n) instanceof ShapeNodeEditPart) {
                Command command;
                int n2;
                Point point;
                List list2;
                ConnectionNodeEditPart connectionNodeEditPart2;
                Point point2;
                int n3;
                Rectangle rectangle;
                abstractGraphicalEditPart = (AbstractGraphicalEditPart)list.get(n);
                if (abstractGraphicalEditPart != abstractGraphicalEditPart2 && !DiagramCoreUtil.isSyncBar((EditPart)abstractGraphicalEditPart2)) {
                    if (!DiagramCoreUtil.isSyncBar((EditPart)abstractGraphicalEditPart)) {
                        Object object;
                        rectangle = abstractGraphicalEditPart.getFigure().getBounds();
                        n3 = (int)((double)(rectangle.width - abstractGraphicalEditPart2.getFigure().getBounds().width) / 2.0);
                        if (!(abstractGraphicalEditPart.getParent() instanceof DiagramEditPart)) {
                            abstractGraphicalEditPart = (AbstractGraphicalEditPart)abstractGraphicalEditPart.getParent();
                            object = abstractGraphicalEditPart.getFigure().getBounds();
                            n3 += rectangle.x - object.x;
                            rectangle = object;
                        }
                        object = new ChangeBoundsCommand((TransactionalEditingDomain)this.transactionDomain, (View)((Node)abstractGraphicalEditPart.getModel()), new Point(abstractGraphicalEditPart2.getFigure().getBounds().x - n3, rectangle.y), rectangle.width, -1);
                        this.getCommandStack().execute((Command)object);
                        abstractGraphicalEditPart.getFigure().setLocation(new Point(abstractGraphicalEditPart2.getFigure().getBounds().x - n3, rectangle.y));
                    } else {
                        rectangle = abstractGraphicalEditPart.getFigure().getBounds().getCenter();
                        n3 = 0;
                        boolean bl = false;
                        point2 = null;
                        connectionNodeEditPart2 = null;
                        list2 = ((ShapeNodeEditPart)abstractGraphicalEditPart).getTargetConnections();
                        for (ConnectionNodeEditPart connectionNodeEditPart2 : list2) {
                            if (!connectionNodeEditPart2.getSource().equals(abstractGraphicalEditPart2)) continue;
                            n3 = 1;
                            break;
                        }
                        if (n3 == 0) {
                            list2 = ((ShapeNodeEditPart)abstractGraphicalEditPart).getSourceConnections();
                            for (ConnectionNodeEditPart connectionNodeEditPart2 : list2) {
                                if (!connectionNodeEditPart2.getTarget().equals(abstractGraphicalEditPart2)) continue;
                                n3 = 1;
                                bl = true;
                                break;
                            }
                        }
                        if (n3 != 0 && abstractGraphicalEditPart2 instanceof ShapeNodeEditPart) {
                            point = abstractGraphicalEditPart2.getFigure().getBounds().getCenter();
                            n2 = point.x - rectangle.x;
                            point2.x += n2;
                            command = new ReconnectLinkCommand(this.transactionDomain, (Edge)connectionNodeEditPart2.getModel(), (Node)abstractGraphicalEditPart.getModel(), bl);
                            command.setEndPoint(point2);
                            this.getCommandStack().execute(command);
                        }
                    }
                }
                if (abstractGraphicalEditPart != abstractGraphicalEditPart2 && !DiagramCoreUtil.isSyncBar((EditPart)abstractGraphicalEditPart2)) {
                    rectangle = abstractGraphicalEditPart2.getFigure().getBounds().getCenter();
                    n3 = 0;
                    List list3 = ((ShapeNodeEditPart)abstractGraphicalEditPart2).getSourceConnections();
                    for (ConnectionNodeEditPart connectionNodeEditPart2 : list3) {
                        if (!connectionNodeEditPart2.getTarget().equals(abstractGraphicalEditPart)) continue;
                        n3 = 1;
                        break;
                    }
                    if (n3 == 0) {
                        list3 = ((ShapeNodeEditPart)abstractGraphicalEditPart2).getTargetConnections();
                        for (ConnectionNodeEditPart connectionNodeEditPart2 : list3) {
                            if (!connectionNodeEditPart2.getSource().equals(abstractGraphicalEditPart)) continue;
                            n3 = 1;
                            break;
                        }
                    }
                    if (DiagramCoreUtil.isSyncBar((EditPart)abstractGraphicalEditPart)) {
                        point2 = new Point();
                        point2.x = (Integer)ViewUtil.getStructuralFeatureValue((View)((View)abstractGraphicalEditPart.getModel()), (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
                        point2.y = (Integer)ViewUtil.getStructuralFeatureValue((View)((View)abstractGraphicalEditPart.getModel()), (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
                        connectionNodeEditPart2 = point2.getCopy();
                        list2 = abstractGraphicalEditPart2.getFigure().getBounds().getCenter();
                        point = abstractGraphicalEditPart.getFigure().getBounds().getCenter();
                        n2 = ((Point)list2).x - point.x;
                        connectionNodeEditPart2.x += n2;
                        command = new ChangeBoundsCommand((TransactionalEditingDomain)this.transactionDomain, (View)((Node)abstractGraphicalEditPart.getModel()), (Point)connectionNodeEditPart2, abstractGraphicalEditPart.getFigure().getBounds().width, -1);
                        this.getCommandStack().execute(command);
                        abstractGraphicalEditPart.getFigure().setLocation(new Point(connectionNodeEditPart2.x, connectionNodeEditPart2.y));
                    } else if (abstractGraphicalEditPart instanceof ShapeNodeEditPart) {
                        point2 = new Point();
                        point2.x = (Integer)ViewUtil.getStructuralFeatureValue((View)((View)abstractGraphicalEditPart.getModel()), (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_X());
                        point2.y = (Integer)ViewUtil.getStructuralFeatureValue((View)((View)abstractGraphicalEditPart.getModel()), (EStructuralFeature)NotationPackage.eINSTANCE.getLocation_Y());
                        connectionNodeEditPart2 = point2.getCopy();
                        list2 = abstractGraphicalEditPart.getFigure().getBounds().getCenter();
                        int n4 = rectangle.x - ((Point)list2).x;
                        connectionNodeEditPart2.x += n4;
                        ChangeBoundsCommand changeBoundsCommand = new ChangeBoundsCommand((TransactionalEditingDomain)this.transactionDomain, (View)((Node)abstractGraphicalEditPart.getModel()), (Point)connectionNodeEditPart2, abstractGraphicalEditPart.getFigure().getBounds().width, -1);
                        this.getCommandStack().execute((Command)changeBoundsCommand);
                        abstractGraphicalEditPart.getFigure().setLocation(new Point(connectionNodeEditPart2.x, connectionNodeEditPart2.y));
                    }
                }
            }
            ++n;
        }
    }

    public void createAlignMenu(IMenuManager iMenuManager, boolean bl) {
        IContributionItem iContributionItem = iMenuManager.find("formatMenu");
        MenuManager menuManager = null;
        if (menuManager == null) {
            menuManager = new MenuManager(DiagramCoreResources.AbstractDiagramEditor_alignMenu_text){

                public boolean isEnabled() {
                    int n = 0;
                    List list = DiagramActionsService.this.graphicalViewer.getSelectedEditParts();
                    if (list.size() > 1) {
                        int n2 = 0;
                        while (n2 < list.size()) {
                            EditPart editPart = (EditPart)list.get(n2);
                            if (editPart instanceof ShapeNodeEditPart && ++n > 1) break;
                            ++n2;
                        }
                    }
                    return n > 1;
                }
            };
        }
        if (iContributionItem != null && iContributionItem instanceof IMenuManager && menuManager.isEnabled() && bl) {
            IContributionItem iContributionItem2 = ((IMenuManager)iContributionItem).find("alignMenu");
            if (iContributionItem2 != null && iContributionItem2 instanceof IMenuManager) {
                IMenuManager iMenuManager2 = (IMenuManager)iContributionItem2;
                iMenuManager2.add(this.getActionRegistry().getAction((Object)ALIGN_HORZ_AVERAGE));
                iMenuManager2.add(this.getActionRegistry().getAction((Object)ALIGN_HORZ_FIRST_SELECTED));
                iMenuManager2.add(this.getActionRegistry().getAction((Object)ALIGN_VERT_AVERAGE));
                iMenuManager2.add(this.getActionRegistry().getAction((Object)ALIGN_VERT_FIRST_SELECTED));
            }
        } else {
            menuManager.add(this.getActionRegistry().getAction((Object)ALIGN_HORZ_AVERAGE));
            menuManager.add(this.getActionRegistry().getAction((Object)ALIGN_HORZ_FIRST_SELECTED));
            menuManager.add(this.getActionRegistry().getAction((Object)ALIGN_VERT_AVERAGE));
            menuManager.add(this.getActionRegistry().getAction((Object)ALIGN_VERT_FIRST_SELECTED));
            if (menuManager.isEnabled() && bl) {
                iMenuManager.appendToGroup("additions", (IContributionItem)new Separator());
                iMenuManager.appendToGroup("additions", (IContributionItem)menuManager);
                iMenuManager.appendToGroup("additions", (IContributionItem)new Separator());
            }
        }
    }
}

