/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.core.bridge;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.diagram.core.bridge.BridgeHelper;
import org.eclipse.epf.diagram.model.util.TxUtil;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.WorkBreakdownElement;
import org.eclipse.epf.uma.WorkOrder;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.gmf.runtime.notation.FontStyle;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.ActivityNode;
import org.eclipse.uml2.uml.ControlFlow;
import org.eclipse.uml2.uml.ControlNode;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;

public class NodeAdapter
extends AdapterImpl {
    protected MethodElement element;
    protected boolean notificationEnabled = true;
    private Collection consumers = new ArrayList();
    protected MethodElementAdapter methodElementAdapter;
    private boolean targetReadOnly;
    protected BreakdownElementWrapperItemProvider wrapper;
    protected InternalTransactionalEditingDomain domain;
    private View view;
    protected IActionManager actionManager;

    protected NodeAdapter() {
    }

    public IActionManager getActionManager() {
        if (this.actionManager != null) {
            return this.actionManager;
        }
        NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter((EObject)this.getNode().getActivity());
        return nodeAdapter.getActionManager();
    }

    public NodeAdapter(BreakdownElementWrapperItemProvider breakdownElementWrapperItemProvider) {
        this((MethodElement)TngUtil.unwrap((Object)breakdownElementWrapperItemProvider));
        this.wrapper = breakdownElementWrapperItemProvider;
        this.targetReadOnly = breakdownElementWrapperItemProvider.isReadOnly();
    }

    public NodeAdapter(MethodElement methodElement) {
        this.element = methodElement;
        this.methodElementAdapter = this.createMethodElementAdapter();
        methodElement.eAdapters().add((Object)this.methodElementAdapter);
    }

    public View getView() {
        if (this.view != null) {
            return this.view;
        }
        View view = this.getDiagramView();
        if (view != null) {
            return BridgeHelper.getView(view, this.getNode());
        }
        return null;
    }

    private View getDiagramView() {
        NodeAdapter nodeAdapter;
        Activity activity = this.getDiagram();
        if (activity != null && (nodeAdapter = BridgeHelper.getNodeAdapter((EObject)activity)) != null) {
            return nodeAdapter.getView();
        }
        return null;
    }

    public void setView(View view) {
        this.view = view;
    }

    public void setEditingDomain(InternalTransactionalEditingDomain internalTransactionalEditingDomain) {
        this.domain = internalTransactionalEditingDomain;
    }

    public boolean isTargetReadOnly() {
        NodeAdapter nodeAdapter;
        if (this.targetReadOnly) {
            return this.targetReadOnly;
        }
        Activity activity = this.getDiagram();
        return activity != this.target && (nodeAdapter = BridgeHelper.getNodeAdapter((EObject)activity)) != null && nodeAdapter.isTargetReadOnly();
    }

    protected void basicSetTargetReadOnly(boolean bl) {
        this.targetReadOnly = bl;
    }

    protected void setTargetReadOnly(boolean bl) {
        boolean bl2 = this.targetReadOnly ^ bl;
        this.targetReadOnly = bl;
        if (bl2) {
            this.updateView();
        }
    }

    protected void updateView() {
        FontStyle fontStyle;
        View view = this.getView();
        if (view != null && (fontStyle = (FontStyle)view.getStyle(NotationPackage.Literals.FONT_STYLE)) == null) {
            view.createStyle(NotationPackage.Literals.FONT_STYLE);
        }
    }

    protected MethodElementAdapter createMethodElementAdapter() {
        return new MethodElementAdapter();
    }

    protected ActivityNode getNode() {
        if (this.target instanceof ActivityNode) {
            return (ActivityNode)this.target;
        }
        return null;
    }

    protected Activity getDiagram() {
        if (this.target instanceof Activity) {
            return (Activity)this.target;
        }
        ActivityNode activityNode = this.getNode();
        return activityNode != null ? activityNode.getActivity() : null;
    }

    protected ActivityEdge addIncomingConnection(MethodElement methodElement) {
        ActivityNode activityNode = BridgeHelper.findNode(this.getDiagram(), methodElement, true);
        if (activityNode == null) {
            return null;
        }
        NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter((EObject)activityNode);
        boolean bl = nodeAdapter != null ? nodeAdapter.notificationEnabled : false;
        try {
            if (nodeAdapter != null) {
                nodeAdapter.notificationEnabled = false;
            }
            ControlFlow controlFlow = UMLFactory.eINSTANCE.createControlFlow();
            controlFlow.setSource(activityNode);
            controlFlow.setTarget(this.getNode());
            this.getDiagram().getEdges().add((Object)controlFlow);
            ControlFlow controlFlow2 = controlFlow;
            return controlFlow2;
        }
        finally {
            if (nodeAdapter != null) {
                nodeAdapter.notificationEnabled = bl;
            }
        }
    }

    protected ActivityEdge addOutgoingConnection(MethodElement methodElement) {
        ActivityNode activityNode = BridgeHelper.findNode(this.getDiagram(), methodElement);
        if (activityNode == null) {
            return null;
        }
        NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter((EObject)activityNode);
        boolean bl = nodeAdapter != null ? nodeAdapter.notificationEnabled : false;
        try {
            if (nodeAdapter != null) {
                nodeAdapter.notificationEnabled = false;
            }
            ActivityEdge activityEdge = this.getDiagram().createEdge("", UMLPackage.Literals.CONTROL_FLOW);
            activityEdge.setSource(this.getNode());
            activityEdge.setTarget(activityNode);
            ActivityEdge activityEdge2 = activityEdge;
            return activityEdge2;
        }
        finally {
            if (nodeAdapter != null) {
                nodeAdapter.notificationEnabled = bl;
            }
        }
    }

    public void addConsumer(Object object) {
        if (!this.consumers.contains(object)) {
            this.consumers.add(object);
        }
    }

    public void removeConsumer(Object object) {
        this.consumers.remove(object);
        if (this.consumers.isEmpty()) {
            this.dispose();
        }
    }

    public void dispose() {
        this.domain = null;
        MethodElement methodElement = this.element;
        if (methodElement != null && this.methodElementAdapter != null) {
            methodElement.eAdapters().remove((Object)this.methodElementAdapter);
        }
        if (this.target != null) {
            this.target.eAdapters().remove((Object)this);
        }
        this.element = null;
    }

    public void setName(String string) {
        ActivityNode activityNode = this.getNode();
        if (activityNode != null) {
            activityNode.setName(string);
        }
    }

    protected void handleNotification(Notification notification) {
        block25: {
            block0 : switch (notification.getFeatureID(ActivityNode.class)) {
                case 4: {
                    if (notification.getEventType() == 1 && this.getElement() instanceof BreakdownElement) {
                        String string = notification.getNewStringValue();
                        BreakdownElement breakdownElement = (BreakdownElement)this.getElement();
                        breakdownElement.setPresentationName(string);
                        if (StrUtil.isBlank((String)breakdownElement.getName())) {
                            breakdownElement.setName(string);
                        }
                    }
                    return;
                }
                case 16: {
                    switch (notification.getEventType()) {
                        case 3: {
                            ActivityEdge activityEdge = (ActivityEdge)notification.getNewValue();
                            this.addToUMA(activityEdge);
                            return;
                        }
                        case 5: {
                            Iterator iterator = ((Collection)notification.getNewValue()).iterator();
                            while (iterator.hasNext()) {
                                this.addToUMA((ActivityEdge)iterator.next());
                            }
                            break;
                        }
                        case 4: {
                            NodeAdapter nodeAdapter;
                            ActivityEdge activityEdge = (ActivityEdge)notification.getOldValue();
                            if (activityEdge.getSource() == null || (nodeAdapter = BridgeHelper.getNodeAdapter((EObject)activityEdge.getSource())) == null) break;
                            nodeAdapter.removeFromUMA(activityEdge, activityEdge.getSource(), (ActivityNode)notification.getNotifier());
                            break;
                        }
                        case 6: {
                            for (ActivityEdge activityEdge : (Collection)notification.getOldValue()) {
                                NodeAdapter nodeAdapter;
                                if (activityEdge.getSource() == null || (nodeAdapter = BridgeHelper.getNodeAdapter((EObject)activityEdge.getSource())) == null) continue;
                                nodeAdapter.removeFromUMA(activityEdge, activityEdge.getSource(), (ActivityNode)notification.getNotifier());
                            }
                            break;
                        }
                    }
                    return;
                }
                case 15: {
                    switch (notification.getEventType()) {
                        case 3: {
                            NodeAdapter nodeAdapter;
                            ActivityEdge activityEdge = (ActivityEdge)notification.getNewValue();
                            if (activityEdge.getTarget() != null && (nodeAdapter = BridgeHelper.getNodeAdapter((EObject)activityEdge.getTarget())) != null) {
                                nodeAdapter.addToUMA(activityEdge);
                                break block0;
                            }
                            break block25;
                        }
                        case 5: {
                            for (ActivityEdge activityEdge : (Collection)notification.getNewValue()) {
                                NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter((EObject)activityEdge.getTarget());
                                if (nodeAdapter == null) continue;
                                nodeAdapter.addToUMA(activityEdge);
                            }
                            break block25;
                        }
                        case 4: {
                            ActivityEdge activityEdge = (ActivityEdge)notification.getOldValue();
                            if (activityEdge.getTarget() != null) {
                                this.removeFromUMA(activityEdge, (ActivityNode)notification.getNotifier(), activityEdge.getTarget());
                                break block0;
                            }
                            break block25;
                        }
                        case 6: {
                            for (ActivityEdge activityEdge : (Collection)notification.getOldValue()) {
                                if (activityEdge.getTarget() == null) continue;
                                this.removeFromUMA(activityEdge, (ActivityNode)notification.getNotifier(), activityEdge.getTarget());
                            }
                        }
                    }
                }
            }
        }
    }

    public void notifyChanged(Notification notification) {
        if (!this.notificationEnabled) {
            return;
        }
        this.notificationEnabled = false;
        try {
            this.handleNotification(notification);
        }
        finally {
            this.notificationEnabled = true;
        }
    }

    protected void addToUmaModel(int n, ActivityNode activityNode) {
    }

    protected void nodeAdded(int n, ActivityNode activityNode) {
        NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter((EObject)activityNode);
        if (nodeAdapter == null) {
            nodeAdapter = this.addNodeAdapterTo(activityNode);
        }
        this.addToUmaModel(n, activityNode);
        if (nodeAdapter != null) {
            nodeAdapter.addConsumer((Object)this);
        }
    }

    protected NodeAdapter addNodeAdapterTo(ActivityNode activityNode) {
        return null;
    }

    protected void removeFromUmaModel(ActivityNode activityNode) {
    }

    protected void nodeRemoved(ActivityNode activityNode) {
        this.removeFromUmaModel(activityNode);
        NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter((EObject)activityNode);
        if (nodeAdapter != null) {
            nodeAdapter.removeConsumer((Object)this);
        }
    }

    protected boolean addToUMA(ActivityEdge activityEdge) {
        return activityEdge.getTarget() != null && activityEdge.getSource() != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void removeFromUMA(ActivityEdge activityEdge, ActivityNode activityNode, ActivityNode activityNode2) {
        MethodElement methodElement = BridgeHelper.getMethodElement((EModelElement)activityNode2);
        if (methodElement instanceof WorkBreakdownElement) {
            NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter((EObject)activityNode2);
            boolean bl = nodeAdapter != null ? nodeAdapter.notificationEnabled : false;
            try {
                WorkBreakdownElement workBreakdownElement;
                Collection collection;
                MethodElement methodElement2;
                if (nodeAdapter != null) {
                    nodeAdapter.notificationEnabled = false;
                }
                if (!BridgeHelper.canRemoveAllPreds(activityEdge, activityNode, activityNode2) || !((methodElement2 = BridgeHelper.getMethodElement((EModelElement)activityNode)) instanceof WorkBreakdownElement) || (collection = UmaUtil.findWorkOrder((WorkBreakdownElement)(workBreakdownElement = (WorkBreakdownElement)BridgeHelper.getMethodElement((EModelElement)activityNode2)), (WorkBreakdownElement)((WorkBreakdownElement)methodElement2), (boolean)true)).isEmpty()) return;
                this.getActionManager().doAction(6, (EObject)workBreakdownElement, (EStructuralFeature)UmaPackage.Literals.WORK_BREAKDOWN_ELEMENT__LINK_TO_PREDECESSOR, (Object)collection, -1);
                return;
            }
            finally {
                if (nodeAdapter != null) {
                    nodeAdapter.notificationEnabled = bl;
                }
            }
        } else {
            if (!(activityNode2 instanceof ControlNode) || !BridgeHelper.isSynchBar(activityNode2)) return;
            ArrayList<ActivityNode> arrayList = new ArrayList<ActivityNode>();
            BridgeHelper.getSuccessorNodes(arrayList, activityNode2);
            for (ActivityNode activityNode3 : arrayList) {
                WorkBreakdownElement workBreakdownElement = (WorkBreakdownElement)BridgeHelper.getMethodElement((EModelElement)activityNode3);
                NodeAdapter nodeAdapter = BridgeHelper.getNodeAdapter((EObject)activityNode3);
                boolean bl = nodeAdapter != null ? nodeAdapter.notificationEnabled : false;
                try {
                    WorkOrder workOrder;
                    if (nodeAdapter != null) {
                        nodeAdapter.notificationEnabled = false;
                    }
                    if (!BridgeHelper.canRemoveAllPreds(activityEdge, activityNode, activityNode3)) continue;
                    while ((workOrder = UmaUtil.findWorkOrder((WorkBreakdownElement)workBreakdownElement, (Object)BridgeHelper.getMethodElement((EModelElement)activityNode))) != null) {
                        this.getActionManager().doAction(4, (EObject)workBreakdownElement, (EStructuralFeature)UmaPackage.Literals.WORK_BREAKDOWN_ELEMENT__LINK_TO_PREDECESSOR, (Object)workOrder, -1);
                    }
                }
                finally {
                    if (nodeAdapter != null) {
                        nodeAdapter.notificationEnabled = bl;
                    }
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public WorkOrder addDefaultWorkOrder(ActivityNode var1_1, WorkBreakdownElement var2_2) {
        var3_3 = BridgeHelper.getNodeAdapter((EObject)var1_1);
        var4_4 = var3_3.notificationEnabled;
        var5_5 = new HashMap<NodeAdapter, Boolean>();
        var6_6 = var3_3.getElement();
        var7_7 = var6_6.eAdapters();
        for (E var9_9 : var7_7) {
            if (!(var9_9 instanceof MethodElementAdapter)) continue;
            var10_11 = ((MethodElementAdapter)var9_9).getNodeAdapter();
            var11_12 = var3_3.notificationEnabled;
            var10_11.notificationEnabled = false;
            var5_5.put(var10_11, new Boolean(var11_12));
        }
        try {
            var3_3.notificationEnabled = false;
            var8_8 = UmaUtil.createDefaultWorkOrder((WorkBreakdownElement)((WorkBreakdownElement)var6_6), (WorkBreakdownElement)var2_2, (boolean)false);
            this.getActionManager().doAction(3, (EObject)var6_6, (EStructuralFeature)UmaPackage.Literals.WORK_BREAKDOWN_ELEMENT__LINK_TO_PREDECESSOR, (Object)var8_8, -1);
            var10_11 = var8_8;
            return var10_11;
        }
        finally {
            var3_3.setNotificationEnabled(var4_4);
            var11_13 = var5_5.keySet();
            ** for (var13_17 : var11_13)
        }
lbl-1000:
        // 1 sources

        {
            var14_19 = var5_5.get(var13_17);
            if (!(var14_19 instanceof Boolean)) continue;
            ((NodeAdapter)var13_17).notificationEnabled = var15_21 = ((Boolean)var14_19).booleanValue();
            continue;
        }
lbl29:
        // 1 sources

        return var10_11;
    }

    public void setNotificationEnabled(boolean bl) {
        this.notificationEnabled = bl;
    }

    public boolean isNotificationEnabled() {
        return this.notificationEnabled;
    }

    public MethodElement getElement() {
        return this.element;
    }

    public void setTarget(Notifier notifier) {
        if (notifier == null) {
            this.dispose();
        }
        super.setTarget(notifier);
    }

    public BreakdownElementWrapperItemProvider getWrapper() {
        return this.wrapper;
    }

    protected class MethodElementAdapter
    extends AdapterImpl {
        protected MethodElementAdapter() {
        }

        protected Collection handleNotification(Notification notification) {
            switch (notification.getFeatureID(DescribableElement.class)) {
                case 7: {
                    NodeAdapter.this.setName(notification.getNewStringValue());
                }
            }
            return Collections.EMPTY_LIST;
        }

        public void notifyChanged(final Notification notification) {
            if (NodeAdapter.this.domain == null || NodeAdapter.this.domain.getChangeRecorder() == null) {
                return;
            }
            if (!NodeAdapter.this.notificationEnabled) {
                return;
            }
            NodeAdapter.this.notificationEnabled = false;
            try {
                try {
                    final ArrayList arrayList = new ArrayList();
                    TxUtil.runInTransaction((TransactionalEditingDomain)NodeAdapter.this.domain, (Runnable)new Runnable(){

                        public void run() {
                            arrayList.addAll(MethodElementAdapter.this.handleNotification(notification));
                        }
                    });
                    if (!arrayList.isEmpty()) {
                        TxUtil.runInTransaction((TransactionalEditingDomain)NodeAdapter.this.domain, (Runnable)new Runnable(){

                            public void run() {
                                for (ActivityNode activityNode : arrayList) {
                                    BridgeHelper.getNodeAdapter((EObject)activityNode).updateView();
                                }
                            }
                        });
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    NodeAdapter.this.notificationEnabled = true;
                }
            }
            finally {
                NodeAdapter.this.notificationEnabled = true;
            }
        }

        public NodeAdapter getNodeAdapter() {
            return NodeAdapter.this;
        }
    }
}

