/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.core.services;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.epf.common.CommonPlugin;
import org.eclipse.epf.diagram.core.DiagramCorePlugin;
import org.eclipse.epf.diagram.core.DiagramCoreResources;
import org.eclipse.epf.diagram.core.bridge.BridgeHelper;
import org.eclipse.epf.diagram.core.services.DiagramManager;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.epf.diagram.model.util.TxUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.persistence.FileManager;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.services.Services;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.gmf.runtime.diagram.core.DiagramEditingDomainFactory;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.uml.Activity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagramHelper {
    public static final int[] DIAGRAM_TYPES;

    static {
        int[] nArray = new int[3];
        nArray[1] = 2;
        nArray[2] = 1;
        DIAGRAM_TYPES = nArray;
    }

    public static int getDiagramType(Diagram diagram) {
        String string = diagram.getType();
        if (string.equals("AD")) {
            return 0;
        }
        if (string.equals("ADD")) {
            return 2;
        }
        if (string.equals("WPDD")) {
            return 1;
        }
        return -1;
    }

    public static org.eclipse.gmf.runtime.notation.Node findNode(Diagram diagram, Object object) {
        if (object == null) {
            return null;
        }
        for (View view : diagram.getChildren()) {
            if (!(view instanceof org.eclipse.gmf.runtime.notation.Node) || view.getElement() == null) continue;
            EObject eObject = null;
            if (object instanceof MethodElement && view.getElement() instanceof EModelElement) {
                Resource resource;
                EModelElement eModelElement = (EModelElement)view.getElement();
                eObject = BridgeHelper.getMethodElement(eModelElement);
                if (eObject == null && (resource = ((MethodElement)object).eResource()).getResourceSet() != null) {
                    eObject = BridgeHelper.getMethodElementFromAnnotation(eModelElement, resource.getResourceSet());
                }
            } else {
                eObject = view.getElement();
            }
            if (!object.equals(eObject)) continue;
            return (org.eclipse.gmf.runtime.notation.Node)view;
        }
        return null;
    }

    public static org.eclipse.gmf.runtime.notation.Node findNodeInModelDiagram(Diagram diagram, MethodElement methodElement) {
        for (View view : diagram.getChildren()) {
            if (!(view instanceof org.eclipse.gmf.runtime.notation.Node)) continue;
            MethodElement methodElement2 = null;
            EObject eObject = view.getElement();
            if (!(eObject instanceof Node) || (methodElement2 = ((Node)eObject).getLinkedElement()) == null || methodElement2 != methodElement) continue;
            return (org.eclipse.gmf.runtime.notation.Node)view;
        }
        return null;
    }

    public static void deleteDiagram(Diagram diagram, boolean bl) throws Exception {
        Object object;
        if (diagram == null) {
            return;
        }
        boolean bl2 = true;
        File file = null;
        MethodElement methodElement = null;
        Process process = null;
        if (diagram.getElement() instanceof Activity) {
            object = BridgeHelper.getDiagramAdapter(diagram.getElement());
            if (object != null && (methodElement = object.getWrapper()) == null) {
                methodElement = object.getElement();
            }
        } else {
            object = (org.eclipse.epf.diagram.model.Diagram)diagram.getElement();
            methodElement = object.getLinkedElement();
        }
        if (methodElement != null && !(file = new File((String)(object = DiagramManager.getDiagramFilePath(process = TngUtil.getOwningProcess((Object)methodElement))))).exists()) {
            bl2 = false;
        }
        object = diagram.eResource();
        if (file == null && object != null && !(file = new File(FileManager.toFileString((URI)object.getURI()))).exists()) {
            bl2 = false;
        }
        if (object != null) {
            TxUtil.runInTransaction((EObject)diagram, (Runnable)new Runnable((Resource)object, diagram){
                private final /* synthetic */ Resource val$resource;
                private final /* synthetic */ Diagram val$diagram;
                {
                    this.val$resource = resource;
                    this.val$diagram = diagram;
                }

                public void run() {
                    this.val$resource.getContents().remove((Object)this.val$diagram.getElement());
                    this.val$resource.getContents().remove((Object)this.val$diagram);
                    UmaUtil.removeAllAdapters((EObject)this.val$diagram.getElement());
                    UmaUtil.removeAllAdapters((EObject)this.val$diagram);
                }
            });
            if (!bl2) {
                return;
            }
            if (bl) {
                ILibraryPersister.FailSafeMethodLibraryPersister failSafeMethodLibraryPersister = Services.getLibraryPersister((String)"xmi").getFailSafePersister();
                try {
                    failSafeMethodLibraryPersister.save((Resource)object);
                    failSafeMethodLibraryPersister.commit();
                }
                catch (Exception exception) {
                    CommonPlugin.getDefault().getLogger().logError((Throwable)exception);
                    failSafeMethodLibraryPersister.rollback();
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.epf.diagram.core", 1, exception.getLocalizedMessage(), null));
                }
            }
        }
    }

    public static InternalTransactionalEditingDomain getEditingDomain() {
        return (InternalTransactionalEditingDomain)DiagramEditingDomainFactory.getInstance().createEditingDomain();
    }

    public static InternalTransactionalEditingDomain getEditingDomain(Diagram diagram) {
        if (diagram == null) {
            return DiagramHelper.getEditingDomain();
        }
        Resource resource = diagram.eResource();
        if (resource == null) {
            return DiagramHelper.getEditingDomain();
        }
        return (InternalTransactionalEditingDomain)DiagramEditingDomainFactory.getInstance().getEditingDomain(resource.getResourceSet());
    }

    public static Collection<Diagram> getDiagrams(org.eclipse.epf.uma.Activity activity, DiagramManager diagramManager) {
        try {
            ArrayList<Diagram> arrayList = new ArrayList<Diagram>();
            int n = 0;
            while (n < DIAGRAM_TYPES.length) {
                List<Diagram> list = diagramManager.getDiagrams(activity, DIAGRAM_TYPES[n]);
                if (!list.isEmpty()) {
                    arrayList.addAll(list);
                }
                ++n;
            }
            return arrayList;
        }
        catch (Exception exception) {
            DiagramCorePlugin.getDefault().getLogger().logError((Throwable)exception);
            return Collections.emptyList();
        }
    }

    public static String getDiagramTypeString(Diagram diagram) {
        String string = diagram.getType();
        if (string.equals("AD")) {
            return DiagramCoreResources.ActivityDiagram_kind;
        }
        if (string.equals("ADD")) {
            return DiagramCoreResources.ActivityDetail_Diagram_kind;
        }
        if (string.equals("WPDD")) {
            return DiagramCoreResources.WorkProductDependency_Diagram_kind;
        }
        return "";
    }

    public static Diagram copyDiagram(EditingDomain editingDomain, Diagram diagram) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(diagram.getElement());
        arrayList.add(diagram);
        Command command = CopyCommand.create((EditingDomain)editingDomain, arrayList);
        command.execute();
        for (Object e : command.getResult()) {
            if (!(e instanceof Diagram)) continue;
            Diagram diagram2 = (Diagram)e;
            return diagram2;
        }
        return null;
    }

    public static void reassociate(org.eclipse.epf.uma.Activity activity, Diagram diagram) {
        for (Object e : activity.getBreakdownElements()) {
            org.eclipse.gmf.runtime.notation.Node node;
            VariabilityElement variabilityElement;
            if (!(e instanceof org.eclipse.epf.uma.Activity) || (variabilityElement = ((org.eclipse.epf.uma.Activity)e).getVariabilityBasedOnElement()) == null || (node = DiagramHelper.findNode(diagram, variabilityElement)) == null) continue;
            EObject eObject = node.getElement();
            BridgeHelper.addEAnnotation((EModelElement)eObject, (MethodElement)e);
        }
    }
}

