/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.epf.diagram.model.ActivityDiagram;
import org.eclipse.epf.diagram.model.Link;
import org.eclipse.epf.diagram.model.LinkedObject;
import org.eclipse.epf.diagram.model.ModelFactory;
import org.eclipse.epf.diagram.model.ModelPackage;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.epf.diagram.model.NodeContainer;
import org.eclipse.epf.diagram.model.TypedNode;
import org.eclipse.epf.diagram.model.impl.DiagramImpl;
import org.eclipse.epf.diagram.model.impl.NamedNodeImpl;
import org.eclipse.epf.diagram.model.impl.NodeImpl;
import org.eclipse.epf.diagram.model.util.GraphicalDataHelper;
import org.eclipse.epf.diagram.model.util.IActivityDiagramChangeListener;
import org.eclipse.epf.diagram.model.util.IAdapterFactoryFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.process.ActivityWrapperItemProvider;
import org.eclipse.epf.library.edit.process.BSActivityItemProvider;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.process.WBSActivityItemProvider;
import org.eclipse.epf.library.edit.util.ConfigurableComposedAdapterFactory;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Diagram;
import org.eclipse.epf.uma.GraphEdge;
import org.eclipse.epf.uma.GraphNode;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.SemanticModelBridge;
import org.eclipse.epf.uma.SimpleSemanticModelElement;
import org.eclipse.epf.uma.UMASemanticModelBridge;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.WorkBreakdownElement;
import org.eclipse.epf.uma.WorkOrder;

public class ActivityDiagramImpl
extends DiagramImpl
implements ActivityDiagram {
    protected ActivityDiagramImpl() {
        this.diagramChangeListener = new ActivityDiagramChangeListener();
    }

    protected Class getDiagramChangeListenerType() {
        return IActivityDiagramChangeListener.class;
    }

    protected EClass eStaticClass() {
        return ModelPackage.Literals.ACTIVITY_DIAGRAM;
    }

    protected void populateNodes() {
        Diagram diagram = this.getUMADiagram();
        ArrayList<TypedNode> arrayList = new ArrayList<TypedNode>();
        for (Object e : diagram.getContained()) {
            int n = ActivityDiagramImpl.getType(e);
            if (n <= 0) continue;
            TypedNode typedNode = ModelFactory.eINSTANCE.createTypedNode();
            typedNode.setType(n);
            typedNode.setObject(e);
            arrayList.add(typedNode);
        }
        this.getNodes().addAll(arrayList);
        this.addElementNodes();
    }

    private static boolean isValidWorkOrder(WorkOrder workOrder, Object object) {
        if (workOrder.getPred() == object) {
            return true;
        }
        if (object instanceof Activity) {
            Activity activity = (Activity)object;
            VariabilityElement variabilityElement = activity.getVariabilityBasedOnElement();
            while (variabilityElement != null) {
                if (variabilityElement == workOrder.getPred()) {
                    return true;
                }
                variabilityElement = variabilityElement.getVariabilityBasedOnElement();
            }
        }
        return false;
    }

    private boolean isValid(Link link) {
        return link.getSource() != null && link.getTarget() != null && this.getNodes().contains((Object)link.getSource()) && this.getNodes().contains((Object)link.getTarget());
    }

    protected void populateLinks() {
        ArrayList<Link> arrayList;
        super.populateLinks();
        for (Object object : this.getNodes()) {
            Object object2 = null;
            if (object.getObject() instanceof WorkBreakdownElement) {
                object2 = (WorkBreakdownElement)object.getObject();
            }
            arrayList = new ArrayList<Link>();
            for (Link link : object.getIncomingConnections()) {
                if (!this.isValid(link)) {
                    arrayList.add(link);
                }
                if (object2 == null || link.getSource() instanceof TypedNode) continue;
                Iterator iterator = link.getSource().getObject();
                boolean bl = false;
                for (WorkOrder workOrder : object2.getLinkToPredecessor()) {
                    if (!ActivityDiagramImpl.isValidWorkOrder(workOrder, iterator)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                arrayList.add(link);
            }
            for (Link link : arrayList) {
                GraphicalDataHelper.removeLink(link);
            }
            arrayList.clear();
            for (Link link : object.getOutgoingConnections()) {
                if (this.isValid(link)) continue;
                arrayList.add(link);
            }
            for (Link link : arrayList) {
                GraphicalDataHelper.removeLink(link);
            }
            arrayList.clear();
            arrayList = null;
        }
        Iterator iterator = this.getAdapterFactory();
        for (Object object2 : this.getNodes()) {
            Link link;
            if (!(object2.getObject() instanceof WorkBreakdownElement)) continue;
            arrayList = new ArrayList();
            WorkBreakdownElement workBreakdownElement = (WorkBreakdownElement)object2.getObject();
            arrayList.addAll(workBreakdownElement.getLinkToPredecessor());
            link = null;
            link = (ITreeItemContentProvider)iterator.adapt((Notifier)workBreakdownElement, ITreeItemContentProvider.class);
            if (link instanceof IBSItemProvider) {
                arrayList.addAll((Collection<Link>)((IBSItemProvider)link).getPredecessors());
            }
            for (Object e : arrayList) {
                LinkedObject linkedObject2;
                Node node;
                WorkOrder workOrder;
                WorkOrder workOrder2 = null;
                workOrder = null;
                if (e instanceof WorkOrder) {
                    workOrder2 = (WorkOrder)e;
                    workOrder = workOrder2.getPred();
                }
                if (e instanceof WBSActivityItemProvider) {
                    workOrder = (BreakdownElement)((WBSActivityItemProvider)e).getTarget();
                }
                if (workOrder == null || !(workOrder instanceof WorkBreakdownElement) || (node = GraphicalDataHelper.findNode((NodeContainer)this, (Object)workOrder, true)) == null) continue;
                boolean bl = false;
                for (LinkedObject linkedObject2 : object2.getIncomingConnections()) {
                    if (linkedObject2.getSource() != node) continue;
                    bl = true;
                    GraphEdge graphEdge = (GraphEdge)linkedObject2.getObject();
                    if (graphEdge.getSemanticModel() != null) break;
                    GraphicalDataHelper.setSemanticModel(linkedObject2, workOrder2);
                    break;
                }
                if (bl || ActivityDiagramImpl.canReachAsFirstActivityNode(node, (Node)object2)) continue;
                NamedNodeImpl namedNodeImpl = (NamedNodeImpl)object2;
                linkedObject2 = (NamedNodeImpl)node;
                boolean bl2 = namedNodeImpl.notificationEnabled;
                boolean bl3 = ((NamedNodeImpl)linkedObject2).notificationEnabled;
                try {
                    namedNodeImpl.notificationEnabled = false;
                    ((NamedNodeImpl)linkedObject2).notificationEnabled = false;
                    namedNodeImpl.addIncomingConnection((MethodElement)workOrder);
                }
                finally {
                    namedNodeImpl.notificationEnabled = bl2;
                    ((NamedNodeImpl)linkedObject2).notificationEnabled = bl3;
                }
            }
        }
        this.cleanDuplicateLinks();
    }

    private void cleanDuplicateLinks() {
        ArrayList arrayList = new ArrayList();
        for (Object object : this.getNodes()) {
            if (!(object instanceof Node)) continue;
            Node node = (Node)object;
            if (node.getIncomingConnections() != null) {
                this.findDuplicateLinks(arrayList, (List)node.getIncomingConnections());
            }
            if (node.getOutgoingConnections() == null) continue;
            this.findDuplicateLinks(arrayList, (List)node.getOutgoingConnections());
        }
        for (Object object : arrayList) {
            GraphicalDataHelper.removeLink(object);
        }
        arrayList.clear();
        arrayList = null;
    }

    private void findDuplicateLinks(List list, List list2) {
        int n = 0;
        while (n < list2.size()) {
            Link link = (Link)list2.get(n);
            if (!list.contains(link)) {
                int n2 = n + 1;
                while (n2 < list2.size()) {
                    Link link2 = (Link)list2.get(n2);
                    if (link2.getSource() == link.getSource() && link2.getTarget() == link.getTarget()) {
                        list.add(link2);
                    }
                    ++n2;
                }
            }
            ++n;
        }
    }

    private static boolean canReachAsFirstActivityNode(Node node, Node node2) {
        for (Link link : node.getOutgoingConnections()) {
            if (link.getTarget() == node2) {
                return true;
            }
            if (!(link.getTarget() instanceof TypedNode) || !ActivityDiagramImpl.canReachAsFirstActivityNode(link.getTarget(), node2)) continue;
            return true;
        }
        return false;
    }

    protected Node newNode() {
        return ModelFactory.eINSTANCE.createWorkBreakdownElementNode();
    }

    public Collection getChildren() {
        ITreeItemContentProvider iTreeItemContentProvider = this.getAdapter();
        if (iTreeItemContentProvider != null) {
            Object object = null;
            boolean bl = false;
            if (iTreeItemContentProvider instanceof ActivityWrapperItemProvider) {
                object = ((ActivityWrapperItemProvider)iTreeItemContentProvider).getDelegatingItemProvider();
            }
            if (iTreeItemContentProvider instanceof BSActivityItemProvider) {
                object = iTreeItemContentProvider;
            }
            if (object instanceof BSActivityItemProvider) {
                bl = ((BSActivityItemProvider)object).isEnableVariabilityInfo();
                ((BSActivityItemProvider)object).setEnableVariabilityInfo(false);
            }
            ArrayList arrayList = new ArrayList();
            this.extractChildren(iTreeItemContentProvider, this.getObject(), arrayList, true);
            if (object instanceof BSActivityItemProvider) {
                ((BSActivityItemProvider)object).setEnableVariabilityInfo(bl);
            }
            return arrayList;
        }
        return Collections.EMPTY_LIST;
    }

    private void addElementNodes() {
        ArrayList<NamedNodeImpl> arrayList = new ArrayList<NamedNodeImpl>();
        for (Object e : this.getChildren()) {
            BreakdownElementWrapperItemProvider breakdownElementWrapperItemProvider;
            Object object = TngUtil.unwrap(e);
            if (!(object instanceof WorkBreakdownElement)) continue;
            NamedNodeImpl namedNodeImpl = (NamedNodeImpl)this.toNode((MethodElement)object);
            if (e instanceof BreakdownElementWrapperItemProvider && (breakdownElementWrapperItemProvider = (BreakdownElementWrapperItemProvider)e).isReadOnly()) {
                namedNodeImpl.itemProvider = breakdownElementWrapperItemProvider;
                namedNodeImpl.readOnly = true;
            }
            arrayList.add(namedNodeImpl);
        }
        this.getNodes().addAll(arrayList);
    }

    private static int getType(Object object) {
        GraphNode graphNode;
        SemanticModelBridge semanticModelBridge;
        if (object instanceof GraphNode && (semanticModelBridge = (graphNode = (GraphNode)object).getSemanticModel()) instanceof SimpleSemanticModelElement) {
            String string = ((SimpleSemanticModelElement)semanticModelBridge).getTypeInfo();
            if ("synchnonization bar".equals(string)) {
                return 1;
            }
            if ("decision node".equals(string)) {
                return 2;
            }
            if ("end node".equals(string)) {
                return 4;
            }
            if ("start node".equals(string)) {
                return 3;
            }
            if ("free text".equals(string)) {
                return 6;
            }
        }
        return -1;
    }

    protected int getType() {
        return 0;
    }

    protected List getBreakdownElementTypes() {
        return Collections.singletonList(WorkBreakdownElement.class);
    }

    /*
     * Unable to fully structure code
     */
    private int toActivityIndex(int var1_1) {
        if (var1_1 == -1) {
            return var1_1;
        }
        var3_3 = var1_1 + 1;
        var2_2 = this.getNodes().size();
        if (var3_3 == var2_2) {
            return -1;
        }
        var4_4 = (Node)this.getNodes().get(var3_3);
        if (var4_4 != null) ** GOTO lbl12
        return -1;
lbl-1000:
        // 1 sources

        {
            var4_4 = (Node)this.getNodes().get(var3_3);
            ++var3_3;
lbl12:
            // 2 sources

            ** while (!(var4_4.getObject() instanceof BreakdownElement) && var3_3 < var2_2)
        }
lbl13:
        // 1 sources

        if (var3_3 == var2_2) {
            return -1;
        }
        var5_5 = (Activity)this.getObject();
        return var5_5.getBreakdownElements().indexOf(var4_4.getObject());
    }

    protected void addToUmaModel(int n, Node node) {
        if (node.getObject() instanceof BreakdownElement) {
            Activity activity = (Activity)this.getObject();
            int n2 = this.toActivityIndex(n);
            if (n2 == -1) {
                activity.getBreakdownElements().add(node.getObject());
            } else {
                activity.getBreakdownElements().add(n2, node.getObject());
            }
        }
        super.addToUmaModel(n, node);
    }

    protected Node addNode(Collection collection, Object object) {
        Activity activity;
        VariabilityElement variabilityElement;
        if (object instanceof Activity && (variabilityElement = (activity = (Activity)object).getVariabilityBasedOnElement()) != null) {
            NodeImpl nodeImpl = (NodeImpl)GraphicalDataHelper.findNode(this, (Object)variabilityElement);
            if (nodeImpl != null) {
                GraphNode graphNode = nodeImpl.getGraphNode();
                UMASemanticModelBridge uMASemanticModelBridge = (UMASemanticModelBridge)graphNode.getSemanticModel();
                if (uMASemanticModelBridge.getElement() != activity) {
                    uMASemanticModelBridge.setElement((MethodElement)activity);
                }
            } else {
                nodeImpl = (NodeImpl)GraphicalDataHelper.findNode(this, (Object)activity);
            }
            if (nodeImpl != null) {
                if (nodeImpl.methodElementAdapter != null) {
                    variabilityElement.eAdapters().remove((Object)nodeImpl.methodElementAdapter);
                }
                nodeImpl.basicSetObject(activity);
                nodeImpl.setReadOnly(false);
                return null;
            }
        }
        return super.addNode(collection, object);
    }

    protected boolean removeNode(Object object) {
        Activity activity;
        VariabilityElement variabilityElement;
        if (object instanceof Activity && (variabilityElement = (activity = (Activity)object).getVariabilityBasedOnElement()) != null) {
            NodeImpl nodeImpl = (NodeImpl)GraphicalDataHelper.findNode(this, (Object)activity);
            if (nodeImpl != null) {
                GraphNode graphNode = nodeImpl.getGraphNode();
                UMASemanticModelBridge uMASemanticModelBridge = (UMASemanticModelBridge)graphNode.getSemanticModel();
                if (uMASemanticModelBridge.getElement() != variabilityElement) {
                    uMASemanticModelBridge.setElement((MethodElement)variabilityElement);
                }
            } else {
                nodeImpl = (NodeImpl)GraphicalDataHelper.findNode(this, (Object)variabilityElement);
            }
            if (nodeImpl != null) {
                if (nodeImpl.methodElementAdapter != null) {
                    activity.eAdapters().remove((Object)nodeImpl.methodElementAdapter);
                }
                nodeImpl.basicSetObject(variabilityElement);
                nodeImpl.setReadOnly(true);
                return false;
            }
        }
        return super.removeNode(object);
    }

    private ITreeItemContentProvider getAdapter() {
        Object object = null;
        object = this.wrapper != null ? this.wrapper : (ITreeItemContentProvider)this.getAdapterFactory().adapt(this.getObject(), ITreeItemContentProvider.class);
        return object;
    }

    private AdapterFactory getAdapterFactory() {
        ComposedAdapterFactory composedAdapterFactory = null;
        if (this.filter == null) {
            composedAdapterFactory = TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory();
        } else if (this.filter instanceof IAdapterFactoryFilter) {
            composedAdapterFactory = (ConfigurableComposedAdapterFactory)((IAdapterFactoryFilter)this.filter).getWBSAdapterFactory();
        }
        return composedAdapterFactory;
    }

    private class ActivityDiagramChangeListener
    extends DiagramImpl.ActivityAdapter
    implements IActivityDiagramChangeListener {
        private ActivityDiagramChangeListener() {
            super(ActivityDiagramImpl.this);
        }
    }
}

