/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.model.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epf.diagram.model.Diagram;
import org.eclipse.epf.diagram.model.util.GraphicalDataHelper;
import org.eclipse.epf.diagram.model.util.IActivityDetailDiagramChangeListener;
import org.eclipse.epf.diagram.model.util.IActivityDiagramChangeListener;
import org.eclipse.epf.diagram.model.util.IDiagramChangeListener;
import org.eclipse.epf.diagram.model.util.IWPDDiagramChangeListener;
import org.eclipse.epf.library.edit.ICommandListener;
import org.eclipse.epf.library.edit.process.command.VaryActivityCommand;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Descriptor;
import org.eclipse.epf.uma.Dimension;
import org.eclipse.epf.uma.GraphConnector;
import org.eclipse.epf.uma.GraphEdge;
import org.eclipse.epf.uma.GraphNode;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Point;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.SemanticModelBridge;
import org.eclipse.epf.uma.UMASemanticModelBridge;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.WorkOrder;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.epf.uma.util.UmaUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GraphicalDataManager {
    private static final String[] diagramPresentations = new String[]{"Workflow", "Work Product Dependency", "Activity Detail"};
    private static final Class[] childTypes = new Class[]{Activity.class, WorkProductDescriptor.class, Descriptor.class};
    private static final Class[] diagramChangeListenerClasses = new Class[]{IActivityDiagramChangeListener.class, IWPDDiagramChangeListener.class, IActivityDetailDiagramChangeListener.class};
    private static GraphicalDataManager instance = null;
    private List<ICommandListener> commandListeners;

    private GraphicalDataManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GraphicalDataManager getInstance() {
        if (instance != null) return instance;
        Class<GraphicalDataManager> clazz = GraphicalDataManager.class;
        synchronized (GraphicalDataManager.class) {
            if (instance != null) return instance;
            instance = new GraphicalDataManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public GraphNode getGraphNode(org.eclipse.epf.uma.Diagram diagram, MethodElement methodElement) {
        if (diagram == null) {
            return this.createGraphNode(methodElement);
        }
        GraphNode graphNode = GraphicalDataManager.findGraphNode(diagram, methodElement);
        if (graphNode == null) {
            graphNode = this.createGraphNode(methodElement);
            this.createGraphConnectors(graphNode, diagram);
            diagram.getContained().add(graphNode);
        }
        return graphNode;
    }

    public static GraphNode findGraphNode(org.eclipse.epf.uma.Diagram diagram, Object object) {
        for (GraphNode graphNode : diagram.getContained()) {
            if (!(graphNode.getSemanticModel() instanceof UMASemanticModelBridge) || object != ((UMASemanticModelBridge)graphNode.getSemanticModel()).getElement()) continue;
            return graphNode;
        }
        return null;
    }

    private org.eclipse.epf.uma.Diagram createDiagram(Activity activity, int n) {
        org.eclipse.epf.uma.Diagram diagram;
        if (ProcessUtil.isExtendingOrLocallyContributing((BreakdownElement)activity) && (diagram = this.getUMADiagram((Activity)activity.getVariabilityBasedOnElement(), n, false)) != null) {
            org.eclipse.epf.uma.Diagram diagram2 = GraphicalDataHelper.copyDiagram(diagram);
            UMASemanticModelBridge uMASemanticModelBridge = (UMASemanticModelBridge)diagram2.getSemanticModel();
            uMASemanticModelBridge.setElement((MethodElement)activity);
            return diagram2;
        }
        diagram = UmaFactory.eINSTANCE.createDiagram();
        UMASemanticModelBridge uMASemanticModelBridge = UmaFactory.eINSTANCE.createUMASemanticModelBridge();
        uMASemanticModelBridge.setElement((MethodElement)activity);
        uMASemanticModelBridge.setPresentation(diagramPresentations[n]);
        diagram.setSemanticModel((SemanticModelBridge)uMASemanticModelBridge);
        this.populateDiagram(diagram, activity, n);
        return diagram;
    }

    private void populateDiagram(org.eclipse.epf.uma.Diagram diagram, Activity activity, int n) {
        ArrayList<GraphNode> arrayList = new ArrayList<GraphNode>();
        for (Object object : activity.getBreakdownElements()) {
            if (!childTypes[n].isInstance(object)) continue;
            GraphNode graphNode = this.createGraphNode((MethodElement)object);
            diagram.getContained().add(graphNode);
            arrayList.add(graphNode);
        }
        for (GraphNode graphNode : arrayList) {
            this.createGraphConnectors(graphNode, diagram, n);
        }
    }

    public IDiagramChangeListener getDiagramChangeListener(Activity activity, int n) {
        for (Object e : activity.eAdapters()) {
            if (!diagramChangeListenerClasses[n].isInstance(e)) continue;
            return (IDiagramChangeListener)e;
        }
        return null;
    }

    public GraphNode createGraphNode(MethodElement methodElement) {
        GraphNode graphNode = UmaFactory.eINSTANCE.createGraphNode();
        UMASemanticModelBridge uMASemanticModelBridge = UmaFactory.eINSTANCE.createUMASemanticModelBridge();
        uMASemanticModelBridge.setElement(methodElement);
        graphNode.setSemanticModel((SemanticModelBridge)uMASemanticModelBridge);
        Point point = UmaFactory.eINSTANCE.createPoint();
        point.setX(new Double(-1.0));
        point.setY(new Double(-1.0));
        graphNode.setPosition(point);
        Dimension dimension = UmaFactory.eINSTANCE.createDimension();
        dimension.setWidth(new Double(-1.0));
        dimension.setHeight(new Double(-1.0));
        graphNode.setSize(dimension);
        return graphNode;
    }

    public GraphEdge addGraphConnectorPair(org.eclipse.epf.uma.Diagram diagram, GraphNode graphNode, WorkOrder workOrder) {
        GraphConnector graphConnector = UmaFactory.eINSTANCE.createGraphConnector();
        graphNode.getAnchorage().add(graphConnector);
        GraphEdge graphEdge = UmaFactory.eINSTANCE.createGraphEdge();
        UMASemanticModelBridge uMASemanticModelBridge = UmaFactory.eINSTANCE.createUMASemanticModelBridge();
        uMASemanticModelBridge.setElement((MethodElement)workOrder);
        graphEdge.setSemanticModel((SemanticModelBridge)uMASemanticModelBridge);
        graphNode.getContained().add(graphEdge);
        graphEdge.getAnchor().add(graphConnector);
        GraphNode graphNode2 = this.getGraphNode(diagram, (MethodElement)UmaUtil.getOwningActivity((WorkOrder)workOrder));
        GraphConnector graphConnector2 = UmaFactory.eINSTANCE.createGraphConnector();
        graphNode2.getAnchorage().add(graphConnector2);
        graphEdge.getAnchor().add(graphConnector2);
        return graphEdge;
    }

    public GraphEdge addGraphConnectorPair(GraphNode graphNode, GraphNode graphNode2) {
        GraphConnector graphConnector = UmaFactory.eINSTANCE.createGraphConnector();
        graphNode.getAnchorage().add(graphConnector);
        GraphEdge graphEdge = UmaFactory.eINSTANCE.createGraphEdge();
        graphNode.getContained().add(graphEdge);
        graphEdge.getAnchor().add(graphConnector);
        GraphConnector graphConnector2 = UmaFactory.eINSTANCE.createGraphConnector();
        graphNode2.getAnchorage().add(graphConnector2);
        graphEdge.getAnchor().add(graphConnector2);
        return graphEdge;
    }

    public void removeGraphEdge(GraphEdge graphEdge) {
        EcoreUtil.remove((EObject)graphEdge);
        for (GraphConnector graphConnector : graphEdge.getAnchor()) {
            EcoreUtil.remove((EObject)graphConnector);
        }
    }

    public void removeGraphConnectionPair(GraphNode graphNode, WorkOrder workOrder) {
        Iterator iterator = graphNode.getAnchorage().iterator();
        while (iterator.hasNext()) {
            GraphConnector graphConnector;
            SemanticModelBridge semanticModelBridge;
            GraphConnector graphConnector2 = (GraphConnector)iterator.next();
            GraphEdge graphEdge = (GraphEdge)graphConnector2.getGraphEdge().get(0);
            if (graphEdge.eContainer() != graphNode || !((semanticModelBridge = (graphConnector = (GraphConnector)graphEdge.getAnchor().get(1)).getGraphElement().getSemanticModel()) instanceof UMASemanticModelBridge) || ((UMASemanticModelBridge)semanticModelBridge).getElement() != UmaUtil.getOwningActivity((WorkOrder)workOrder)) continue;
            graphConnector.getGraphElement().getAnchorage().remove(graphConnector);
            iterator.remove();
            graphNode.getContained().remove(graphEdge);
            return;
        }
    }

    private void createGraphConnectors(GraphNode graphNode, org.eclipse.epf.uma.Diagram diagram) {
        this.createGraphConnectors(graphNode, diagram, this.getDiagramType(diagram));
    }

    int getDiagramType(org.eclipse.epf.uma.Diagram diagram) {
        String string = diagram.getSemanticModel().getPresentation();
        int n = 0;
        while (n < diagramPresentations.length) {
            if (diagramPresentations[n].equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private void createGraphConnectors(GraphNode graphNode, org.eclipse.epf.uma.Diagram diagram, int n) {
        MethodElement methodElement = ((UMASemanticModelBridge)graphNode.getSemanticModel()).getElement();
        switch (n) {
            case 0: {
                if (!(methodElement instanceof Activity)) break;
                Activity activity = (Activity)methodElement;
                for (WorkOrder workOrder : activity.getLinkToPredecessor()) {
                    GraphNode graphNode2 = GraphicalDataManager.findGraphNode(diagram, workOrder.getPred());
                    if (graphNode2 == null) continue;
                    this.addGraphConnectorPair(graphNode2, graphNode);
                }
                break;
            }
            case 1: {
                if (!(methodElement instanceof WorkProductDescriptor)) break;
                WorkProductDescriptor workProductDescriptor = (WorkProductDescriptor)methodElement;
                for (WorkProductDescriptor workProductDescriptor2 : workProductDescriptor.getImpacts()) {
                    GraphNode graphNode3 = GraphicalDataManager.findGraphNode(diagram, workProductDescriptor2);
                    if (graphNode3 == null) continue;
                    this.addGraphConnectorPair(graphNode, graphNode3);
                }
                break;
            }
        }
    }

    public org.eclipse.epf.uma.Diagram getUMADiagram(Activity activity, int n, boolean bl) {
        org.eclipse.epf.uma.Diagram diagram2 = null;
        EObject eObject = activity.eContainer();
        if (eObject != null) {
            ProcessPackage processPackage = (ProcessPackage)eObject;
            for (org.eclipse.epf.uma.Diagram diagram2 : processPackage.getDiagrams()) {
                SemanticModelBridge semanticModelBridge = diagram2.getSemanticModel();
                if (semanticModelBridge == null || !(semanticModelBridge instanceof UMASemanticModelBridge) || activity != ((UMASemanticModelBridge)semanticModelBridge).getElement() || !diagramPresentations[n].equals(((UMASemanticModelBridge)semanticModelBridge).getPresentation())) continue;
                return diagram2;
            }
        }
        if (bl) {
            diagram2 = this.createDiagram(activity, n);
            if (eObject != null) {
                ((ProcessPackage)eObject).getDiagrams().add(diagram2);
            }
            return diagram2;
        }
        return null;
    }

    public Diagram getDiagram(Activity activity, int n) {
        IDiagramChangeListener iDiagramChangeListener = this.getDiagramChangeListener(activity, n);
        return iDiagramChangeListener == null ? null : iDiagramChangeListener.getDiagram();
    }

    public List<ICommandListener> getCommandListeners() {
        if (this.commandListeners == null) {
            this.commandListeners = new ArrayList<ICommandListener>();
        }
        this.commandListeners.add(new ICommandListener(){

            public void notifyExecuted(Command command) {
                Activity activity = (Activity)command.getResult().iterator().next();
                Activity activity2 = (Activity)activity.getVariabilityBasedOnElement();
                if (activity2 != null) {
                    UMASemanticModelBridge uMASemanticModelBridge;
                    GraphNode graphNode;
                    Activity activity3 = activity.getSuperActivities();
                    org.eclipse.epf.uma.Diagram diagram = GraphicalDataManager.this.getUMADiagram(activity3, 0, false);
                    if (diagram != null && (graphNode = GraphicalDataManager.findGraphNode(diagram, activity2)) != null && (uMASemanticModelBridge = (UMASemanticModelBridge)graphNode.getSemanticModel()).getElement() != activity) {
                        uMASemanticModelBridge.setElement((MethodElement)activity);
                    }
                    if (activity.getVariabilityType() == VariabilityType.LOCAL_CONTRIBUTION_LITERAL) {
                        int n = 0;
                        while (n < GraphicalDataHelper.DIAGRAM_TYPES.length) {
                            int n2 = GraphicalDataHelper.DIAGRAM_TYPES[n];
                            diagram = GraphicalDataManager.this.getUMADiagram(activity2, n2, false);
                            if (diagram != null) {
                                org.eclipse.epf.uma.Diagram diagram2 = GraphicalDataManager.this.getUMADiagram(activity, n2, true);
                                diagram2.setSuppressed(diagram.getSuppressed());
                            }
                            ++n;
                        }
                    }
                }
            }

            public Class getCommandType() {
                return VaryActivityCommand.class;
            }

            public void preUndo(Command command) {
                UMASemanticModelBridge uMASemanticModelBridge;
                GraphNode graphNode;
                Activity activity;
                org.eclipse.epf.uma.Diagram diagram;
                Activity activity2 = (Activity)command.getResult().iterator().next();
                VariabilityElement variabilityElement = activity2.getVariabilityBasedOnElement();
                if (variabilityElement != null && (diagram = GraphicalDataManager.this.getUMADiagram(activity = activity2.getSuperActivities(), 0, false)) != null && (graphNode = GraphicalDataManager.findGraphNode(diagram, activity2)) != null && (uMASemanticModelBridge = (UMASemanticModelBridge)graphNode.getSemanticModel()).getElement() != variabilityElement) {
                    uMASemanticModelBridge.setElement((MethodElement)variabilityElement);
                }
            }

            public void preExecute(Command command) {
            }

            public void postUndo(Command command) {
            }
        });
        return this.commandListeners;
    }
}

