/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.catalina.Host;
import org.apache.catalina.Logger;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.util.StringManager;

public class ExpandWar {
    protected static final StringManager sm = StringManager.getManager("org.apache.catalina.startup");

    public static String expand(Host host, URL war) throws IOException {
        int slash;
        int period;
        String pathname;
        int debug = 0;
        Logger logger = host.getLogger();
        if (host instanceof StandardHost) {
            debug = ((StandardHost)host).getDebug();
        }
        if (debug >= 1) {
            logger.log("expand(" + war.toString() + ")");
        }
        if ((pathname = war.toString().replace('\\', '/')).endsWith("!/")) {
            pathname = pathname.substring(0, pathname.length() - 2);
        }
        if ((period = pathname.lastIndexOf(46)) >= pathname.length() - 4) {
            pathname = pathname.substring(0, period);
        }
        if ((slash = pathname.lastIndexOf(47)) >= 0) {
            pathname = pathname.substring(slash + 1);
        }
        if (debug >= 1) {
            logger.log("  Proposed directory name: " + pathname);
        }
        return ExpandWar.expand(host, war, pathname);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String expand(Host host, URL war, String pathname) throws IOException {
        File docBase;
        block25: {
            Throwable t22;
            JarFile jarFile;
            block22: {
                File appBase;
                int debug = 0;
                Logger logger = host.getLogger();
                if (host instanceof StandardHost) {
                    debug = ((StandardHost)host).getDebug();
                }
                if (!(appBase = new File(host.getAppBase())).isAbsolute()) {
                    appBase = new File(System.getProperty("catalina.base"), host.getAppBase());
                }
                if (!appBase.exists() || !appBase.isDirectory()) {
                    throw new IOException(sm.getString("hostConfig.appBase", appBase.getAbsolutePath()));
                }
                docBase = new File(appBase, pathname);
                if (docBase.exists()) {
                    return docBase.getAbsolutePath();
                }
                docBase.mkdir();
                if (debug >= 2) {
                    logger.log("  Have created expansion directory " + docBase.getAbsolutePath());
                }
                JarURLConnection juc = (JarURLConnection)war.openConnection();
                juc.setUseCaches(false);
                jarFile = null;
                InputStream input = null;
                try {
                    jarFile = juc.getJarFile();
                    if (debug >= 2) {
                        logger.log("  Have opened JAR file successfully");
                    }
                    Enumeration<JarEntry> jarEntries = jarFile.entries();
                    if (debug >= 2) {
                        logger.log("  Have retrieved entries enumeration");
                    }
                    while (jarEntries.hasMoreElements()) {
                        int last;
                        JarEntry jarEntry = jarEntries.nextElement();
                        String name = jarEntry.getName();
                        if (debug >= 2) {
                            logger.log("  Am processing entry " + name);
                        }
                        if ((last = name.lastIndexOf(47)) >= 0) {
                            File parent = new File(docBase, name.substring(0, last));
                            if (debug >= 2) {
                                logger.log("  Creating parent directory " + parent);
                            }
                            parent.mkdirs();
                        }
                        if (name.endsWith("/")) continue;
                        if (debug >= 2) {
                            logger.log("  Creating expanded file " + name);
                        }
                        input = jarFile.getInputStream(jarEntry);
                        ExpandWar.expand(input, docBase, name);
                        input.close();
                        input = null;
                    }
                    jarFile = null;
                    Object var16_15 = null;
                    if (input == null) break block22;
                }
                catch (Throwable throwable) {
                    Throwable t22;
                    Object var16_16 = null;
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable t22) {
                            // empty catch block
                        }
                        input = null;
                    }
                    if (jarFile != null) {
                        try {
                            jarFile.close();
                        }
                        catch (Throwable t22) {
                            // empty catch block
                        }
                        jarFile = null;
                    }
                    throw throwable;
                }
                try {
                    input.close();
                }
                catch (Throwable t22) {
                    // empty catch block
                }
                input = null;
            }
            if (jarFile == null) break block25;
            try {
                jarFile.close();
            }
            catch (Throwable t22) {
                // empty catch block
            }
            jarFile = null;
            {
            }
        }
        return docBase.getAbsolutePath();
    }

    protected static void expand(InputStream input, File docBase, String name) throws IOException {
        int n;
        File file = new File(docBase, name);
        BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(file));
        byte[] buffer = new byte[2048];
        while ((n = input.read(buffer)) > 0) {
            output.write(buffer, 0, n);
        }
        output.close();
    }
}

