/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.ui.action.DeleteAction;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.command.DeleteMethodElementCommand;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.persistence.ILibraryResourceSet;
import org.eclipse.epf.library.ui.LibraryUIPlugin;
import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.epf.library.ui.actions.ILibraryAction;
import org.eclipse.epf.library.ui.actions.LibraryLockingOperationRunner;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.jface.operation.IRunnableWithProgress;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodElementDeleteAction
extends DeleteAction
implements ILibraryAction {
    protected Collection<?> selection = null;
    protected boolean confirm = true;
    private IProgressMonitor progressMonitor;

    public MethodElementDeleteAction() {
    }

    public MethodElementDeleteAction(EditingDomain editingDomain) {
        super(editingDomain);
    }

    public MethodElementDeleteAction(EditingDomain editingDomain, boolean bl) {
        this(editingDomain);
        this.confirm = bl;
    }

    public Command createCommand(Collection<?> collection) {
        this.selection = collection;
        DeleteMethodElementCommand deleteMethodElementCommand = this.createMethodElementDeleteCommand();
        deleteMethodElementCommand.addCommandListener(new DeleteMethodElementCommand.CommandListener(){

            public void notifyExecuted(EventObject eventObject) {
                DeleteMethodElementCommand deleteMethodElementCommand = (DeleteMethodElementCommand)eventObject.getSource();
                MethodElementDeleteAction.this.didDelete(deleteMethodElementCommand.getResult());
            }

            public void notifyFailure(EventObject eventObject) {
                MethodElementDeleteAction.this.deleteFailed();
            }
        });
        return deleteMethodElementCommand;
    }

    protected void deleteFailed() {
    }

    public DeleteMethodElementCommand createMethodElementDeleteCommand() {
        return new DeleteMethodElementCommand(super.createCommand(this.selection), this.selection, this.confirm){

            protected void loadOppositeFeatures(List list, Set set) {
                ILibraryResourceSet iLibraryResourceSet = (ILibraryResourceSet)LibraryService.getInstance().getCurrentMethodLibrary().eResource().getResourceSet();
                iLibraryResourceSet.loadOppositeFeatures(list, set);
            }
        };
    }

    protected void didDelete(Collection<?> collection) {
    }

    protected String getDeleteConfirmationMessage() {
        return LibraryUIResources.MethodElementDeleteAction_deleteconfirm_text;
    }

    protected boolean confirmDelete() {
        Object object;
        if (!this.confirm) {
            return true;
        }
        if (this.selection == null || this.selection.isEmpty()) {
            return false;
        }
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        Object[] objectArray = this.selection.iterator();
        while (objectArray.hasNext()) {
            object = TngUtil.unwrap(objectArray.next());
            if (!(object instanceof MethodElement)) continue;
            if (n > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.getDisplayString((MethodElement)object));
            ++n;
        }
        objectArray = new Object[]{stringBuffer.toString()};
        object = LibraryUIResources.bind((String)LibraryUIResources.confirmDeleteDialog_msg, (Object[])objectArray);
        String string = LibraryUIResources.confirmDeleteDialog_title;
        boolean bl = LibraryUIPlugin.getDefault().getMsgDialog().displayConfirmation(string, (String)object);
        return bl;
    }

    protected String getDisplayString(MethodElement methodElement) {
        return methodElement.getName();
    }

    @Override
    public void setProgressMonitor(IProgressMonitor iProgressMonitor) {
        this.progressMonitor = iProgressMonitor;
    }

    protected IProgressMonitor getProgressMonitor() {
        if (this.progressMonitor == null) {
            this.progressMonitor = new NullProgressMonitor();
        }
        return this.progressMonitor;
    }

    public void run() {
        LibraryLockingOperationRunner libraryLockingOperationRunner = new LibraryLockingOperationRunner();
        libraryLockingOperationRunner.setProgressMonitor(this.getProgressMonitor());
        libraryLockingOperationRunner.run(new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                MethodElementDeleteAction.this.performDelete();
            }
        });
    }

    protected void performDelete() {
        super.run();
    }
}

