/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.LibraryResources;
import org.eclipse.epf.library.edit.command.DeleteMethodElementCommand;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.ui.LibraryUIPlugin;
import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.epf.library.ui.LibraryUIText;
import org.eclipse.epf.library.util.ConvertActivityType;
import org.eclipse.epf.library.util.TypeConverter;
import org.eclipse.epf.uma.Activity;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListDialog;

public class ConvertActivityDialog {
    public static Activity queryUserAndConvert(Activity activity, Shell shell, DeleteMethodElementCommand deleteMethodElementCommand) {
        if (shell == null) {
            shell = Display.getCurrent().getActiveShell();
        }
        ListDialog listDialog = new ListDialog(shell);
        listDialog.setHeightInChars(5);
        listDialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        listDialog.setLabelProvider((ILabelProvider)new LabelProvider(){

            public String getText(Object object) {
                switch ((Integer)object) {
                    case 53: {
                        return LibraryUIText.TEXT_ACTIVITY;
                    }
                    case 57: {
                        return LibraryUIText.TEXT_ITERATION;
                    }
                    case 58: {
                        return LibraryUIText.TEXT_PHASE;
                    }
                }
                return LibraryResources.unknownGuidance_text;
            }
        });
        List list = ConvertActivityDialog.getValidNewActivityTypes(activity);
        if (list == null) {
            LibraryUIPlugin.getDefault().getMsgDialog().displayError(LibraryResources.convertActivityError_title, LibraryUIResources.unsupportedActivityType_msg, LibraryUIResources.bind(LibraryUIResources.unsupportedActivityType_reason, StrUtil.toLower((String)TngUtil.getTypeText((EObject)activity))));
            return null;
        }
        listDialog.setInput((Object)list);
        listDialog.setTitle(LibraryUIResources.convertActivityDialog_title);
        listDialog.setMessage(LibraryUIResources.convertActivityDialog_text);
        if (listDialog.open() == 1) {
            return null;
        }
        Object[] objectArray = listDialog.getResult();
        if (objectArray == null) {
            return null;
        }
        int n = (Integer)objectArray[0];
        return TypeConverter.convertActivity((Activity)activity, (EClass)TypeConverter.getActivityType((int)n));
    }

    public static List getValidNewActivityTypes(Activity activity) {
        if (activity == null) {
            return null;
        }
        Integer n = new Integer(activity.eClass().getClassifierID());
        if (!ConvertActivityType.compatibleActivitiesList.contains(n)) {
            return null;
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (Integer n2 : ConvertActivityType.compatibleActivitiesList) {
            if (n.equals(n2) || n2 == 103 || n2 == 101) continue;
            arrayList.add(n2);
        }
        return arrayList;
    }
}

