/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.ui.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.epf.library.ui.views.ProcessTreeUIFolder;
import org.eclipse.epf.uma.CapabilityPattern;
import org.eclipse.epf.uma.DeliveryProcess;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class ProcessTreeContentProvider
implements ITreeContentProvider {
    protected static final String CAPABILITY_PATTERNS = LibraryUIResources.capabilityPattern_text_plural;
    protected static final String DELIVERY_PROCESSES = LibraryUIResources.deliveryProcess_text_plural;
    protected static final Object[] EMPTY_LIST = new Object[0];
    protected Map<MethodPlugin, ProcessTreeUIFolder> capabilityPatternUIFolders = new HashMap<MethodPlugin, ProcessTreeUIFolder>();
    protected Map<MethodPlugin, ProcessTreeUIFolder> deliveryProcessUIFolders = new HashMap<MethodPlugin, ProcessTreeUIFolder>();

    public Object[] getChildren(Object object) {
        if (object instanceof MethodLibrary) {
            ArrayList<MethodPlugin> arrayList = new ArrayList<MethodPlugin>();
            List list = ((MethodLibrary)object).getMethodPlugins();
            for (MethodPlugin methodPlugin : list) {
                List list2 = TngUtil.getAllProcesses((MethodPlugin)methodPlugin);
                if (list2.size() <= 0) continue;
                arrayList.add(methodPlugin);
            }
            return arrayList.toArray();
        }
        if (object instanceof MethodPlugin) {
            ProcessTreeUIFolder processTreeUIFolder;
            MethodPlugin methodPlugin = (MethodPlugin)object;
            ProcessTreeUIFolder processTreeUIFolder2 = this.capabilityPatternUIFolders.get(methodPlugin);
            if (processTreeUIFolder2 == null) {
                processTreeUIFolder2 = new ProcessTreeUIFolder(CAPABILITY_PATTERNS, LibraryEditPlugin.INSTANCE.getImage("full/obj16/CapabilityPatterns"), object);
                this.capabilityPatternUIFolders.put(methodPlugin, processTreeUIFolder2);
            }
            if ((processTreeUIFolder = this.deliveryProcessUIFolders.get(methodPlugin)) == null) {
                processTreeUIFolder = new ProcessTreeUIFolder(DELIVERY_PROCESSES, LibraryEditPlugin.INSTANCE.getImage("full/obj16/DeliveryProcesses"), object);
                this.deliveryProcessUIFolders.put(methodPlugin, processTreeUIFolder);
            }
            return new Object[]{processTreeUIFolder2, processTreeUIFolder};
        }
        if (object instanceof ProcessTreeUIFolder) {
            ProcessTreeUIFolder processTreeUIFolder = (ProcessTreeUIFolder)object;
            MethodPlugin methodPlugin = (MethodPlugin)processTreeUIFolder.getParent();
            if (processTreeUIFolder.getName() == CAPABILITY_PATTERNS) {
                return LibraryServiceUtil.getCapabilityPatterns((MethodPlugin)methodPlugin).toArray();
            }
            return LibraryServiceUtil.getDeliveryProcesses((MethodPlugin)methodPlugin).toArray();
        }
        return EMPTY_LIST;
    }

    public Object getParent(Object object) {
        if (object instanceof ProcessTreeUIFolder) {
            return ((ProcessTreeUIFolder)object).getParent();
        }
        if (object instanceof CapabilityPattern) {
            MethodPlugin methodPlugin = UmaUtil.getMethodPlugin((EObject)((CapabilityPattern)object));
            return this.capabilityPatternUIFolders.get(methodPlugin);
        }
        if (object instanceof DeliveryProcess) {
            MethodPlugin methodPlugin = UmaUtil.getMethodPlugin((EObject)((DeliveryProcess)object));
            return this.deliveryProcessUIFolders.get(methodPlugin);
        }
        return null;
    }

    public boolean hasChildren(Object object) {
        return this.getChildren(object).length > 0;
    }

    public Object[] getElements(Object object) {
        return this.getChildren(object);
    }

    public void inputChanged(Viewer viewer, Object object, Object object2) {
        this.capabilityPatternUIFolders.clear();
        this.deliveryProcessUIFolders.clear();
    }

    public void dispose() {
    }
}

