/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.category;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.EMFEditPlugin;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.Disposable;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.epf.library.edit.FeatureValueWrapperItemProvider;
import org.eclipse.epf.library.edit.IDefaultNameSetter;
import org.eclipse.epf.library.edit.ILibraryItemProvider;
import org.eclipse.epf.library.edit.IStatefulItemProvider;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.PresentationContext;
import org.eclipse.epf.library.edit.command.MethodElementAddCommand;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.RoleSet;
import org.eclipse.epf.uma.RoleSetGrouping;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.edit.command.MethodElementCreateCopyCommand;
import org.eclipse.epf.uma.edit.command.MethodElementInitializeCopyCommand;
import org.eclipse.epf.uma.provider.RoleSetGroupingItemProvider;
import org.eclipse.epf.uma.util.UmaUtil;

public class RoleSetCategoryItemProvider
extends RoleSetGroupingItemProvider
implements IDefaultNameSetter,
ILibraryItemProvider,
IStatefulItemProvider {
    private Disposable children;

    public RoleSetCategoryItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    protected void collectNewChildDescriptors(Collection collection, Object object) {
        collection.add(this.createChildParameter(UmaPackage.eINSTANCE.getRoleSetGrouping_RoleSets(), UmaFactory.eINSTANCE.createRoleSet()));
    }

    public Collection getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            this.childrenFeatures = new ArrayList();
            this.childrenFeatures.add(UmaPackage.eINSTANCE.getRoleSetGrouping_RoleSets());
        }
        return this.childrenFeatures;
    }

    public Object getParent(Object object) {
        MethodPlugin methodPlugin;
        if (object instanceof EObject && (methodPlugin = UmaUtil.getMethodPlugin((EObject)((EObject)object))) != null) {
            String[] stringArray = new String[]{LibraryEditPlugin.INSTANCE.getString("_UI_Content_group"), LibraryEditPlugin.INSTANCE.getString("_UI_Standard_Categories_group"), LibraryEditPlugin.INSTANCE.getString("_UI_Role_Sets_group")};
            return TngUtil.getAdapter(methodPlugin, stringArray);
        }
        return super.getParent(object);
    }

    public Object getCreateChildImage(Object object, Object object2, Object object3, Collection collection) {
        if (object2 instanceof EReference && object3 instanceof EObject) {
            EReference eReference = (EReference)object2;
            EClass eClass = eReference.getEContainingClass();
            EClass eClass2 = ((EObject)object3).eClass();
            String string = "full/ctool16/Create" + eClass.getName() + "_" + eReference.getName() + "_" + eClass2.getName();
            try {
                return LibraryEditPlugin.INSTANCE.getImage(string);
            }
            catch (MissingResourceException missingResourceException) {
                System.err.println(missingResourceException.getMessage());
                return null;
            }
        }
        return EMFEditPlugin.INSTANCE.getImage("full/ctool16/CreateChild");
    }

    public String getText(Object object) {
        return TngUtil.getLabel((VariabilityElement)object, this.getString("_UI_RoleSetGrouping_type"), true);
    }

    public void notifyChanged(Notification notification) {
        this.setDefaultName(notification);
        this.updateChildren(notification);
        switch (notification.getFeatureID(RoleSetGrouping.class)) {
            case 20: {
                ContentPackage contentPackage = (ContentPackage)((EObject)notification.getNotifier()).eContainer();
                boolean bl = false;
                switch (notification.getEventType()) {
                    case 3: {
                        RoleSet roleSet = (RoleSet)notification.getNewValue();
                        if (roleSet.eContainer() == null) {
                            contentPackage.getContentElements().add(roleSet);
                            break;
                        }
                        if (roleSet.eContainer() != contentPackage) break;
                        bl = true;
                        break;
                    }
                    case 5: {
                        for (RoleSet roleSet : (Collection)notification.getNewValue()) {
                            if (roleSet.eContainer() == null) {
                                contentPackage.getContentElements().add(roleSet);
                                continue;
                            }
                            if (roleSet.eContainer() != contentPackage) continue;
                            bl = true;
                        }
                        break;
                    }
                    case 4: 
                    case 6: {
                        bl = true;
                    }
                }
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                if (bl) {
                    this.fireNotifyChanged((Notification)new ViewerNotification(notification, this.getParent(this.target), true, false));
                }
                return;
            }
        }
        super.notifyChanged(notification);
    }

    public Collection getChildren(Object object) {
        Collection collection = super.getChildren(object);
        if (collection instanceof List) {
            Collections.sort((List)collection, PresentationContext.INSTANCE.getComparator());
        }
        return collection;
    }

    protected boolean isWrappingNeeded(Object object) {
        return true;
    }

    protected Object createWrapper(EObject eObject, EStructuralFeature eStructuralFeature, Object object, int n) {
        if (!this.isWrappingNeeded(eObject)) {
            return object;
        }
        return TngUtil.createWrapper(this.adapterFactory, eObject, eStructuralFeature, object, n);
    }

    protected Collection createWrappers(Collection collection) {
        if (this.children == null) {
            this.children = new Disposable();
        }
        FeatureValueWrapperItemProvider.fill((Collection)this.children, null, collection, this.target, this.adapterFactory);
        ArrayList arrayList = new ArrayList(this.children);
        return arrayList;
    }

    public void dispose() {
        if (this.children != null) {
            this.children.dispose();
        }
        super.dispose();
    }

    public void setDefaultName(Notification notification) {
        int n;
        RoleSetCategoryItemProvider roleSetCategoryItemProvider = this;
        if (roleSetCategoryItemProvider.getInterestedFeatureOwnerClass() != null && (n = notification.getFeatureID(roleSetCategoryItemProvider.getInterestedFeatureOwnerClass())) == roleSetCategoryItemProvider.getInterestedFeatureID()) {
            switch (notification.getEventType()) {
                case 3: {
                    this.setDefaultName(notification.getNewValue(), notification.getNotifier());
                    break;
                }
                case 5: {
                    Iterator iterator = ((Collection)notification.getNewValue()).iterator();
                    while (iterator.hasNext()) {
                        this.setDefaultName(iterator.next(), notification.getNotifier());
                    }
                    break;
                }
            }
        }
    }

    private void setDefaultName(Object object, Object object2) {
        String string = null;
        if (object instanceof RoleSet) {
            string = "new_role_set";
        }
        if (string != null) {
            TngUtil.setDefaultName(TngUtil.extract(((ContentPackage)((RoleSetGrouping)object2).eContainer()).getContentElements(), RoleSet.class), (MethodElement)object, "new_role_set");
        }
    }

    public void setDefaultName(Object object) {
        String string = null;
        if (object instanceof RoleSet) {
            string = "new_role_set";
        }
        if (string != null) {
            TngUtil.setDefaultName(((RoleSetGrouping)this.target).getRoleSets(), (MethodElement)object, string);
        }
    }

    public int getInterestedFeatureID() {
        return 20;
    }

    public Class getInterestedFeatureOwnerClass() {
        return RoleSetGrouping.class;
    }

    protected Command createInitializeCopyCommand(EditingDomain editingDomain, EObject eObject, CopyCommand.Helper helper) {
        return new MethodElementInitializeCopyCommand(editingDomain, eObject, helper);
    }

    protected Command createCreateCopyCommand(EditingDomain editingDomain, EObject eObject, CopyCommand.Helper helper) {
        return new MethodElementCreateCopyCommand(editingDomain, eObject, helper);
    }

    protected Command createAddCommand(EditingDomain editingDomain, EObject eObject, EStructuralFeature eStructuralFeature, Collection collection, int n) {
        return new MethodElementAddCommand((Command)((AddCommand)super.createAddCommand(editingDomain, eObject, eStructuralFeature, collection, n)));
    }

    public void setParent(Object object) {
    }
}

