/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class BatchCommand
extends AbstractCommand {
    private Map objectToOldFeatureValuesMap;
    private Map objectToNewFeatureValuesMap;
    private boolean clear;

    public BatchCommand(boolean bl) {
        this.clear = bl;
    }

    public boolean canExecute() {
        return this.objectToNewFeatureValuesMap != null && !this.objectToNewFeatureValuesMap.isEmpty();
    }

    public void execute() {
        if (this.objectToNewFeatureValuesMap == null || this.objectToNewFeatureValuesMap.isEmpty()) {
            return;
        }
        if (this.objectToOldFeatureValuesMap == null) {
            this.objectToOldFeatureValuesMap = new HashMap();
        }
        for (Map.Entry entry2 : this.objectToNewFeatureValuesMap.entrySet()) {
            EObject eObject = (EObject)entry2.getKey();
            Map map = (Map)entry2.getValue();
            for (Map.Entry entry2 : map.entrySet()) {
                EStructuralFeature eStructuralFeature = (EStructuralFeature)entry2.getKey();
                if (eStructuralFeature.isMany()) {
                    if (this.clear) {
                        eObject.eSet(eStructuralFeature, entry2.getValue());
                        continue;
                    }
                    ((List)eObject.eGet(eStructuralFeature)).addAll((Collection)entry2.getValue());
                    continue;
                }
                Object object = eObject.eGet(eStructuralFeature);
                if (object == entry2.getValue()) continue;
                this.saveOldFeatureValue(eObject, eStructuralFeature);
                eObject.eSet(eStructuralFeature, entry2.getValue());
            }
        }
    }

    public void redo() {
        this.execute();
    }

    public void undo() {
        EStructuralFeature eStructuralFeature;
        Map map;
        EObject eObject;
        if (this.objectToNewFeatureValuesMap != null && !this.objectToNewFeatureValuesMap.isEmpty()) {
            for (Map.Entry entry22 : this.objectToNewFeatureValuesMap.entrySet()) {
                eObject = (EObject)entry22.getKey();
                map = (Map)entry22.getValue();
                for (Map.Entry entry22 : map.entrySet()) {
                    eStructuralFeature = (EStructuralFeature)entry22.getKey();
                    if (!eStructuralFeature.isMany()) continue;
                    ((List)eObject.eGet(eStructuralFeature)).removeAll((Collection)entry22.getValue());
                }
            }
        }
        if (this.objectToOldFeatureValuesMap != null && !this.objectToOldFeatureValuesMap.isEmpty()) {
            for (Map.Entry entry22 : this.objectToOldFeatureValuesMap.entrySet()) {
                eObject = (EObject)entry22.getKey();
                map = (Map)entry22.getValue();
                for (Map.Entry entry22 : map.entrySet()) {
                    eStructuralFeature = (EStructuralFeature)entry22.getKey();
                    eObject.eSet(eStructuralFeature, entry22.getValue());
                }
            }
            this.objectToOldFeatureValuesMap.clear();
        }
    }

    public void addFeatureValue(EObject eObject, EStructuralFeature eStructuralFeature, Object object) {
        BatchCommand.addFeatureValue(this.getObjectToNewFeatureValuesMap(), eObject, eStructuralFeature, object);
    }

    public void addFeatureValues(EObject eObject, EStructuralFeature eStructuralFeature, Collection collection) {
        BatchCommand.addFeatureValues(this.getObjectToNewFeatureValuesMap(), eObject, eStructuralFeature, collection);
    }

    public Map getObjectToNewFeatureValuesMap() {
        if (this.objectToNewFeatureValuesMap == null) {
            this.objectToNewFeatureValuesMap = new HashMap();
        }
        return this.objectToNewFeatureValuesMap;
    }

    protected void saveOldFeatureValue(EObject eObject, EStructuralFeature eStructuralFeature) {
        HashMap hashMap;
        ArrayList arrayList = eObject.eGet(eStructuralFeature);
        if (eStructuralFeature.isMany()) {
            arrayList = new ArrayList(arrayList);
        }
        if ((hashMap = (HashMap)this.objectToOldFeatureValuesMap.get(eObject)) == null) {
            hashMap = new HashMap();
            this.objectToOldFeatureValuesMap.put(eObject, hashMap);
        }
        hashMap.put(eStructuralFeature, arrayList);
    }

    public void dispose() {
        if (this.objectToNewFeatureValuesMap != null) {
            this.objectToNewFeatureValuesMap.clear();
            this.objectToNewFeatureValuesMap = null;
        }
        if (this.objectToOldFeatureValuesMap != null) {
            this.objectToOldFeatureValuesMap.clear();
            this.objectToOldFeatureValuesMap = null;
        }
    }

    public static void addFeatureValue(Map map, EObject eObject, EStructuralFeature eStructuralFeature, Object object) {
        HashMap<EStructuralFeature, Object> hashMap = (HashMap<EStructuralFeature, Object>)map.get(eObject);
        if (hashMap == null) {
            hashMap = new HashMap<EStructuralFeature, Object>();
            map.put(eObject, hashMap);
        }
        if (eStructuralFeature.isMany()) {
            ArrayList<Object> arrayList = (ArrayList<Object>)hashMap.get(eStructuralFeature);
            if (arrayList == null) {
                arrayList = new ArrayList<Object>();
                hashMap.put(eStructuralFeature, arrayList);
            }
            arrayList.add(object);
        } else {
            hashMap.put(eStructuralFeature, object);
        }
    }

    public static void addFeatureValues(Map map, EObject eObject, EStructuralFeature eStructuralFeature, Collection collection) {
        ArrayList arrayList;
        HashMap hashMap = (HashMap)map.get(eObject);
        if (hashMap == null) {
            hashMap = new HashMap();
            map.put(eObject, hashMap);
        }
        if ((arrayList = (ArrayList)hashMap.get(eStructuralFeature)) == null) {
            arrayList = new ArrayList();
            hashMap.put(eStructuralFeature, arrayList);
        }
        arrayList.addAll(collection);
    }
}

