/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.command;

import java.util.EventObject;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.command.ActionManager;
import org.eclipse.epf.library.edit.command.CommandStackChangedEvent;
import org.eclipse.epf.library.edit.process.command.BSDragAndDropCommand;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.osgi.util.NLS;

public class FullyRevertibleCommandStack
extends BasicCommandStack {
    private IErrorReporter errReporter;
    private ActionManager actionMgr;

    public FullyRevertibleCommandStack(ActionManager actionManager) {
        this.actionMgr = actionManager;
    }

    public FullyRevertibleCommandStack(ActionManager actionManager, IErrorReporter iErrorReporter) {
        this(actionManager);
        this.errReporter = iErrorReporter;
    }

    public void setErrorReporter(IErrorReporter iErrorReporter) {
        this.errReporter = iErrorReporter;
    }

    private void registerAsModifier(Command command) {
        Set<Resource> set = TngUtil.getModifiedResources(command);
        if (!set.isEmpty()) {
            for (Resource resource : set) {
                this.actionMgr.registerAsModifierOf(resource);
            }
        }
    }

    public boolean doExecute(Command command) {
        boolean bl;
        if (!command.canUndo()) {
            return false;
        }
        super.execute(command);
        if (command instanceof BSDragAndDropCommand && command.getAffectedObjects().isEmpty()) {
            if (this.top != -1) {
                this.commandList.remove(this.top--);
                this.mostRecentCommand = this.top != -1 ? (Command)this.commandList.get(this.top) : null;
            }
            return false;
        }
        boolean bl2 = bl = this.getMostRecentCommand() != null;
        if (bl && this.actionMgr != null) {
            this.registerAsModifier(command);
        }
        this.notifyListeners(new CommandStackChangedEvent((Object)this, 2));
        return bl;
    }

    public void execute(Command command) {
        this.doExecute(command);
    }

    public void redo() {
        super.redo();
        this.notifyListeners(new CommandStackChangedEvent((Object)this, 2));
    }

    public void undo() {
        if (this.canUndo()) {
            block3: {
                Command command = (Command)this.commandList.get(this.top--);
                try {
                    command.undo();
                    this.mostRecentCommand = command;
                }
                catch (RuntimeException runtimeException) {
                    CommonPlugin.INSTANCE.log((Object)new WrappedException(CommonPlugin.INSTANCE.getString("_UI_IgnoreException_exception"), (Exception)runtimeException).fillInStackTrace());
                    this.mostRecentCommand = null;
                    ++this.top;
                    if (this.errReporter == null) break block3;
                    Object[] objectArray = new Object[]{command};
                    objectArray[1] = runtimeException;
                    this.errReporter.showError(NLS.bind((String)LibraryEditResources.undoCommandError_msg, (Object[])objectArray));
                }
            }
            this.notifyListeners(new CommandStackChangedEvent((Object)this, 4));
        }
    }

    public boolean undoAll() {
        try {
            while (this.canUndo()) {
                Command command = (Command)this.commandList.get(this.top--);
                try {
                    command.undo();
                    this.mostRecentCommand = command;
                }
                catch (RuntimeException runtimeException) {
                    CommonPlugin.INSTANCE.log((Object)new WrappedException(CommonPlugin.INSTANCE.getString("_UI_IgnoreException_exception"), (Exception)runtimeException).fillInStackTrace());
                    this.mostRecentCommand = null;
                    ++this.top;
                    if (this.errReporter != null) {
                        Object[] objectArray = new Object[]{command};
                        objectArray[1] = runtimeException;
                        this.errReporter.showError(NLS.bind((String)LibraryEditResources.undoCommandError_msg, (Object[])objectArray));
                    }
                    this.notifyListeners(new CommandStackChangedEvent((Object)this, 8));
                    return false;
                }
            }
        }
        finally {
            this.notifyListeners(new CommandStackChangedEvent((Object)this, 8));
        }
        return true;
    }

    protected void notifyListeners(EventObject eventObject) {
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ((CommandStackListener)iterator.next()).commandStackChanged(eventObject);
        }
    }

    protected void notifyListeners() {
    }

    public void saveIsDone() {
        super.saveIsDone();
        this.notifyListeners(new CommandStackChangedEvent((Object)this, 1));
        this.commandList.clear();
        this.top = -1;
        this.saveIndex = -1;
    }

    public boolean isSaveNeeded() {
        return super.isSaveNeeded();
    }

    public static interface IErrorReporter {
        public void showError(String var1);
    }
}

