/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.command;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.common.util.AbstractTreeIterator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.epf.common.serviceability.MsgBox;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.command.CommandStatusChecker;
import org.eclipse.epf.library.edit.command.INestedCommandProvider;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.command.IUserInteractionHandler;
import org.eclipse.epf.library.edit.command.Reference;
import org.eclipse.epf.library.edit.command.SaveStatus;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.ExtensionManager;
import org.eclipse.epf.library.edit.util.ITextReferenceReplacer;
import org.eclipse.epf.library.edit.util.Messenger;
import org.eclipse.epf.library.edit.util.Misc;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.IValidator;
import org.eclipse.epf.library.edit.validation.IValidatorFactory;
import org.eclipse.epf.library.edit.validation.NameChecker;
import org.eclipse.epf.library.edit.validation.internal.ContentElementNameValidator;
import org.eclipse.epf.library.edit.validation.internal.UniquenessValidator;
import org.eclipse.epf.library.edit.validation.internal.ValidatorFactory;
import org.eclipse.epf.services.IFileBasedLibraryPersister;
import org.eclipse.epf.services.ILibraryPersister;
import org.eclipse.epf.services.Services;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.MethodUnit;
import org.eclipse.epf.uma.NamedElement;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessElement;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.edit.domain.TraceableAdapterFactoryEditingDomain;
import org.eclipse.epf.uma.util.AssociationHelper;
import org.eclipse.epf.uma.util.ContentDescriptionFactory;
import org.eclipse.epf.uma.util.MessageException;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodElementAddCommand
extends CommandWrapper
implements IResourceAwareCommand {
    public static final Map<EClass, Collection<EStructuralFeature>> typeToExcludedFeaturesFromCheck = new HashMap<EClass, Collection<EStructuralFeature>>();
    protected boolean canUndo = true;
    protected AddCommand addCommand;
    protected Map elementToOldPluginMap;
    protected boolean removeXRefRequired;
    protected MethodPlugin ownerPlugin;
    protected ArrayList addList;
    protected MultiStatus status = new MultiStatus(LibraryEditPlugin.INSTANCE.getSymbolicName(), 0, "", null);
    protected boolean runWithProgress;
    protected ArrayList<EStructuralFeature> featuresToCheck;
    private ArrayList nestedCommands;
    private HashSet modifiedResources;
    private static ResourceManager resMgr = null;
    private static StringValidator stringValidator = null;

    public static void excludeFromCheck(EClass eClass, EStructuralFeature eStructuralFeature) {
        Collection<EStructuralFeature> collection = typeToExcludedFeaturesFromCheck.get(eClass);
        if (collection == null) {
            collection = new HashSet<EStructuralFeature>();
        }
        collection.add(eStructuralFeature);
    }

    public MethodElementAddCommand(Command command) {
        this(command, true);
    }

    public MethodElementAddCommand(Command command, boolean bl) {
        super(command);
        this.addCommand = (AddCommand)TngUtil.unwrap(command);
        this.setRunWithProgress(bl);
    }

    public void setRunWithProgress(boolean bl) {
        this.runWithProgress = bl;
    }

    public boolean canUndo() {
        return this.canUndo;
    }

    public Collection getResult() {
        if (this.status.isOK()) {
            return super.getResult();
        }
        return Collections.EMPTY_LIST;
    }

    private void handleError(IStatus iStatus) {
        Messenger.INSTANCE.showError(this.getLabel(), LibraryEditResources.createElementError_msg, iStatus);
        this.status.add(iStatus);
        this.status.addAll(iStatus);
    }

    public void dispose() {
        if (this.nestedCommands != null && !this.nestedCommands.isEmpty()) {
            int n = this.nestedCommands.size() - 1;
            while (n > -1) {
                Command command = (Command)this.nestedCommands.get(n);
                try {
                    command.dispose();
                }
                catch (Exception exception) {}
                --n;
            }
        }
        super.dispose();
    }

    public void execute() {
        Shell shell = MsgBox.getDefaultShell();
        Collection collection = this.getModifiedResources();
        IStatus iStatus = UserInteractionHelper.checkModify(collection, shell);
        if (!iStatus.isOK()) {
            this.handleError(iStatus);
            return;
        }
        iStatus = UserInteractionHelper.checkConfigurationsToUpdate(this.addCommand, shell);
        if (!iStatus.isOK()) {
            this.handleError(iStatus);
            return;
        }
        if (this.willSaveModifiedResources() && !UserInteractionHelper.checkOutOfSynch(collection)) {
            this.status.add(Status.CANCEL_STATUS);
            return;
        }
        this.doAdd();
    }

    public void undo() {
        this.undoNestedCommands();
        super.undo();
    }

    private void undoNestedCommands() {
        if (this.nestedCommands != null && !this.nestedCommands.isEmpty()) {
            int n = this.nestedCommands.size() - 1;
            while (n > -1) {
                block14: {
                    Command command = (Command)this.nestedCommands.get(n);
                    try {
                        try {
                            if (command.canUndo()) {
                                command.undo();
                            }
                        }
                        catch (Exception exception) {
                            LibraryEditPlugin.getDefault().getLogger().logError((Throwable)exception);
                            try {
                                command.dispose();
                            }
                            catch (Exception exception2) {}
                            break block14;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            command.dispose();
                        }
                        catch (Exception exception) {}
                        throw throwable;
                    }
                    try {
                        command.dispose();
                    }
                    catch (Exception exception) {}
                }
                --n;
            }
        }
    }

    private boolean checkFolder(Shell shell) {
        Object object;
        IFileBasedLibraryPersister iFileBasedLibraryPersister = (IFileBasedLibraryPersister)Services.getLibraryPersister((String)"xmi");
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray = this.addCommand.getCollection().iterator();
        while (stringArray.hasNext()) {
            object = TngUtil.unwrap(stringArray.next());
            if (!(object instanceof MethodElement) || !iFileBasedLibraryPersister.hasOwnResource(object)) continue;
            String string = iFileBasedLibraryPersister.getFolderRelativePath((MethodElement)object);
            MethodPlugin methodPlugin = UmaUtil.getMethodPlugin((EObject)this.addCommand.getOwner());
            String string2 = null;
            if (methodPlugin == null) {
                MethodLibrary methodLibrary = UmaUtil.getMethodLibrary((EObject)this.addCommand.getOwner());
                string2 = new File(methodLibrary.eResource().getURI().toFileString()).getParent();
            } else {
                string2 = new File(methodPlugin.eResource().getURI().toFileString()).getParent();
            }
            arrayList.add(String.valueOf(string2) + File.separator + string);
        }
        if (!arrayList.isEmpty()) {
            stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
            object = Services.getFileManager().checkModify(stringArray, (Object)shell);
            if (!object.isOK()) {
                this.handleError((IStatus)object);
                return false;
            }
        }
        return true;
    }

    public IStatus getStatus() {
        return this.status;
    }

    private boolean isMove() {
        Iterator iterator;
        Command command = TngUtil.unwrap(this.command);
        if (command instanceof AddCommand && (iterator = ((AddCommand)command).getCollection().iterator()).hasNext()) {
            EObject eObject = (EObject)iterator.next();
            return UmaUtil.getMethodPlugin((EObject)eObject) != null;
        }
        return false;
    }

    public static Collection<Reference> getIllegalOutgoingReferences(MethodPlugin methodPlugin, EObject eObject, Collection<Reference> collection) {
        if (collection == null) {
            collection = new ArrayList<Reference>();
        }
        EContentsEList.FeatureIterator featureIterator = (EContentsEList.FeatureIterator)eObject.eCrossReferences().iterator();
        while (featureIterator.hasNext()) {
            MethodPlugin methodPlugin2;
            EObject eObject2 = (EObject)featureIterator.next();
            EStructuralFeature eStructuralFeature = featureIterator.feature();
            if (eStructuralFeature.isDerived() || (methodPlugin2 = UmaUtil.getMethodPlugin((EObject)eObject2)) == null || methodPlugin2 == methodPlugin || Misc.isBaseOf(methodPlugin2, methodPlugin)) continue;
            collection.add(new Reference(eObject, eStructuralFeature, eObject2, -1));
            if (eStructuralFeature != UmaPackage.eINSTANCE.getVariabilityElement_VariabilityBasedOnElement()) continue;
            eStructuralFeature = UmaPackage.eINSTANCE.getVariabilityElement_VariabilityType();
            collection.add(new Reference(eObject, eStructuralFeature, eObject.eGet(eStructuralFeature), -1));
        }
        return collection;
    }

    private static void removeReferences(Collection<Reference> collection) {
        for (Reference reference : collection) {
            if (reference.feature.isMany()) {
                List list = (List)reference.owner.eGet(reference.feature);
                list.remove(reference.value);
                continue;
            }
            reference.owner.eSet(reference.feature, null);
        }
    }

    public static Collection<Reference> removeIllegalReferences(MethodPlugin methodPlugin, EObject eObject) {
        Collection<Reference> collection = MethodElementAddCommand.getIllegalOutgoingReferences(methodPlugin, eObject, null);
        MethodElementAddCommand.removeReferences(collection);
        return collection;
    }

    private static boolean hasNext(Iterator iterator) {
        return iterator.hasNext();
    }

    public static boolean hasIllegalReference(MethodPlugin methodPlugin, EObject eObject, Collection collection) {
        EContentsEList.FeatureIterator featureIterator = (EContentsEList.FeatureIterator)eObject.eCrossReferences().iterator();
        while (MethodElementAddCommand.hasNext((Iterator)featureIterator)) {
            MethodPlugin methodPlugin2;
            EObject eObject2 = (EObject)featureIterator.next();
            if (collection.contains(eObject2) || (methodPlugin2 = UmaUtil.getMethodPlugin((EObject)eObject2)) == null || methodPlugin2 == methodPlugin || Misc.isBaseOf(methodPlugin2, methodPlugin)) continue;
            return true;
        }
        return false;
    }

    public static boolean isReferencedIllegally(MethodPlugin methodPlugin, MethodElement methodElement, Collection collection) {
        Collection collection2 = AssociationHelper.getReferences((MethodElement)methodElement);
        for (MethodElement methodElement2 : collection2) {
            MethodPlugin methodPlugin2;
            if (MethodElementAddCommand.isExcludedFromOutgoingReferenceCheck(methodElement2) || collection.contains(methodElement2) || (methodPlugin2 = UmaUtil.getMethodPlugin((EObject)methodElement2)) == null || methodPlugin2 == methodPlugin || Misc.isBaseOf(methodPlugin, methodPlugin2)) continue;
            return true;
        }
        return false;
    }

    private static void checkModify(EObject eObject) {
        IStatus iStatus = TngUtil.checkEdit(eObject, null);
        if (!iStatus.isOK()) {
            throw new MessageException(TngUtil.getMessage(iStatus));
        }
    }

    public static Collection removeIllegalReferencesTo(MethodPlugin methodPlugin, MethodElement methodElement, Collection collection) {
        ArrayList<MethodElement> arrayList = new ArrayList<MethodElement>();
        Collection collection2 = AssociationHelper.getReferences((MethodElement)methodElement);
        for (MethodElement methodElement2 : collection2) {
            MethodPlugin methodPlugin2;
            if (collection.contains(methodElement2) || (methodPlugin2 = UmaUtil.getMethodPlugin((EObject)methodElement2)) == null || methodPlugin2 == methodPlugin || Misc.isBaseOf(methodPlugin, methodPlugin2)) continue;
            MethodElementAddCommand.checkModify((EObject)methodElement2);
            MethodElementAddCommand.removeReferences((EObject)methodElement2, (EObject)methodElement);
            arrayList.add(methodElement2);
        }
        return arrayList;
    }

    private static Collection getXReferences(EObject eObject, EObject eObject2, Collection arrayList) {
        if (arrayList == null) {
            arrayList = new ArrayList<EStructuralFeature>();
        }
        EContentsEList.FeatureIterator featureIterator = (EContentsEList.FeatureIterator)eObject.eCrossReferences().iterator();
        while (featureIterator.hasNext()) {
            EObject eObject3 = (EObject)featureIterator.next();
            EStructuralFeature eStructuralFeature = featureIterator.feature();
            if (eObject3 != eObject2) continue;
            arrayList.add(eStructuralFeature);
        }
        return arrayList;
    }

    public static Collection removeReferences(EObject eObject, EObject eObject2) {
        Collection collection = MethodElementAddCommand.getXReferences(eObject, eObject2, null);
        for (EStructuralFeature eStructuralFeature : collection) {
            if (eStructuralFeature.isMany()) {
                ((Collection)eObject.eGet(eStructuralFeature)).remove(eObject2);
                continue;
            }
            eObject.eSet(eStructuralFeature, null);
        }
        return collection;
    }

    public static boolean hasIllegalReferenceIncludingAllChildren(MethodPlugin methodPlugin, MethodElement methodElement, Collection collection) {
        if (methodPlugin == UmaUtil.getMethodPlugin((EObject)methodElement)) {
            return false;
        }
        if (MethodElementAddCommand.hasIllegalReference(methodPlugin, (EObject)methodElement, collection)) {
            return true;
        }
        TreeIterator treeIterator = methodElement.eAllContents();
        while (treeIterator.hasNext()) {
            if (!MethodElementAddCommand.hasIllegalReference(methodPlugin, (EObject)treeIterator.next(), collection)) continue;
            return true;
        }
        return false;
    }

    protected void superExecute() {
        super.execute();
    }

    protected Collection getFeaturesToCheck() {
        if (this.featuresToCheck == null) {
            this.featuresToCheck = new ArrayList();
            this.featuresToCheck.add((EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name());
        }
        return this.featuresToCheck;
    }

    protected IValidator createValidator(EObject eObject, EStructuralFeature eStructuralFeature) {
        IValidator iValidator = null;
        if (this.addCommand.getFeature() instanceof EReference) {
            iValidator = IValidatorFactory.INSTANCE.createValidator(this.addCommand.getOwner(), (EReference)this.addCommand.getFeature(), (EClass)null, eObject, eStructuralFeature);
        }
        return iValidator;
    }

    private void getOffStringToCheckName(Object object, Collection collection) {
        if (this.addCommand.getOwner() instanceof ProcessPackage && this.addCommand.getFeature() == UmaPackage.eINSTANCE.getMethodPackage_ChildPackages() && object instanceof ProcessPackage && !(object instanceof ProcessComponent)) {
            MethodElementAddCommand.getProcessComponents((ProcessPackage)object, collection);
        }
    }

    private static void getProcessComponents(ProcessPackage processPackage, Collection collection) {
        for (Object e : processPackage.getChildPackages()) {
            if (e instanceof ProcessComponent) {
                collection.add(e);
                continue;
            }
            if (!(e instanceof ProcessPackage)) continue;
            MethodElementAddCommand.getProcessComponents((ProcessPackage)e, collection);
        }
    }

    private boolean checkStringValue(NamedElement namedElement, EStructuralFeature eStructuralFeature, Collection collection) {
        Collection<EStructuralFeature> collection2 = typeToExcludedFeaturesFromCheck.get(namedElement.eClass());
        if (collection2 != null && collection2.contains(eStructuralFeature)) {
            return true;
        }
        IValidator iValidator = this.createValidator((EObject)namedElement, eStructuralFeature);
        if (iValidator != null) {
            String string = null;
            try {
                string = MethodElementAddCommand.checkStringValue(namedElement, eStructuralFeature, iValidator, collection);
            }
            catch (OperationCanceledException operationCanceledException) {
                return false;
            }
            if (string != null) {
                string = string.trim();
                namedElement.eSet(eStructuralFeature, (Object)string);
                this.featureChanged((EObject)namedElement, eStructuralFeature, string);
            }
        }
        return true;
    }

    protected boolean checkStringValue(EStructuralFeature eStructuralFeature) {
        ArrayList arrayList = new ArrayList();
        Collection collection = this.addCommand.getCollection();
        for (NamedElement namedElement : collection) {
            if (!this.checkStringValue(namedElement, eStructuralFeature, collection)) {
                return false;
            }
            this.getOffStringToCheckName(namedElement, arrayList);
        }
        for (NamedElement namedElement : arrayList) {
            EAttribute eAttribute;
            if (this.checkStringValue(namedElement, (EStructuralFeature)(eAttribute = UmaPackage.eINSTANCE.getNamedElement_Name()), arrayList)) continue;
            return false;
        }
        return true;
    }

    protected void featureChanged(EObject eObject, EStructuralFeature eStructuralFeature, Object object) {
    }

    private static Collection getElementsToCheckName(AddCommand addCommand) {
        ArrayList arrayList = new ArrayList(addCommand.getCollection());
        for (Object e : addCommand.getCollection()) {
            if (!(e instanceof ProcessPackage)) continue;
            AbstractTreeIterator abstractTreeIterator = new AbstractTreeIterator(e, false){
                private static final long serialVersionUID = 1L;

                protected Iterator getChildren(Object object) {
                    if (object instanceof ProcessComponent) {
                        return Collections.EMPTY_LIST.iterator();
                    }
                    if (object instanceof ProcessPackage) {
                        return ((ProcessPackage)object).getChildPackages().iterator();
                    }
                    return Collections.EMPTY_LIST.iterator();
                }
            };
            while (abstractTreeIterator.hasNext()) {
                Object e2 = abstractTreeIterator.next();
                if (!(e2 instanceof ProcessComponent)) continue;
                arrayList.add(e2);
            }
        }
        return arrayList;
    }

    protected static Map checkName(AddCommand addCommand) {
        Collection collection = MethodElementAddCommand.getElementsToCheckName(addCommand);
        HashMap<NamedElement, String> hashMap = new HashMap<NamedElement, String>();
        for (NamedElement namedElement : collection) {
            IValidator iValidator = namedElement instanceof ContentElement ? new ContentElementNameValidator(addCommand.getOwner(), addCommand.getFeature(), (ContentElement)namedElement, new ValidatorFactory.TypeFilter((EObject)namedElement)) : IValidatorFactory.INSTANCE.createNameValidator((Object)addCommand.getOwner(), namedElement);
            String string = null;
            try {
                string = MethodElementAddCommand.checkStringValue(namedElement, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name(), iValidator, collection);
            }
            catch (OperationCanceledException operationCanceledException) {
                return null;
            }
            if (string == null) continue;
            IStatus iStatus = UserInteractionHelper.checkModify((EObject)namedElement, MsgBox.getDefaultShell());
            String string2 = LibraryEditResources.errorDialog_title;
            String string3 = MessageFormat.format(LibraryEditResources.errorDialog_cannotRename, TngUtil.getTypeText((EObject)namedElement), namedElement.getName(), string);
            while (!iStatus.isOK()) {
                IUserInteractionHandler iUserInteractionHandler = ExtensionManager.getDefaultUserInteractionHandler();
                if (iUserInteractionHandler != null) {
                    int[] nArray = new int[2];
                    nArray[1] = 1;
                    if (iUserInteractionHandler.selectOne(nArray, string2, string3, null) != 1) continue;
                    return null;
                }
                return null;
            }
            hashMap.put(namedElement, string);
        }
        return hashMap;
    }

    public static String checkStringValue(NamedElement namedElement, EStructuralFeature eStructuralFeature, IValidator iValidator, Collection collection) throws OperationCanceledException {
        String string;
        final StringValidator stringValidator = MethodElementAddCommand.getStringValidator();
        stringValidator.setElements(collection);
        stringValidator.setFeature(eStructuralFeature);
        stringValidator.setValidator(iValidator);
        String string2 = (String)namedElement.eGet(eStructuralFeature);
        if (string2 != null && string2.length() > 0 && (string = stringValidator.isValid(string2)) != null) {
            String string3 = TngUtil.getFeatureText(eStructuralFeature);
            String string4 = LibraryEditResources.resolveNameConflictDialog_title;
            String string5 = NLS.bind((String)LibraryEditResources.resolveNameConflictDialog_text, (Object)StrUtil.toLower((String)string3), (Object)namedElement.getName());
            String string6 = (String)namedElement.eGet(eStructuralFeature);
            IInputValidator iInputValidator = new IInputValidator(){

                public String isValid(String string) {
                    if (stringValidator != null) {
                        return UserInteractionHelper.getSimpleErrorMessage(stringValidator.isValid(string));
                    }
                    return null;
                }
            };
            InputDialog inputDialog = new InputDialog(MsgBox.getDefaultShell(), string4, string5, string6, iInputValidator);
            if (inputDialog.open() == 1) {
                throw new OperationCanceledException();
            }
            return inputDialog.getValue();
        }
        return null;
    }

    public Collection getAffectedObjects() {
        Set<EObject> set = super.getAffectedObjects();
        if (set == null) {
            EObject eObject = this.addCommand.getOwner();
            set = eObject == null ? Collections.EMPTY_SET : Collections.singleton(eObject);
        }
        return set;
    }

    protected Collection getElementsToCheckForIllegalReferences() {
        return this.addCommand.getCollection();
    }

    private static boolean isExcludedFromOutgoingReferenceCheck(Object object) {
        return object instanceof ProcessPackage || object instanceof ProcessElement;
    }

    protected String checkForIllegalReferences() {
        Collection collection = this.getElementsToCheckForIllegalReferences();
        this.addList = new ArrayList(collection);
        for (Object object : collection) {
            TreeIterator treeIterator = object.eAllContents();
            while (treeIterator.hasNext()) {
                this.addList.add(treeIterator.next());
            }
        }
        this.ownerPlugin = UmaUtil.getMethodPlugin((EObject)this.addCommand.getOwner());
        this.removeXRefRequired = false;
        for (Object object : this.addCommand.getCollection()) {
            if (MethodElementAddCommand.isExcludedFromOutgoingReferenceCheck(object) || !(object instanceof MethodElement) || !MethodElementAddCommand.hasIllegalReferenceIncludingAllChildren(this.ownerPlugin, (MethodElement)object, this.addList)) continue;
            this.removeXRefRequired = true;
            break;
        }
        if (this.removeXRefRequired) {
            return LibraryEditResources.invalidReferencesError_reason;
        }
        return null;
    }

    public Collection getModifiedResources() {
        Object object;
        if (this.modifiedResources == null) {
            this.modifiedResources = new HashSet();
        }
        if (this.addFeatureIsContainment()) {
            ILibraryPersister iLibraryPersister = Services.getDefaultLibraryPersister();
            boolean bl = false;
            object = this.addCommand.getCollection().iterator();
            while (object.hasNext()) {
                Object e = object.next();
                if (iLibraryPersister.hasOwnResourceWithoutReferrer(e)) continue;
                bl = true;
            }
            if (bl) {
                this.modifiedResources.add(this.addCommand.getOwner().eResource());
            }
        } else {
            this.modifiedResources.add(this.addCommand.getOwner().eResource());
        }
        if (this.nestedCommands != null && !this.nestedCommands.isEmpty()) {
            int n = this.nestedCommands.size() - 1;
            while (n > -1) {
                Command command = (Command)this.nestedCommands.get(n);
                try {
                    if (command instanceof IResourceAwareCommand && (object = ((IResourceAwareCommand)command).getModifiedResources()) != null) {
                        this.modifiedResources.addAll(object);
                    }
                }
                catch (Exception exception) {
                    LibraryEditPlugin.getDefault().getLogger().logError((Throwable)exception);
                }
                --n;
            }
        }
        return this.modifiedResources;
    }

    protected boolean willSaveModifiedResources() {
        return true;
    }

    private ILibraryPersister.FailSafeMethodLibraryPersister getPersister() {
        return Services.getDefaultLibraryPersister().getFailSafePersister();
    }

    /*
     * Exception decompiling
     */
    protected void saveModifiedResources() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [18[DOLOOP]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Collection replaceTextReferences(Collection collection) {
        HashSet<Resource> hashSet = new HashSet<Resource>();
        ITextReferenceReplacer iTextReferenceReplacer = ExtensionManager.getTextReferenceReplacer();
        if (iTextReferenceReplacer == null) {
            return hashSet;
        }
        EditingDomain editingDomain = this.addCommand.getDomain();
        if (editingDomain instanceof TraceableAdapterFactoryEditingDomain) {
            Object object;
            Object object2;
            Map map = ((TraceableAdapterFactoryEditingDomain)editingDomain).getCopyToOriginalMap();
            HashMap hashMap = new HashMap();
            for (Map.Entry eObject : map.entrySet()) {
                object2 = eObject.getKey();
                object = eObject.getValue();
                if (object2 == null || object == null) continue;
                hashMap.put(object, object2);
            }
            for (EObject eObject : collection) {
                object2 = eObject.eAllContents();
                while (object2.hasNext()) {
                    object = (EObject)object2.next();
                    for (EAttribute eAttribute : object.eClass().getEAllAttributes()) {
                        String string;
                        String string2;
                        if (!eAttribute.isChangeable() || eAttribute.isDerived() || !eAttribute.isMany() && !object.eIsSet((EStructuralFeature)eAttribute) || eAttribute.getEAttributeType().getInstanceClass() != XMLTypePackage.Literals.STRING.getInstanceClass() || (string2 = (String)object.eGet((EStructuralFeature)eAttribute)) == null || (string = iTextReferenceReplacer.replace(string2, (EObject)object, hashMap)).equals(string2)) continue;
                        object.eSet((EStructuralFeature)eAttribute, (Object)string);
                        hashSet.add(object.eResource());
                    }
                }
            }
        }
        return hashSet;
    }

    /*
     * WARNING - void declaration
     */
    protected void doAdd() {
        try {
            void var5_10;
            Object object2;
            EStructuralFeature eStructuralFeature22;
            for (EStructuralFeature eStructuralFeature22 : this.getFeaturesToCheck()) {
                if (this.checkStringValue(eStructuralFeature22)) continue;
                return;
            }
            boolean bl = false;
            eStructuralFeature22 = this.addCommand.getDomain();
            if (eStructuralFeature22 instanceof TraceableAdapterFactoryEditingDomain) {
                object2 = ((TraceableAdapterFactoryEditingDomain)eStructuralFeature22).getCopyToOriginalMap();
                if (this.addCommand.getCollection() != null && this.addCommand.getCollection().size() > 0 && object2.containsKey(this.addCommand.getCollection().toArray()[0])) {
                    this.elementToOldPluginMap = new HashMap();
                    for (Map.Entry object3 : object2.entrySet()) {
                        if (!(object3.getValue() instanceof MethodElement) || object3.getValue() instanceof MethodConfiguration) continue;
                        MethodPlugin runtimeException = UmaUtil.getMethodPlugin((EObject)((MethodElement)object3.getValue()));
                        if (runtimeException != null) {
                            this.elementToOldPluginMap.put(object3.getKey(), runtimeException);
                            continue;
                        }
                        bl = true;
                    }
                }
            }
            if (bl) {
                Messenger.INSTANCE.showWarning(this.getLabel(), LibraryEditResources.MethodElementAddCommand_originalNotFoundWarning_msg);
            }
            object2 = new StringBuffer();
            Object object4 = new IRunnableWithProgress((StringBuffer)object2){
                private final /* synthetic */ StringBuffer val$msgBuff;
                {
                    this.val$msgBuff = stringBuffer;
                }

                public void run(IProgressMonitor iProgressMonitor) {
                    String string = MethodElementAddCommand.this.checkForIllegalReferences();
                    if (string != null) {
                        this.val$msgBuff.append(string);
                    }
                }
            };
            Object var5_8 = null;
            if (!this.runWithProgress) {
                NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
            }
            if (this.runWithProgress) {
                UserInteractionHelper.runWithProgress((IRunnableWithProgress)object4, LibraryEditResources.checkingReferencesTask_name);
            } else {
                try {
                    object4.run((IProgressMonitor)var5_10);
                }
                catch (RuntimeException exception) {
                    LibraryEditPlugin.INSTANCE.log(exception);
                    throw exception;
                }
                catch (Exception exception) {
                    LibraryEditPlugin.INSTANCE.log(exception);
                    throw new RuntimeException(exception.toString());
                }
            }
            if (((StringBuffer)object2).length() > 0 && MsgBox.prompt((Shell)Display.getCurrent().getActiveShell(), (String)((StringBuffer)object2).toString(), (int)192) == 128) {
                return;
            }
            this.status = new MultiStatus(LibraryEditPlugin.INSTANCE.getSymbolicName(), 0, LibraryEditResources.MethodElementAddCommand_errorSavingFiles, null);
            object4 = new IRunnableWithProgress(){

                public void run(IProgressMonitor iProgressMonitor) {
                    Object object;
                    if (MethodElementAddCommand.this.removeXRefRequired) {
                        iProgressMonitor.subTask("");
                        for (EObject eObject : MethodElementAddCommand.this.addList) {
                            if (!(eObject instanceof MethodElement)) continue;
                            MethodElementAddCommand.removeIllegalReferences(MethodElementAddCommand.this.ownerPlugin, eObject);
                        }
                    }
                    MethodElementAddCommand.this.superExecute();
                    MethodElementAddCommand.this.executeNestedCommands();
                    if (MethodElementAddCommand.this.willSaveModifiedResources()) {
                        object = MethodElementAddCommand.this.saveNewElementsWithOwnResource();
                        if (object.isOK()) {
                            iProgressMonitor.subTask(LibraryEditResources.savingModifiedFilesTask_name);
                            MethodElementAddCommand.this.saveModifiedResources();
                        } else {
                            MethodElementAddCommand.this.status.add((IStatus)object);
                        }
                    }
                    if (!MethodElementAddCommand.this.status.isOK()) {
                        MethodElementAddCommand.this.undo();
                        if (CommandStatusChecker.hasRollbackError((IStatus)MethodElementAddCommand.this.status)) {
                            EObject eObject;
                            object = MethodElementAddCommand.this.command.getResult();
                            eObject = Services.getDefaultLibraryPersister();
                            Iterator iterator = object.iterator();
                            while (iterator.hasNext()) {
                                Object e = iterator.next();
                                if (!(e instanceof MethodElement)) continue;
                                try {
                                    eObject.delete((MethodElement)e);
                                }
                                catch (Exception exception) {
                                    LibraryEditPlugin.getDefault().getLogger().logError((Throwable)exception);
                                }
                            }
                        }
                    }
                }
            };
            if (this.runWithProgress) {
                UserInteractionHelper.runWithProgress((IRunnableWithProgress)object4, "");
            } else {
                try {
                    object4.run((IProgressMonitor)var5_10);
                }
                catch (RuntimeException runtimeException) {
                    LibraryEditPlugin.INSTANCE.log(runtimeException);
                    throw runtimeException;
                }
                catch (Exception exception) {
                    LibraryEditPlugin.INSTANCE.log(exception);
                    throw new RuntimeException(exception.toString());
                }
            }
            if (!this.status.isOK()) {
                Messenger.INSTANCE.showError(this.getLabel(), LibraryEditResources.error_msgWithDetails, (IStatus)this.status);
                return;
            }
        }
        catch (RuntimeException runtimeException) {
            Messenger.INSTANCE.showError(this.getLabel(), LibraryEditResources.error_msg, null, runtimeException);
        }
    }

    private boolean addFeatureIsContainment() {
        return this.addCommand.getFeature() instanceof EReference && ((EReference)this.addCommand.getFeature()).isContainment();
    }

    protected IStatus saveNewElementsWithOwnResource() {
        if (this.addFeatureIsContainment()) {
            ILibraryPersister iLibraryPersister = Services.getDefaultLibraryPersister();
            for (Object e : this.addList) {
                IStatus iStatus;
                if (!(e instanceof MethodElement)) continue;
                MethodElement methodElement = (MethodElement)e;
                if ((methodElement instanceof ContentElement || methodElement instanceof MethodPlugin || methodElement instanceof MethodConfiguration) && (iStatus = this.checkFilePathLengthBeforeSave(methodElement)) != null) {
                    return iStatus;
                }
                if (!iLibraryPersister.hasOwnResourceWithoutReferrer((Object)methodElement)) continue;
                try {
                    iLibraryPersister.save(methodElement);
                }
                catch (Exception exception) {
                    LibraryEditPlugin.getDefault().getLogger().logError((Throwable)exception);
                    String string = exception.getMessage();
                    if (StrUtil.isBlank((String)string)) {
                        string = exception.toString();
                    }
                    return new SaveStatus(4, LibraryEditPlugin.INSTANCE.getSymbolicName(), 1, string, exception);
                }
            }
        }
        return Status.OK_STATUS;
    }

    private IStatus checkFilePathLengthBeforeSave(MethodElement methodElement) {
        Object object = null;
        object = methodElement instanceof MethodPlugin || methodElement instanceof MethodConfiguration ? UmaUtil.getMethodLibrary((EObject)methodElement) : UmaUtil.getMethodPlugin((EObject)methodElement);
        if (!NameChecker.checkFilePathLength((MethodElement)object, methodElement, methodElement.getName(), 255, null)) {
            String string = NLS.bind((String)LibraryEditResources.filePathNameTooLong_msg, (Object[])new Object[]{new Integer(255)});
            return new SaveStatus(4, LibraryEditPlugin.INSTANCE.getSymbolicName(), 1, string, null);
        }
        return null;
    }

    protected void executeNestedCommands() {
        List<INestedCommandProvider> list = ExtensionManager.getNestedCommandProviders();
        if (!list.isEmpty() && !this.addList.isEmpty()) {
            this.nestedCommands = new ArrayList();
            for (INestedCommandProvider iNestedCommandProvider : list) {
                try {
                    Command command = iNestedCommandProvider.createRelatedObjects(this.addList, this);
                    if (command == null || !command.canExecute()) continue;
                    command.execute();
                    this.nestedCommands.add(command);
                }
                catch (Exception exception) {
                    LibraryEditPlugin.getDefault().getLogger().logError((Throwable)exception);
                }
            }
        }
    }

    public static void setResourceManager(ResourceManager resourceManager) {
        resMgr = resourceManager;
    }

    private static StringValidator getStringValidator() {
        if (stringValidator == null) {
            stringValidator = new StringValidator();
        }
        return stringValidator;
    }

    static /* synthetic */ ResourceManager access$2() {
        return resMgr;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BasicResourceManager
    implements ResourceManager {
        @Override
        public Collection<Resource> copyReferencedContents(Collection<MethodElement> collection, Map<MethodElement, MethodPlugin> map) {
            return null;
        }
    }

    private static class ContainmentInfo {
        EObject container;
        int index;

        ContainmentInfo(EObject eObject, int n) {
            this.container = eObject;
            this.index = n;
        }
    }

    private static class IllegalReferenceRemover {
        private MethodPlugin targetPlugin;
        private Collection elementsToMove;
        private List illegalReferences;
        private Set affectedResources;
        private ArrayList removedReferences;
        private boolean searchOutgoingRefs;
        private boolean searchIncomingRefs;

        public IllegalReferenceRemover(MethodPlugin methodPlugin, Collection collection, boolean bl, boolean bl2) {
            this.targetPlugin = methodPlugin;
            this.elementsToMove = collection;
            this.searchOutgoingRefs = bl;
            this.searchIncomingRefs = bl2;
        }

        public Set getAffectedResources() {
            if (this.affectedResources == null) {
                this.illegalReferences = new ArrayList();
                for (Object object : this.elementsToMove) {
                    if (!(object instanceof MethodElement)) continue;
                    MethodElement methodElement = (MethodElement)object;
                    if (this.searchOutgoingRefs && !MethodElementAddCommand.isExcludedFromOutgoingReferenceCheck(object)) {
                        MethodElementAddCommand.getIllegalOutgoingReferences(this.targetPlugin, (EObject)methodElement, this.illegalReferences);
                    }
                    if (!this.searchIncomingRefs) continue;
                    Collection collection = AssociationHelper.getReferences((MethodElement)methodElement);
                    for (MethodElement methodElement2 : collection) {
                        MethodPlugin methodPlugin;
                        if (this.elementsToMove.contains(methodElement2) || (methodPlugin = UmaUtil.getMethodPlugin((EObject)methodElement2)) == null || methodPlugin == this.targetPlugin || Misc.isBaseOf(this.targetPlugin, methodPlugin)) continue;
                        Collection collection2 = MethodElementAddCommand.getXReferences((EObject)methodElement2, (EObject)methodElement, null);
                        for (EStructuralFeature eStructuralFeature : collection2) {
                            this.illegalReferences.add(new Reference((EObject)methodElement2, eStructuralFeature, methodElement));
                        }
                    }
                }
                this.affectedResources = new HashSet();
                for (Object object : this.illegalReferences) {
                    if (((Reference)object).owner.eResource() == null) continue;
                    this.affectedResources.add(((Reference)object).owner.eResource());
                }
            }
            return this.affectedResources;
        }

        public void removeIllegalReferences() {
            this.removedReferences = new ArrayList();
            for (Reference reference : this.illegalReferences) {
                if (reference.feature.isMany()) {
                    List list = (List)reference.owner.eGet(reference.feature);
                    list.remove(reference.value);
                } else if (reference.feature == UmaPackage.eINSTANCE.getVariabilityElement_VariabilityType()) {
                    reference.owner.eSet(reference.feature, (Object)VariabilityType.NA_LITERAL);
                } else {
                    reference.owner.eSet(reference.feature, null);
                }
                this.removedReferences.add(reference);
            }
        }

        /*
         * Unable to fully structure code
         */
        public void restoreRemovedReferences() {
            if (this.removedReferences == null) {
                return;
            }
            var1_1 = this.removedReferences.size() - 1;
            while (var1_1 > -1) {
                var2_2 = (Reference)this.removedReferences.get(var1_1);
                if (var2_2.feature.isMany()) {
                    var3_3 = (List)var2_2.owner.eGet(var2_2.feature);
                    if (var2_2.index != -1) {
                        if (var3_3.contains(var2_2.value)) ** GOTO lbl23
                        if (var2_2.index < var3_3.size()) {
                            var3_3.add(var2_2.index, var2_2.value);
                        }
                        var3_3.add(var2_2.value);
                    } else {
                        var3_3.add(var2_2.value);
                    }
                } else {
                    var2_2.owner.eSet(var2_2.feature, var2_2.value);
                }
lbl23:
                // 5 sources

                --var1_1;
            }
        }
    }

    public static class MoveOperation {
        private static final int STATE_START = 0;
        private static final int STATE_SAVED_FILES = 80;
        private static final int STATE_MOVED_FILES = 70;
        private static final int STATE_COPIED_RESOURCES = 90;
        private static final int STATE_END = 100;
        private AddCommand addCommand;
        private Collection moveList;
        private boolean removeXRefRequired = false;
        private boolean isRefenrecedIllegally = false;
        private MethodPlugin ownerPlugin;
        private Map elementToOldPluginMap;
        private Map elementToNewNameMap;
        private IProgressMonitor monitor;
        private Shell shell;
        private HashSet movedResources;
        private MultiStatus status;
        private int state;
        protected Set modifiedResources;
        private IllegalReferenceRemover illegalReferenceRemover;
        private HashMap elementToOldContainerMap;

        public MoveOperation(Command command, IProgressMonitor iProgressMonitor, Shell shell) {
            this.addCommand = (AddCommand)TngUtil.unwrap(command);
            this.monitor = iProgressMonitor;
            this.shell = shell;
        }

        public IStatus getStatus() {
            return this.status;
        }

        public boolean reloadNeeded() {
            return this.status != null && CommandStatusChecker.hasRollbackError((IStatus)this.status);
        }

        private void undo() {
            NamedElement namedElement;
            if (this.elementToNewNameMap != null) {
                for (Map.Entry entry : this.elementToNewNameMap.entrySet()) {
                    namedElement = (NamedElement)entry.getKey();
                    namedElement.setName((String)entry.getValue());
                }
            }
            if (this.elementToOldContainerMap != null) {
                for (Map.Entry entry : this.elementToOldContainerMap.entrySet()) {
                    namedElement = (EObject)entry.getKey();
                    ContainmentInfo containmentInfo = (ContainmentInfo)entry.getValue();
                    EStructuralFeature eStructuralFeature = this.addCommand.getFeature();
                    if (eStructuralFeature.isMany()) {
                        ((List)containmentInfo.container.eGet(eStructuralFeature)).add(containmentInfo.index, namedElement);
                        continue;
                    }
                    containmentInfo.container.eSet(eStructuralFeature, (Object)namedElement);
                }
            }
            if (this.illegalReferenceRemover != null) {
                this.illegalReferenceRemover.restoreRemovedReferences();
            }
        }

        /*
         * WARNING - void declaration
         */
        public void run() {
            this.state = 0;
            this.status = new MultiStatus(LibraryEditPlugin.INSTANCE.getSymbolicName(), 0, LibraryEditResources.error_reason, null);
            if (this.checkName()) {
                Object object;
                Object object2;
                IStatus iStatus = UserInteractionHelper.checkConfigurationsToUpdate(this.addCommand, this.shell);
                if (!iStatus.isOK()) {
                    Messenger.INSTANCE.showError(LibraryEditResources.moveDialog_title, null, iStatus);
                    return;
                }
                final StringBuffer stringBuffer = new StringBuffer();
                Object object4 = new IRunnableWithProgress(){

                    public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                        iProgressMonitor.subTask(LibraryEditResources.checkingReferencesTask_name);
                        String string = MoveOperation.this.checkForIllegalReferences();
                        if (string != null) {
                            stringBuffer.append(string);
                        }
                    }
                };
                try {
                    ModalContext.run((IRunnableWithProgress)object4, (boolean)true, (IProgressMonitor)this.monitor, (Display)this.shell.getDisplay());
                }
                catch (Exception exception) {
                    LibraryEditPlugin.INSTANCE.log(exception);
                    Throwable throwable = exception instanceof InvocationTargetException ? ((InvocationTargetException)exception).getTargetException() : exception;
                    String string = TngUtil.toStackTraceString(throwable);
                    this.status.add((IStatus)new Status(4, LibraryEditPlugin.INSTANCE.getSymbolicName(), 0, string, throwable));
                    return;
                }
                if (stringBuffer.length() > 0 && MsgBox.prompt((Shell)this.shell, (String)stringBuffer.toString(), (int)192) == 128) {
                    return;
                }
                final HashMap<EObject, Resource> hashMap = new HashMap<EObject, Resource>();
                for (EObject object32 : this.moveList) {
                    if (!(object32 instanceof MethodElement)) continue;
                    hashMap.put(object32, object32.eResource());
                }
                if (this.removeXRefRequired || this.isRefenrecedIllegally) {
                    this.illegalReferenceRemover = new IllegalReferenceRemover(this.ownerPlugin, this.moveList, this.removeXRefRequired, this.isRefenrecedIllegally);
                    object4 = new IRunnableWithProgress(){

                        public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                            iProgressMonitor.subTask(LibraryEditResources.checkAffectedResourcesTask_name);
                            MoveOperation.this.modifiedResources = MoveOperation.this.illegalReferenceRemover.getAffectedResources();
                        }
                    };
                    try {
                        ModalContext.run((IRunnableWithProgress)object4, (boolean)true, (IProgressMonitor)this.monitor, (Display)this.shell.getDisplay());
                    }
                    catch (Exception exception3) {
                        void var6_15;
                        LibraryEditPlugin.INSTANCE.log(exception3);
                        if (exception3 instanceof InvocationTargetException) {
                            Throwable exception2 = ((InvocationTargetException)exception3).getTargetException();
                        } else {
                            Exception exception3;
                            Exception exception4 = exception3;
                        }
                        String string = TngUtil.toStackTraceString((Throwable)var6_15);
                        this.status.add((IStatus)new Status(4, LibraryEditPlugin.INSTANCE.getSymbolicName(), 0, string, (Throwable)var6_15));
                        return;
                    }
                    iStatus = UserInteractionHelper.checkModify(this.modifiedResources, this.shell);
                    if (!iStatus.isOK()) {
                        Messenger.INSTANCE.showError(LibraryEditResources.moveDialog_title, null, iStatus);
                        return;
                    }
                    try {
                        this.monitor.subTask(LibraryEditResources.removingReferencestask_name);
                        this.illegalReferenceRemover.removeIllegalReferences();
                    }
                    catch (Exception exception) {
                        this.undo();
                        String string = TngUtil.toStackTraceString(exception);
                        this.status.add((IStatus)new Status(4, LibraryEditPlugin.INSTANCE.getSymbolicName(), 0, string, (Throwable)exception));
                    }
                } else {
                    this.modifiedResources = new HashSet();
                    this.monitor.subTask("");
                }
                for (Map.Entry entry : this.elementToNewNameMap.entrySet()) {
                    object2 = (NamedElement)entry.getKey();
                    object2.setName((String)entry.getValue());
                    this.modifiedResources.add(object2.eResource());
                    if (!(object2 instanceof MethodUnit)) continue;
                    this.movedResources.add(object2.eResource());
                    if (!(object2 instanceof ContentElement) || !ContentDescriptionFactory.hasPresentation((MethodElement)(object = (ContentElement)object2))) continue;
                    this.movedResources.add(object.getPresentation());
                }
                object4 = new IRunnableWithProgress(){

                    public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                        iProgressMonitor.setTaskName(LibraryEditResources.movingTask_name);
                        MoveOperation.this.doMove(iProgressMonitor, hashMap, MoveOperation.this.modifiedResources);
                    }
                };
                try {
                    ModalContext.run((IRunnableWithProgress)object4, (boolean)true, (IProgressMonitor)this.monitor, (Display)this.shell.getDisplay());
                }
                catch (Exception exception) {
                    void var6_22;
                    this.undo();
                    if (exception instanceof InvocationTargetException) {
                        Throwable throwable = ((InvocationTargetException)exception).getTargetException();
                    } else {
                        Exception exception5 = exception;
                    }
                    object2 = TngUtil.toStackTraceString((Throwable)var6_22);
                    this.status.add((IStatus)new Status(4, LibraryEditPlugin.INSTANCE.getSymbolicName(), 0, (String)object2, (Throwable)var6_22));
                    return;
                }
                ArrayList arrayList = new ArrayList(this.movedResources);
                arrayList.removeAll(this.modifiedResources);
                iStatus = UserInteractionHelper.checkModify(arrayList, this.shell);
                if (!iStatus.isOK()) {
                    Messenger.INSTANCE.showError(LibraryEditResources.moveDialog_title, null, iStatus);
                    this.undo();
                    return;
                }
                object4 = new IRunnableWithProgress(){

                    public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                        try {
                            IStatus iStatus = MoveOperation.this.save(iProgressMonitor);
                            if (!iStatus.isOK()) {
                                MoveOperation.this.status.add(iStatus);
                            }
                        }
                        catch (RuntimeException runtimeException) {
                            LibraryEditPlugin.INSTANCE.log(runtimeException);
                            throw runtimeException;
                        }
                    }
                };
                try {
                    ModalContext.run((IRunnableWithProgress)object4, (boolean)true, (IProgressMonitor)this.monitor, (Display)this.shell.getDisplay());
                }
                catch (Exception exception) {
                    object2 = exception instanceof InvocationTargetException ? ((InvocationTargetException)exception).getTargetException() : exception;
                    object = TngUtil.toStackTraceString((Throwable)object2);
                    this.status.add((IStatus)new Status(4, LibraryEditPlugin.INSTANCE.getSymbolicName(), 0, (String)object, (Throwable)object2));
                    return;
                }
            }
            this.state = 100;
        }

        private boolean checkName() {
            this.elementToNewNameMap = MethodElementAddCommand.checkName(this.addCommand);
            return this.elementToNewNameMap != null;
        }

        private String checkForIllegalReferences() {
            this.elementToOldPluginMap = new HashMap();
            this.moveList = new ArrayList(this.addCommand.getCollection());
            this.movedResources = new HashSet();
            for (Object object : this.addCommand.getCollection()) {
                if (object instanceof MethodElement) {
                    this.elementToOldPluginMap.put(object, UmaUtil.getMethodPlugin((EObject)object));
                }
                TreeIterator treeIterator = object.eAllContents();
                while (treeIterator.hasNext()) {
                    this.moveList.add(treeIterator.next());
                }
            }
            this.ownerPlugin = UmaUtil.getMethodPlugin((EObject)this.addCommand.getOwner());
            for (Object object : this.addCommand.getCollection()) {
                if (MethodElementAddCommand.isExcludedFromOutgoingReferenceCheck(object) || !(object instanceof MethodElement) || !MethodElementAddCommand.hasIllegalReferenceIncludingAllChildren(this.ownerPlugin, (MethodElement)object, this.moveList)) continue;
                this.removeXRefRequired = true;
                break;
            }
            for (Object object : this.moveList) {
                if (!(object instanceof MethodElement) || !MethodElementAddCommand.isReferencedIllegally(this.ownerPlugin, (MethodElement)object, this.moveList)) continue;
                this.isRefenrecedIllegally = true;
                break;
            }
            if (this.removeXRefRequired || this.isRefenrecedIllegally) {
                return LibraryEditResources.invalidReferencesError_reason;
            }
            return null;
        }

        private void doMove(IProgressMonitor iProgressMonitor, Map map, Set set) {
            EStructuralFeature eStructuralFeature;
            EObject eObject;
            Object object2;
            iProgressMonitor.subTask("");
            this.elementToOldContainerMap = new HashMap();
            for (Object object2 : this.addCommand.getCollection()) {
                if (!(object2 instanceof MethodElement)) continue;
                eObject = object2.eContainer();
                eStructuralFeature = object2.eContainingFeature();
                int n = eStructuralFeature.isMany() ? ((List)eObject.eGet(eStructuralFeature)).indexOf(object2) : -1;
                this.elementToOldContainerMap.put(object2, new ContainmentInfo(eObject, n));
            }
            this.addCommand.execute();
            Resource resource = this.addCommand.getOwner().eResource();
            set.add(resource);
            object2 = this.addCommand.getAffectedObjects().iterator();
            while (object2.hasNext()) {
                Object v;
                eObject = (EObject)TngUtil.unwrap(object2.next());
                if (!(eObject instanceof MethodElement)) continue;
                eStructuralFeature = ((ContainmentInfo)this.elementToOldContainerMap.get((Object)eObject)).container;
                if (eStructuralFeature.eResource() != resource && !eStructuralFeature.eResource().getContents().isEmpty()) {
                    set.add(eStructuralFeature.eResource());
                    Resource resource2 = (Resource)map.get(eObject);
                    if (eStructuralFeature.eResource() != resource2) {
                        this.movedResources.add(resource2);
                    }
                }
                if (this.ownerPlugin == (v = this.elementToOldPluginMap.get(eObject))) continue;
                TreeIterator treeIterator = eObject.eAllContents();
                while (treeIterator.hasNext()) {
                    EObject eObject2 = (EObject)treeIterator.next();
                    if (!UmaUtil.hasDirectResource((EObject)eObject2)) continue;
                    this.movedResources.add(eObject2.eResource());
                    this.elementToOldPluginMap.put(eObject2, v);
                }
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private IStatus save(IProgressMonitor var1_1) {
            block24: {
                var2_2 = new MultiStatus(LibraryEditPlugin.INSTANCE.getSymbolicName(), 0, LibraryEditResources.MethodElementAddCommand_errorSavingFiles, null);
                var1_1.subTask(LibraryEditResources.savingModifiedFilesTask_name);
                var3_3 = Services.getDefaultLibraryPersister().getFailSafePersister();
                try {
                    if (!this.movedResources.isEmpty()) {
                        var1_1.subTask(LibraryEditResources.movingFilesTask_name);
                        var3_3.adjustLocation((Collection)this.movedResources);
                    }
                    this.state = 70;
                    for (Collection<Resource> var5_6 : this.modifiedResources) {
                        try {
                            var3_3.save((Resource)var5_6);
                        }
                        catch (Exception var6_7) {
                            var7_10 = NLS.bind((String)LibraryEditResources.saveFileError_reason, (Object)(var5_6.getURI().isFile() != false ? var5_6.getURI().toFileString() : var5_6.toString()));
                            var2_2.add((IStatus)new SaveStatus(4, LibraryEditPlugin.INSTANCE.getSymbolicName(), 1, var7_10, var6_7));
lbl16:
                            // 2 sources

                            while (var2_2.getSeverity() == 4) {
                                try {
                                    var3_3.rollback();
                                }
                                catch (Exception var12_12) {
                                    LibraryEditPlugin.INSTANCE.log(var12_12);
                                    var13_16 = new StringWriter();
                                    var12_12.printStackTrace(new PrintWriter(var13_16));
                                    var14_20 = new SaveStatus(4, LibraryEditPlugin.INSTANCE.getSymbolicName(), 2, var13_16.toString(), var12_12);
                                    var2_2.add((IStatus)var14_20);
                                }
                                break block24;
                            }
                            break block24;
                        }
                    }
                }
                catch (RuntimeException var4_5) {
                    var5_6 = new StringWriter();
                    var4_5.printStackTrace(new PrintWriter((Writer)var5_6));
                    var6_9 = new SaveStatus(4, LibraryEditPlugin.INSTANCE.getSymbolicName(), 1, var5_6.toString(), var4_5);
                    var2_2.add((IStatus)var6_9);
                    if (var2_2.getSeverity() == 4) {
                        try {
                            var3_3.rollback();
                        }
                        catch (Exception var12_13) {
                            LibraryEditPlugin.INSTANCE.log(var12_13);
                            var13_17 = new StringWriter();
                            var12_13.printStackTrace(new PrintWriter(var13_17));
                            var14_21 = new SaveStatus(4, LibraryEditPlugin.INSTANCE.getSymbolicName(), 2, var13_17.toString(), var12_13);
                            var2_2.add((IStatus)var14_21);
                        }
                    }
                    break block24;
                }
                catch (Throwable var11_27) {
                    if (var2_2.getSeverity() != 4) throw var11_27;
                    try {
                        var3_3.rollback();
                        throw var11_27;
                    }
                    catch (Exception var12_14) {
                        LibraryEditPlugin.INSTANCE.log(var12_14);
                        var13_18 = new StringWriter();
                        var12_14.printStackTrace(new PrintWriter(var13_18));
                        var14_22 = new SaveStatus(4, LibraryEditPlugin.INSTANCE.getSymbolicName(), 2, var13_18.toString(), var12_14);
                        var2_2.add((IStatus)var14_22);
                    }
                    throw var11_27;
                }
                {
                    block25: {
                        var3_3.commit();
                        this.state = 80;
                        if (MethodElementAddCommand.access$2() == null) break block25;
                        var1_1.subTask(LibraryEditResources.copyingResourcesTask_name);
                        var4_4 = new ArrayList<E>();
                        for (Object var6_8 : this.movedResources) {
                            var4_4.addAll(var6_8.getContents());
                        }
                        var4_4.addAll(this.addCommand.getAffectedObjects());
                        var5_6 = MethodElementAddCommand.access$2().copyReferencedContents((Collection<MethodElement>)var4_4, this.elementToOldPluginMap);
                        if (var5_6 == null || var5_6.isEmpty()) break block25;
                        for (Resource var7_11 : var5_6) {
                            var8_24 = new Object[]{var7_11.getURI().isFile() != false ? var7_11.getURI().toFileString() : var7_11.toString()};
                            try {
                                var1_1.subTask(MessageFormat.format(LibraryEditResources.savingFileTask_name, var8_24));
                                var3_3.save(var7_11);
                            }
                            catch (Exception var9_25) {
                                var10_26 = MessageFormat.format(LibraryEditResources.saveFileError_reason, var8_24);
                                var2_2.add((IStatus)new SaveStatus(4, LibraryEditPlugin.INSTANCE.getSymbolicName(), 1, var10_26, var9_25));
                                ** GOTO lbl16
                            }
                        }
                    }
                    var3_3.commit();
                    this.state = 90;
                }
                if (var2_2.getSeverity() == 4) {
                    try {
                        var3_3.rollback();
                    }
                    catch (Exception var12_15) {
                        LibraryEditPlugin.INSTANCE.log(var12_15);
                        var13_19 = new StringWriter();
                        var12_15.printStackTrace(new PrintWriter(var13_19));
                        var14_23 = new SaveStatus(4, LibraryEditPlugin.INSTANCE.getSymbolicName(), 2, var13_19.toString(), var12_15);
                        var2_2.add((IStatus)var14_23);
                    }
                }
            }
            var1_1.subTask(LibraryEditResources.command_done);
            return var2_2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ResourceManager {
        public Collection<Resource> copyReferencedContents(Collection<MethodElement> var1, Map<MethodElement, MethodPlugin> var2);
    }

    private static class StringValidator
    implements IInputValidator {
        private Collection elements;
        private IValidator validator;
        private EStructuralFeature feature;

        private StringValidator() {
        }

        public StringValidator(Collection collection, EStructuralFeature eStructuralFeature) {
            this.elements = collection;
            this.feature = eStructuralFeature;
        }

        public void setElements(Collection collection) {
            this.elements = collection;
        }

        public void setFeature(EStructuralFeature eStructuralFeature) {
            this.feature = eStructuralFeature;
        }

        public void setValidator(IValidator iValidator) {
            this.validator = iValidator;
        }

        public String isValid(String string) {
            if (this.validator instanceof UniquenessValidator) {
                EObject eObject = ((UniquenessValidator)this.validator).getEObject();
                int n = eObject.eClass().getClassifierID();
                string = string.trim();
                for (EObject eObject2 : this.elements) {
                    String string2 = (String)eObject2.eGet(this.feature);
                    if (eObject == eObject2 || n != eObject2.eClass().getClassifierID() || !string.equalsIgnoreCase(string2)) continue;
                    return NLS.bind((String)LibraryEditResources.duplicateElementNameError_msg, (Object)string);
                }
            }
            return this.validator.isValid(string);
        }
    }
}

