/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.navigator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.epf.library.edit.IGroupContainer;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.TransientGroupItemProvider;
import org.eclipse.epf.library.edit.category.StandardCategoriesItemProvider;
import org.eclipse.epf.library.edit.element.IElementItemProvider;
import org.eclipse.epf.library.edit.navigator.MethodPackagesItemProvider;
import org.eclipse.epf.library.edit.util.ModelStructure;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.util.UmaUtil;

public class ContentItemProvider
extends ItemProviderAdapter
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource,
IElementItemProvider,
IGroupContainer {
    protected MethodPlugin plugin;
    protected ModelStructure modelStruct;
    protected Map groupItemProviderMap;
    protected ArrayList children;
    protected ContentPackage coreContentPkg;

    public ContentItemProvider(AdapterFactory adapterFactory, MethodPlugin methodPlugin, ModelStructure modelStructure) {
        super(adapterFactory);
        this.plugin = methodPlugin;
        this.modelStruct = modelStructure;
    }

    public ContentPackage getCoreContentPackage() {
        return this.coreContentPkg;
    }

    public Notifier getTarget() {
        return this.coreContentPkg;
    }

    public Collection getChildren(Object object) {
        if (this.children == null) {
            ContentPackage contentPackage;
            this.children = new ArrayList();
            this.groupItemProviderMap = new HashMap();
            this.coreContentPkg = contentPackage = UmaUtil.findContentPackage((MethodPlugin)this.plugin, (String[])this.modelStruct.coreContentPath);
            if (contentPackage != null) {
                CustomCategory customCategory;
                String string = LibraryEditPlugin.INSTANCE.getString("_UI_MethodContent_group");
                TransientGroupItemProvider transientGroupItemProvider = new MethodPackagesItemProvider(this.adapterFactory, (Notifier)contentPackage, string);
                transientGroupItemProvider.setParent(this);
                this.children.add(transientGroupItemProvider);
                this.groupItemProviderMap.put(string, transientGroupItemProvider);
                contentPackage = UmaUtil.findContentPackage((MethodPlugin)this.plugin, (String[])this.modelStruct.standardCategoryPath);
                if (contentPackage != null) {
                    string = LibraryEditPlugin.INSTANCE.getString("_UI_Standard_Categories_group");
                    transientGroupItemProvider = new StandardCategoriesItemProvider(this.adapterFactory, (Notifier)contentPackage, string);
                    transientGroupItemProvider.setParent(this);
                    this.children.add(transientGroupItemProvider);
                    this.groupItemProviderMap.put(string, transientGroupItemProvider);
                }
                if ((customCategory = TngUtil.getRootCustomCategory(this.plugin)) != null) {
                    boolean bl = customCategory.eDeliver();
                    try {
                        customCategory.eSetDeliver(false);
                        customCategory.setName(LibraryEditPlugin.INSTANCE.getString("_UI_Custom_Categories_group"));
                    }
                    finally {
                        customCategory.eSetDeliver(bl);
                    }
                    this.children.add(customCategory);
                }
            }
        }
        return this.children;
    }

    public Object getImage(Object object) {
        return LibraryEditPlugin.INSTANCE.getImage("full/obj16/Content");
    }

    public String getText(Object object) {
        return LibraryEditPlugin.INSTANCE.getString("_UI_Content_group");
    }

    public Object getGroupItemProvider(String string) {
        return this.groupItemProviderMap != null ? this.groupItemProviderMap.get(string) : null;
    }

    public Collection getNewChildDescriptors(Object object, EditingDomain editingDomain, Object object2) {
        return Collections.EMPTY_LIST;
    }

    public Object getParent(Object object) {
        return this.plugin;
    }

    public void dispose() {
        if (this.groupItemProviderMap != null) {
            for (Object v : this.groupItemProviderMap.values()) {
                if (!(v instanceof IDisposable)) continue;
                ((IDisposable)v).dispose();
            }
            this.groupItemProviderMap.clear();
            this.groupItemProviderMap = null;
        }
        if (this.children != null) {
            this.children.clear();
        }
        this.plugin = null;
        this.coreContentPkg = null;
        super.dispose();
    }
}

