/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ITableItemLabelProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.epf.library.edit.ICachedChildrenItemProvider;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.command.ResourceAwareDragAndDropCommand;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.process.IColumnAware;
import org.eclipse.epf.library.edit.process.IProcessItemProvider;
import org.eclipse.epf.library.edit.process.command.GenericDropCommand;
import org.eclipse.epf.library.edit.util.PredecessorList;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.WorkBreakdownElement;
import org.eclipse.epf.uma.edit.command.MethodElementCreateCopyCommand;
import org.eclipse.epf.uma.edit.command.MethodElementInitializeCopyCommand;

public class BreakdownElementItemProvider
extends org.eclipse.epf.uma.provider.BreakdownElementItemProvider
implements IProcessItemProvider,
IBSItemProvider,
ITableItemLabelProvider,
ICachedChildrenItemProvider {
    private Object parent;
    private int id;
    private Object topItem;
    private boolean rolledUp;
    private Boolean expanded;
    private PredecessorList predecessors;
    protected ItemProviderAdapter delegateItemProvider;
    protected List cachedChildren;

    public BreakdownElementItemProvider(AdapterFactory adapterFactory, ItemProviderAdapter itemProviderAdapter) {
        super(adapterFactory);
        this.delegateItemProvider = itemProviderAdapter;
    }

    public void dispose() {
        if (this.predecessors != null) {
            this.predecessors.dispose();
        }
        if (this.cachedChildren != null) {
            this.cachedChildren.clear();
            this.cachedChildren = null;
        }
        super.dispose();
    }

    public List getPropertyDescriptors(Object object) {
        if (this.delegateItemProvider != null) {
            return this.delegateItemProvider.getPropertyDescriptors(object);
        }
        return super.getPropertyDescriptors(object);
    }

    protected void collectNewChildDescriptors(Collection collection, Object object) {
    }

    public Collection getChildrenFeatures(Object object) {
        return Collections.EMPTY_LIST;
    }

    public Boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(Boolean bl) {
        this.expanded = bl;
    }

    public void setParent(Object object) {
        this.parent = object;
    }

    public Object getParent(Object object) {
        if (this.parent != null) {
            return this.parent;
        }
        if (object instanceof BreakdownElement) {
            return ((BreakdownElement)object).getSuperActivities();
        }
        return null;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = n;
    }

    public Object getTopItem() {
        IBSItemProvider iBSItemProvider;
        Object object = this.getParent(this.target);
        if (this.topItem == null && object != null && (iBSItemProvider = (IBSItemProvider)this.getRootAdapterFactory().adapt(object, ITreeItemContentProvider.class)) != null) {
            Object object2 = iBSItemProvider.getTopItem();
            if (object2 == null && object instanceof Process && ((Process)object).getSuperActivities() == null) {
                object2 = object;
                iBSItemProvider.setTopItem(object2);
            }
            return object2;
        }
        return this.topItem;
    }

    protected String getColumnName(int n) {
        Map map;
        AdapterFactory adapterFactory = this.getRootAdapterFactory();
        if (adapterFactory instanceof IColumnAware && (map = ((IColumnAware)adapterFactory).getColumnIndexToNameMap()) != null) {
            return (String)map.get(new Integer(n));
        }
        return null;
    }

    public Object getColumnImage(Object object, int n) {
        String string = this.getColumnName(n);
        return TngUtil.getColumnImage(object, string);
    }

    public String getColumnText(Object object, int n) {
        String string = this.getColumnName(n);
        return this.getAttribute(object, string);
    }

    public String getText(Object object) {
        return TngUtil.getLabel(object);
    }

    public void setTopItem(Object object) {
        this.topItem = object;
    }

    public boolean isRolledUp() {
        return this.rolledUp;
    }

    public void setRolledUp(boolean bl) {
        this.rolledUp = bl;
    }

    public String getAttribute(Object object, String string) {
        return ProcessUtil.getAttribute(object, string, this);
    }

    public void setAttribute(Object object, String string, String string2) {
        WorkBreakdownElement workBreakdownElement = (WorkBreakdownElement)object;
        if (string == "name") {
            workBreakdownElement.setName(string2);
        } else if (string != "predecessors") {
            if (string == "is_event_driven") {
                workBreakdownElement.setIsEventDriven(Boolean.valueOf(string2));
            } else if (string == "is_ongoing") {
                workBreakdownElement.setIsOngoing(Boolean.valueOf(string2));
            } else if (string == "is_repeatable") {
                workBreakdownElement.setIsRepeatable(Boolean.valueOf(string2));
            }
        }
    }

    public List getListeners() {
        if (this.changeNotifier == null) {
            return null;
        }
        return Collections.unmodifiableList((List)this.changeNotifier);
    }

    public PredecessorList getPredecessors() {
        if (this.predecessors == null) {
            this.predecessors = new PredecessorList(TngUtil.getBestAdapterFactory(this.adapterFactory), this.target);
        }
        return this.predecessors;
    }

    public boolean isFirstElement(Object object) {
        return ProcessUtil.isFirstElement(this.getRootAdapterFactory(), (ItemProviderAdapter)this, object);
    }

    public boolean isLastElement(Object object) {
        return ProcessUtil.isLastElement(this.getRootAdapterFactory(), (ItemProviderAdapter)this, object);
    }

    public void moveUp(Object object, IActionManager iActionManager) {
        Object object2 = this.getParent(object);
        if (object2 != null && object2 instanceof Activity) {
            TngUtil.moveUp((Activity)object2, object, this.getEClasses(), iActionManager);
        }
    }

    public void moveDown(Object object, IActionManager iActionManager) {
        Object object2 = this.getParent(object);
        if (object2 != null && object2 instanceof Activity) {
            TngUtil.moveDown((Activity)object2, object, this.getEClasses(), iActionManager);
        }
    }

    public Collection getEClasses() {
        return null;
    }

    protected Command createInitializeCopyCommand(EditingDomain editingDomain, EObject eObject, CopyCommand.Helper helper) {
        return new MethodElementInitializeCopyCommand(editingDomain, eObject, helper);
    }

    protected Command createCreateCopyCommand(EditingDomain editingDomain, EObject eObject, CopyCommand.Helper helper) {
        return new MethodElementCreateCopyCommand(editingDomain, eObject, helper);
    }

    public Object getImage(Object object) {
        if (this.delegateItemProvider != null) {
            return this.delegateItemProvider.getImage(object);
        }
        return super.getImage(object);
    }

    public void notifyChanged(Notification notification) {
        if (TngUtil.handlePredecessorListChange((ItemProviderAdapter)this, notification)) {
            return;
        }
        super.notifyChanged(notification);
    }

    protected void refreshChildren(Notification notification, Collection collection) {
        if (!collection.isEmpty()) {
            this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
            return;
        }
    }

    public GenericDropCommand.ElementAdapter createDropAdapter() {
        return null;
    }

    public IResourceAwareCommand createDropCommand(Object object, List list) {
        return null;
    }

    public Collection getChildrenFromCache() {
        if (this.cachedChildren == null) {
            this.getChildren(this.target);
        }
        return this.cachedChildren;
    }

    public Collection getRollupChildrenFromCache() {
        return Collections.EMPTY_LIST;
    }

    protected Command createDragAndDropCommand(EditingDomain editingDomain, Object object, float f, int n, int n2, Collection collection) {
        return new ResourceAwareDragAndDropCommand(editingDomain, object, f, n, n2, collection);
    }
}

