/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.process.BreakdownElementItemProvider;
import org.eclipse.epf.library.edit.process.command.GenericDropCommand;
import org.eclipse.epf.library.edit.process.command.OBSDragAndDropCommand;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Role;
import org.eclipse.epf.uma.RoleDescriptor;
import org.eclipse.epf.uma.TeamProfile;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;

public class TeamProfileItemProvider
extends BreakdownElementItemProvider {
    private GenericDropCommand.ElementAdapter dropAdapter;

    public TeamProfileItemProvider(AdapterFactory adapterFactory, ItemProviderAdapter itemProviderAdapter) {
        super(adapterFactory, itemProviderAdapter);
    }

    protected void collectNewChildDescriptors(Collection collection, Object object) {
        collection.add(this.createChildParameter(UmaPackage.eINSTANCE.getTeamProfile_SubTeam(), UmaFactory.eINSTANCE.createTeamProfile()));
    }

    public Collection getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            this.childrenFeatures = new ArrayList();
            this.childrenFeatures.add(UmaPackage.eINSTANCE.getTeamProfile_SubTeam());
        }
        return this.childrenFeatures;
    }

    public IResourceAwareCommand createDropCommand(Object object, List list) {
        return new GenericDropCommand((EObject)((TeamProfile)object), (EStructuralFeature)UmaPackage.eINSTANCE.getTeamProfile_TeamRoles(), list, this.getDropAdapter(object));
    }

    private GenericDropCommand.ElementAdapter getDropAdapter(Object object) {
        BreakdownElementItemProvider breakdownElementItemProvider = (BreakdownElementItemProvider)this.adapterFactory.adapt(object, IEditingDomainItemProvider.class);
        return breakdownElementItemProvider.createDropAdapter();
    }

    public Collection getChildren(Object object) {
        Collection collection = super.getChildren(object);
        IFilter iFilter = ProcessUtil.getFilter(this.adapterFactory);
        boolean bl = iFilter == null;
        TeamProfile teamProfile = (TeamProfile)object;
        for (RoleDescriptor roleDescriptor : teamProfile.getTeamRoles()) {
            if (roleDescriptor.getSuperActivities() != null || !bl && !iFilter.accept(roleDescriptor)) continue;
            collection.add(roleDescriptor);
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ProcessUtil.setParent(iterator.next(), object, this.getRootAdapterFactory());
        }
        return collection;
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(TeamProfile.class)) {
            case 21: {
                int n = notification.getEventType();
                if (n == 3 || n == 5) {
                    List list = ProcessUtil.getAffectedElements(notification, null);
                    for (TeamProfile teamProfile : list) {
                        ProcessUtil.addToContainer((BreakdownElement)teamProfile, (ItemProviderAdapter)this);
                    }
                }
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
            case 19: {
                List list = ProcessUtil.getAffectedElements(notification, null);
                int n = notification.getEventType();
                boolean bl = false;
                for (BreakdownElement breakdownElement : list) {
                    if (n == 3 || n == 5) {
                        ProcessUtil.addToContainer(breakdownElement, (ItemProviderAdapter)this, false);
                    }
                    if (breakdownElement.getSuperActivities() == null) {
                        bl = true;
                        continue;
                    }
                    this.fireNotifyChanged((Notification)new ViewerNotification(notification, (Object)breakdownElement, false, true));
                }
                if (bl) {
                    this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                }
                return;
            }
            case 7: {
                TeamProfile teamProfile = (TeamProfile)notification.getNotifier();
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, (Object)teamProfile, false, true));
                for (RoleDescriptor roleDescriptor : teamProfile.getTeamRoles()) {
                    this.fireNotifyChanged((Notification)new ViewerNotification(notification, (Object)roleDescriptor, false, true));
                }
                return;
            }
            case 5: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    public Collection getEClasses() {
        return ProcessUtil.getOBSEclasses();
    }

    protected Command createDragAndDropCommand(EditingDomain editingDomain, Object object, float f, int n, int n2, Collection collection) {
        return new OBSDragAndDropCommand(editingDomain, object, f, n, n2, collection);
    }

    private boolean descriptorExists(Object object) {
        TeamProfile teamProfile = (TeamProfile)this.getTarget();
        for (RoleDescriptor roleDescriptor : teamProfile.getTeamRoles()) {
            if (roleDescriptor.getRole() != object) continue;
            return true;
        }
        return false;
    }

    public GenericDropCommand.ElementAdapter createDropAdapter() {
        if (this.dropAdapter == null) {
            this.dropAdapter = new GenericDropCommand.ElementAdapter(){

                public Object adapt(Object object) {
                    if (object instanceof Role && !TeamProfileItemProvider.this.descriptorExists(object)) {
                        return ProcessUtil.createRoleDescriptor((Role)object);
                    }
                    return null;
                }
            };
        }
        return this.dropAdapter;
    }

    public String getAttribute(Object object, String string) {
        if (string == "teams") {
            return TngUtil.getPresentationName(((TeamProfile)object).getSuperTeam());
        }
        return super.getAttribute(object, string);
    }

    public void moveUp(Object object, IActionManager iActionManager) {
        Object object2 = this.getParent(object);
        if (object2 != null && object2 instanceof Activity) {
            TngUtil.moveUp((Activity)object2, object, this.getEClasses(), iActionManager);
        }
        if (object2 != null && object2 instanceof TeamProfile) {
            TeamProfile teamProfile = (TeamProfile)object2;
            List list = teamProfile.getSubTeam();
            int n = 0;
            int n2 = 0;
            while (n2 < list.size()) {
                if (object.equals(list.get(n2))) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            ((EList)teamProfile.getSubTeam()).move(n, n - 1);
            Activity activity = this.getActivity(object);
            TngUtil.moveUp(activity, object, this.getEClasses(), iActionManager);
        }
    }

    public void moveDown(Object object, IActionManager iActionManager) {
        Object object2 = this.getParent(object);
        if (object2 != null && object2 instanceof Activity) {
            TngUtil.moveDown((Activity)object2, object, this.getEClasses(), iActionManager);
        }
        if (object2 != null && object2 instanceof TeamProfile) {
            TeamProfile teamProfile = (TeamProfile)object2;
            List list = teamProfile.getSubTeam();
            int n = 0;
            int n2 = 0;
            while (n2 < list.size()) {
                if (object.equals(list.get(n2))) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            ((EList)teamProfile.getSubTeam()).move(n, n + 1);
            Activity activity = this.getActivity(object);
            TngUtil.moveDown(activity, object, this.getEClasses(), iActionManager);
        }
    }

    public Activity getActivity(Object object) {
        Object object2 = this.getParent(object);
        while (object2 != null) {
            if (object2 instanceof Activity) {
                return (Activity)object2;
            }
            AdapterFactory adapterFactory = TngUtil.getBestAdapterFactory(this.adapterFactory);
            ItemProviderAdapter itemProviderAdapter = (ItemProviderAdapter)adapterFactory.adapt(object2, ITreeItemContentProvider.class);
            object2 = itemProviderAdapter.getParent(object2);
        }
        return null;
    }
}

