/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.process.command.AddMethodElementCommand;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Checklist;
import org.eclipse.epf.uma.Concept;
import org.eclipse.epf.uma.Example;
import org.eclipse.epf.uma.Guidance;
import org.eclipse.epf.uma.Guideline;
import org.eclipse.epf.uma.ReusableAsset;
import org.eclipse.epf.uma.Roadmap;
import org.eclipse.epf.uma.SupportingMaterial;

public class AddGuidanceToActivityCommand
extends AddMethodElementCommand {
    private List guidances;
    private Activity activity;
    private Collection modifiedResources;

    public AddGuidanceToActivityCommand(Activity activity, List list) {
        super(TngUtil.getOwningProcess((BreakdownElement)activity));
        this.guidances = list;
        this.activity = activity;
        this.modifiedResources = new HashSet();
    }

    public void execute() {
        if (!super.addToDefaultConfiguration(this.guidances)) {
            return;
        }
        this.redo();
    }

    public void redo() {
        if (!this.guidances.isEmpty()) {
            for (Object e : this.guidances) {
                if (!(e instanceof Guidance)) continue;
                Guidance guidance = (Guidance)e;
                if (guidance instanceof Checklist) {
                    this.activity.getChecklists().add(guidance);
                    continue;
                }
                if (guidance instanceof Concept) {
                    this.activity.getConcepts().add(guidance);
                    continue;
                }
                if (guidance instanceof Example) {
                    this.activity.getExamples().add(guidance);
                    continue;
                }
                if (guidance instanceof SupportingMaterial) {
                    this.activity.getSupportingMaterials().add(guidance);
                    continue;
                }
                if (guidance instanceof Guideline) {
                    this.activity.getGuidelines().add(guidance);
                    continue;
                }
                if (guidance instanceof ReusableAsset) {
                    this.activity.getReusableAssets().add(guidance);
                    continue;
                }
                if (guidance instanceof Roadmap) {
                    this.activity.getRoadmaps().add(guidance);
                    continue;
                }
                LibraryEditPlugin.getDefault().getLogger().logError("Cant set guidance " + guidance.getType().getName() + ":" + guidance.getName());
            }
        }
    }

    public void undo() {
        if (!this.guidances.isEmpty()) {
            super.undo();
            for (Object e : this.guidances) {
                if (!(e instanceof Guidance)) continue;
                Guidance guidance = (Guidance)e;
                if (guidance instanceof Checklist) {
                    this.activity.getChecklists().remove(guidance);
                    continue;
                }
                if (guidance instanceof Concept) {
                    this.activity.getConcepts().remove(guidance);
                    continue;
                }
                if (guidance instanceof Example) {
                    this.activity.getExamples().remove(guidance);
                    continue;
                }
                if (guidance instanceof SupportingMaterial) {
                    this.activity.getSupportingMaterials().remove(guidance);
                    continue;
                }
                if (guidance instanceof Guideline) {
                    this.activity.getGuidelines().remove(guidance);
                    continue;
                }
                if (guidance instanceof ReusableAsset) {
                    this.activity.getReusableAssets().remove(guidance);
                    continue;
                }
                if (guidance instanceof Roadmap) {
                    this.activity.getRoadmaps().remove(guidance);
                    continue;
                }
                LibraryEditPlugin.getDefault().getLogger().logError("Cant set guidance " + guidance.getType().getName() + ":" + guidance.getName());
            }
        }
    }

    protected boolean prepare() {
        return true;
    }

    public Collection getModifiedResources() {
        if (!this.guidances.isEmpty() && this.activity.eResource() != null) {
            this.modifiedResources.add(this.activity.eResource());
        }
        return this.modifiedResources;
    }

    public Collection getAffectedObjects() {
        if (this.activity != null) {
            return Arrays.asList(this.activity);
        }
        return super.getAffectedObjects();
    }
}

